/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.help.HelpHistoryModel;
import org.gjt.sp.jedit.help.HelpHistoryModelListener;
import org.gjt.sp.jedit.help.HelpSearchPanel;
import org.gjt.sp.jedit.help.HelpTOCPanel;
import org.gjt.sp.jedit.help.HelpViewerInterface;
import org.gjt.sp.jedit.help.HistoryButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;

public class HelpViewer
extends JFrame
implements HelpViewerInterface,
EBComponent,
HelpHistoryModelListener {
    private String baseURL;
    private String shortURL;
    private HistoryButton back;
    private HistoryButton forward;
    private JEditorPane viewer;
    private JScrollPane viewerScrollPane;
    private JLabel title;
    private JSplitPane splitter;
    private HelpHistoryModel historyModel;
    private HelpTOCPanel toc;
    private boolean queuedTOCReload;

    public HelpViewer() {
        this("welcome.html");
    }

    public HelpViewer(URL url) {
        this(url.toString());
    }

    public HelpViewer(String url) {
        super(jEdit.getProperty("helpviewer.title"));
        this.setIconImage(GUIUtilities.getEditorIcon());
        try {
            this.baseURL = new File(MiscUtilities.constructPath(jEdit.getJEditHome(), "doc")).toURL().toString();
        }
        catch (MalformedURLException mu) {
            Log.log(9, this, mu);
        }
        ActionHandler actionListener = new ActionHandler();
        JTabbedPane tabs = new JTabbedPane();
        this.toc = new HelpTOCPanel(this);
        tabs.addTab(jEdit.getProperty("helpviewer.toc.label"), this.toc);
        tabs.addTab(jEdit.getProperty("helpviewer.search.label"), new HelpSearchPanel(this));
        tabs.setMinimumSize(new Dimension(0, 0));
        JPanel rightPanel = new JPanel(new BorderLayout());
        Box toolBar = new Box(0);
        this.title = new JLabel();
        toolBar.add(this.title);
        toolBar.add(Box.createGlue());
        this.historyModel = new HelpHistoryModel(25);
        this.back = new HistoryButton(0, this.historyModel);
        this.back.addActionListener(actionListener);
        toolBar.add(this.back);
        this.forward = new HistoryButton(1, this.historyModel);
        this.forward.addActionListener(actionListener);
        toolBar.add(this.forward);
        this.back.setPreferredSize(this.forward.getPreferredSize());
        rightPanel.add("North", toolBar);
        this.viewer = new JEditorPane();
        this.viewer.setEditable(false);
        this.viewer.addHyperlinkListener(new LinkHandler());
        this.viewer.setFont(new Font("Monospaced", 0, 12));
        this.viewer.addPropertyChangeListener(new PropertyChangeHandler());
        this.viewer.addKeyListener(new KeyHandler());
        this.viewerScrollPane = new JScrollPane(this.viewer);
        rightPanel.add("Center", this.viewerScrollPane);
        this.splitter = new JSplitPane(1, jEdit.getBooleanProperty("appearance.continuousLayout"), tabs, rightPanel);
        this.splitter.setBorder(null);
        this.getContentPane().add("Center", this.splitter);
        this.historyModel.addHelpHistoryModelListener(this);
        this.historyUpdated();
        this.gotoURL(url, true, 0);
        this.setDefaultCloseOperation(2);
        this.getRootPane().setPreferredSize(new Dimension(750, 500));
        this.pack();
        GUIUtilities.loadGeometry(this, "helpviewer");
        GUIUtilities.addSizeSaver(this, "helpviewer");
        EditBus.addToBus(this);
        this.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HelpViewer.this.splitter.setDividerLocation(jEdit.getIntegerProperty("helpviewer.splitter", 250));
                HelpViewer.this.viewer.requestFocus();
            }
        });
    }

    public void gotoURL(String url, boolean addToHistory, final int scrollPosition) {
        String shortURL;
        if (MiscUtilities.isURL(url)) {
            if (url.startsWith(this.baseURL)) {
                shortURL = url.substring(this.baseURL.length());
                if (shortURL.startsWith("/")) {
                    shortURL = shortURL.substring(1);
                }
            } else {
                shortURL = url;
            }
        } else {
            shortURL = url;
            url = this.baseURL.endsWith("/") ? this.baseURL + url : this.baseURL + '/' + url;
        }
        this.viewer.setCursor(Cursor.getDefaultCursor());
        try {
            URL _url = new URL(url);
            if (!_url.equals(this.viewer.getPage())) {
                this.title.setText(jEdit.getProperty("helpviewer.loading"));
            }
            this.historyModel.setCurrentScrollPosition(this.viewer.getPage(), this.getCurrentScrollPosition());
            this.viewer.setPage(_url);
            if (0 != scrollPosition) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        HelpViewer.this.viewerScrollPane.getVerticalScrollBar().setValue(scrollPosition);
                    }
                });
            }
            if (addToHistory) {
                this.historyModel.addToHistory(url);
            }
        }
        catch (MalformedURLException mf) {
            Log.log(9, this, mf);
            Object[] args = new String[]{url, mf.getMessage()};
            GUIUtilities.error(this, "badurl", args);
            return;
        }
        catch (IOException io) {
            Log.log(9, this, io);
            Object[] args = new String[]{url, io.toString()};
            GUIUtilities.error(this, "read-error", args);
            return;
        }
        this.shortURL = shortURL;
        if (shortURL != null) {
            this.toc.selectNode(shortURL);
        }
        this.viewer.requestFocus();
    }

    int getCurrentScrollPosition() {
        return this.viewerScrollPane.getVerticalScrollBar().getValue();
    }

    URL getCurrentPage() {
        return this.viewer.getPage();
    }

    public void dispose() {
        EditBus.removeFromBus(this);
        jEdit.setIntegerProperty("helpviewer.splitter", this.splitter.getDividerLocation());
        super.dispose();
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof PluginUpdate) {
            PluginUpdate pmsg = (PluginUpdate)msg;
            if (!(pmsg.getWhat() != PluginUpdate.LOADED && pmsg.getWhat() != PluginUpdate.UNLOADED || pmsg.isExiting())) {
                if (!this.queuedTOCReload) {
                    this.queueTOCReload();
                }
                this.queuedTOCReload = true;
            }
        } else if (msg instanceof PropertiesChanged) {
            GUIUtilities.initContinuousLayout(this.splitter);
        }
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getShortURL() {
        return this.shortURL;
    }

    public void historyUpdated() {
        this.back.setEnabled(this.historyModel.hasPrevious());
        this.forward.setEnabled(this.historyModel.hasNext());
    }

    public Component getComponent() {
        return this.getRootPane();
    }

    public void queueTOCReload() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HelpViewer.this.queuedTOCReload = false;
                HelpViewer.this.toc.load();
            }
        });
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        public void keyPressed(KeyEvent ke) {
            switch (ke.getKeyCode()) {
                case 38: {
                    JScrollBar scrollBar = HelpViewer.this.viewerScrollPane.getVerticalScrollBar();
                    scrollBar.setValue(scrollBar.getValue() - scrollBar.getUnitIncrement(-1));
                    ke.consume();
                    break;
                }
                case 40: {
                    JScrollBar scrollBar = HelpViewer.this.viewerScrollPane.getVerticalScrollBar();
                    scrollBar.setValue(scrollBar.getValue() + scrollBar.getUnitIncrement(1));
                    ke.consume();
                    break;
                }
                case 37: {
                    JScrollBar scrollBar = HelpViewer.this.viewerScrollPane.getHorizontalScrollBar();
                    scrollBar.setValue(scrollBar.getValue() - scrollBar.getUnitIncrement(-1));
                    ke.consume();
                    break;
                }
                case 39: {
                    JScrollBar scrollBar = HelpViewer.this.viewerScrollPane.getHorizontalScrollBar();
                    scrollBar.setValue(scrollBar.getValue() + scrollBar.getUnitIncrement(1));
                    ke.consume();
                }
            }
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("page".equals(evt.getPropertyName())) {
                String titleStr = (String)HelpViewer.this.viewer.getDocument().getProperty("title");
                if (titleStr == null) {
                    titleStr = MiscUtilities.getFileName(HelpViewer.this.viewer.getPage().toString());
                }
                HelpViewer.this.title.setText(titleStr);
                HelpViewer.this.historyModel.updateTitle(HelpViewer.this.viewer.getPage().toString(), titleStr);
            }
        }
    }

    class LinkHandler
    implements HyperlinkListener {
        LinkHandler() {
        }

        public void hyperlinkUpdate(HyperlinkEvent evt) {
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (evt instanceof HTMLFrameHyperlinkEvent) {
                    ((HTMLDocument)HelpViewer.this.viewer.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)evt);
                    HelpViewer.this.historyUpdated();
                } else {
                    URL url = evt.getURL();
                    if (url != null) {
                        HelpViewer.this.gotoURL(url.toString(), true, 0);
                    }
                }
            } else if (evt.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                HelpViewer.this.viewer.setCursor(Cursor.getPredefinedCursor(12));
            } else if (evt.getEventType() == HyperlinkEvent.EventType.EXITED) {
                HelpViewer.this.viewer.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            int scrollPosition;
            String url;
            Object source = evt.getSource();
            String actionCommand = evt.getActionCommand();
            int separatorPosition = actionCommand.lastIndexOf(58);
            if (-1 == separatorPosition) {
                url = actionCommand;
                scrollPosition = 0;
            } else {
                url = actionCommand.substring(0, separatorPosition);
                scrollPosition = Integer.parseInt(actionCommand.substring(separatorPosition + 1));
            }
            if (url.length() != 0) {
                HelpViewer.this.gotoURL(url, false, scrollPosition);
                return;
            }
            if (source == HelpViewer.this.back) {
                HelpHistoryModel.HistoryEntry entry = HelpViewer.this.historyModel.back(HelpViewer.this);
                if (entry == null) {
                    HelpViewer.this.getToolkit().beep();
                } else {
                    HelpViewer.this.gotoURL(entry.url, false, entry.scrollPosition);
                }
            } else if (source == HelpViewer.this.forward) {
                HelpHistoryModel.HistoryEntry entry = HelpViewer.this.historyModel.forward(HelpViewer.this);
                if (entry == null) {
                    HelpViewer.this.getToolkit().beep();
                } else {
                    HelpViewer.this.gotoURL(entry.url, false, entry.scrollPosition);
                }
            }
        }
    }
}

