/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.net.URL;
import java.util.Vector;
import org.gjt.sp.jedit.help.HelpHistoryModelListener;
import org.gjt.sp.jedit.help.HelpViewer;

public class HelpHistoryModel {
    private int historyPos;
    private HistoryEntry[] history;
    private Vector listeners;

    public HelpHistoryModel(int size) {
        boolean historyPos = false;
        this.history = new HistoryEntry[size];
        this.listeners = new Vector();
    }

    public HistoryEntry forward(HelpViewer helpViewer) {
        if (this.history.length - this.historyPos <= 1) {
            return null;
        }
        if (this.history[this.historyPos] == null) {
            return null;
        }
        this.setCurrentScrollPosition(helpViewer.getCurrentPage(), helpViewer.getCurrentScrollPosition());
        HistoryEntry result = new HistoryEntry(this.history[this.historyPos]);
        ++this.historyPos;
        this.fireUpdate();
        return result;
    }

    public boolean hasNext() {
        return this.history.length - this.historyPos > 1 && this.history[this.historyPos] != null;
    }

    public HistoryEntry back(HelpViewer helpViewer) {
        if (this.historyPos <= 1) {
            return null;
        }
        this.setCurrentScrollPosition(helpViewer.getCurrentPage(), helpViewer.getCurrentScrollPosition());
        HistoryEntry result = new HistoryEntry(this.history[--this.historyPos - 1]);
        this.fireUpdate();
        return result;
    }

    public boolean hasPrevious() {
        return this.historyPos > 1;
    }

    public void addToHistory(String url) {
        this.history[this.historyPos] = new HistoryEntry(url, url, 0);
        if (this.historyPos + 1 == this.history.length) {
            System.arraycopy(this.history, 1, this.history, 0, this.history.length - 1);
            this.history[this.historyPos] = null;
        } else {
            ++this.historyPos;
            for (int i = this.historyPos; i < this.history.length; ++i) {
                this.history[i] = null;
            }
        }
        this.fireUpdate();
    }

    public void setCurrentScrollPosition(URL currentPage, int scrollPosition) {
        if (null != currentPage && this.historyPos >= 1 && currentPage.toString().equals(this.history[this.historyPos - 1].url)) {
            this.history[this.historyPos - 1].scrollPosition = scrollPosition;
        }
    }

    public void setCurrentEntry(HistoryEntry entry) {
        for (int i = 0; i < this.history.length; ++i) {
            if (this.history[i] == null || !this.history[i].equals(entry)) continue;
            this.historyPos = i + 1;
            this.fireUpdate();
            break;
        }
    }

    public void updateTitle(String url, String title) {
        for (int i = 0; i < this.history.length; ++i) {
            if (this.history[i] == null || !this.history[i].url.equals(url)) continue;
            this.history[i].title = title;
        }
        this.fireUpdate();
    }

    public HistoryEntry[] getPreviousURLs() {
        if (this.historyPos <= 1) {
            return new HistoryEntry[0];
        }
        HistoryEntry[] previous = new HistoryEntry[this.historyPos - 1];
        System.arraycopy(this.history, 0, previous, 0, this.historyPos - 1);
        return previous;
    }

    public HistoryEntry[] getNextURLs() {
        if (this.history.length - this.historyPos <= 1) {
            return new HistoryEntry[0];
        }
        if (this.history[this.historyPos] == null) {
            return new HistoryEntry[0];
        }
        HistoryEntry[] next = new HistoryEntry[this.history.length - this.historyPos];
        System.arraycopy(this.history, this.historyPos, next, 0, this.history.length - this.historyPos);
        return next;
    }

    public void addHelpHistoryModelListener(HelpHistoryModelListener hhml) {
        this.listeners.add(hhml);
    }

    public void removeHelpHistoryModelListener(HelpHistoryModelListener hhml) {
        this.listeners.remove(hhml);
    }

    public void fireUpdate() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((HelpHistoryModelListener)this.listeners.elementAt(i)).historyUpdated();
        }
    }

    static class HistoryEntry {
        String url;
        String title;
        int scrollPosition;

        HistoryEntry(String url, String title) {
            this(url, title, 0);
        }

        HistoryEntry(HistoryEntry original) {
            this(original.url, original.title, original.scrollPosition);
        }

        HistoryEntry(String url, String title, int scrollPosition) {
            this.url = url;
            this.title = title;
            this.scrollPosition = scrollPosition;
        }

        public boolean equals(HistoryEntry he) {
            return he.url.equals(this.url) && he.title.equals(this.title) && he.scrollPosition == this.scrollPosition;
        }

        public String toString() {
            return this.getClass().getName() + "[url=" + this.url + ",title=" + this.title + ",scrollPosition=" + this.scrollPosition + "]";
        }
    }
}

