/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;

public class WrapWidgetFactory
implements StatusWidgetFactory {
    public Widget getWidget(View view) {
        WrapWidget wrap = new WrapWidget(view);
        return wrap;
    }

    private static class WrapWidget
    implements Widget {
        private final JLabel wrap = new ToolTipLabel();
        private final View view;

        public WrapWidget(final View view) {
            this.wrap.setHorizontalAlignment(0);
            this.wrap.setToolTipText(jEdit.getProperty("view.status.wrap-tooltip"));
            this.view = view;
            this.wrap.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    view.getBuffer().toggleWordWrap(view);
                }
            });
        }

        public JComponent getComponent() {
            return this.wrap;
        }

        public void update() {
            Buffer buffer = this.view.getBuffer();
            String wrap = buffer.getStringProperty("wrap");
            if (wrap.equals("none")) {
                this.wrap.setText("-");
            } else if (wrap.equals("hard")) {
                this.wrap.setText("H");
            } else if (wrap.equals("soft")) {
                this.wrap.setText("S");
            }
        }

        public void propertiesChanged() {
            Font font = new JLabel().getFont();
            FontMetrics fm = this.wrap.getFontMetrics(font);
            Dimension dim = new Dimension(Math.max(Math.max(fm.charWidth('-'), fm.charWidth('H')), fm.charWidth('S')) + 1, fm.getHeight());
            this.wrap.setPreferredSize(dim);
            this.wrap.setMaximumSize(dim);
        }
    }
}

