/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.bufferset.BufferSetManager;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;

public class BufferSetWidgetFactory
implements StatusWidgetFactory {
    public Widget getWidget(View view) {
        BufferSetWidget bufferSetWidget = new BufferSetWidget(view);
        return bufferSetWidget;
    }

    private static class BufferSetWidget
    implements Widget,
    EBComponent {
        private final JLabel bufferSetLabel = new ToolTipLabel(){

            public void addNotify() {
                super.addNotify();
                EditBus.addToBus(BufferSetWidget.this);
            }

            public void removeNotify() {
                super.removeNotify();
                EditBus.removeFromBus(BufferSetWidget.this);
            }
        };
        private final View view;
        private BufferSet.Scope currentScope;

        BufferSetWidget(final View view) {
            this.view = view;
            this.update();
            this.bufferSetLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    if (evt.getClickCount() == 2) {
                        EditPane editPane = view.getEditPane();
                        BufferSet bufferSet = editPane.getBufferSet();
                        BufferSet.Scope scope = bufferSet.getScope();
                        BufferSetManager bufferSetManager = jEdit.getBufferSetManager();
                        switch (scope) {
                            case global: {
                                editPane.setBufferSet(bufferSetManager.getViewBufferSet(editPane.getView()));
                                break;
                            }
                            case view: {
                                editPane.setBufferSet(bufferSetManager.getEditPaneBufferSet(editPane));
                                break;
                            }
                            case editpane: {
                                editPane.setBufferSet(bufferSetManager.getGlobalBufferSet());
                            }
                        }
                    }
                }
            });
        }

        public JComponent getComponent() {
            return this.bufferSetLabel;
        }

        public void update() {
            BufferSet.Scope scope = this.view.getEditPane().getBufferSet().getScope();
            if (this.currentScope == null || !this.currentScope.equals((Object)scope)) {
                this.bufferSetLabel.setText(scope.toString().substring(0, 1).toUpperCase());
                this.bufferSetLabel.setToolTipText(jEdit.getProperty("view.status.bufferset-tooltip", new Object[]{scope}));
                this.currentScope = scope;
            }
        }

        public void propertiesChanged() {
            Font font = new JLabel().getFont();
            FontMetrics fm = this.bufferSetLabel.getFontMetrics(font);
            Dimension dim = new Dimension(Math.max(fm.charWidth('E'), Math.max(fm.charWidth('V'), fm.charWidth('G'))), fm.getHeight());
            this.bufferSetLabel.setPreferredSize(dim);
            this.bufferSetLabel.setMaximumSize(dim);
        }

        public void handleMessage(EBMessage message) {
            EditPaneUpdate editPaneUpdate;
            if (message instanceof ViewUpdate) {
                ViewUpdate viewUpdate = (ViewUpdate)message;
                if (viewUpdate.getWhat() == ViewUpdate.EDIT_PANE_CHANGED) {
                    this.update();
                }
            } else if (message instanceof EditPaneUpdate && (editPaneUpdate = (EditPaneUpdate)message).getEditPane() == this.view.getEditPane() && editPaneUpdate.getWhat() == EditPaneUpdate.BUFFERSET_CHANGED) {
                this.update();
            }
        }
    }
}

