/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableWindow;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.RegisterChanged;

public class RegisterViewer
extends JPanel
implements EBComponent,
ActionListener,
DockableWindow {
    private JList registerList;
    private JTextArea contentTextArea;
    private DocumentHandler documentHandler;
    private View view;
    private boolean editing;
    private JSplitPane splitPane;
    private JPopupMenu popup;

    public RegisterViewer(View view, String position) {
        super(new BorderLayout());
        this.view = view;
        Box toolBar = new Box(0);
        JLabel label = new JLabel(jEdit.getProperty("view-registers.title"));
        label.setBorder(new EmptyBorder(0, 0, 3, 0));
        toolBar.add(label);
        toolBar.add(Box.createGlue());
        RolloverButton pasteRegister = new RolloverButton(GUIUtilities.loadIcon("Paste.png"));
        pasteRegister.setToolTipText(GUIUtilities.prettifyMenuLabel(jEdit.getProperty("paste-string-register.label")));
        pasteRegister.addActionListener(this);
        pasteRegister.setActionCommand("paste-string-register");
        toolBar.add(pasteRegister);
        RolloverButton clearRegister = new RolloverButton(GUIUtilities.loadIcon("Clear.png"));
        clearRegister.setToolTipText(GUIUtilities.prettifyMenuLabel(jEdit.getProperty("clear-string-register.label")));
        clearRegister.addActionListener(this);
        clearRegister.setActionCommand("clear-string-register");
        toolBar.add(clearRegister);
        this.add("North", toolBar);
        DefaultListModel registerModel = new DefaultListModel();
        this.registerList = new JList(registerModel);
        this.registerList.setSelectionMode(0);
        this.registerList.setCellRenderer(new Renderer());
        this.registerList.addListSelectionListener(new ListHandler());
        this.registerList.addMouseListener(new MouseHandler());
        this.contentTextArea = new JTextArea(10, 20);
        this.contentTextArea.setEditable(true);
        this.documentHandler = new DocumentHandler();
        this.contentTextArea.addFocusListener(new FocusHandler());
        int orientation = 1;
        if (position.equals("left") || position.equals("right")) {
            orientation = 0;
        }
        this.splitPane = new JSplitPane(orientation, jEdit.getBooleanProperty("appearance.continuousLayout"), new JScrollPane(this.registerList), new JScrollPane(this.contentTextArea));
        this.add("Center", this.splitPane);
        this.refreshList();
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals("paste-string-register")) {
            this.insertRegister();
        } else if (cmd.equals("clear-string-register")) {
            this.clearSelectedIndex();
        }
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof RegisterChanged) {
            if (((RegisterChanged)msg).getRegisterName() != '%') {
                this.refreshList();
            }
        } else if (msg instanceof PropertiesChanged) {
            GUIUtilities.initContinuousLayout(this.splitPane);
        }
    }

    public void addNotify() {
        super.addNotify();
        EditBus.addToBus(this);
    }

    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus(this);
    }

    public void move(String newPosition) {
        int orientation = 1;
        if (newPosition.equals("left") || newPosition.equals("right")) {
            orientation = 0;
        }
        this.splitPane.setOrientation(orientation);
        this.revalidate();
    }

    private void clearSelectedIndex() {
        Object o = this.registerList.getSelectedValue();
        if (o != null && o instanceof Character) {
            Registers.clearRegister(((Character)o).charValue());
            this.refreshList();
        }
    }

    private void refreshList() {
        DefaultListModel registerModel = (DefaultListModel)this.registerList.getModel();
        Object o = this.registerList.getSelectedValue();
        int selected = -1;
        if (o != null && o instanceof Character) {
            selected = ((Character)o).charValue();
        }
        registerModel.removeAllElements();
        Registers.Register[] registers = Registers.getRegisters();
        int index = 0;
        for (int i = 0; i < registers.length; ++i) {
            String value;
            Registers.Register reg = registers[i];
            if (reg == null || i == 37 || (value = ((Object)reg).toString()) == null) continue;
            if (i == selected) {
                index = registerModel.size();
            }
            registerModel.addElement(Character.valueOf((char)i));
        }
        if (registerModel.getSize() == 0) {
            registerModel.addElement(jEdit.getProperty("view-registers.none"));
            this.registerList.setEnabled(false);
        } else {
            this.registerList.setEnabled(true);
        }
        this.registerList.setSelectedIndex(index);
    }

    private void insertRegister() {
        Object o = this.registerList.getSelectedValue();
        if (o == null || !(o instanceof Character)) {
            return;
        }
        Registers.Register reg = Registers.getRegister(((Character)o).charValue());
        this.view.getTextArea().setSelectedText(((Object)reg).toString());
        this.view.getTextArea().requestFocus();
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        public void focusGained(FocusEvent e) {
            RegisterViewer.this.contentTextArea.getDocument().addDocumentListener(RegisterViewer.this.documentHandler);
        }

        public void focusLost(FocusEvent e) {
            RegisterViewer.this.contentTextArea.getDocument().removeDocumentListener(RegisterViewer.this.documentHandler);
        }
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        public void changedUpdate(DocumentEvent e) {
            this.updateRegisterSafely();
        }

        public void insertUpdate(DocumentEvent e) {
            this.updateRegisterSafely();
        }

        public void removeUpdate(DocumentEvent e) {
            this.updateRegisterSafely();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateRegisterSafely() {
            try {
                RegisterViewer.this.editing = true;
                this.updateRegister();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                RegisterViewer.this.editing = false;
                throw throwable;
            }
            RegisterViewer.this.editing = false;
        }

        private void updateRegister() {
            Object value = RegisterViewer.this.registerList.getSelectedValue();
            if (!(value instanceof Character)) {
                return;
            }
            char name = ((Character)value).charValue();
            Registers.setRegister(name, RegisterViewer.this.contentTextArea.getText());
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            int i = RegisterViewer.this.registerList.locationToIndex(evt.getPoint());
            if (i != -1) {
                RegisterViewer.this.registerList.setSelectedIndex(i);
            }
            if (GUIUtilities.isPopupTrigger(evt)) {
                if (RegisterViewer.this.popup == null) {
                    RegisterViewer.this.popup = new JPopupMenu();
                    JMenuItem item = GUIUtilities.loadMenuItem("paste");
                    RegisterViewer.this.popup.add(item);
                    item = new JMenuItem(jEdit.getProperty("clear-string-register.label"));
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            RegisterViewer.this.clearSelectedIndex();
                        }
                    });
                    RegisterViewer.this.popup.add(item);
                }
                GUIUtilities.showPopupMenu(RegisterViewer.this.popup, RegisterViewer.this.registerList, evt.getX(), evt.getY(), false);
            } else if (evt.getClickCount() % 2 == 0) {
                RegisterViewer.this.insertRegister();
            }
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            Object value = RegisterViewer.this.registerList.getSelectedValue();
            if (!(value instanceof Character)) {
                if (!RegisterViewer.this.editing) {
                    RegisterViewer.this.contentTextArea.setText("");
                    RegisterViewer.this.contentTextArea.setEditable(false);
                }
                return;
            }
            char name = ((Character)value).charValue();
            Registers.Register reg = Registers.getRegister(name);
            if (reg == null) {
                if (!RegisterViewer.this.editing) {
                    RegisterViewer.this.contentTextArea.setText("");
                    RegisterViewer.this.contentTextArea.setEditable(false);
                }
                return;
            }
            if (!RegisterViewer.this.editing) {
                RegisterViewer.this.contentTextArea.setText(((Object)reg).toString());
                RegisterViewer.this.contentTextArea.setEditable(true);
                RegisterViewer.this.contentTextArea.setCaretPosition(0);
            }
        }
    }

    static class Renderer
    extends DefaultListCellRenderer {
        Renderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Character) {
                String registerValue;
                char name = ((Character)value).charValue();
                String label = name == '\n' ? "\n" : (name == '\t' ? "\t" : (name == '$' ? jEdit.getProperty("view-registers.clipboard") : (name == '%' ? jEdit.getProperty("view-registers.selection") : String.valueOf(name))));
                Registers.Register register = Registers.getRegister(name);
                if (register == null) {
                    registerValue = jEdit.getProperty("view-registers.undefined");
                } else {
                    registerValue = ((Object)register).toString();
                    if (registerValue.length() > 100) {
                        registerValue = registerValue.substring(0, 100) + "...";
                    }
                    registerValue = registerValue.replaceAll("\n", " ");
                    registerValue = registerValue.replaceAll("\t", " ");
                }
                this.setText(label + " : " + registerValue);
            }
            return this;
        }
    }
}

