/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilteredTableModel<E extends TableModel>
extends AbstractTableModel
implements TableModelListener {
    protected E delegated;
    private Vector<Integer> filteredIndices;
    private Map<Integer, Integer> invertedIndices;
    private String filter;
    private JTable table;

    protected FilteredTableModel(E delegated) {
        this.delegated = delegated;
        delegated.addTableModelListener(this);
        this.resetFilter();
    }

    public void setTable(JTable table) {
        if (table.getModel() != this) {
            throw new IllegalArgumentException("The given table " + table + " doesn't use this model " + this);
        }
        this.table = table;
    }

    public E getDelegated() {
        return this.delegated;
    }

    public void setDelegated(E delegated) {
        this.delegated.removeTableModelListener(this);
        delegated.addTableModelListener(this);
        this.delegated = delegated;
    }

    private void resetFilter() {
        this.filteredIndices = null;
    }

    public void setFilter(String filter) {
        Set<Integer> selectedIndices = this.saveSelection();
        this.filter = filter;
        if (filter != null && filter.length() > 0) {
            int size = this.delegated.getRowCount();
            filter = this.prepareFilter(filter);
            Vector<Integer> indices = new Vector<Integer>(size);
            HashMap<Integer, Integer> invertedIndices = new HashMap<Integer, Integer>();
            for (int i = 0; i < size; ++i) {
                if (!this.passFilter(i, filter)) continue;
                Integer delegatedIndice = i;
                indices.add(delegatedIndice);
                invertedIndices.put(delegatedIndice, indices.size() - 1);
            }
            this.invertedIndices = invertedIndices;
            this.filteredIndices = indices;
        } else {
            this.resetFilter();
        }
        this.fireTableDataChanged();
        this.restoreSelection(selectedIndices);
    }

    public String prepareFilter(String filter) {
        return filter;
    }

    public abstract boolean passFilter(int var1, String var2);

    private Set<Integer> saveSelection() {
        if (this.table == null) {
            return null;
        }
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            return null;
        }
        HashSet<Integer> selectedRows = new HashSet<Integer>(rows.length);
        for (int row : rows) {
            selectedRows.add(this.getTrueRow(row));
        }
        return selectedRows;
    }

    private void restoreSelection(Set<Integer> selectedIndices) {
        if (selectedIndices == null || this.getRowCount() == 0) {
            return;
        }
        for (Integer selectedIndex : selectedIndices) {
            int i = this.getInternal2ExternalRow(selectedIndex);
            if (i == -1) continue;
            this.table.getSelectionModel().setSelectionInterval(i, i);
        }
    }

    @Override
    public int getRowCount() {
        if (this.filteredIndices == null) {
            return this.delegated.getRowCount();
        }
        return this.filteredIndices.size();
    }

    @Override
    public int getColumnCount() {
        return this.delegated.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.delegated.getColumnName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.delegated.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        int trueRowIndex = this.getTrueRow(rowIndex);
        return this.delegated.isCellEditable(trueRowIndex, columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int trueRowIndex = this.getTrueRow(rowIndex);
        return this.delegated.getValueAt(trueRowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int trueRowIndex = this.getTrueRow(rowIndex);
        this.delegated.setValueAt(aValue, trueRowIndex, columnIndex);
    }

    public int getTrueRow(int rowIndex) {
        if (this.filteredIndices == null) {
            return rowIndex;
        }
        return this.filteredIndices.get(rowIndex);
    }

    public int getInternal2ExternalRow(int internalRowIndex) {
        if (this.invertedIndices == null) {
            return internalRowIndex;
        }
        Integer externalRowIndex = this.invertedIndices.get(internalRowIndex);
        if (externalRowIndex == null) {
            return -1;
        }
        return externalRowIndex;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.setFilter(this.filter);
    }
}

