/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilteredListModel<E extends ListModel>
extends AbstractListModel
implements ListDataListener {
    protected E delegated;
    private Vector<Integer> filteredIndices;
    private Map<Integer, Integer> invertedIndices;
    private String filter;
    private JList list;

    protected FilteredListModel(E delegated) {
        this.delegated = delegated;
        delegated.addListDataListener(this);
        this.resetFilter();
    }

    public void setList(JList list) {
        if (list.getModel() != this) {
            throw new IllegalArgumentException("The given list " + list + " doesn't use this model " + this);
        }
        this.list = list;
    }

    public E getDelegated() {
        return this.delegated;
    }

    public void setDelegated(E delegated) {
        this.delegated.removeListDataListener(this);
        delegated.addListDataListener(this);
        this.delegated = delegated;
    }

    private void resetFilter() {
        this.filteredIndices = null;
    }

    public void setFilter(final String filter) {
        Runnable runner = new Runnable(){

            public void run() {
                Set<Integer> selectedIndices = FilteredListModel.this.saveSelection();
                FilteredListModel.this.filter = filter;
                if (filter != null && filter.length() > 0) {
                    int size = FilteredListModel.this.delegated.getSize();
                    String prepped_filter = FilteredListModel.this.prepareFilter(filter);
                    Vector<Integer> indices = new Vector<Integer>(size);
                    HashMap<Integer, Integer> invertedIndices = new HashMap<Integer, Integer>();
                    for (int i = 0; i < size; ++i) {
                        if (!FilteredListModel.this.passFilter(i, prepped_filter)) continue;
                        Integer delegatedIndice = i;
                        indices.add(delegatedIndice);
                        invertedIndices.put(delegatedIndice, indices.size() - 1);
                    }
                    FilteredListModel.this.invertedIndices = invertedIndices;
                    FilteredListModel.this.filteredIndices = indices;
                } else {
                    FilteredListModel.this.resetFilter();
                }
                FilteredListModel.this.fireContentsChanged(this, 0, FilteredListModel.this.getSize());
                FilteredListModel.this.restoreSelection(selectedIndices);
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    public String prepareFilter(String filter) {
        return filter;
    }

    public abstract boolean passFilter(int var1, String var2);

    protected Set<Integer> saveSelection() {
        if (this.list == null) {
            return null;
        }
        int[] rows = this.list.getSelectedIndices();
        if (rows.length == 0) {
            return null;
        }
        HashSet<Integer> selectedRows = new HashSet<Integer>(rows.length);
        for (int row : rows) {
            selectedRows.add(this.getTrueRow(row));
        }
        return selectedRows;
    }

    protected void restoreSelection(Set<Integer> selectedIndices) {
        if (selectedIndices == null || this.getSize() == 0) {
            return;
        }
        for (Integer selectedIndex : selectedIndices) {
            int i = this.getInternal2ExternalRow(selectedIndex);
            if (i == -1) continue;
            this.list.setSelectionInterval(i, i);
        }
    }

    public int getTrueRow(int rowIndex) {
        if (this.filteredIndices == null) {
            return rowIndex;
        }
        return this.filteredIndices.get(rowIndex);
    }

    public int getInternal2ExternalRow(int internalRowIndex) {
        if (this.invertedIndices == null) {
            return internalRowIndex;
        }
        Integer externalRowIndex = this.invertedIndices.get(internalRowIndex);
        if (externalRowIndex == null) {
            return -1;
        }
        return externalRowIndex;
    }

    @Override
    public Object getElementAt(int index) {
        int trueRowIndex = this.getTrueRow(index);
        return this.delegated.getElementAt(trueRowIndex);
    }

    @Override
    public int getSize() {
        if (this.filteredIndices == null) {
            return this.delegated.getSize();
        }
        return this.filteredIndices.size();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.setFilter(this.filter);
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.setFilter(this.filter);
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.setFilter(this.filter);
    }
}

