/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.gjt.sp.jedit.gui.ExtendedGridLayoutConstraints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedGridLayout
implements LayoutManager2 {
    private final Hashtable<Component, ExtendedGridLayoutConstraints> comptable;
    private final int hgap;
    private final int vgap;
    private final Insets distanceToBorders;

    public ExtendedGridLayout(int hgap, int vgap, Insets distanceToBorders) {
        if (hgap < 0) {
            throw new IllegalArgumentException("hgap must be non-negative (" + hgap + ')');
        }
        if (vgap < 0) {
            throw new IllegalArgumentException("vgap must be non-negative (" + vgap + ')');
        }
        this.hgap = hgap;
        this.vgap = vgap;
        this.distanceToBorders = (Insets)distanceToBorders.clone();
        this.comptable = new Hashtable();
    }

    public ExtendedGridLayout() {
        this(0, 0, new Insets(0, 0, 0, 0));
    }

    @Override
    public void addLayoutComponent(String name, Component component) {
        this.addLayoutComponent(component, name);
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
        ExtendedGridLayoutConstraints eglConstraints;
        if (null == constraints) {
            constraints = new ExtendedGridLayoutConstraints(component);
        }
        if (constraints instanceof ExtendedGridLayoutConstraints) {
            eglConstraints = (ExtendedGridLayoutConstraints)constraints;
            if (eglConstraints.isPlaceholder()) {
                throw new IllegalArgumentException("constraints must not be a placeholder");
            }
            if (component != eglConstraints.getComponent()) {
                throw new IllegalArgumentException("constraints is not the right one for this component");
            }
        } else {
            throw new IllegalArgumentException("constraints must not be an ExtendedGridLayoutConstraints object");
        }
        this.comptable.put(component, eglConstraints);
    }

    private ExtendedGridLayoutConstraints lookupConstraints(Component component) {
        if (null == component) {
            throw new NullPointerException("component must not be null");
        }
        ExtendedGridLayoutConstraints constraints = this.comptable.get(component);
        if (null == constraints) {
            constraints = new ExtendedGridLayoutConstraints(component);
            this.comptable.put(component, constraints);
        }
        return constraints;
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.comptable.remove(component);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            ArrayList<List<ExtendedGridLayoutConstraints>> gridRows = new ArrayList<List<ExtendedGridLayoutConstraints>>();
            HashSet<ExtendedGridLayoutConstraints> colspans = new HashSet<ExtendedGridLayoutConstraints>();
            HashSet<ExtendedGridLayoutConstraints> rowspans = new HashSet<ExtendedGridLayoutConstraints>();
            Dimension gridSize = this.buildGrid(parent, gridRows, colspans, rowspans);
            return this.getSize(parent, LayoutSize.MINIMUM, false, gridSize, gridRows, colspans, rowspans, new int[0][0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            ArrayList<List<ExtendedGridLayoutConstraints>> gridRows = new ArrayList<List<ExtendedGridLayoutConstraints>>();
            HashSet<ExtendedGridLayoutConstraints> colspans = new HashSet<ExtendedGridLayoutConstraints>();
            HashSet<ExtendedGridLayoutConstraints> rowspans = new HashSet<ExtendedGridLayoutConstraints>();
            Dimension gridSize = this.buildGrid(parent, gridRows, colspans, rowspans);
            return this.getSize(parent, LayoutSize.PREFERRED, false, gridSize, gridRows, colspans, rowspans, new int[0][0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension maximumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            ArrayList<List<ExtendedGridLayoutConstraints>> gridRows = new ArrayList<List<ExtendedGridLayoutConstraints>>();
            HashSet<ExtendedGridLayoutConstraints> colspans = new HashSet<ExtendedGridLayoutConstraints>();
            HashSet<ExtendedGridLayoutConstraints> rowspans = new HashSet<ExtendedGridLayoutConstraints>();
            Dimension gridSize = this.buildGrid(parent, gridRows, colspans, rowspans);
            return this.getSize(parent, LayoutSize.MAXIMUM, false, gridSize, gridRows, colspans, rowspans, new int[0][0]);
        }
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            ArrayList<List<ExtendedGridLayoutConstraints>> gridRows = new ArrayList<List<ExtendedGridLayoutConstraints>>();
            HashSet<ExtendedGridLayoutConstraints> colspans = new HashSet<ExtendedGridLayoutConstraints>();
            HashSet<ExtendedGridLayoutConstraints> rowspans = new HashSet<ExtendedGridLayoutConstraints>();
            Dimension gridSize = this.buildGrid(parent, gridRows, colspans, rowspans);
            int[][] layoutSizes = new int[6][];
            Dimension preferredSize = this.getSize(parent, LayoutSize.PREFERRED, true, gridSize, gridRows, colspans, rowspans, layoutSizes);
            int[] minimumColWidths = layoutSizes[0];
            int[] minimumRowHeights = layoutSizes[1];
            int[] preferredColWidths = layoutSizes[2];
            int[] preferredRowHeights = layoutSizes[3];
            int[] maximumColWidths = layoutSizes[4];
            int[] maximumRowHeights = layoutSizes[5];
            Dimension parentSize = parent.getSize();
            Insets insets = parent.getInsets();
            int freeWidth = parentSize.width - insets.left - insets.right - (gridSize.width - 1) * this.hgap - this.distanceToBorders.left - this.distanceToBorders.right;
            int freeHeight = parentSize.height - insets.top - insets.bottom - (gridSize.height - 1) * this.vgap - this.distanceToBorders.top - this.distanceToBorders.bottom;
            this.redistributeSpace(preferredSize.width, freeWidth, 0, gridSize.width, preferredColWidths, minimumColWidths, maximumColWidths);
            this.redistributeSpace(preferredSize.height, freeHeight, 0, gridSize.height, preferredRowHeights, minimumRowHeights, maximumRowHeights);
            int y = insets.top + this.distanceToBorders.top;
            for (int row = 0; row < gridSize.height; ++row) {
                List gridRow = (List)gridRows.get(row);
                int x = insets.left + this.distanceToBorders.left;
                for (int col = 0; col < gridSize.width; ++col) {
                    ExtendedGridLayoutConstraints cell = (ExtendedGridLayoutConstraints)gridRow.get(col);
                    if (null != cell && null != cell.getComponent() && !cell.isPlaceholder()) {
                        Component component = cell.getComponent();
                        Dimension maxSize = component.getMaximumSize();
                        int fromCol = cell.getCol();
                        int colspan = cell.getEffectiveColspan();
                        int toCol = fromCol + colspan;
                        int width = 0;
                        for (int col2 = fromCol; col2 < toCol; ++col2) {
                            width += preferredColWidths[col2];
                        }
                        width += (colspan - 1) * this.hgap;
                        int fromRow = cell.getRow();
                        int rowspan = cell.getEffectiveRowspan();
                        int toRow = fromRow + rowspan;
                        int height = 0;
                        for (int row2 = fromRow; row2 < toRow; ++row2) {
                            height += preferredRowHeights[row2];
                        }
                        height += (rowspan - 1) * this.vgap;
                        int xCorrection = 0;
                        int yCorrection = 0;
                        if (width > maxSize.width) {
                            xCorrection = (int)((float)(width - maxSize.width) * component.getAlignmentX());
                            width = maxSize.width;
                        }
                        if (height > maxSize.height) {
                            yCorrection = (int)((float)(height - maxSize.height) * component.getAlignmentY());
                            height = maxSize.height;
                        }
                        component.setBounds(x + xCorrection, y + yCorrection, width, height);
                    }
                    x += preferredColWidths[col] + this.hgap;
                }
                y += preferredRowHeights[row] + this.vgap;
            }
        }
    }

    private void redistributeSpace(int totalSize, int freeSize, int start, int stop, int[] preferredElementSizes, int[] minimumElementSizes, int[] maximumElementSizes) {
        if (totalSize != freeSize) {
            boolean grow = totalSize < freeSize;
            freeSize = (freeSize - totalSize) * (grow ? 1 : -1);
            while (freeSize > 0) {
                int i;
                int modifyableAmount = 0;
                long modifySize = 0L;
                for (int i2 = start; i2 < stop; ++i2) {
                    if ((!grow || preferredElementSizes[i2] >= maximumElementSizes[i2]) && (grow || preferredElementSizes[i2] <= minimumElementSizes[i2])) continue;
                    ++modifyableAmount;
                    modifySize += (long)preferredElementSizes[i2];
                }
                boolean checkBounds = true;
                if (0 == modifyableAmount) {
                    for (i = start; i < stop; ++i) {
                        modifySize += (long)preferredElementSizes[i];
                    }
                    checkBounds = false;
                    modifyableAmount = stop - start;
                }
                if (modifySize == 0L) break;
                if (freeSize < modifyableAmount) {
                    for (i = start; i < stop; ++i) {
                        if (freeSize == 0 || checkBounds && (!checkBounds || !grow || preferredElementSizes[i] >= maximumElementSizes[i]) && (grow || preferredElementSizes[i] <= minimumElementSizes[i])) continue;
                        int n = i;
                        preferredElementSizes[n] = preferredElementSizes[n] + (grow ? 1 : -1);
                        if (0 > preferredElementSizes[i]) {
                            preferredElementSizes[i] = 0;
                        }
                        --freeSize;
                    }
                    continue;
                }
                long modifySizeAddition = 0L;
                double factor = (double)((long)freeSize + modifySize) / (double)modifySize;
                for (int i3 = start; i3 < stop; ++i3) {
                    long modifyableSize = checkBounds ? (grow ? maximumElementSizes[i3] - preferredElementSizes[i3] : preferredElementSizes[i3] - minimumElementSizes[i3]) : Integer.MAX_VALUE - preferredElementSizes[i3];
                    long elementModifySize = Math.abs(Math.round(factor * (double)preferredElementSizes[i3] - (double)preferredElementSizes[i3]));
                    if (elementModifySize <= modifyableSize) {
                        int n = i3;
                        preferredElementSizes[n] = (int)((long)preferredElementSizes[n] + (grow ? elementModifySize : -elementModifySize));
                        modifySizeAddition += grow ? elementModifySize : -elementModifySize;
                        freeSize = (int)((long)freeSize - elementModifySize);
                    } else {
                        int n = i3;
                        preferredElementSizes[n] = (int)((long)preferredElementSizes[n] + (grow ? modifyableSize : -modifyableSize));
                        modifySizeAddition += grow ? modifyableSize : -modifyableSize;
                        freeSize = (int)((long)freeSize - modifyableSize);
                    }
                    if (0 <= preferredElementSizes[i3]) continue;
                    preferredElementSizes[i3] = 0;
                }
                modifySize += modifySizeAddition;
            }
        }
    }

    private Dimension getSize(Container parent, LayoutSize layoutSize, boolean fillRawSizes, Dimension gridSize, List<List<ExtendedGridLayoutConstraints>> gridRows, Set<ExtendedGridLayoutConstraints> colspans, Set<ExtendedGridLayoutConstraints> rowspans, int[][] resultArrays) {
        int[] rowHeights;
        int[] colWidths;
        Component component;
        if (fillRawSizes && resultArrays.length < 6) {
            throw new IllegalArgumentException("If fillRawSizes is true, resultArrays.length must be >= 6 (" + resultArrays.length + ')');
        }
        int[] minimumColWidths = new int[gridSize.width];
        int[] minimumRowHeights = new int[gridSize.height];
        int[] preferredColWidths = new int[gridSize.width];
        int[] preferredRowHeights = new int[gridSize.height];
        int[] maximumColWidths = new int[gridSize.width];
        int[] maximumRowHeights = new int[gridSize.height];
        Arrays.fill(minimumColWidths, 0);
        Arrays.fill(minimumRowHeights, 0);
        Arrays.fill(preferredColWidths, 0);
        Arrays.fill(preferredRowHeights, 0);
        Arrays.fill(maximumColWidths, 0);
        Arrays.fill(maximumRowHeights, 0);
        for (int row = 0; row < gridSize.height; ++row) {
            List<ExtendedGridLayoutConstraints> gridRow = gridRows.get(row);
            for (int col = 0; col < gridSize.width; ++col) {
                ExtendedGridLayoutConstraints cell = gridRow.get(col);
                if (null == cell || null == cell.getComponent()) continue;
                Component component2 = cell.getComponent();
                Dimension minimumSize = component2.getMinimumSize();
                Dimension preferredSize = component2.getPreferredSize();
                Dimension maximumSize = component2.getMaximumSize();
                if (!colspans.contains(cell)) {
                    minimumColWidths[col] = Math.max(minimumColWidths[col], minimumSize.width);
                    preferredColWidths[col] = Math.max(preferredColWidths[col], preferredSize.width);
                    maximumColWidths[col] = Math.max(maximumColWidths[col], maximumSize.width);
                }
                if (rowspans.contains(cell)) continue;
                minimumRowHeights[row] = Math.max(minimumRowHeights[row], minimumSize.height);
                preferredRowHeights[row] = Math.max(preferredRowHeights[row], preferredSize.height);
                maximumRowHeights[row] = Math.max(maximumRowHeights[row], maximumSize.height);
            }
        }
        for (int col = 0; col < gridSize.width; ++col) {
            if (minimumColWidths[col] >= maximumColWidths[col]) {
                maximumColWidths[col] = minimumColWidths[col];
                preferredColWidths[col] = minimumColWidths[col];
                continue;
            }
            if (preferredColWidths[col] < minimumColWidths[col]) {
                preferredColWidths[col] = minimumColWidths[col];
                continue;
            }
            if (preferredColWidths[col] <= maximumColWidths[col]) continue;
            preferredColWidths[col] = maximumColWidths[col];
        }
        for (ExtendedGridLayoutConstraints cell : colspans) {
            int wantedPreferredColWidth;
            int wantedMinimumColWidth;
            int fromCol = cell.getCol();
            int colspan = cell.getEffectiveColspan();
            int toCol = fromCol + colspan;
            int currentMinimumColWidth = 0;
            int currentPreferredColWidth = 0;
            int currentMaximumColWidth = 0;
            for (int col = fromCol; col < toCol; ++col) {
                int minimumColWidth = minimumColWidths[col];
                currentMinimumColWidth = Integer.MAX_VALUE - minimumColWidth < currentMinimumColWidth ? Integer.MAX_VALUE : (currentMinimumColWidth += minimumColWidth);
                int preferredColWidth = preferredColWidths[col];
                currentPreferredColWidth = Integer.MAX_VALUE - preferredColWidth < currentPreferredColWidth ? Integer.MAX_VALUE : (currentPreferredColWidth += preferredColWidth);
                int maximumColWidth = maximumColWidths[col];
                if (Integer.MAX_VALUE - maximumColWidth < currentMaximumColWidth) {
                    currentMaximumColWidth = Integer.MAX_VALUE;
                    continue;
                }
                currentMaximumColWidth += maximumColWidth;
            }
            component = cell.getComponent();
            int wantedMaximumColWidth = component.getMaximumSize().width - (colspan - 1) * this.hgap;
            if (currentMaximumColWidth < wantedMaximumColWidth) {
                this.redistributeSpace(currentMaximumColWidth, wantedMaximumColWidth, fromCol, toCol, maximumColWidths, maximumColWidths, maximumColWidths);
            }
            if (currentMinimumColWidth < (wantedMinimumColWidth = component.getMinimumSize().width - (colspan - 1) * this.hgap)) {
                this.redistributeSpace(currentMinimumColWidth, wantedMinimumColWidth, fromCol, toCol, minimumColWidths, minimumColWidths, maximumColWidths);
            }
            if (currentPreferredColWidth >= (wantedPreferredColWidth = component.getPreferredSize().width - (colspan - 1) * this.hgap)) continue;
            this.redistributeSpace(currentPreferredColWidth, wantedPreferredColWidth, fromCol, toCol, preferredColWidths, minimumColWidths, maximumColWidths);
        }
        for (int col = 0; col < gridSize.width; ++col) {
            if (minimumColWidths[col] >= maximumColWidths[col]) {
                maximumColWidths[col] = minimumColWidths[col];
                preferredColWidths[col] = minimumColWidths[col];
                continue;
            }
            if (preferredColWidths[col] < minimumColWidths[col]) {
                preferredColWidths[col] = minimumColWidths[col];
                continue;
            }
            if (preferredColWidths[col] <= maximumColWidths[col]) continue;
            preferredColWidths[col] = maximumColWidths[col];
        }
        for (int row = 0; row < gridSize.height; ++row) {
            if (minimumRowHeights[row] >= maximumRowHeights[row]) {
                maximumRowHeights[row] = minimumRowHeights[row];
                preferredRowHeights[row] = minimumRowHeights[row];
                continue;
            }
            if (preferredRowHeights[row] < minimumRowHeights[row]) {
                preferredRowHeights[row] = minimumRowHeights[row];
                continue;
            }
            if (preferredRowHeights[row] <= maximumRowHeights[row]) continue;
            preferredRowHeights[row] = maximumRowHeights[row];
        }
        for (ExtendedGridLayoutConstraints cell : rowspans) {
            int wantedPreferredRowHeight;
            int wantedMinimumRowHeight;
            int fromRow = cell.getRow();
            int rowspan = cell.getEffectiveRowspan();
            int toRow = fromRow + rowspan;
            int currentMinimumRowHeight = 0;
            int currentPreferredRowHeight = 0;
            int currentMaximumRowHeight = 0;
            for (int row = fromRow; row < toRow; ++row) {
                int minimumRowHeight = minimumRowHeights[row];
                currentMinimumRowHeight = Integer.MAX_VALUE - minimumRowHeight < currentMinimumRowHeight ? Integer.MAX_VALUE : (currentMinimumRowHeight += minimumRowHeight);
                int preferredRowHeight = preferredRowHeights[row];
                currentPreferredRowHeight = Integer.MAX_VALUE - preferredRowHeight < currentPreferredRowHeight ? Integer.MAX_VALUE : (currentPreferredRowHeight += preferredRowHeight);
                int maximumRowHeight = maximumRowHeights[row];
                if (Integer.MAX_VALUE - maximumRowHeight < currentMaximumRowHeight) {
                    currentMaximumRowHeight = Integer.MAX_VALUE;
                    continue;
                }
                currentMaximumRowHeight += maximumRowHeight;
            }
            component = cell.getComponent();
            int wantedMaximumRowHeight = component.getMaximumSize().height - (rowspan - 1) * this.vgap;
            if (currentMaximumRowHeight < wantedMaximumRowHeight) {
                this.redistributeSpace(currentMaximumRowHeight, wantedMaximumRowHeight, fromRow, toRow, maximumRowHeights, maximumRowHeights, maximumRowHeights);
            }
            if (currentMinimumRowHeight < (wantedMinimumRowHeight = component.getMinimumSize().height - (rowspan - 1) * this.vgap)) {
                this.redistributeSpace(currentMinimumRowHeight, wantedMinimumRowHeight, fromRow, toRow, minimumRowHeights, minimumRowHeights, maximumRowHeights);
            }
            if (currentPreferredRowHeight >= (wantedPreferredRowHeight = component.getPreferredSize().height - (rowspan - 1) * this.vgap)) continue;
            this.redistributeSpace(currentPreferredRowHeight, wantedPreferredRowHeight, fromRow, toRow, preferredRowHeights, minimumRowHeights, maximumRowHeights);
        }
        for (int row = 0; row < gridSize.height; ++row) {
            if (minimumRowHeights[row] >= maximumRowHeights[row]) {
                maximumRowHeights[row] = minimumRowHeights[row];
                preferredRowHeights[row] = minimumRowHeights[row];
                continue;
            }
            if (preferredRowHeights[row] < minimumRowHeights[row]) {
                preferredRowHeights[row] = minimumRowHeights[row];
                continue;
            }
            if (preferredRowHeights[row] <= maximumRowHeights[row]) continue;
            preferredRowHeights[row] = maximumRowHeights[row];
        }
        if (fillRawSizes) {
            resultArrays[0] = minimumColWidths;
            resultArrays[1] = minimumRowHeights;
            resultArrays[2] = preferredColWidths;
            resultArrays[3] = preferredRowHeights;
            resultArrays[4] = maximumColWidths;
            resultArrays[5] = maximumRowHeights;
        }
        switch (layoutSize) {
            case MINIMUM: {
                colWidths = minimumColWidths;
                rowHeights = minimumRowHeights;
                break;
            }
            case PREFERRED: {
                colWidths = preferredColWidths;
                rowHeights = preferredRowHeights;
                break;
            }
            case MAXIMUM: {
                colWidths = maximumColWidths;
                rowHeights = maximumRowHeights;
                break;
            }
            default: {
                throw new InternalError("Missing case branch for LayoutSize: " + (Object)((Object)layoutSize));
            }
        }
        long totalWidth = 0L;
        long totalHeight = 0L;
        for (int width : colWidths) {
            totalWidth += (long)width;
        }
        for (int height : rowHeights) {
            totalHeight += (long)height;
        }
        if (!fillRawSizes) {
            Insets insets = parent.getInsets();
            totalWidth += (long)(insets.left + insets.right + (gridSize.width - 1) * this.hgap + this.distanceToBorders.left + this.distanceToBorders.right);
            totalHeight += (long)(insets.top + insets.bottom + (gridSize.height - 1) * this.vgap + this.distanceToBorders.top + this.distanceToBorders.bottom);
        }
        if (totalWidth > Integer.MAX_VALUE) {
            totalWidth = Integer.MAX_VALUE;
        }
        if (totalHeight > Integer.MAX_VALUE) {
            totalHeight = Integer.MAX_VALUE;
        }
        return new Dimension((int)totalWidth, (int)totalHeight);
    }

    /*
     * Could not resolve type clashes
     */
    private Dimension buildGrid(Container parent, List<List<ExtendedGridLayoutConstraints>> gridRows, Set<ExtendedGridLayoutConstraints> colspans, Set<ExtendedGridLayoutConstraints> rowspans) {
        ExtendedGridLayoutConstraints rowspanPlaceholder;
        ArrayList gridRow;
        Component[] components;
        ArrayList rows = new ArrayList();
        for (Component component : components = parent.getComponents()) {
            int rowNumber;
            if (!component.isVisible()) continue;
            ExtendedGridLayoutConstraints constraints = this.lookupConstraints(component).getWorkCopy();
            int c = rows.size();
            for (int i = rowNumber = constraints.getRow(); i >= c; --i) {
                rows.add(new ArrayList());
            }
            List row = (List)rows.get(rowNumber);
            row.add(constraints);
        }
        ArrayList rowIterators = new ArrayList();
        ArrayList gridRowIterators = new ArrayList();
        boolean haveNext = false;
        for (List row : rows) {
            Iterator rowIterator = row.iterator();
            rowIterators.add(rowIterator);
            if (rowIterator.hasNext()) {
                haveNext = true;
            }
            gridRow = new ArrayList();
            gridRows.add(gridRow);
            gridRowIterators.add(gridRow.listIterator());
        }
        int col = -1;
        while (haveNext) {
            ++col;
            haveNext = false;
            int c = gridRows.size();
            for (int row = 0; row < c; ++row) {
                ExtendedGridLayoutConstraints rowspanSource;
                Iterator rowIterator = (Iterator)rowIterators.get(row);
                ListIterator gridRowIterator = (ListIterator)gridRowIterators.get(row);
                if (row > 0 && null != (rowspanSource = gridRows.get(row - 1).get(col)) && null != (rowspanPlaceholder = rowspanSource.getRowspanPlaceholder(true))) {
                    rowspans.add(rowspanSource);
                    gridRowIterator.add(rowspanPlaceholder);
                    if (null != rowspanPlaceholder.getColspanPlaceholder(false)) {
                        switch (rowspanPlaceholder.getColspan()) {
                            case 0x7FFFFFFF: {
                                break;
                            }
                            default: {
                                haveNext = true;
                                break;
                            }
                        }
                        continue;
                    }
                    if (!rowIterator.hasNext()) continue;
                    haveNext = true;
                    continue;
                }
                if (gridRowIterator.hasPrevious()) {
                    ExtendedGridLayoutConstraints colspanPlaceholder;
                    ExtendedGridLayoutConstraints colspanSource = (ExtendedGridLayoutConstraints)gridRowIterator.previous();
                    gridRowIterator.next();
                    if (null != colspanSource && null != (colspanPlaceholder = colspanSource.getColspanPlaceholder(true))) {
                        colspans.add(colspanSource);
                        gridRowIterator.add(colspanPlaceholder);
                        if (null != colspanPlaceholder.getColspanPlaceholder(false)) {
                            switch (colspanPlaceholder.getColspan()) {
                                case 0x7FFFFFFF: {
                                    break;
                                }
                                default: {
                                    haveNext = true;
                                    break;
                                }
                            }
                            continue;
                        }
                        if (!rowIterator.hasNext()) continue;
                        haveNext = true;
                        continue;
                    }
                }
                if (rowIterator.hasNext()) {
                    ExtendedGridLayoutConstraints newConstraints = (ExtendedGridLayoutConstraints)rowIterator.next();
                    newConstraints.setCol(col);
                    gridRowIterator.add(newConstraints);
                    if (null != newConstraints.getColspanPlaceholder(false)) {
                        switch (newConstraints.getColspan()) {
                            case 0x7FFFFFFF: {
                                break;
                            }
                            default: {
                                haveNext = true;
                                break;
                            }
                        }
                        continue;
                    }
                    if (!rowIterator.hasNext()) continue;
                    haveNext = true;
                    continue;
                }
                gridRowIterator.add(null);
            }
        }
        haveNext = false;
        int gridRowsSize = gridRows.size();
        if (gridRowsSize > 0) {
            ListIterator<ExtendedGridLayoutConstraints> gridRowIterator = gridRows.get(gridRows.size() - 1).listIterator();
            while (gridRowIterator.hasNext()) {
                ExtendedGridLayoutConstraints cell = gridRowIterator.next();
                if (null == cell || Integer.MAX_VALUE == cell.getRowspan() || null == cell.getRowspanPlaceholder(false)) continue;
                haveNext = true;
                break;
            }
            block15: while (haveNext) {
                ExtendedGridLayoutConstraints cell;
                haveNext = false;
                gridRowIterator = gridRows.get(gridRows.size() - 1).listIterator();
                gridRow = new ArrayList();
                gridRows.add(gridRow);
                ListIterator<ExtendedGridLayoutConstraints> newGridRowIterator = gridRow.listIterator();
                while (gridRowIterator.hasNext()) {
                    cell = gridRowIterator.next();
                    if (null != cell && null != cell.getRowspanPlaceholder(false)) {
                        rowspans.add(cell);
                        rowspanPlaceholder = cell.getRowspanPlaceholder(true);
                        newGridRowIterator.add(rowspanPlaceholder);
                        continue;
                    }
                    newGridRowIterator.add(null);
                }
                gridRowIterator = gridRow.listIterator();
                while (gridRowIterator.hasNext()) {
                    cell = gridRowIterator.next();
                    if (null == cell || Integer.MAX_VALUE == cell.getRowspan() || null == cell.getRowspanPlaceholder(false)) continue;
                    haveNext = true;
                    continue block15;
                }
            }
        }
        return new Dimension(col + 1, gridRows.size());
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ",distanceToBorders=" + this.distanceToBorders + ",comptable=" + this.comptable + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LayoutSize {
        MINIMUM,
        PREFERRED,
        MAXIMUM;

    }
}

