/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableLayout;
import org.gjt.sp.jedit.gui.DockablePanel;
import org.gjt.sp.jedit.gui.DockableWindow;
import org.gjt.sp.jedit.gui.DockableWindowContainer;
import org.gjt.sp.jedit.gui.DockableWindowFactory;
import org.gjt.sp.jedit.gui.FloatingWindowContainer;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.PanelWindowContainer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DockableWindowUpdate;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockableWindowManager
extends JPanel
implements EBComponent {
    public static final String FLOATING = "floating";
    public static final String TOP = "top";
    public static final String LEFT = "left";
    public static final String BOTTOM = "bottom";
    public static final String RIGHT = "right";
    private final View view;
    private final DockableWindowFactory factory;
    private final Map<String, Entry> windows;
    private final PanelWindowContainer left;
    private final PanelWindowContainer right;
    private final PanelWindowContainer top;
    private final PanelWindowContainer bottom;
    private final List<Entry> clones;
    private Entry lastEntry;
    public Stack showStack = new Stack();
    int resizePos;
    Rectangle resizeRect;
    private boolean continuousLayout;

    public static String[] getRegisteredDockableWindows() {
        return DockableWindowFactory.getInstance().getRegisteredDockableWindows();
    }

    public DockableWindowManager(View view, DockableWindowFactory factory, View.ViewConfig config) {
        this.setLayout(new DockableLayout());
        this.view = view;
        this.factory = factory;
        this.windows = new HashMap<String, Entry>();
        this.clones = new ArrayList<Entry>();
        this.top = new PanelWindowContainer(this, TOP, config.topPos);
        this.left = new PanelWindowContainer(this, LEFT, config.leftPos);
        this.bottom = new PanelWindowContainer(this, BOTTOM, config.bottomPos);
        this.right = new PanelWindowContainer(this, RIGHT, config.rightPos);
        this.add("top-buttons", this.top.buttonPanel);
        this.add("left-buttons", this.left.buttonPanel);
        this.add("bottom-buttons", this.bottom.buttonPanel);
        this.add("right-buttons", this.right.buttonPanel);
        this.add(TOP, this.top.dockablePanel);
        this.add(LEFT, this.left.dockablePanel);
        this.add(BOTTOM, this.bottom.dockablePanel);
        this.add(RIGHT, this.right.dockablePanel);
    }

    public void init() {
        EditBus.addToBus(this);
        Iterator<DockableWindowFactory.Window> entries = this.factory.getDockableWindowIterator();
        while (entries.hasNext()) {
            this.addEntry(entries.next());
        }
        this.propertiesChanged();
    }

    public KeyListener closeListener(String dockableName) {
        return new KeyHandler(dockableName);
    }

    public View getView() {
        return this.view;
    }

    public JComponent floatDockableWindow(String name) {
        Entry entry = this.windows.get(name);
        if (entry == null) {
            Log.log(9, this, "Unknown dockable window: " + name);
            return null;
        }
        Entry newEntry = new Entry(entry.factory, FLOATING);
        newEntry.win = newEntry.factory.createDockableWindow(this.view, FLOATING);
        if (newEntry.win != null) {
            FloatingWindowContainer fwc = new FloatingWindowContainer(this, true);
            newEntry.container = fwc;
            newEntry.container.register(newEntry);
            newEntry.container.show(newEntry);
        }
        this.clones.add(newEntry);
        return newEntry.win;
    }

    public void showDockableWindow(String name) {
        this.lastEntry = this.windows.get(name);
        if (this.lastEntry == null) {
            Log.log(9, this, "Unknown dockable window: " + name);
            return;
        }
        if (this.lastEntry.win == null) {
            this.lastEntry.win = this.lastEntry.factory.createDockableWindow(this.view, this.lastEntry.position);
        }
        if (this.lastEntry.win != null) {
            if (this.lastEntry.position.equals(FLOATING) && this.lastEntry.container == null) {
                FloatingWindowContainer fwc = new FloatingWindowContainer(this, this.view.isPlainView());
                this.lastEntry.container = fwc;
                this.lastEntry.container.register(this.lastEntry);
            }
            this.showStack.push(name);
            this.lastEntry.container.show(this.lastEntry);
            Object reason = DockableWindowUpdate.ACTIVATED;
            EditBus.send(new DockableWindowUpdate(this, reason, name));
        }
    }

    public void addDockableWindow(String name) {
        this.showDockableWindow(name);
    }

    public void hideDockableWindow(String name) {
        Entry entry = this.windows.get(name);
        if (entry == null) {
            Log.log(9, this, "Unknown dockable window: " + name);
            return;
        }
        if (entry.win == null) {
            return;
        }
        entry.container.show(null);
    }

    public void removeDockableWindow(String name) {
        this.hideDockableWindow(name);
    }

    public void toggleDockableWindow(String name) {
        if (this.isDockableWindowVisible(name)) {
            this.removeDockableWindow(name);
        } else {
            this.addDockableWindow(name);
        }
    }

    public JComponent getDockableWindow(String name) {
        return this.getDockable(name);
    }

    public JComponent getDockable(String name) {
        Entry entry = this.windows.get(name);
        if (entry == null || entry.win == null) {
            return null;
        }
        return entry.win;
    }

    public String getDockableTitle(String name) {
        Entry e = this.windows.get(name);
        return e.longTitle();
    }

    public void setDockableTitle(String dockableName, String newTitle) {
        Entry entry = this.windows.get(dockableName);
        String propName = entry.factory.name + ".longtitle";
        String oldTitle = jEdit.getProperty(propName);
        jEdit.setProperty(propName, newTitle);
        this.firePropertyChange(propName, oldTitle, newTitle);
    }

    public boolean isDockableWindowVisible(String name) {
        Entry entry = this.windows.get(name);
        if (entry == null || entry.win == null) {
            return false;
        }
        return entry.container.isVisible(entry);
    }

    public boolean isDockableWindowDocked(String name) {
        Entry entry = this.windows.get(name);
        if (entry == null) {
            return false;
        }
        return !entry.position.equals(FLOATING);
    }

    public void closeCurrentArea() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    String dockableName = DockableWindowManager.this.showStack.pop().toString();
                    DockableWindowManager.this.hideDockableWindow(dockableName);
                    return;
                }
                catch (Exception e) {
                    for (Component comp = DockableWindowManager.this.view.getFocusOwner(); comp != null; comp = comp.getParent()) {
                        if (!(comp instanceof DockablePanel)) continue;
                        DockablePanel panel = (DockablePanel)comp;
                        PanelWindowContainer container = panel.getWindowContainer();
                        container.show(null);
                        return;
                    }
                    DockableWindowManager.this.getToolkit().beep();
                    return;
                }
            }
        });
    }

    public void close() {
        EditBus.removeFromBus(this);
        for (Entry entry : this.windows.values()) {
            if (entry.win == null) continue;
            entry.container.unregister(entry);
        }
        for (Entry clone : this.clones) {
            if (clone.win == null) continue;
            clone.container.unregister(clone);
        }
    }

    public PanelWindowContainer getTopDockingArea() {
        return this.top;
    }

    public PanelWindowContainer getLeftDockingArea() {
        return this.left;
    }

    public PanelWindowContainer getBottomDockingArea() {
        return this.bottom;
    }

    public PanelWindowContainer getRightDockingArea() {
        return this.right;
    }

    public JPopupMenu createPopupMenu(final DockableWindowContainer container, final String dockable, final boolean clone) {
        JPopupMenu popup = new JPopupMenu();
        if (dockable == null && container instanceof PanelWindowContainer) {
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    DockableWindowManager.this.showDockableWindow(evt.getActionCommand());
                }
            };
            String[] dockables = ((PanelWindowContainer)container).getDockables();
            TreeMap<String, String> dockableMap = new TreeMap<String, String>();
            for (int i = 0; i < dockables.length; ++i) {
                String action = dockables[i];
                dockableMap.put(this.getDockableTitle(action), action);
            }
            for (Map.Entry entry : dockableMap.entrySet()) {
                JMenuItem item = new JMenuItem((String)entry.getKey());
                item.setActionCommand((String)entry.getValue());
                item.addActionListener(listener);
                popup.add(item);
            }
        } else {
            JMenuItem caption = new JMenuItem(this.getDockableTitle(dockable));
            caption.setEnabled(false);
            popup.add(caption);
            popup.addSeparator();
            String currentPos = jEdit.getProperty(dockable + ".dock-position", FLOATING);
            if (!clone) {
                String[] positions = new String[]{FLOATING, TOP, LEFT, BOTTOM, RIGHT};
                for (int i = 0; i < positions.length; ++i) {
                    final String pos = positions[i];
                    if (pos.equals(currentPos)) continue;
                    JMenuItem moveMenuItem = new JMenuItem(jEdit.getProperty("view.docking.menu-" + pos));
                    moveMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            jEdit.setProperty(dockable + ".dock-position", pos);
                            EditBus.send(new DockableWindowUpdate(DockableWindowManager.this, DockableWindowUpdate.PROPERTIES_CHANGED, null));
                            DockableWindowManager.this.showDockableWindow(dockable);
                        }
                    });
                    popup.add(moveMenuItem);
                }
                popup.addSeparator();
            }
            JMenuItem cloneMenuItem = new JMenuItem(jEdit.getProperty("view.docking.menu-clone"));
            cloneMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    DockableWindowManager.this.floatDockableWindow(dockable);
                }
            });
            popup.add(cloneMenuItem);
            popup.addSeparator();
            JMenuItem closeMenuItem = new JMenuItem(jEdit.getProperty("view.docking.menu-close"));
            closeMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (clone) {
                        ((FloatingWindowContainer)container).dispose();
                    } else {
                        DockableWindowManager.this.removeDockableWindow(dockable);
                    }
                }
            });
            popup.add(closeMenuItem);
            if (!clone && !currentPos.equals(FLOATING)) {
                JMenuItem undockMenuItem = new JMenuItem(jEdit.getProperty("view.docking.menu-undock"));
                undockMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        jEdit.setProperty(dockable + ".dock-position", DockableWindowManager.FLOATING);
                        EditBus.send(new DockableWindowUpdate(DockableWindowManager.this, DockableWindowUpdate.PROPERTIES_CHANGED, null));
                        Entry entry = (Entry)DockableWindowManager.this.windows.get(dockable);
                        if (entry == null) {
                            Log.log(9, this, "Unknown dockable window: " + dockable);
                        } else {
                            entry.win = null;
                        }
                    }
                });
                popup.add(undockMenuItem);
            }
        }
        return popup;
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.resizeRect != null) {
            g.setColor(Color.darkGray);
            g.fillRect(this.resizeRect.x, this.resizeRect.y, this.resizeRect.width, this.resizeRect.height);
        }
    }

    @Override
    public void handleMessage(EBMessage msg) {
        block10: {
            block11: {
                block9: {
                    if (!(msg instanceof DockableWindowUpdate)) break block9;
                    if (((DockableWindowUpdate)msg).getWhat() != DockableWindowUpdate.PROPERTIES_CHANGED) break block10;
                    this.propertiesChanged();
                    break block10;
                }
                if (!(msg instanceof PropertiesChanged)) break block11;
                this.propertiesChanged();
                break block10;
            }
            if (!(msg instanceof PluginUpdate)) break block10;
            PluginUpdate pmsg = (PluginUpdate)msg;
            if (pmsg.getWhat() == PluginUpdate.LOADED) {
                Iterator<DockableWindowFactory.Window> iter = this.factory.getDockableWindowIterator();
                while (iter.hasNext()) {
                    DockableWindowFactory.Window w = iter.next();
                    if (w.plugin != pmsg.getPluginJAR()) continue;
                    this.addEntry(w);
                }
                this.propertiesChanged();
            } else if (!pmsg.isExiting()) {
                if (pmsg.getWhat() == PluginUpdate.DEACTIVATED) {
                    Iterator<Entry> iter = this.getAllPluginEntries(pmsg.getPluginJAR(), false);
                    while (iter.hasNext()) {
                        Entry entry = iter.next();
                        if (entry.container == null) continue;
                        entry.container.remove(entry);
                    }
                } else if (pmsg.getWhat() == PluginUpdate.UNLOADED) {
                    Iterator<Entry> iter = this.getAllPluginEntries(pmsg.getPluginJAR(), true);
                    while (iter.hasNext()) {
                        Entry entry = iter.next();
                        if (entry.container == null) continue;
                        entry.container.unregister(entry);
                        entry.win = null;
                        entry.container = null;
                    }
                }
            }
        }
    }

    void setResizePos(int resizePos, PanelWindowContainer resizing) {
        this.resizePos = resizePos;
        if (resizePos < 0) {
            resizePos = 0;
        }
        if (this.continuousLayout) {
            return;
        }
        Rectangle newResizeRect = new Rectangle(0, 0, 8, 8);
        if (resizing == this.top) {
            resizePos = Math.min(resizePos, this.getHeight() - this.top.buttonPanel.getHeight() - this.bottom.dockablePanel.getHeight() - this.bottom.buttonPanel.getHeight() - 10);
            newResizeRect.x = this.top.dockablePanel.getX() + 1;
            newResizeRect.y = resizePos + this.top.buttonPanel.getHeight() + 1;
            newResizeRect.width = this.top.dockablePanel.getWidth() - 2;
        } else if (resizing == this.left) {
            resizePos = Math.min(resizePos, this.getWidth() - this.left.buttonPanel.getWidth() - this.right.dockablePanel.getWidth() - this.right.buttonPanel.getWidth() - 10);
            newResizeRect.x = resizePos + this.left.buttonPanel.getWidth() + 1;
            newResizeRect.y = this.left.dockablePanel.getY() + 1;
            newResizeRect.height = this.left.dockablePanel.getHeight() - 2;
        } else if (resizing == this.bottom) {
            resizePos = Math.min(resizePos, this.getHeight() - this.bottom.buttonPanel.getHeight() - this.top.dockablePanel.getHeight() - this.top.buttonPanel.getHeight() - 10);
            newResizeRect.x = this.bottom.dockablePanel.getX() + 1;
            newResizeRect.y = this.getHeight() - this.bottom.buttonPanel.getHeight() - resizePos - 10 + 2;
            newResizeRect.width = this.bottom.dockablePanel.getWidth() - 2;
        } else if (resizing == this.right) {
            resizePos = Math.min(resizePos, this.getWidth() - this.right.buttonPanel.getWidth() - this.left.dockablePanel.getWidth() - this.left.buttonPanel.getWidth() - 10);
            newResizeRect.x = this.getWidth() - this.right.buttonPanel.getWidth() - resizePos - 10 + 1;
            newResizeRect.y = this.right.dockablePanel.getY() + 1;
            newResizeRect.height = this.right.dockablePanel.getHeight() - 2;
        }
        Rectangle toRepaint = this.resizeRect == null ? newResizeRect : this.resizeRect.union(newResizeRect);
        this.resizeRect = newResizeRect;
        this.repaint(toRepaint);
    }

    void finishResizing() {
        this.resizeRect = null;
        this.repaint();
    }

    private void propertiesChanged() {
        if (this.view.isPlainView()) {
            return;
        }
        ((DockableLayout)this.getLayout()).setAlternateLayout(jEdit.getBooleanProperty("view.docking.alternateLayout"));
        String[] windowList = this.factory.getRegisteredDockableWindows();
        for (int i = 0; i < windowList.length; ++i) {
            String dockable = windowList[i];
            Entry entry = this.windows.get(dockable);
            String newPosition = jEdit.getProperty(dockable + ".dock-position", FLOATING);
            if (newPosition.equals(entry.position)) continue;
            entry.position = newPosition;
            if (entry.container != null) {
                entry.container.unregister(entry);
                entry.container = null;
                if (entry.factory.movable) {
                    if (entry.win instanceof DockableWindow) {
                        ((DockableWindow)((Object)entry.win)).move(newPosition);
                    }
                } else {
                    entry.win = null;
                }
            }
            if (newPosition.equals(FLOATING)) continue;
            if (newPosition.equals(TOP)) {
                entry.container = this.top;
            } else if (newPosition.equals(LEFT)) {
                entry.container = this.left;
            } else if (newPosition.equals(BOTTOM)) {
                entry.container = this.bottom;
            } else if (newPosition.equals(RIGHT)) {
                entry.container = this.right;
            } else {
                Log.log(7, this, "Unknown position: " + newPosition);
                continue;
            }
            entry.container.register(entry);
        }
        this.top.sortDockables();
        this.left.sortDockables();
        this.bottom.sortDockables();
        this.right.sortDockables();
        this.continuousLayout = jEdit.getBooleanProperty("appearance.continuousLayout");
        this.revalidate();
        this.repaint();
    }

    private void addEntry(DockableWindowFactory.Window factory) {
        Entry e;
        if (this.view.isPlainView()) {
            e = new Entry(factory, FLOATING);
        } else {
            e = new Entry(factory);
            if (!e.position.equals(FLOATING)) {
                if (e.position.equals(TOP)) {
                    e.container = this.top;
                } else if (e.position.equals(LEFT)) {
                    e.container = this.left;
                } else if (e.position.equals(BOTTOM)) {
                    e.container = this.bottom;
                } else if (e.position.equals(RIGHT)) {
                    e.container = this.right;
                } else {
                    Log.log(7, this, "Unknown position: " + e.position);
                }
            }
            if (e.container != null) {
                e.container.register(e);
            }
        }
        this.windows.put(factory.name, e);
    }

    private Iterator<Entry> getAllPluginEntries(PluginJAR plugin, boolean remove) {
        Entry entry;
        LinkedList<Entry> returnValue = new LinkedList<Entry>();
        Iterator<Entry> iter = this.windows.values().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            if (entry.factory.plugin != plugin) continue;
            returnValue.add(entry);
            if (!remove) continue;
            iter.remove();
        }
        iter = this.clones.iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            if (entry.factory.plugin != plugin) continue;
            returnValue.add(entry);
            iter.remove();
        }
        return returnValue.iterator();
    }

    class KeyHandler
    extends KeyAdapter {
        static final String action = "close-docking-area";
        KeyEventTranslator.Key b1;
        KeyEventTranslator.Key b2;
        String name;

        public KeyHandler(String dockableName) {
            String shortcut1 = jEdit.getProperty("close-docking-area.shortcut");
            String shortcut2 = jEdit.getProperty("close-docking-area.shortcut2");
            if (shortcut1 != null) {
                this.b1 = KeyEventTranslator.parseKey(shortcut1);
            }
            if (shortcut2 != null) {
                this.b2 = KeyEventTranslator.parseKey(shortcut2);
            }
            this.name = dockableName;
        }

        public void keyTyped(KeyEvent e) {
            char cc = e.getKeyChar();
            if (this.b1 != null && cc == this.b1.key || this.b2 != null && cc == this.b2.key) {
                DockableWindowManager.this.hideDockableWindow(this.name);
            }
        }
    }

    class Entry {
        DockableWindowFactory.Window factory;
        String position;
        DockableWindowContainer container;
        JComponent win;
        AbstractButton btn;

        Entry(DockableWindowFactory.Window factory) {
            this(factory, jEdit.getProperty(factory.name + ".dock-position", DockableWindowManager.FLOATING));
        }

        public String longTitle() {
            String title = jEdit.getProperty(this.factory.name + ".longtitle");
            if (title == null) {
                return this.shortTitle();
            }
            return title;
        }

        public String shortTitle() {
            String title = jEdit.getProperty(this.factory.name + ".title");
            if (title == null) {
                return "NO TITLE PROPERTY: " + this.factory.name;
            }
            return title;
        }

        public String label() {
            String retval = jEdit.getProperty(this.factory.name + ".label");
            retval = retval.replaceAll("\\$", "");
            return retval;
        }

        Entry(DockableWindowFactory.Window factory, String position) {
            this.factory = factory;
            this.position = position;
        }
    }
}

