/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;

public class AboutDialog
extends JDialog
implements ActionListener {
    public AboutDialog(View view) {
        super(view, jEdit.getProperty("about.title"), true);
        this.setResizable(false);
        JButton closeBtn = new JButton(jEdit.getProperty("common.close"));
        closeBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(closeBtn);
        JPanel p = new JPanel(new BorderLayout());
        AboutPanel aboutPanel = new AboutPanel();
        JPanel flowP = new JPanel(new FlowLayout());
        flowP.add(closeBtn);
        flowP.add(Box.createRigidArea(new Dimension(40, 40)));
        Dimension dim = new Dimension(10, 0);
        p.add("West", Box.createRigidArea(dim));
        p.add("East", Box.createRigidArea(dim));
        p.add("North", Box.createRigidArea(new Dimension(10, 10)));
        p.add("South", flowP);
        p.add("Center", aboutPanel);
        this.setContentPane(p);
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - this.getWidth()) / 2, (d.height - this.getHeight()) / 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AboutPanel.stopThread();
                AboutDialog.this.dispose();
            }
        });
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        AboutPanel.stopThread();
        this.dispose();
    }

    static class AboutPanel
    extends JComponent
    implements Runnable {
        private BufferedImage bufImage = null;
        private Graphics2D g = null;
        private static final Font defaultFont = UIManager.getFont("Label.font");
        private Font bottomLineFont = defaultFont.deriveFont(9.8f);
        private String sBottomLine;
        private ImageIcon image;
        private Vector<String> vLines;
        private static boolean doWork = false;
        private Thread th = null;
        private FontMetrics fm = null;
        private int iLineHeight = 0;
        private int iListHeight;
        private int iLineCount = 0;
        private int iBottomLineXOffset = 0;
        private int iBottomLineYOffset = 0;
        private int iPipeLineCount = 0;
        private int w = 0;
        private int h = 0;
        private int y = 0;
        private static final int SLEEP_TIME = 30;
        private static final int iBottomPadding = 36;
        private static final int iTopPadding = 120;
        private static Rectangle2D.Float rectangle;
        private static GradientPaint gradientPaint;

        AboutPanel() {
            Object[] args = new String[]{jEdit.getVersion(), System.getProperty("java.version")};
            this.sBottomLine = jEdit.getProperty("about.version", args);
            this.setFont(defaultFont);
            this.fm = this.getFontMetrics(defaultFont);
            FontMetrics fmBottom = this.getFontMetrics(this.bottomLineFont);
            this.iLineHeight = this.fm.getHeight();
            this.vLines = new Vector(50);
            this.image = (ImageIcon)GUIUtilities.loadIcon("about.png");
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(this.image.getImage(), 0);
            try {
                tracker.waitForID(0);
            }
            catch (Exception exc) {
                AboutPanel.tell("AboutPanel: " + exc);
            }
            Dimension d = new Dimension(this.image.getIconWidth(), this.image.getIconHeight());
            this.setSize(d);
            this.setPreferredSize(d);
            this.w = d.width;
            this.h = d.height;
            this.iBottomLineXOffset = this.w / 2 - fmBottom.stringWidth(this.sBottomLine) / 2;
            this.iBottomLineYOffset = this.h - this.iLineHeight / 2;
            StringTokenizer st = new StringTokenizer(jEdit.getProperty("about.text"), "\n");
            while (st.hasMoreTokens()) {
                this.vLines.add(st.nextToken());
            }
            this.iLineCount = this.vLines.size();
            this.iListHeight = this.iLineCount * this.iLineHeight;
            this.startThread();
            this.updateUI();
        }

        private final void drain() {
            if (this.bufImage == null) {
                Dimension d = this.getSize();
                this.bufImage = new BufferedImage(d.width, d.height, 1);
                this.g = this.bufImage.createGraphics();
                rectangle = new Rectangle2D.Float(0.0f, 120.0f, d.width, d.height - 36 - 120);
                this.iPipeLineCount = 1 + (int)(AboutPanel.rectangle.height / (float)this.iLineHeight);
                this.y = d.height + 36;
                this.g.setFont(defaultFont);
                gradientPaint = new GradientPaint(AboutPanel.rectangle.width / 2.0f, 200.0f, new Color(80, 80, 80), AboutPanel.rectangle.width / 2.0f, 120.0f, new Color(205, 205, 205));
                this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.g.drawImage(this.image.getImage(), 0, 0, this.w, this.h, this);
            this.g.setFont(this.bottomLineFont);
            this.g.setPaint(new Color(55, 55, 55));
            this.g.drawString(this.sBottomLine, this.iBottomLineXOffset, this.iBottomLineYOffset);
            this.g.setPaint(new Color(255, 255, 255, 50));
            this.g.drawString(this.sBottomLine, this.iBottomLineXOffset + 1, this.iBottomLineYOffset + 1);
            this.g.setFont(defaultFont);
            this.g.setPaint(Color.black);
            this.g.drawRect(0, 0, this.w - 1, this.h - 1);
            this.g.clip(rectangle);
            this.g.setPaint(gradientPaint);
            int iDrawnLinesCount = 0;
            int yCoor = 0;
            for (int i = 0; i < this.iLineCount; ++i) {
                yCoor = this.y + i * this.iLineHeight;
                if (yCoor < 120) continue;
                String sLine = this.vLines.get(i);
                int x = (this.w - this.fm.stringWidth(sLine)) / 2;
                this.g.drawString(sLine, x, yCoor);
                if (++iDrawnLinesCount >= this.iPipeLineCount) break;
            }
            --this.y;
            this.paint(this.getGraphics());
            if (this.y + this.iListHeight < 120) {
                this.y = this.h + 36;
            }
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics panelGraphics) {
            if (panelGraphics != null && this.bufImage != null) {
                panelGraphics.drawImage(this.bufImage, 0, 0, this.w, this.h, this);
            }
        }

        public void run() {
            try {
                while (doWork) {
                    this.drain();
                    Thread.sleep(30L);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            doWork = false;
            this.th = null;
        }

        public void startThread() {
            if (this.th == null) {
                this.th = new Thread(this);
                doWork = true;
                this.th.start();
            }
        }

        public static void stopThread() {
            doWork = false;
        }

        public static void tell(Object obj) {
            String str = obj == null ? "NULL" : obj.toString();
            JOptionPane.showMessageDialog(jEdit.getActiveView(), str, "Title", 1);
        }

        static {
            gradientPaint = null;
        }
    }
}

