/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bufferio;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.zip.GZIPInputStream;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferio.BufferIORequest;
import org.gjt.sp.jedit.io.AutoDetection;
import org.gjt.sp.jedit.io.EncodingDetector;
import org.gjt.sp.jedit.io.EncodingServer;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkThread;

public class BufferLoadRequest
extends BufferIORequest {
    public BufferLoadRequest(View view, Buffer buffer, Object session, VFS vfs, String path) {
        super(view, buffer, session, vfs, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block26: {
            block25: {
                this.setAbortable(true);
                if (!this.buffer.isTemporary()) {
                    Object[] args = new String[]{this.vfs.getFileName(this.path)};
                    this.setStatus(jEdit.getProperty("vfs.status.load", args));
                    this.setValue(0L);
                }
                this.path = this.vfs._canonPath(this.session, this.path, this.view);
                this.readContents();
                this.buffer.setNewFile(false);
                if (jEdit.getBooleanProperty("persistentMarkers") && this.vfs.isMarkersFileSupported()) {
                    InputStream markers = null;
                    try {
                        block24: {
                            Object[] args = new String[]{this.vfs.getFileName(this.path)};
                            if (!this.buffer.isTemporary()) {
                                this.setStatus(jEdit.getProperty("vfs.status.load-markers", args));
                            }
                            this.setAbortable(true);
                            markers = this.vfs._createInputStream(this.session, this.markersPath, true, this.view);
                            if (markers == null) break block24;
                            BufferLoadRequest.readMarkers(this.buffer, markers);
                        }
                        Object var4_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_10 = null;
                        IOUtilities.closeQuietly(markers);
                        throw throwable;
                    }
                    IOUtilities.closeQuietly(markers);
                    {
                        break block25;
                        catch (Exception e) {
                            Object var4_9 = null;
                            IOUtilities.closeQuietly(markers);
                        }
                    }
                }
            }
            Object var6_12 = null;
            try {
                this.vfs._endVFSSession(this.session, this.view);
            }
            catch (Exception e2) {
                Log.log(9, this, e2);
                Object[] pp2 = new String[]{e2.toString()};
                VFSManager.error(this.view, this.path, "ioerror.read-error", pp2);
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
            }
            catch (WorkThread.Abort a2) {
                this.buffer.setBooleanProperty("BufferIORequest__error", true);
            }
            break block26;
            {
                catch (Exception e) {
                    Log.log(9, this, e);
                    Object[] pp = new Object[]{e.toString()};
                    VFSManager.error(this.view, this.path, "ioerror.read-error", pp);
                    this.buffer.setBooleanProperty("BufferIORequest__error", true);
                    Object var6_13 = null;
                    try {
                        this.vfs._endVFSSession(this.session, this.view);
                    }
                    catch (Exception e2) {
                        Log.log(9, this, e2);
                        Object[] pp2 = new String[]{e2.toString()};
                        VFSManager.error(this.view, this.path, "ioerror.read-error", pp2);
                        this.buffer.setBooleanProperty("BufferIORequest__error", true);
                    }
                    catch (WorkThread.Abort a2) {
                        this.buffer.setBooleanProperty("BufferIORequest__error", true);
                    }
                    break block26;
                }
                catch (OutOfMemoryError oom) {
                    Log.log(9, this, oom);
                    VFSManager.error(this.view, this.path, "out-of-memory-error", null);
                    this.buffer.setBooleanProperty("BufferIORequest__error", true);
                    Object var6_14 = null;
                    try {
                        this.vfs._endVFSSession(this.session, this.view);
                    }
                    catch (Exception e2) {
                        Log.log(9, this, e2);
                        Object[] pp2 = new String[]{e2.toString()};
                        VFSManager.error(this.view, this.path, "ioerror.read-error", pp2);
                        this.buffer.setBooleanProperty("BufferIORequest__error", true);
                    }
                    catch (WorkThread.Abort a2) {
                        this.buffer.setBooleanProperty("BufferIORequest__error", true);
                    }
                    break block26;
                }
                catch (WorkThread.Abort a) {
                    this.buffer.setBooleanProperty("BufferIORequest__error", true);
                    Object var6_15 = null;
                    try {
                        this.vfs._endVFSSession(this.session, this.view);
                    }
                    catch (Exception e2) {
                        Log.log(9, this, e2);
                        Object[] pp2 = new String[]{e2.toString()};
                        VFSManager.error(this.view, this.path, "ioerror.read-error", pp2);
                        this.buffer.setBooleanProperty("BufferIORequest__error", true);
                    }
                    catch (WorkThread.Abort a2) {
                        this.buffer.setBooleanProperty("BufferIORequest__error", true);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_16 = null;
                try {
                    this.vfs._endVFSSession(this.session, this.view);
                }
                catch (Exception e2) {
                    Log.log(9, this, e2);
                    Object[] pp2 = new String[]{e2.toString()};
                    VFSManager.error(this.view, this.path, "ioerror.read-error", pp2);
                    this.buffer.setBooleanProperty("BufferIORequest__error", true);
                }
                catch (WorkThread.Abort a2) {
                    this.buffer.setBooleanProperty("BufferIORequest__error", true);
                }
                throw throwable;
            }
        }
    }

    private InputStream getNakedStream() throws IOException {
        InputStream in = this.vfs._createInputStream(this.session, this.path, false, this.view);
        if (in != null) {
            return in;
        }
        throw new IOException("Unable to get a Stream for " + this.path);
    }

    private long getContentLength() throws IOException {
        VFSFile entry = this.vfs._getFile(this.session, this.path, this.view);
        if (entry != null) {
            return entry.getLength();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedInputStream rewindContentsStream(BufferedInputStream markedStream, boolean gzipped) throws IOException {
        try {
            markedStream.reset();
            return markedStream;
        }
        catch (IOException e) {
            BufferedInputStream bufferedInputStream;
            Log.log(5, this, this.path + ": Reopening to rewind the stream");
            markedStream.close();
            InputStream in = this.getNakedStream();
            try {
                if (gzipped) {
                    in = new GZIPInputStream(in);
                }
                BufferedInputStream result = AutoDetection.getMarkedStream(in);
                in = null;
                bufferedInputStream = result;
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                IOUtilities.closeQuietly(in);
                throw throwable;
            }
            IOUtilities.closeQuietly(in);
            return bufferedInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readContents() throws IOException {
        long length = this.getContentLength();
        BufferedInputStream markedStream = AutoDetection.getMarkedStream(this.getNakedStream());
        try {
            String encoding;
            boolean gzipped = false;
            ArrayList<Object> encodingProviders = new ArrayList<Object>();
            boolean autodetect = this.buffer.getBooleanProperty("encodingAutodetect");
            if (autodetect) {
                gzipped = AutoDetection.isGzipped(markedStream);
                markedStream.reset();
                encodingProviders.addAll(AutoDetection.getEncodingDetectors());
                encodingProviders.add(this.buffer.getStringProperty("encoding"));
                String fallbackEncodings = jEdit.getProperty("fallbackEncodings");
                if (fallbackEncodings != null && fallbackEncodings.length() > 0) {
                    void var10_11;
                    String[] arr$ = fallbackEncodings.split("\\s+");
                    int len$ = arr$.length;
                    boolean bl = false;
                    while (var10_11 < len$) {
                        encoding = arr$[var10_11];
                        encodingProviders.add(encoding);
                        ++var10_11;
                    }
                }
            } else {
                gzipped = this.buffer.getBooleanProperty("gzipped");
                encodingProviders.add(this.buffer.getStringProperty("encoding"));
            }
            if (gzipped) {
                Log.log(1, this, this.path + ": Stream is gzipped.");
                markedStream = AutoDetection.getMarkedStream(new GZIPInputStream(markedStream));
            }
            HashSet<String> failedEncodings = new HashSet<String>();
            Throwable encodingError = null;
            for (Object e : encodingProviders) {
                block19: {
                    encoding = null;
                    if (e instanceof String) {
                        encoding = (String)e;
                    } else if (e instanceof EncodingDetector) {
                        markedStream = this.rewindContentsStream(markedStream, gzipped);
                        encoding = ((EncodingDetector)e).detectEncoding(new BufferedInputStream(markedStream));
                    } else {
                        Log.log(1, this, "Strange encodingProvider: " + e);
                    }
                    if (encoding == null || encoding.length() <= 0 || failedEncodings.contains(encoding)) continue;
                    markedStream = this.rewindContentsStream(markedStream, gzipped);
                    try {
                        this.read(EncodingServer.getTextReader(markedStream, encoding), length, false);
                        if (!autodetect) break block19;
                        if (gzipped) {
                            this.buffer.setBooleanProperty("gzipped", true);
                        }
                        this.buffer.setProperty("encoding", encoding);
                    }
                    catch (CharConversionException e2) {
                        encodingError = e2;
                    }
                    catch (CharacterCodingException e3) {
                        encodingError = e3;
                    }
                    catch (UnsupportedEncodingException e4) {
                        encodingError = e4;
                    }
                    catch (UnsupportedCharsetException e5) {
                        encodingError = e5;
                    }
                }
                Object var14_19 = null;
                markedStream.close();
                return;
                Log.log(5, this, this.path + ": " + encoding + ": " + encodingError);
                failedEncodings.add(encoding);
            }
            Object[] pp = new Object[]{TextUtilities.join(failedEncodings, ","), ""};
            pp[1] = failedEncodings.size() < 2 ? encodingError.toString() : "See details in Activity Log";
            VFSManager.error(this.view, this.path, "ioerror.encoding-error", pp);
            markedStream = this.rewindContentsStream(markedStream, gzipped);
            this.read(EncodingServer.getEncoding(this.buffer.getStringProperty("encoding")).getPermissiveTextReader(markedStream), length, false);
            if (autodetect && gzipped) {
                this.buffer.setBooleanProperty("gzipped", true);
            }
            Object var14_20 = null;
            markedStream.close();
            return;
        }
        catch (Throwable throwable) {
            Object var14_21 = null;
            markedStream.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readMarkers(Buffer buffer, InputStream _in) throws IOException {
        buffer.removeAllMarkers();
        BufferedReader in = new BufferedReader(new InputStreamReader(_in));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) != '!') continue;
                char shortcut = line.charAt(1);
                int start = line.indexOf(59);
                int end = line.indexOf(59, start + 1);
                int position = Integer.parseInt(line.substring(start + 1, end));
                buffer.addMarker(shortcut, position);
            }
            buffer.setMarkersChanged(false);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }
}

