/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.text.Position;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.util.Log;

public class PositionManager {
    boolean iteration;
    private JEditBuffer buffer;
    private SortedMap<PosBottomHalf, PosBottomHalf> positions = new TreeMap<PosBottomHalf, PosBottomHalf>();

    public PositionManager(JEditBuffer buffer) {
        this.buffer = buffer;
    }

    public synchronized Position createPosition(int offset) {
        PosBottomHalf bh = new PosBottomHalf(offset);
        PosBottomHalf existing = (PosBottomHalf)this.positions.get(bh);
        if (existing == null) {
            this.positions.put(bh, bh);
            existing = bh;
        }
        return new PosTopHalf(existing);
    }

    public synchronized void contentInserted(int offset, int length) {
        if (this.positions.isEmpty()) {
            return;
        }
        Iterator<PosBottomHalf> iter = this.positions.tailMap(new PosBottomHalf(offset)).keySet().iterator();
        this.iteration = true;
        while (iter.hasNext()) {
            iter.next().contentInserted(offset, length);
        }
        this.iteration = false;
    }

    public synchronized void contentRemoved(int offset, int length) {
        if (this.positions.isEmpty()) {
            return;
        }
        Iterator<PosBottomHalf> iter = this.positions.tailMap(new PosBottomHalf(offset)).keySet().iterator();
        this.iteration = true;
        while (iter.hasNext()) {
            iter.next().contentRemoved(offset, length);
        }
        this.iteration = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PosBottomHalf
    implements Comparable<PosBottomHalf> {
        int offset;
        int ref;

        PosBottomHalf(int offset) {
            this.offset = offset;
        }

        void ref() {
            ++this.ref;
        }

        void unref() {
            if (--this.ref == 0) {
                PositionManager.this.positions.remove(this);
            }
        }

        void contentInserted(int offset, int length) {
            if (offset > this.offset) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.offset += length;
            this.checkInvariants();
        }

        void contentRemoved(int offset, int length) {
            if (offset > this.offset) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.offset = this.offset <= offset + length ? offset : (this.offset -= length);
            this.checkInvariants();
        }

        public boolean equals(Object o) {
            if (!(o instanceof PosBottomHalf)) {
                return false;
            }
            return ((PosBottomHalf)o).offset == this.offset;
        }

        @Override
        public int compareTo(PosBottomHalf posBottomHalf) {
            if (PositionManager.this.iteration) {
                Log.log(9, this, "Consistency failure");
            }
            return this.offset - posBottomHalf.offset;
        }

        private void checkInvariants() {
            if (this.offset < 0 || this.offset > PositionManager.this.buffer.getLength()) {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    class PosTopHalf
    implements Position {
        final PosBottomHalf bh;

        PosTopHalf(PosBottomHalf bh) {
            this.bh = bh;
            bh.ref();
        }

        public int getOffset() {
            return this.bh.offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            PositionManager positionManager = PositionManager.this;
            synchronized (positionManager) {
                this.bh.unref();
            }
        }
    }
}

