/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.ServiceListHandler;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.FoldHandlerProvider;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.XMLUtilities;

public class ServiceManager {
    private static final Map<Descriptor, Descriptor> serviceMap = new HashMap<Descriptor, Descriptor>();

    public static void loadServices(PluginJAR plugin, URL uri, PluginJAR.PluginCacheEntry cache) {
        ServiceListHandler dh = new ServiceListHandler(plugin, uri);
        try {
            if (!XMLUtilities.parseXML(uri.openStream(), dh) && cache != null) {
                cache.cachedServices = dh.getCachedServices();
            }
        }
        catch (IOException ioe) {
            Log.log(9, ServiceManager.class, ioe);
        }
    }

    public static void unloadServices(PluginJAR plugin) {
        Iterator<Descriptor> descriptors = serviceMap.keySet().iterator();
        while (descriptors.hasNext()) {
            Descriptor d = descriptors.next();
            if (d.plugin != plugin) continue;
            descriptors.remove();
        }
    }

    public static void registerService(String clazz, String name, String code, PluginJAR plugin) {
        Descriptor d = new Descriptor(clazz, name, code, plugin);
        serviceMap.put(d, d);
    }

    public static void unregisterService(String clazz, String name) {
        Descriptor d = new Descriptor(clazz, name);
        serviceMap.remove(d);
    }

    public static String[] getServiceTypes() {
        HashSet<String> returnValue = new HashSet<String>();
        Set<Descriptor> keySet = serviceMap.keySet();
        for (Descriptor d : keySet) {
            returnValue.add(d.clazz);
        }
        return returnValue.toArray(new String[returnValue.size()]);
    }

    public static String[] getServiceNames(String clazz) {
        ArrayList<String> returnValue = new ArrayList<String>();
        Set<Descriptor> keySet = serviceMap.keySet();
        for (Descriptor d : keySet) {
            if (!d.clazz.equals(clazz)) continue;
            returnValue.add(d.name);
        }
        return returnValue.toArray(new String[returnValue.size()]);
    }

    public static Object getService(String clazz, String name) {
        Descriptor key = new Descriptor(clazz, name);
        Descriptor value = serviceMap.get(key);
        if (value == null) {
            return null;
        }
        if (value.code == null) {
            ServiceManager.loadServices(value.plugin, value.plugin.getServicesURI(), null);
            value = serviceMap.get(key);
        }
        return value.getInstance();
    }

    static void registerService(Descriptor d) {
        serviceMap.put(d, d);
    }

    public static class ServiceFoldHandlerProvider
    implements FoldHandlerProvider {
        public static final String SERVICE = "org.gjt.sp.jedit.buffer.FoldHandler";

        public FoldHandler getFoldHandler(String name) {
            FoldHandler handler = (FoldHandler)ServiceManager.getService(SERVICE, name);
            return handler;
        }

        public String[] getFoldModes() {
            String[] handlers = ServiceManager.getServiceNames(SERVICE);
            Arrays.sort(handlers, new StandardUtilities.StringCompare());
            return handlers;
        }
    }

    static class Descriptor {
        final String clazz;
        final String name;
        String code;
        PluginJAR plugin;
        Object instance;
        boolean instanceIsNull;

        Descriptor(String clazz, String name) {
            this.clazz = clazz;
            this.name = name;
        }

        Descriptor(String clazz, String name, String code, PluginJAR plugin) {
            this.clazz = clazz;
            this.name = name;
            this.code = code;
            this.plugin = plugin;
        }

        Object getInstance() {
            if (this.instanceIsNull) {
                return null;
            }
            if (this.instance == null) {
                this.instance = BeanShell.eval(null, BeanShell.getNameSpace(), this.code);
                if (this.instance == null) {
                    this.instanceIsNull = true;
                }
            }
            return this.instance;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Descriptor) {
                Descriptor d = (Descriptor)o;
                return d.clazz.equals(this.clazz) && d.name.equals(this.name);
            }
            return false;
        }
    }
}

