/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.jEdit;

public class AbstractOptionPane
extends JPanel
implements OptionPane {
    protected boolean initialized;
    protected GridBagLayout gridBag;
    protected int y;
    private String name;

    public AbstractOptionPane(String internalName) {
        this.name = internalName;
        this.gridBag = new GridBagLayout();
        this.setLayout(this.gridBag);
    }

    public String getName() {
        return this.name;
    }

    public Component getComponent() {
        return this;
    }

    public void init() {
        if (!this.initialized) {
            this.initialized = true;
            this._init();
        }
    }

    public void save() {
        if (this.initialized) {
            this._save();
        }
    }

    public JLabel newLabel(String label, Component comp) {
        JLabel retval = new JLabel(label);
        try {
            JComponent jc = (JComponent)comp;
            String tttext = jc.getToolTipText();
            retval.setToolTipText(tttext);
        }
        catch (Exception e) {
            // empty catch block
        }
        return retval;
    }

    public void addComponent(String label, Component comp) {
        JLabel l = this.newLabel(label, comp);
        l.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.addComponent(l, comp, 1);
    }

    public void addComponent(String label, Component comp, int fill) {
        JLabel l = this.newLabel(label, comp);
        l.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.addComponent(l, comp, fill);
    }

    public void addComponent(Component comp1, Component comp2) {
        this.addComponent(comp1, comp2, 1);
    }

    public void addComponent(Component comp1, Component comp2, int fill) {
        this.copyToolTips(comp1, comp2);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        cons.insets = new Insets(1, 0, 1, 0);
        cons.fill = 1;
        this.gridBag.setConstraints(comp1, cons);
        this.add(comp1);
        cons.fill = fill;
        cons.gridx = 1;
        cons.weightx = 1.0;
        this.gridBag.setConstraints(comp2, cons);
        this.add(comp2);
    }

    public void addComponent(Component comp) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 0;
        cons.fill = 0;
        cons.anchor = 17;
        cons.weightx = 1.0;
        cons.insets = new Insets(1, 0, 1, 0);
        this.gridBag.setConstraints(comp, cons);
        this.add(comp);
    }

    public void addComponent(Component comp, int fill) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 0;
        cons.fill = fill;
        cons.anchor = 17;
        cons.weightx = 1.0;
        cons.insets = new Insets(1, 0, 1, 0);
        this.gridBag.setConstraints(comp, cons);
        this.add(comp);
    }

    private void copyToolTips(Component c1, Component c2) {
        int tooltips = 0;
        int jc = 0;
        String text = null;
        JComponent jc1 = null;
        JComponent jc2 = null;
        try {
            jc1 = (JComponent)c1;
            text = jc1.getToolTipText();
            ++jc;
            if (text != null && text.length() > 0) {
                ++tooltips;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            jc2 = (JComponent)c2;
            String text2 = jc2.getToolTipText();
            ++jc;
            if (text2 != null && text2.length() > 0) {
                text = text2;
                ++tooltips;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tooltips == 1 && jc == 2) {
            jc1.setToolTipText(text);
            jc2.setToolTipText(text);
        }
    }

    public void addSeparator() {
        this.addComponent(Box.createVerticalStrut(6));
        JSeparator sep = new JSeparator(0);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 0;
        cons.fill = 1;
        cons.anchor = 17;
        cons.weightx = 1.0;
        this.gridBag.setConstraints(sep, cons);
        this.add(sep);
        this.addComponent(Box.createVerticalStrut(6));
    }

    public void addSeparator(String label) {
        if (this.y != 0) {
            this.addComponent(Box.createVerticalStrut(6));
        }
        Box box = new Box(0);
        Box box2 = new Box(1);
        box2.add(Box.createGlue());
        box2.add(new JSeparator(0));
        box2.add(Box.createGlue());
        box.add(box2);
        JLabel l = new JLabel(jEdit.getProperty(label));
        l.setMaximumSize(l.getPreferredSize());
        box.add(l);
        Box box3 = new Box(1);
        box3.add(Box.createGlue());
        box3.add(new JSeparator(0));
        box3.add(Box.createGlue());
        box.add(box3);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.y++;
        cons.gridheight = 1;
        cons.gridwidth = 0;
        cons.fill = 1;
        cons.anchor = 17;
        cons.weightx = 1.0;
        cons.insets = new Insets(1, 0, 1, 0);
        this.gridBag.setConstraints(box, cons);
        this.add(box);
    }

    protected void _init() {
    }

    protected void _save() {
    }
}

