string sendsms_script;


string css()
{
    return """
        div.message
        {
            width: 200px;
            border: 2px solid #008000;
            color: #004000;
            padding: 5px;
            margin-bottom: 10px;
        }
        div.error
        {
            width: 200px;
            border: 2px solid #800000;
            color: #400000;
            padding: 5px;
            margin-bottom: 10px;
        }
    """;
}

void stylecss(Soup.Server server, Soup.Message msg, string path, GLib.HashTable<string, string>? query, Soup.ClientContext client)
{
    var response = css();
    msg.set_response("text/html", Soup.MemoryUse.COPY, response, response.length);
    msg.set_status(200);
}


string smsform(string? message = null, string? error = null)
{
    var response = """
        <html>
            <head>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                <link rel="stylesheet" href="/style.css" />
            </head>
            <body>
    """;

    if (message != null)
        response += "<div class='message'>" + message + "</div>";
    if (error != null)
        response += "<div class='error'>" + error + "</div>";

    response += """
                <form method="post" action="/sendsms">
                    <table>
                        <tr>
                            <td>To:</td>
                            <td><input type="text" name="to" /></td>
                        </tr>
                        <tr>
                            <td>SMS:</td>
                            <td><input type="text" name="sms" /></td>
                        </tr>
                        <tr>
                            <td colspan="2" align="right">
                                <input type="submit" value="Send" />
                            </td>
                        </tr>
                    </table>
                </form>
            </body>
        </html>
    """;

    return response;
}


void root(Soup.Server server, Soup.Message msg, string path, GLib.HashTable<string, string>? query, Soup.ClientContext client)
{
    string response;
    if (query != null)
        response = smsform(query.lookup("message"), query.lookup("error"));
    else
        response = smsform();

    msg.set_response("text/html", Soup.MemoryUse.COPY, response, response.length);
    msg.set_status(200);
}



void sendsms(Soup.Server server, Soup.Message msg, string path, GLib.HashTable<string, string>? query, Soup.ClientContext client)
{
    var form = Soup.form_decode(msg.request_body.flatten().data);

    stdout.printf("To: %s\n", form.lookup("to"));
    stdout.printf("SMS: %s\n", form.lookup("sms"));


    string? message = null;
    string? error = null;

    try
    {
        string[] args = { sendsms_script, form.lookup("to"), form.lookup("sms") };
        Process.spawn_sync(null, args, null, 0, null);
        message = "Message to %s sent".printf(form.lookup("to"));
    }
    catch (SpawnError e)
    {
        stdout.printf("SpawnError: %s\n".printf(e.message));
        error = e.message;
    }

    msg.set_response("text/html", Soup.MemoryUse.COPY, "qwe", 3);
    var url = "/?";
    if (message != null)
        url += "message=" + message.replace(" ", "+");
    else
        url += "error=" + Soup.URI.encode(error, null);//error.replace(" ", "+");
    msg.response_headers.append("Location", url);
    msg.set_status(302);
}


public void main(string[] args)
{
    sendsms_script = Path.get_dirname(args[0]) + Path.DIR_SEPARATOR_S + "sendsms.py";

    var server = new Soup.Server(
        Soup.SERVER_PORT, 9876
    );
    server.add_handler("/", root);
    server.add_handler("/sendsms", sendsms);
    server.add_handler("/style.css", stylecss);
    server.run();
}
