#!/usr/bin/env python
# -*- coding: UTF-8 -*-

# Build with inspiration from http://blog.rburchell.com/2010/01/simple-pyside-pyqt-tutorial-aimed-at.html
# and related posts: http://blog.rburchell.com/2010/02/simple-pyside-tutorial-2-signals-and.html
# http://blog.rburchell.com/2010/02/pyside-tutorial-model-view-programming.html
# http://blog.rburchell.com/2010/02/pyside-tutorial-model-view-programming_22.html

import sys
from PySide.QtCore import *
from PySide.QtGui import *
from PySide.QtMaemo5 import *
import rejseplanen
 
class RejseplanenWindow(QMainWindow):
	def __init__(self):
		QMainWindow.__init__(self)
		self.setAttribute(Qt.WA_Maemo5StackedWindow)
		self.setWindowTitle('Rejseplanen')
	
	def render_startup(self):
		"""
		Render the startup screen, while getting fixes and stops from the internet.
		"""
		self.main_widget = QWidget(self)
		vbox = QVBoxLayout(self.main_widget)
		self.label = QLabel(u'Finder din position og nærmeste stop...')
		self.label.setAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
		vbox.addWidget(self.label)
		self.setCentralWidget(self.main_widget)
	
	def render_stops_list(self):
		"""
		Renders the list of stops to choose from.
		"""
		self.setWindowTitle(u'Vælg et stop - Rejseplanen')
		
		self.main_widget = QWidget(self)
		self.main_widget.setMinimumSize(792,0)
		vbox = QVBoxLayout(self.main_widget)
		
		buttons = {}
		for stop in self.stops:
			dist = str(round(stop.distance, 2)) + 'km'
			if stop.distance < 1:
				dist = str(int(stop.distance * 1000)) + 'm'
			buttons[stop.id] = QPushButton(stop.name + ' (' + dist + ')')
			buttons[stop.id].stop = stop
			def opentt():
				self.open_time_table(stop.id)
			self.connect(buttons[stop.id], SIGNAL("clicked()"), self.open_time_table)
			vbox.addWidget(buttons[stop.id])
		
		vbox.setSizeConstraint(QLayout.SetMinAndMaxSize)
		self.scroller = QScrollArea(self)
		self.scroller.setWidget(self.main_widget)
		self.setCentralWidget(self.scroller)
	
	def open_time_table(self):
		rejseplanen.open_browser(self.sender().stop)
 
if __name__ == '__main__':
	app = QApplication(sys.argv)
	w = RejseplanenWindow()
	w.render_startup()
	w.show()
	#la, lo = 55.670169, 12.540683
	la, lo = rejseplanen.get_fix()
	w.stops = rejseplanen.get_stops(la, lo)
	w.render_stops_list()
	app.exec_()
	sys.exit()
