/*
   rdesktop: A Remote Desktop Protocol client.
   Common data types
   Copyright (C) Matthew Chapman 1999-2007

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef UIMAEMO_H_
#define UIMAEMO_H_

#include <X11/Xlib.h>

#define DBG

#ifdef DBG
#define DEBUG_FG(fmt, ...) \
do { \
	printf("%s: " fmt "\n", __PRETTY_FUNCTION__, ##__VA_ARGS__); \
	fflush(stdout); \
} while (0)
#else
#define DEBUG_FG(...)
#endif

extern uint16 ui_maemo_x_location;
extern uint16 ui_maemo_y_location;
extern RD_BOOL ui_maemo_connection_success;
extern RD_BOOL ui_maemo_btkbd; /*bluetooth keyboard?*/

extern char ui_maemo_server[256];
extern char ui_maemo_password[256];
extern char ui_maemo_domain[256];

extern Window ui_maemo_fsicon_win;
extern Window ui_maemo_helpicon_win;

void ui_maemo_progress_start(void);
void ui_maemo_progress_stop(void);
void ui_maemo_setup_window(Display *display, Window wnd);
void ui_maemo_embed_window(Window wnd);
void ui_maemo_create_icons(Display *display, Window wnd, long input_mask);
int ui_maemo_mouse_event(XEvent *xevent, RD_BOOL down);
void ui_maemo_show_icons(Display *display, GC gc);
void ui_maemo_toggle_fullscreen(void);
int ui_maemo_restart_with_args(void);
void ui_maemo_show_msg(char *msg);
int ui_maemo_init(int argc, char **argv, char *server);
void ui_maemo_done(void);

#endif /* UIMAEMO_H_ */
