/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef EVENTWRITERS_VMGWRITER_H
#define EVENTWRITERS_VMGWRITER_H

#include "iEventWriter.h"

class NumberToNameLookup;
class Settings;

namespace EventWriters
{
	class VMGWriter : public iEventWriter
	{
	public:
		VMGWriter(const Settings &setting, const NumberToNameLookup &numberToNameLookup);

		virtual void Write(EventTypes::iEvent &event);

	protected:
		const Settings &CurrentSettings() const { return m_Settings; }
		const NumberToNameLookup &NameLookup() { return m_NumberToNameLookup; }

	private:
		const Settings &m_Settings;
		const NumberToNameLookup &m_NumberToNameLookup;
	};
}

#endif // EVENTWRITERS_VMGWRITER_H
