/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef EVENTWRITERS_CSVSYMBIANEVENTLOGWRITER_H
#define EVENTWRITERS_CSVSYMBIANEVENTLOGWRITER_H

#include "EventFormats/SymbianEventLog.h"
#include "iEventWriter.h"

class NumberToNameLookup;
class Settings;

#include <QChar>
class QFile;
#include <QHash>
class QString;
class QTextStream;
#include <QVector>

namespace EventWriters
{
	class CSVSymbianEventLogWriter : public iEventWriter, public SymbianEventLog
	{
	public:
		typedef QVector<QString> ColumnIndicesByIndexHash;

		CSVSymbianEventLogWriter(const Settings &settings, const NumberToNameLookup &numberToNameLookup);
		~CSVSymbianEventLogWriter();

		virtual void Write(EventTypes::iEvent &event);

	protected:
		void OpenStream();

	private:
		void WriteHeaders();
		void WriteStrings(QTextStream &stringsStream);

	// Properties
	protected:
		const Settings &CurrentSettings() const { return m_Settings; }
		const NumberToNameLookup &NameLookup() const { return m_NumberToNameLookup; }
		QTextStream *const Stream() const { return m_Stream; }
		const ColumnIndicesByIndexHash Headers() const { return m_Headers; }
		const QChar Delimiter() const { return m_Delimiter; }
		StringsLookup &Strings() { return m_Strings; }

	private:
		const Settings &m_Settings;
		const NumberToNameLookup &m_NumberToNameLookup;

		void Stream(QTextStream *const stream) { m_Stream = stream; }
		QTextStream *m_Stream;
		void Headers(ColumnIndicesByIndexHash &headers) { m_Headers = headers; }
		ColumnIndicesByIndexHash m_Headers;
		void Delimiter(QChar delimiter) { m_Delimiter = delimiter; }
		QChar m_Delimiter;
		void Strings(StringsLookup &strings) { m_Strings = strings; }
		StringsLookup m_Strings;

		QFile *const File() const { return m_File; }
		void File(QFile *const file) { m_File = file; }
		QFile *m_File;
	};
}

#endif // EVENTWRITERS_CSVSYMBIANEVENTLOGWRITER_H
