/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef EVENTTYPES_PHONECALL_H
#define EVENTTYPES_PHONECALL_H

#include "Settings.h"

#include <QDateTime>
#include <QDebug>
#include <QList>
#include <QString>

#include "EventTypes/iCSVSymbianEvent.h"
#include "RtcomEvent.h"

#include "AttachmentCollection.h"

class Settings;

namespace EventTypes
{
	class PhoneCall : public RtcomEvent, public EventTypes::iCSVSymbianEvent
	{
	public:
		virtual const DBBackends::iDBBackend &DB() const;

		PhoneCall(const Settings &settings);
		PhoneCall(const Settings &settings, const Settings::eDirection destination, const QDateTime &timestamp, const QString &tel, const int durationInSeconds, const bool isMissedCall, const AttachmentCollection &attachments = AttachmentCollection());
		~PhoneCall();

		virtual const uint HashCode() const;

		const Settings::eDirection Destination() const { return m_Destination; }
		void Destination(const Settings::eDirection destination) { m_Destination = destination; }

		virtual const QDateTime Timestamp() const { return m_Timestamp; }
		void Timestamp(const QDateTime timestamp) { m_Timestamp = timestamp; }

		const QString Tel() const { return m_Tel; }
		void Tel(const QString tel) { m_Tel = tel; }

		virtual const int DurationInSeconds() const { return m_DurationInSeconds; }
		void DurationInSeconds(const int durationInSeconds) { m_DurationInSeconds = durationInSeconds; }

		virtual const AttachmentCollection & Attachments() const { return m_Attachments; }
		virtual AttachmentCollection & Attachments() { return m_Attachments; }

		const bool IsMissedCall() const { return m_IsMissedCall; }
		void IsMissedCall(const bool isMissedCall) { m_IsMissedCall = isMissedCall; }

	public:
		PhoneCall(const Settings &settings, const RTComElEvent& event, const QList<RTComElAttachment*> attachments = QList<RTComElAttachment*>());
		virtual RTComElEvent * toRTComEvent(const NumberToNameLookup &numberToNameLookup) const;

	public:
		virtual void WriteCSVSymbian(QTextStream &stream, const ColumnIndicesByIndexHash &headerIndices, const QChar delimiter, const NumberToNameLookup &numberToNameLookup, SymbianEventLogStrings &strings) const;

	protected:
		const Settings &CurrentSettings() const { return m_Settings; }

	private:
		const Settings &m_Settings;
		Settings::eDirection m_Destination;
		QDateTime m_Timestamp;
		QString m_Tel;
		int m_DurationInSeconds;
		bool m_IsMissedCall;
		AttachmentCollection m_Attachments;
	};
}

QDebug operator<<(QDebug dbg, EventTypes::PhoneCall & event);

#endif // EVENTTYPES_PHONECALL_H
