/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include <QSet>

#include "EventProcessors/Hasher.h"

#include "EventTypes/iEvent.h"

#include <QDateTime>
#include <QHash>

#include <QDebug>

using namespace EventProcessors;

void Hasher::Process(EventTypes::iEvent &event)
{
	uint hash(event.HashCode());
	m_Hashes.insert(hash);
	qDebug() << "DB Event hash: " << hash << " @ " << event.Timestamp().toUTC();
}

void Hasher::EmitEventProcessed(int eventsProcessed, int totalEvents)
{
	emit EventProcessed(eventsProcessed, totalEvents);
}
