/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "Factory.h"

#include "VBody.h"
#include "VCard.h"
#include "VEnvelope.h"
#include "VMessage.h"
#include "VCalendar.h"

#include <QDebug>

using namespace EventParsers::VMGEntities;

iReader *Factory::Instantiate(const Settings &settings, QString& lineData, const SMSEntity *parent)
{
	if(lineData.startsWith("BEGIN:"))
	{
		QString item = lineData.mid(lineData.indexOf(":")+1);

		if(item == "VMSG")
			return new VMessage(settings, parent);
		else if(item == "VCARD")
			return new VCard(settings, parent);
		else if(item == "VENV")
			return new VEnvelope(settings, parent);
		else if(item == "VBODY")
			return new VBody(settings, parent);
		else if(item == "VCALENDAR")
			return new VCalendar(settings, parent);
	}

	qDebug() << "Unrecognised entity '" << lineData <<"'";
	return NULL;
}
