/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include <rtcom-eventlogger/eventlogger-attach-iter.h>
#include <rtcom-eventlogger/event.h>

#include "AttachmentCollection.h"

#include <QHash>

#include "Attachment.h"

const uint AttachmentCollection::HashCode() const
{
	uint hashCode = qHash(size());

	if(size() > 0)
	{
		foreach(QSharedPointer<Attachment> attachment, *this)
		{
			qDebug() << attachment->Description();
			qDebug() << attachment->Path();
			hashCode ^= attachment->HashCode();
		}
	}
	return hashCode;
}

GList * AttachmentCollection::toRTComAttachments() const
{
	GList *rattachments(NULL);

	foreach(QSharedPointer<Attachment> attachment, *this)
		rattachments = g_list_prepend(rattachments, attachment->toRTComAttachment());

	return rattachments;
}

void AttachmentCollection::freeRTComContents(GList &attachments)
{
	for (GList *attachment(&attachments); NULL != attachment; attachment = attachment->next)
	{
		Attachment::freeRTComContents(*(RTComElAttachment*)attachment->data);
		rtcom_el_free_attachment((RTComElAttachment*)attachment->data);
	}

	g_list_free (&attachments);
}
