/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef ATTACHMENT_H
#define ATTACHMENT_H

#include <QDebug>
#include <QFile>
#include <QString>

class _RTComElAttachment;
typedef _RTComElAttachment RTComElAttachment;

class QTextStream;

#include "iHashable.h"

class Attachment : public iHashable
{
public:
	Attachment(const QString filename, const QString description);
	~Attachment();

	Attachment(const RTComElAttachment &attachment);

	const QString &Path() const { return m_Path; }
	const QString &Description() const { return m_Description; }
	QTextStream &Stream() const { return *m_Stream; }

	RTComElAttachment * toRTComAttachment() const;
	static void freeRTComContents(RTComElAttachment &attachment);

	virtual const uint HashCode() const;
void killStream()
{
	delete m_Stream;
	m_Stream = NULL;
}

private:
	void setPath(QString &path) { m_Path = path; }
	void setDescription(QString &description) { m_Description = description; }
	//void setStream(QTextStream &stream) { m_Stream = stream; }

private:
	QString m_Path;
	QString m_Description;

	QFile m_FileHandle;
	QTextStream *m_Stream;

	bool m_DeleteFileOnDestruction;
};

QDebug operator<<(QDebug dbg, Attachment& attachment);

#endif // ATTACHMENT_H
