/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef EVENTPARSERS_VMGEntities_SMSENTITY_H
#define EVENTPARSERS_VMGEntities_SMSENTITY_H

#include <cstddef>
#include <typeinfo>

namespace EventParsers
{
	namespace VMGEntities
	{
		class iReader;

		class SMSEntity
		{
		public:
			SMSEntity(const SMSEntity* parent);
			virtual ~SMSEntity() {};

		protected:
			const bool isAttachment() const;

			const SMSEntity* m_Parent;
			const SMSEntity* getParent() const { return m_Parent; };

			virtual const char* getTagName() const { return "VBODY"; }
		};
	}
}

#endif // EVENTPARSERS_VMGEntities_SMSENTITY_H
