/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef EVENTPARSERS_CSVSYMBIANEVENTLOGPARSER_H
#define EVENTPARSERS_CSVSYMBIANEVENTLOGPARSER_H

#include "iEventParser.h"

template <typename T1, typename T2> class QHash;
class QFile;
class QString;

namespace EventParsers
{
	class CSVSymbianEventLogParser : public iEventParser
	{
	public:
		typedef QHash<QString, int> ColumnIndicesHash;

		static iEventParser *IsValid(QFile &eventFile);

		CSVSymbianEventLogParser(const QString &filename, const ColumnIndicesHash &columns);

		virtual EventTypes::EventFromFileList ParseFile(QFile &eventFile, const QList<unsigned int> &recordsToReturn);
	};
}

#endif // EVENTPARSERS_CSVSYMBIANEVENTLOGPARSER_H
