import QtQuick 1.1

Item {
    signal clicked
    property alias text: txt.text
    property alias fontsize: txt.font.pixelSize
    id: main
    width: parent.width - 10
    height: 68
    anchors.horizontalCenter: parent.horizontalCenter

    Rectangle {
        id: border
        color: "#01262c"
        border.color:  "#59686a"
        border.width: 1
        smooth: true
        radius: 4
        width: parent.width - 4
        height: parent.height - 4
        anchors.horizontalCenter: parent.horizontalCenter
        Behavior on scale {NumberAnimation{duration: 50; easing.type: Easing.InOutQuad}}


    }

    Text {
        id: txt
        anchors.centerIn: border
        color: "white"
        font.weight: Font.Light
    }
    MouseArea {
        id: mArea
        anchors.fill: parent
        onClicked: main.clicked()
    }
    states: State {
        name: "pressed"
        when: mArea.pressed
        PropertyChanges {
            target: border
            scale: 0.9
        }
    }

}

