#include "imageprovider.h"
#include <QDebug>
#include <QProcess>
#include <QApplication>

ImageProvider::ImageProvider() :
    QDeclarativeImageProvider(QDeclarativeImageProvider::Image)
{
}

QImage ImageProvider::requestImage(const QString &id, QSize *size, const QSize &requestedSize)
{
    Q_UNUSED(size);
    Q_UNUSED(requestedSize);

    QProcess proc;
    QString exec;

    QString thumbnail = QString("/dev/shm/%1.png").arg(id.split("/").at(4));

    exec = QString("ffmpeg -ss 5 -i %1 -vcodec png -vframes 1 %2").arg(id, thumbnail);

    proc.start(exec);

    proc.waitForStarted();
    proc.waitForFinished();
    proc.waitForReadyRead();

    QImage image(thumbnail);

    proc.terminate();
    proc.waitForFinished();

    proc.startDetached("rm", QStringList() << thumbnail);

    return image;
}
