#!/usr/bin/env python2.5

import gtk
import hildon
import sys
import os
import ConfigParser
import pango
import commands
import time
#import re
import xml.etree.ElementTree as ET
import osso
#from mokoui import FingerScroll as FS
#import hildonhelp

a_name = "Quick Clip Viewer"
a_version = "0.4.0"
osso_context = osso.Context('com.quickclip.Viewer','.0.4.0', False)

class QuickClipViewer(hildon.Program):
   def __init__(self):
      hildon.Program.__init__(self)

      files = self.get_files()

# Global variables

      self.searched_text = None
      self.current_file = files.index(sys.argv[1])

      gtk.set_application_name("")

      self.window = hildon.Window()
      self.window.connect("destroy", self.close_application)
      self.add_window(self.window)

      settings = self.get_settings()

      if settings['scrolling'] == 1:
         self.sw = gtk.ScrolledWindow()
         self.sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
      else:
         from mokoui import FingerScroll as FS
         self.sw = FS()
         self.sw.set_property('mode', 1)
         #self.sw.set_property('deceleration', .1)
         #self.sw.set_property('sps', 100)

      self.textview = gtk.TextView()
      textbuffer = self.textview.get_buffer()
      self.textview.set_sensitive(False)

      tag_find_all = textbuffer.create_tag('search_hilight')
      tag_find_all.set_property('background','yellow')

      self.textview.modify_font(pango.FontDescription(settings['font']))

      self.sw.add(self.textview)

      self.menu()
      self.toolbar()
      self.findbar()
      self.buffer_loader(files, self.current_file)

      self.window.add(self.sw)
      self.window.show_all()

############################################

# Main menu

   def menu(self):

      self.menu = gtk.Menu()

# Document Submenu

      m_document = gtk.MenuItem("Document")
      self.menu.append(m_document)

      self.document_submenu = gtk.Menu()
      m_properties = gtk.ImageMenuItem(gtk.STOCK_PROPERTIES)
      self.document_submenu.append(m_properties)
      m_find = gtk.ImageMenuItem(gtk.STOCK_FIND)
      self.document_submenu.append(m_find)
      m_properties.connect('activate',self.document_properties)
      m_find.connect('activate', self.show_find)
      m_document.set_submenu(self.document_submenu)

# Edit Submenu

      m_edit = gtk.MenuItem("Edit")
      self.menu.append(m_edit)

      self.edit_submenu = gtk.Menu()
      self.m_select_mode = gtk.CheckMenuItem("Select Mode")
      m_copy = gtk.ImageMenuItem(gtk.STOCK_COPY)
      m_select_all = gtk.ImageMenuItem(gtk.STOCK_SELECT_ALL)
      m_goto_top = gtk.ImageMenuItem(gtk.STOCK_GOTO_TOP)
      m_goto_bottom = gtk.ImageMenuItem(gtk.STOCK_GOTO_BOTTOM)
      m_zoom_in = gtk.ImageMenuItem(gtk.STOCK_ZOOM_IN)
      m_zoom_out = gtk.ImageMenuItem(gtk.STOCK_ZOOM_OUT)
      self.edit_submenu.append(self.m_select_mode)
      self.edit_submenu.append(gtk.SeparatorMenuItem())
      self.edit_submenu.append(m_copy)
      self.edit_submenu.append(m_select_all)
      self.edit_submenu.append(gtk.SeparatorMenuItem())
      self.edit_submenu.append(m_goto_top)
      self.edit_submenu.append(m_goto_bottom)
      self.edit_submenu.append(gtk.SeparatorMenuItem())
      self.edit_submenu.append(m_zoom_in)
      self.edit_submenu.append(m_zoom_out)
      self.m_select_mode.connect('activate',self.select_mode_button_callback, False, True)
      m_copy.connect('activate',self.copy_button_callback)
      m_select_all.connect('activate',self.select_all_button_callback)
      m_goto_top.connect('activate',self.goto_top_button_callback)
      m_goto_bottom.connect('activate',self.goto_bottom_button_callback)
      m_zoom_in.connect('activate',self.zoom_in_button_callback)
      m_zoom_out.connect('activate',self.zoom_out_button_callback)
      m_edit.set_submenu(self.edit_submenu)

# Options Submenu

      m_options = gtk.MenuItem("Options")
      self.menu.append(m_options)

      self.options_submenu = gtk.Menu()
      m_font = gtk.ImageMenuItem(gtk.STOCK_SELECT_FONT)
      m_preferences = gtk.ImageMenuItem(gtk.STOCK_PREFERENCES)
      m_about = gtk.ImageMenuItem(gtk.STOCK_ABOUT)
      self.options_submenu.append(m_font)
      self.options_submenu.append(m_preferences)
      self.options_submenu.append(m_about)
      m_font.connect('activate',self.font_button_callback)
      m_preferences.connect('activate',self.preference_button_callback)
      m_about.connect('activate',self.about_dialog)
      m_options.set_submenu(self.options_submenu)

      m_help = gtk.ImageMenuItem(gtk.STOCK_HELP)
      m_help.connect('activate', self.help)
      self.menu.append(gtk.SeparatorMenuItem())
      self.menu.append(m_help)

      m_quit = gtk.ImageMenuItem(gtk.STOCK_QUIT)
      m_quit.connect('activate', self.quit_button_callback)
      self.menu.append(gtk.SeparatorMenuItem())
      self.menu.append(m_quit)

      self.window.set_menu(self.menu)

# Main Toolbar

   def toolbar(self):

      toolbar = gtk.Toolbar()

      self.select_mode_button = gtk.ToggleToolButton(gtk.STOCK_EDIT)
      self.select_mode_button.connect('toggled', self.select_mode_button_callback, True, False)
      preference_button = gtk.ToolButton(gtk.STOCK_PREFERENCES)
      preference_button.connect('clicked', self.preference_button_callback)
      font_button = gtk.ToolButton(gtk.STOCK_SELECT_FONT)
      font_button.connect('clicked', self.font_button_callback)
      copy_button = gtk.ToolButton(gtk.STOCK_COPY)
      copy_button.connect('clicked', self.copy_button_callback)
      select_all_button = gtk.ToolButton(gtk.STOCK_SELECT_ALL)
      select_all_button.connect('clicked', self.select_all_button_callback)
      find_button = gtk.ToolButton(gtk.STOCK_FIND)
      find_button.connect('clicked', self.show_find)
      top_button = gtk.ToolButton(gtk.STOCK_GOTO_TOP)
      top_button.connect('clicked', self.goto_top_button_callback)
      bottom_button = gtk.ToolButton(gtk.STOCK_GOTO_BOTTOM)
      bottom_button.connect('clicked', self.goto_bottom_button_callback)
      zoom_in_button = gtk.ToolButton(gtk.STOCK_ZOOM_IN)
      zoom_in_button.connect('clicked', self.zoom_in_button_callback)
      zoom_out_button = gtk.ToolButton(gtk.STOCK_ZOOM_OUT)
      zoom_out_button.connect('clicked', self.zoom_out_button_callback)
      self.back_button = gtk.ToolButton()
      self.back_button.set_expand(True)
      b_image = gtk.Image()
      b_image.set_from_pixbuf(gtk.gdk.pixbuf_new_from_file_at_size("/usr/share/icons/hicolor/26x26/hildon/qgn_list_gene_back.png", 26, 26))
      self.back_button.set_icon_widget(b_image)
      self.back_button.connect('clicked', self.go_back)
      self.forward_button = gtk.ToolButton()
      self.forward_button.set_expand(True)
      f_image = gtk.Image()
      f_image.set_from_pixbuf(gtk.gdk.pixbuf_new_from_file_at_size("/usr/share/icons/hicolor/26x26/hildon/qgn_list_gene_forward.png", 26, 26))
      self.forward_button.set_icon_widget(f_image)
      self.forward_button.connect('clicked', self.go_forward)
#      about_button = gtk.ToolButton(gtk.STOCK_ABOUT)
#      about_button.connect('clicked', self.about_dialog)
#      quit_button = gtk.ToolButton(gtk.STOCK_QUIT)
#      quit_button.connect('clicked', self.quit_button_callback)

      toolbar.insert(self.select_mode_button, -1)
      toolbar.insert(preference_button, -1)
      toolbar.insert(font_button, -1)
      toolbar.insert(gtk.SeparatorToolItem(), -1)
      toolbar.insert(copy_button, -1)
      toolbar.insert(select_all_button, -1)
      toolbar.insert(find_button, -1)
      toolbar.insert(gtk.SeparatorToolItem(), -1)
      toolbar.insert(top_button, -1)
      toolbar.insert(bottom_button, -1)
      toolbar.insert(gtk.SeparatorToolItem(), -1)
      toolbar.insert(zoom_in_button, -1)
      toolbar.insert(zoom_out_button, -1)
      toolbar.insert(gtk.SeparatorToolItem(), -1)
      toolbar.insert(self.back_button, -1)
      toolbar.insert(self.forward_button, -1)
#      toolbar.insert(about_button, -1)
#      toolbar.insert(quit_button, -1)

      self.window.connect("key-press-event", self.on_key_press)
      self.window.connect("window-state-event", self.on_window_state_change)

      self.window.add_toolbar(toolbar)

# Find Toolbar

   def findbar(self):

      self.find_toolbar = hildon.FindToolbar("Search for :")

      self.find_toolbar.connect("close", self.hide_find)
      self.find_toolbar.connect("search", self.get_find_text)
      self.find_toolbar.set_no_show_all(True)
      self.window.add_toolbar(self.find_toolbar)

# Textbuffer loader

   def buffer_loader(self, files, index):
      textbuffer = self.textview.get_buffer()
      q_settings = self.get_q_settings()

      self.open_file = q_settings['path'] + files[index] + '.txt'

      infile = open(self.open_file, "r")

      if infile:
         string = infile.read()
         infile.close()
         textbuffer.set_text(string)
      self.textview.set_wrap_mode(gtk.WRAP_WORD)

      self.window.set_title("QCV - " + files[index])

      if index == (len(files) - 1):
         self.forward_button.set_sensitive(False)
      else:
         self.forward_button.set_sensitive(True)
      if index == 0:
         self.back_button.set_sensitive(False)
      else:
         self.back_button.set_sensitive(True)

############################################

   def quit_button_callback(self, widget):
      gtk.main_quit()

# Go Back/Forward

   def go_forward(self, widget):
      files = self.get_files()

      if self.current_file == (len(files) - 1):
         #self.forward_button.set_sensitive(False)
         return
      else:
         self.current_file = self.current_file + 1

      try:
         self.buffer_loader(files, self.current_file)
      except IOError:
         pass

   def go_back(self, widget):
      files = self.get_files()

      if self.current_file == 0:
         return
      else:
         self.current_file = self.current_file - 1

      try:
         self.buffer_loader(files, self.current_file)
      except IOError:
         pass

# Find/Search functions

   def hide_find(self, widget):
      self.find_toolbar.hide()
      buffer = self.textview.get_buffer()
      start, end = buffer.get_bounds()
      buffer.remove_tag_by_name("search_hilight", start, end)
      self.searched_text_count = 0
      self.search_results_list_start=[]
      self.search_results_list_end=[]
      self.searched_text = None

   def show_find(self, widget):
      self.find_toolbar.show()

   def get_find_text(self, widget):
      text = widget.get_property("prefix")
      self.search(text)

   def search(self, text):
      buffer = self.textview.get_buffer()
      if self.searched_text != text:
         start, end = buffer.get_bounds()
         buffer.remove_tag_by_name("search_hilight", start, end)
         self.searched_text = text
         self.searched_text_count = 0

         self.search_results_list_start=[]
         self.search_results_list_end=[]

         search_results = self.findSubstring(buffer.get_text(start, end), text)
         for index in search_results:
            found_start = buffer.get_iter_at_offset(index.span()[0])
            found_end = buffer.get_iter_at_offset(index.span()[1])
            buffer.apply_tag_by_name("search_hilight", found_start, found_end)
            self.search_results_list_start.append(found_start.get_offset())
            self.search_results_list_end.append(found_end.get_offset())

      else:
         self.searched_text_count = self.searched_text_count + 1
      try:
         iter_start = buffer.get_iter_at_offset(self.search_results_list_start[self.searched_text_count])
         iter_end = buffer.get_iter_at_offset(self.search_results_list_end[self.searched_text_count])
         buffer.place_cursor(iter_start)
         buffer.select_range(iter_start, iter_end)
         self.textview.scroll_to_iter(iter_start,0)
      except IndexError:
         hildon.hildon_banner_show_information(self.textview, None, "No more matches.")

   def findSubstring(self, text, substring):
      import re
      searched_text=re.compile(substring)
      return searched_text.finditer(text)

   def document_properties(self, widget):

      dialog = gtk.Dialog("Properties",None,gtk.DIALOG_MODAL)
      ok_button = dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)

      file_hbox = gtk.HBox()
      type_hbox = gtk.HBox()
      char_hbox = gtk.HBox()
      word_hbox = gtk.HBox()
      size_hbox = gtk.HBox()
      mod_hbox = gtk.HBox()

      file_label = gtk.Label()
      file_label.set_markup('<b>File:</b>')
      file_label_d = gtk.Label(self.open_file)
      file_label_d.set_line_wrap(gtk.WRAP_CHAR)

      type_label = gtk.Label()
      type_label.set_markup('<b>Type:</b>')
      command = 'file "' + self.open_file + '"'
      f_type = commands.getoutput(command)
      output = self.open_file + ": "
      f_type = f_type.replace(output, '')
      type_label_d = gtk.Label(f_type)
      type_label_d.set_line_wrap(gtk.WRAP_WORD)

      char_label = gtk.Label()
      char_label.set_markup('<b>Character Count:</b>')
      textbuffer = self.textview.get_buffer()
      char = len(textbuffer.get_text(*textbuffer.get_bounds()))
      char_label_d = gtk.Label(char)

      word_label = gtk.Label()
      word_label.set_markup('<b>Word Count:</b>')
      textbuffer = self.textview.get_buffer()
      text = textbuffer.get_text(*textbuffer.get_bounds())

      words = str.split(text)
      word_label_d = gtk.Label(len(words))

      size_label = gtk.Label()
      size_label.set_markup('<b>Size:</b>')
      fsize = os.path.getsize(self.open_file)

      if fsize < 1024:
         size = "%0.0f B" % float(fsize)
      elif fsize >= 1024 and fsize < 1048576 :
         size = "%0.1f KB" % float(fsize/1024.0)
      elif fsize >= 1048576:
         size = "%0.2f MB" % float(fsize/1048576.0)
      else:
         size = "Unknown"

      size_label_d = gtk.Label(size)

      mod_label = gtk.Label()
      mod_label.set_markup('<b>Modified:</b>')
      mod_label_d = gtk.Label(time.strftime("%m/%d/%Y %I:%M:%S %p",time.localtime(os.path.getmtime(self.open_file))))

      file_hbox.pack_start(file_label, False, 5, 5)
      file_hbox.pack_end(file_label_d, False, 5, 5)

      type_hbox.pack_start(type_label, False, 5, 5)
      type_hbox.pack_end(type_label_d, False, 5, 5)

      char_hbox.pack_start(char_label, False, 5, 5)
      char_hbox.pack_end(char_label_d, False, 5, 5)

      word_hbox.pack_start(word_label, False, 5, 5)
      word_hbox.pack_end(word_label_d, False, 5, 5)

      size_hbox.pack_start(size_label, False, 5, 5)
      size_hbox.pack_end(size_label_d, False, 5, 5)

      mod_hbox.pack_start(mod_label, False, 5, 5)
      mod_hbox.pack_end(mod_label_d, False, 5, 5)

      dialog.vbox.pack_start(file_hbox, True, 10, 10)
      dialog.vbox.pack_start(type_hbox, True, 10, 10)
      dialog.vbox.pack_start(char_hbox, True, 10, 10)
      dialog.vbox.pack_start(word_hbox, True, 10, 10)
      dialog.vbox.pack_start(size_hbox, True, 10, 10)
      dialog.vbox.pack_start(mod_hbox, True, 10, 10)

      dialog.show_all()
      dialog.run()
      dialog.destroy()

   def goto_top_button_callback(self, widget):
      textview_iter = self.textview.get_iter_at_location(0, 0)
      self.textview.scroll_to_iter(textview_iter, False)

   def goto_bottom_button_callback(self, widget):
      textbuffer = self.textview.get_buffer()
      buffer_length = textbuffer.get_end_iter()
      self.textview.scroll_to_iter(buffer_length, False)

   def zoom_in_button_callback(self, widget):
      context = self.textview.get_pango_context()
      font = context.get_font_description()
      size = font.get_size()

      if size > 32000:
         hildon.hildon_banner_show_information(self.textview, None, "Maximum zoom level reached")
         return

      font.set_size(int(size + 2000))
      self.textview.modify_font(font)
      self.set_settings(font)

   def zoom_out_button_callback(self, widget):
      context = self.textview.get_pango_context()
      font = context.get_font_description()
      size = font.get_size()

      if size < 6000:
         hildon.hildon_banner_show_information(self.textview, None, "Minimum zoom level reached")
         return

      font.set_size(int(size - 2000))
      self.textview.modify_font(font)
      self.set_settings(font)

   def font_button_callback(self, widget):
      font_dialog = gtk.FontSelectionDialog("Select A Font")
      font_dialog.set_size_request(700, 450)
      response = font_dialog.run()

      if response == gtk.RESPONSE_OK:
         font_desc = pango.FontDescription(font_dialog.get_font_name())
         if font_desc:
            self.textview.modify_font(font_desc)
            self.set_settings(font_desc)

      font_dialog.destroy()

   def copy_button_callback(self, widget):
      try:
         textview_buffer = self.textview.get_buffer()
         start, end = textview_buffer.get_selection_bounds()

         clipboard = gtk.clipboard_get(gtk.gdk.SELECTION_CLIPBOARD)
         clipboard.set_text(textview_buffer.get_text(start, end))
         hildon.hildon_banner_show_information(self.textview, None, "Copied")
      except ValueError:
         hildon.hildon_banner_show_information(self.textview, "qgn_note_gene_syswarning", "Nothing Selected")

   def select_all_button_callback(self, widget):
      textbuffer = self.textview.get_buffer()

      if textbuffer.get_selection_bounds() == ():
         start, end = textbuffer.get_bounds()
         textbuffer.select_range(start, end)
      else:
         start, end = textbuffer.get_bounds()
         textbuffer.select_range(start, start)

   def select_mode_button_callback(self, widget, button=False, check=False):
      if button == True:
         active = self.select_mode_button.get_active()
         self.m_select_mode.set_active(active)
      if check == True:
         active = self.m_select_mode.get_active()
         self.select_mode_button.set_active(active)

      if active == True:
         self.textview.set_sensitive(True)
         self.textview.set_editable(False)
      else:
         self.textview.set_sensitive(False)

   def preference_button_callback(self, widget):
      dialog = gtk.Dialog("Settings",None,gtk.DIALOG_MODAL)
      dialog.set_size_request(400, -1)
      ok_button = dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
      cancel_button = dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)

      settings = self.get_settings()

      combobox = gtk.combo_box_new_text()
      combobox.append_text("Kinetic")
      combobox.append_text("GTK")

      combobox.set_active(int(settings['scrolling']))

      hbox = gtk.HBox()
      hbox.pack_start(gtk.Label("Scrolling:"), False, 5, 5)
      hbox.pack_end(combobox)

      label = gtk.Label()
      label.set_markup("<b>Note:</b> You may need to restart the\nprogram for some changes to take effect.")

      dialog.vbox.pack_start(hbox, False, 10, 10)
      dialog.vbox.pack_end(label, False, 10, 10)

      dialog.show_all()
      response = dialog.run()

      if response == gtk.RESPONSE_OK:
         scrolling = combobox.get_active()
         self.set_settings(None, scrolling)

      dialog.destroy()

# Main Help

   def help(self, widget, data=None):
      import hildonhelp
      hildonhelp.help_show(osso_context, "osso_quickclip_viewer", 0)

# About dialog

   def about_dialog(self,widget,data=None):
      about_quick_clip = gtk.AboutDialog()
      about_quick_clip.set_name(a_name)
      about_quick_clip.set_version(a_version)
      about_quick_clip.set_logo(gtk.gdk.pixbuf_new_from_file("/usr/share/icons/hicolor/40x40/hildon/quick_clip-40x40.png"))
      about_quick_clip.set_comments("""
The fast and easy way to copy and save information.
""")
      about_quick_clip.set_copyright("Copyright 2009, Brent Chiodo")
      about_quick_clip.set_license("""This program is free software: you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation, either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program.  If not, see
<http://www.gnu.org/licenses/>.""")

      authors = ["Brent Chiodo <bchiodo@gmail.com>"]
      about_quick_clip.set_authors(authors)
      about_quick_clip.run()
      about_quick_clip.destroy()

# Get Quick Clip's settings

   def get_q_settings(self):

      user_config_file = open('/home/user/.quickclip/quickclip.conf', 'r')
      user_config_access = ConfigParser.RawConfigParser()
      user_config_access.readfp(user_config_file)

      settings_dict = {}
      settings_dict['path'] = user_config_access.get('DEFAULT', 'path')
      settings_dict['view_program'] = user_config_access.get('DEFAULT', 'view_program')
      settings_dict['edit_program'] = user_config_access.get('DEFAULT', 'edit_program')
      settings_dict['use_date_stamp'] = user_config_access.get('DEFAULT', 'use_date_stamp')
      settings_dict['use_separater'] = user_config_access.get('DEFAULT', 'use_separater')
      settings_dict['default_menu_positioning'] = user_config_access.get('DEFAULT', 'default_menu_positioning')

      settings_dict['use_date_stamp'] = self.get_settings_helper(settings_dict['use_date_stamp'])
      settings_dict['use_separater'] = self.get_settings_helper(settings_dict['use_separater'])
      settings_dict['default_menu_positioning'] = self.get_settings_helper(settings_dict['default_menu_positioning'])

      user_config_file.close()

      return settings_dict

   def get_settings_helper(self, value):
      if value == "True":
         return True
      if value == "False":
         return False
      if value == "1":
         return 1
      if value == "0":
         return 0

# Get parent files

   def get_files(self):
      tree = ET.parse("/home/user/.quickclip/parent_files.xml")
      elements = tree.getroot()
      files_list = []

      for subelement in elements:
         files_list.append(subelement.text)

      return files_list

# Get User's settings

   def get_settings(self):

      user_config_file = open('/home/user/.quickclip/viewer.conf', 'r')
      user_config_access = ConfigParser.RawConfigParser()
      user_config_access.readfp(user_config_file)

      settings_dict = {}
      settings_dict['font'] = user_config_access.get('DEFAULT', 'font')
      settings_dict['scrolling'] = user_config_access.get('DEFAULT', 'scrolling')
      settings_dict['scrolling'] = int(settings_dict['scrolling'])

      user_config_file.close()

      return settings_dict

# Set settings

   def set_settings(self, font=None, scrolling=None):

      settings = self.get_settings()

      user_config_file = open('/home/user/.quickclip/viewer.conf', 'w')
      user_config_access = ConfigParser.RawConfigParser()

      if not font == None:
         user_config_access.set('DEFAULT', 'font', font)
         user_config_access.set('DEFAULT', 'scrolling', settings['scrolling'])

      if not scrolling == None:
         user_config_access.set('DEFAULT', 'scrolling', scrolling)
         user_config_access.set('DEFAULT', 'font', settings['font'])

      user_config_access.write(user_config_file)
      user_config_file.close()

   def on_window_state_change(self, widget, event, *args):
      if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
         self.window_in_fullscreen = True
      else:
         self.window_in_fullscreen = False

   def on_key_press(self, widget, event, *args):
      if event.keyval == gtk.keysyms.F6:
      # The "Full screen" hardware key has been pressed
         if self.window_in_fullscreen:
            self.window.unfullscreen()
         else:
            self.window.fullscreen()

      if event.keyval == gtk.keysyms.F7:
         self.zoom_in_button_callback(self.textview)

      if event.keyval == gtk.keysyms.F8:
         self.zoom_out_button_callback(self.textview)

      if event.keyval == gtk.keysyms.Up:
         swt = type(self.sw)

         if swt == gtk.ScrolledWindow:
            newval = self.sw.props.vadjustment.value - self.sw.props.vadjustment.page_size
            if newval < self.sw.props.vadjustment.lower:
               newval = self.sw.props.vadjustment.lower
            self.sw.props.vadjustment.value = newval
         else:
            hildon.hildon_banner_show_information(self.sw, "qgn_note_gene_syswarning", "Sorry, the kinetic scroller doesn't support key-press scrolling.")

      if event.keyval == gtk.keysyms.Down:
         swt = type(self.sw)

         if swt == gtk.ScrolledWindow:
            newval = self.sw.props.vadjustment.value + self.sw.props.vadjustment.page_size
            max = self.sw.props.vadjustment.upper - self.sw.props.vadjustment.page_size
            if newval > max:
               newval = max
            self.sw.props.vadjustment.value = newval
         else:
            hildon.hildon_banner_show_information(self.sw, "qgn_note_gene_syswarning", "Sorry, the kinetic scroller doesn't support key-press scrolling.")

      if event.keyval == gtk.keysyms.Right:
         self.go_forward(None)

      if event.keyval == gtk.keysyms.Left:
         self.go_back(None)

   def close_application(self, widget):
      gtk.main_quit()

   def run(self):
      gtk.main()

if not os.path.exists('/home/user/.quickclip/viewer.conf'):

   user_config_file = open('/home/user/.quickclip/viewer.conf', 'w')
   user_config_access = ConfigParser.RawConfigParser()

   user_config_access.set('DEFAULT', 'font', 'Sans 12')
   user_config_access.set('DEFAULT', 'scrolling', 'kinetic')

   user_config_access.write(user_config_file)
   user_config_file.close()

app = QuickClipViewer()
app.run()