#ifndef QUICKWIDGET_HPP
#define QUICKWIDGET_HPP

#include <QtCore>
#include <QtGui>
#include <q-extras/qemaemo5dynamicwidgethelper.h>

class QDeclarativeView;
class QuickWidgetWrapper;


class QuickWidget : public QeMaemo5DynamicHomescreenWidget
{
    Q_OBJECT

private:
    void initView(const QString& fileName, const QSize& size=QSize(),
		  bool rotate=false);
    QSize size_;
    QDeclarativeView* view_;
    QuickWidgetWrapper* wrapper_;
    bool landscape_;

protected:
//    void showSettingsDialog();
    bool restoreWidgetState();
    void errorWidget();
    void paintEvent(QPaintEvent *event);

public slots:
  void resizer(const QSize& size);
  void rotateScreen(const QString& orientation);

public:
    static QuickWidget *createAndShowNew(const QString& fileName, 
					 const QSize& size=QSize(),
					 bool rotate=false);

    explicit QuickWidget(QWidget *parent = 0);
    ~QuickWidget();

};

class QuickWidgetWrapper : public QObject
{
    Q_OBJECT

Q_SIGNALS:
    void onHomeScreenChanged();

public:
    QuickWidgetWrapper(QuickWidget *owner) : m_owner(owner) {;}
    Q_PROPERTY(bool isActiveWindow READ onHomeScreen NOTIFY onHomeScreenChanged);

    bool onHomeScreen() const { return m_homeScreen; }

public slots:
    void setOnHomeScreen(bool active)
    {
        if (active == m_homeScreen)
            return;
        m_homeScreen = active;
        emit onHomeScreenChanged();
    }

private:
    QuickWidget *m_owner;
    bool m_homeScreen;
};

#endif // QuickWidget_HPP
