#include <QtCore>
#include <QtGui>
#include <q-extras/qtsingleapplication.h>

#include "appeventlistener.hpp"
#include "quickwidgetsettings.hpp"

static AppEventListener *_instance = NULL;

AppEventListener* AppEventListener::instance()
{
    if (_instance == NULL)
        _instance = new AppEventListener(QCoreApplication::instance());

    return _instance;
}

AppEventListener::AppEventListener(QObject *parent) :
    QObject(parent)
{
    // Connect to the QtSingleApplication's event
    QObject::connect(QtSingleApplication::instance(), SIGNAL(messageReceived(const QString&)), this, SLOT(receiveMessage(const QString&)));
}

void AppEventListener::receiveMessage(const QString& message)
{
    if (message == APP_MESSAGE_ADDWIDGET)
    {
        qDebug() << "TTTTTTEEEEST";
        QuickWidgetSettings settings;
        settings.exec();
    }
    else if (message == APP_MESSAGE_CLOSE)
    {
        ((QApplication*)sender())->quit();
    }
}

