/*
	quick-launch status-bar applet
	
	@author	Daniele Maio (b0unc3) 
	@date	16/02/2010
	@update	17/10/2010
	@ver	0.9
	
*/

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <libosso.h>
#include <gconf/gconf-client.h>

#include "quick-launch.h"

                         
#define QUICK_LAUNCH_STATUS_MENU_ITEM_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj, QUICK_LAUNCH_TYPE_STATUS_MENU_ITEM, QuickLaunchStatusMenuItemPrivate))





struct _QuickLaunchStatusMenuItemPrivate
{
	gpointer data;
};

HD_DEFINE_PLUGIN_MODULE (QuickLaunchStatusMenuItem, quick_launch_status_menu_item, HD_TYPE_STATUS_MENU_ITEM)



void
parse_info (GConfClient* client, gboolean big_icon)
{
	g_print("parsing info\n");
	if ( client == NULL )
		g_print("clnt null\n");
	else g_print("clnt ok'\n");
	GError *err;
	GtkWidget *icoim;
	GdkPixbuf *pixim;
	int i;
	GSList *lst = NULL;
	gpointer *in;
	
	for(i=0;i<4;i++) {
		if (gconf_entry_get_value (g_strdup_printf("%s%s",APP_GCONF_KEY,group_name[i])) != NULL) {
			lst = gconf_client_get_list (GCONF_CLIENT(client),g_strdup_printf("%s%s",APP_GCONF_KEY,group_name[i]), GCONF_VALUE_STRING, &err);
			if ( lst != NULL ) {
				in = g_slist_nth_data (lst, 1);
				
				g_print("getted = %s\n",in);
				pixim = gdk_pixbuf_new_from_file ( (gchar *)in, NULL );
				if ( big_icon )
					icoim = gtk_image_new_from_pixbuf (gdk_pixbuf_scale_simple (pixim, 64,64, GDK_INTERP_BILINEAR) );
				else 
					icoim = gtk_image_new_from_pixbuf (gdk_pixbuf_scale_simple ( pixim, 48,48, GDK_INTERP_BILINEAR ));
				
				if ( btns[i] == NULL )
					g_print("btn failsk\n");
				else g_print("btn ok'\n");
				hildon_button_set_image ( HILDON_BUTTON(btns[i]), icoim );
				gtk_widget_show ( GTK_WIDGET(btns[i]) );

			}
		}
	}
	
}


gboolean
load_app(GtkWidget *widget , gpointer data)
{
	gint pos;
	GKeyFile *conf;
	GError *err;
	gchar *oss,*cbin;
	oss = cbin = "";
	gpointer *o,*b;
	GSList *lst = NULL;
	GConfClient* client;
	
	/*init GConf */
	client = gconf_client_get_default();
	
	GtkWidget *toplevel = gtk_widget_get_toplevel(widget);
        gtk_widget_hide (toplevel);


	pos = (gint) data;
	if (gconf_entry_get_value (g_strdup_printf("%s%s",APP_GCONF_KEY,group_name[pos])) != NULL) {
		lst = gconf_client_get_list (GCONF_CLIENT(client),g_strdup_printf("%s%s",APP_GCONF_KEY,group_name[pos]), GCONF_VALUE_STRING, &err);
		if ( lst != NULL ) {
			o =  g_slist_nth_data (lst, 2);
			b =  g_slist_nth_data (lst, 3);
			oss = (gchar *)o;
			cbin = (gchar *)b;
			
			if ( GTK_IS_WIDGET(d) ) gtk_widget_destroy( GTK_WIDGET(d) );
			if ( g_strcasecmp(oss,"")!=0 ) {
				gboolean result;
			
				osso_context_t *osso=osso_initialize("quick-launch","0.1",TRUE,NULL);
				if ( !(result = osso_rpc_run_with_defaults(osso, oss, "top_application", NULL, DBUS_TYPE_INVALID) == OSSO_OK))
				{
					hildon_banner_show_information(NULL, NULL, "Execution failed");
				}
				osso_deinitialize(osso);
				return FALSE;
			
		
			} else if ( g_strcasecmp(cbin,"")!=0 ) { 
				gint argc;
				gchar **argv;
				pid_t pid;
				GError *error;
			
				if (g_shell_parse_argv(cbin,&argc,&argv,NULL)) {
					if ( g_spawn_async(NULL,argv,NULL,(GSpawnFlags)G_SPAWN_SEARCH_PATH,NULL,NULL,&pid,&error) ) {
						g_spawn_close_pid (pid);
						return FALSE;
					} else return FALSE;
				} else return FALSE;
				
				if (error)
				{
					hildon_banner_show_information(NULL, NULL, "Execution failed");
					g_error_free(error);
					return FALSE;
				}
			}
		}
	}
	
	return FALSE;

}

static void
quick_launch_status_menu_item_class_finalize (QuickLaunchStatusMenuItemClass *klass) {}

static void
quick_launch_status_menu_item_class_init (QuickLaunchStatusMenuItemClass *klass)
{
    g_type_class_add_private (klass, sizeof (QuickLaunchStatusMenuItemPrivate));
}

static void
quick_launch_status_menu_item_init (QuickLaunchStatusMenuItem *plugin)
{	
	GtkWidget *hbox,*icon;
	GConfClient* client;
	
	/*init GConf */
	client = gconf_client_get_default();

    	plugin->priv = QUICK_LAUNCH_STATUS_MENU_ITEM_GET_PRIVATE (plugin);
   	
   	hbox = gtk_hbox_new(FALSE, 0);
   	int i;
   	for(i=0;i<4;i++) {
	   	btns[i] = hildon_button_new(HILDON_SIZE_THUMB_HEIGHT,
				/*HILDON_SIZE_FINGER_HEIGHT,*/ HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	   	gtk_widget_set_size_request ( GTK_WIDGET(btns[i]), 48,48 );
		gtk_widget_show(btns[i]);
		gtk_box_pack_start(GTK_BOX(hbox), btns[i], TRUE, TRUE, 1);
		g_signal_connect ( G_OBJECT(btns[i]), "clicked", G_CALLBACK(load_app), (gpointer) i);
	}
	// Pack widgets to menu
	gtk_widget_show(hbox);
	gtk_container_add(GTK_CONTAINER(plugin), hbox);
	gtk_widget_show(GTK_WIDGET(plugin));

	gconf_client_add_dir(client,
                       g_strdup_printf("%s%s",GCONF_DIR,APP_NAME),
                       GCONF_CLIENT_PRELOAD_NONE,
                       NULL);

  	gconf_client_notify_add(client, g_strdup_printf("%sfirst",APP_GCONF_KEY),
                          parse_info,
                          NULL,
                          NULL, NULL);
                          
	gconf_client_notify_add(client, g_strdup_printf("%ssecond",APP_GCONF_KEY),
                          parse_info,
                          NULL,
                          NULL, NULL);
                          
	gconf_client_notify_add(client, g_strdup_printf("%sthird",APP_GCONF_KEY),
                          parse_info,
                          NULL,
                          NULL, NULL);
                          
	gconf_client_notify_add(client, g_strdup_printf("%sfourth",APP_GCONF_KEY),
                          parse_info,
                          NULL,
                          NULL, NULL);


	parse_info(client,FALSE);

}


