#include <hildon/hildon.h>
#include <gconf/gconf-client.h>
#include <locale.h>

#include "quick-launch.h"


GtkTreeModel *
create_completion_model (void)
{
  GtkListStore *store;
  GtkTreeIter iter;
  
  store = gtk_list_store_new (1, G_TYPE_STRING);

  GDir 		*d;
  GKeyFile 	*dsk;
  GError	*error;
  d = g_dir_open(APPS_DIR,0,NULL);
  
	if ( d ) {
		setlocale( LC_ALL, "" );
		const gchar *file;
		while ( (file=g_dir_read_name(d)) ) {
			if ( g_strrstr(file,".desktop") != NULL ) {
			/* Add item to the column */

			dsk = g_key_file_new();
			gchar *n,*oss,*bin;
			n = NULL;
			
			if ( g_key_file_load_from_file ( dsk, g_strdup_printf("%s%s",APPS_DIR,file), G_KEY_FILE_KEEP_COMMENTS, &error ) ){
				if ( g_key_file_has_key ( dsk, "Desktop Entry", "X-Text-Domain", &error ) ) {
				//get name from gettext
					textdomain( g_key_file_get_value( dsk, "Desktop Entry", "X-Text-Domain", &error ) );
					n = gettext( g_key_file_get_value ( dsk, "Desktop Entry", "Name", &error ) );
				} else if ( g_key_file_has_key ( dsk, "Desktop Entry", "Name", &error ) ) {
				//get name from entry
					n = g_key_file_get_value ( dsk, "Desktop Entry", "Name", &error );
				}
				
				if ( n != NULL ) {
					gtk_list_store_append (store, &iter);
					gtk_list_store_set (store, &iter, 0, g_strdup(n), -1);
				}
			}
			}
		
			
		g_key_file_free (dsk);
		}
		
		g_dir_close(d);
	}

  
  return GTK_TREE_MODEL (store);
}


static gboolean
run_cmd()
{
	HildonDialog *c;
	GtkWidget *entry,*runte,*box;
	
	entry = hildon_entry_new (HILDON_SIZE_AUTO);
	runte = hildon_check_button_new ( HILDON_SIZE_AUTO );
	gtk_button_set_label (GTK_BUTTON (runte), "Run in terminal");
        hildon_gtk_entry_set_placeholder_text (GTK_ENTRY (entry), " Program name");
        box = gtk_vbox_new ( 0, FALSE );
        gtk_box_pack_start ( GTK_BOX(box), entry, FALSE,FALSE, 0 );
        gtk_box_pack_start ( GTK_BOX(box), runte, FALSE,FALSE, 0 );
	c = HILDON_DIALOG (hildon_dialog_new ());
	hildon_dialog_add_button (HILDON_DIALOG (c), GTK_STOCK_OK, GTK_RESPONSE_OK);
	gtk_window_set_title (GTK_WINDOW (c), "QuickLaunch: run command...");
	
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(c)->vbox), box);
	gtk_widget_show_all (GTK_WIDGET (c));
	
	int response;
	response = gtk_dialog_run (GTK_DIALOG (c));
	if ( response == GTK_RESPONSE_OK ) { //execute program
		if ( gtk_entry_get_text ( GTK_ENTRY(entry) ) == NULL ) {
			hildon_banner_show_information(NULL,NULL, "You must fill the text entry before");
		} else {
			gchar *bin;
			if ( hildon_check_button_get_active ( HILDON_CHECK_BUTTON (runte) ) ) { //run in terminal 
				bin = g_strdup_printf("/usr/bin/osso-xterm -e \"%s\"",gtk_entry_get_text ( GTK_ENTRY(entry) ));
			} else bin = gtk_entry_get_text ( GTK_ENTRY(entry) );

			gint argc;
			gchar **argv;
			pid_t pid;
			GError *error;
		
			if (g_shell_parse_argv(bin,&argc,&argv,NULL)) {
				if ( g_spawn_async(NULL,argv,NULL,(GSpawnFlags)G_SPAWN_SEARCH_PATH,NULL,NULL,&pid,&error) ) {
					g_spawn_close_pid (pid);
				}
			}
			
			if (error)
			{
				hildon_banner_show_information(NULL, NULL, g_strdup_printf("Execution failed : %s",error->message));
				g_error_free(error);
			}
			gtk_widget_destroy ( GTK_WIDGET(c) );
			if ( GTK_IS_WIDGET(d) ) gtk_widget_destroy( GTK_WIDGET(d) );			
		}
	}
	
	gtk_widget_destroy ( GTK_WIDGET(c));
	
	return FALSE;
}


int main ( int argc, char *argv[] )
{
	GtkWidget *bbox;
	GtkWidget *rbox;
	GtkWidget *abox;
	GtkWidget *rc;
	GtkWidget *sentry;
	GConfClient* client;
	GtkEntryCompletion *completion;
	GtkTreeModel *completion_model;
	gint response;
	
	hildon_gtk_init (&argc, &argv);
	d = HILDON_DIALOG (hildon_dialog_new ());
	gtk_window_set_title (GTK_WINDOW (d), "QuickLaunch");
	GtkWidget *table;
	bbox = gtk_hbox_new ( FALSE, 0 );
	rbox = gtk_hbox_new ( TRUE, 0 );
	abox = gtk_hbox_new ( FALSE, 0 );
	rc = hildon_button_new_with_text(HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL, "Run command...", "");
	sentry = hildon_entry_new (HILDON_SIZE_AUTO);
	hildon_entry_set_text ( HILDON_ENTRY(sentry), "Type an app name" );
	completion = gtk_entry_completion_new ();
	gtk_entry_set_completion (GTK_ENTRY (sentry), completion);
	g_object_unref (completion);
    
	/* Create a tree model and use it as the completion model */
	completion_model = create_completion_model ();
	gtk_entry_completion_set_model (completion, completion_model);
	g_object_unref (completion_model);
    
	/* Use model column 0 as the text column */
	gtk_entry_completion_set_text_column (completion, 0);
	
	int i;
   	for(i=0;i<4;i++) {
	   	btns[i] = hildon_button_new(HILDON_SIZE_FULLSCREEN_WIDTH, HILDON_BUTTON_ARRANGEMENT_HORIZONTAL);
	   	gtk_widget_set_size_request ( GTK_WIDGET(btns[i]), 64,64 );
		gtk_widget_show(btns[i]);
	//	gtk_box_pack_start(GTK_BOX(bbox), btns[i], FALSE, FALSE, 1);
		g_signal_connect ( G_OBJECT(btns[i]), "clicked", G_CALLBACK(load_app), (gpointer) i);
	}
	client = gconf_client_get_default();
	
	gconf_client_add_dir(client,
                       g_strdup_printf("%s%s",GCONF_DIR,APP_NAME),
                       GCONF_CLIENT_PRELOAD_NONE,
                       NULL);

	g_print("gconf on %s%s\n",GCONF_DIR,APP_NAME);	
	parse_info(client,TRUE);
	
	g_signal_connect ( G_OBJECT(rc), "clicked", G_CALLBACK(run_cmd), NULL );
	GtkWidget *search_btn;
	
	search_btn = hildon_button_new_with_text (  HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL, "Search app", "Click to search" );
	GtkWidget *img = gtk_image_new_from_file ( ICON_PATH );
	hildon_button_set_image ( HILDON_BUTTON(search_btn), img);
	g_signal_connect ( G_OBJECT(search_btn), "clicked", G_CALLBACK(app_search_button_release), NULL );

	GtkWidget *lbox,*tbox;
	lbox = gtk_vbox_new ( 0, TRUE );
	gtk_box_pack_start ( GTK_BOX(lbox), bbox, FALSE,FALSE,0 );
	gtk_box_pack_start ( GTK_BOX(abox), lbox, TRUE,TRUE,0 );
	

	table = gtk_table_new ( 2, 5, FALSE );
	
	gtk_table_attach_defaults ( GTK_TABLE(table), btns[0], 0, 1, 0, 2 ); 
	gtk_table_attach_defaults ( GTK_TABLE(table), btns[1], 1, 2, 0, 2 ); 
	gtk_table_attach_defaults ( GTK_TABLE(table), btns[2], 2, 3, 0, 2 ); 
	gtk_table_attach_defaults ( GTK_TABLE(table), btns[3], 3, 4, 0, 2 ); 
	gtk_table_attach_defaults ( GTK_TABLE(table), rc, 4, 5, 0, 1 ); 
	gtk_table_attach_defaults ( GTK_TABLE(table), search_btn, 4, 5, 1, 2 );
	
	
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(d)->vbox), table);
	gtk_widget_show_all (GTK_WIDGET (d));

       	gtk_dialog_run (GTK_DIALOG (d));
       	
       	gtk_widget_destroy ( GTK_WIDGET(d) );
       	
	return 0;
}
