// util.cpp - 'A Quest Too Far'
//
// Copyright 2010 Geoffrey White
//
// see readme.txt for more details.

#include "util.h"
#include <assert.h>

// --- directional stuff ---

int dir_xs[8] = {0, 1, 1, 1, 0, -1, -1, -1};
int dir_ys[8] = {-1, -1, 0, 1, 1, 1, 0, -1};
int dirs_from[3][3] =
{{	7,	6,	5},
 {	0,	-1,	4},
 {	1,	2,	3}
};

int dir_from(int dx, int dy)
{
	assert(dx >= -1);
	assert(dx <= 1);
	assert(dy >= -1);
	assert(dy <= 1);

	return dirs_from[dx + 1][dy + 1];
}

// --- directional keys ---

struct key_move
{
	SDLKey key;
	int delta_x, delta_y;
};
key_move key_moves[] =
{{SDLK_UP,		0,	-1},	// arrows
 {SDLK_KP8,		0,	-1},	// numeric keypad
 {SDLK_8,		0,	-1},	// direct numbers
 {SDLK_DOWN,	0,	1},
 {SDLK_KP2,		0,	1},
 {SDLK_2,		0,	1},
 {SDLK_k,		0,	1},		// laptop keypad mapping (so that num-lock isn't needed)
 {SDLK_LEFT,	-1,	0},
 {SDLK_KP4,		-1,	0},
 {SDLK_4,		-1,	0},
 {SDLK_u,		-1,	0},
 {SDLK_RIGHT,	1,	0},
 {SDLK_KP6,		1,	0},
 {SDLK_6,		1,	0},
 {SDLK_o,		1,	0},
 {SDLK_HOME,	-1,	-1},
 {SDLK_KP7,		-1,	-1},
 {SDLK_7,		-1,	-1},
 {SDLK_PAGEUP,	1,	-1},
 {SDLK_KP9,		1,	-1},
 {SDLK_9,		1,	-1},
 {SDLK_END,		-1,	1},
 {SDLK_KP1,		-1,	1},
 {SDLK_1,		-1,	1},
 {SDLK_j,		-1,	1},
 {SDLK_PAGEDOWN,1,	1},
 {SDLK_KP3,		1,	1},
 {SDLK_3,		1,	1},
 {SDLK_l,		1,	1}};

bool translate_direction_key(const char_key &key, int &out_dx, int &out_dy)
{
	int i;

	for (i = 0; i < (int)(sizeof(key_moves) / sizeof(key_move)); i++)
	{
		if (key.sdl == key_moves[i].key)
		{
			out_dx = key_moves[i].delta_x;
			out_dy = key_moves[i].delta_y;
			return true;
		}
	}

	return false;
}