#ifndef HOST_H
#define HOST_H

#include <QtCore>
#include "imagegridwidget.h"

class Host : public ImageGridWidget::Item {
public:
    Host();
    Host(const Host& other);
    Host(QString name, int imageIndex, QString macAddress, QImage image );

    bool getMacAddress(char address[]);

public:
    static void registerMeataType();

public:
    int         m_imageIndex;
    QString     m_macAddress;
};

Q_DECLARE_METATYPE(Host)
Q_DECLARE_METATYPE(QList<Host>)


#endif // HOST_H
