#include "hexlineedit.h"
#include <QRegExpValidator>
#include <QIntValidator>

HexLineEdit::HexLineEdit(QWidget* parent/*=0*/) :
        QLineEdit(parent)
{
    m_min =0;
    m_max =255;
    m_isDecimal = false;

    setValidator();
    setValue(0);
}

/*
QValidator::State HexLineEdit::validate(QString &text, int &pos) const {
    if (m_isDecimal) return QSpinBox::validate(text,pos);
    return m_validator.validate(text, pos);
}

QString HexLineEdit::textFromValue(int value) const {
    if (m_isDecimal) return QSpinBox::textFromValue(value);
    return QString::number(value, 16).toUpper();
}

int HexLineEdit::valueFromText(const QString &text) const {
    if (m_isDecimal) return QSpinBox::valueFromText(text);

    bool ok;
    return text.toInt(&ok, 16);
}
*/

bool HexLineEdit::isDecimal() {
    return m_isDecimal;
}

void HexLineEdit::setIsDecimal(bool isDecimal){
    int val = value();

    m_isDecimal = isDecimal;
    setValidator();
    setValue(val);
}

int HexLineEdit::value() const {
    bool ok;
    return text().toInt(&ok, m_isDecimal ? 10 : 16);
}

void HexLineEdit::setValue(int value) {
    setText(QString::number(value, m_isDecimal?10:16).toUpper());
}

void HexLineEdit::setRange(int min, int max) {
    m_min = min;
    m_max = max;
    setValidator();
    setValue(min);
}

void HexLineEdit::setValidator() {
    if ( m_isDecimal ) {
        QLineEdit::setValidator( new QIntValidator(m_min, m_max, this) );
    } else {
        QLineEdit::setValidator( new QRegExpValidator(QRegExp("[0-9A-Fa-f]{1,2}"), this) );
    }
}
