#include "testmousedlg.h"
#include "ui_testmousedlg.h"

#include <QMouseEvent>
#include <QMessageBox>

TestMouseDlg::TestMouseDlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::TestMouseDlg)
{
    ui->setupUi(this);
}

TestMouseDlg::~TestMouseDlg()
{
    delete ui;
}

void TestMouseDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void TestMouseDlg::mousePressEvent(QMouseEvent *event) {
    message(event);

   // QDialog::mousePressEvent(event);
}

void TestMouseDlg::mouseReleaseEvent(QMouseEvent *event) {
    message(event);

//    QDialog::mouseReleaseEvent(event);
}

void TestMouseDlg::mouseMoveEvent(QMouseEvent *event) {
    // message(event);

    QDialog::mouseMoveEvent(event);
}

void TestMouseDlg::mouseDoubleClickEvent(QMouseEvent *event) {
    message(event);

//    QDialog::mouseDoubleClickEvent(event);

}

void TestMouseDlg::message(QMouseEvent *pEvent) {
    QString str;
    str.append("Type:");
    str.append(QString::number(pEvent->type()));
    str.append("; Button:");
    str.append(QString::number(pEvent->button()));
    str.append("; Button:");
    str.append(QString::number(pEvent->x()));
    str.append(" X ");
    str.append(QString::number(pEvent->y()));

    ui->listWidget->addItem(str);
}


void TestMouseDlg::on_pushButton_clicked()
{
    ui->listWidget->clear();
}

void TestMouseDlg::contextMenuEvent(QContextMenuEvent *pEvent) {
    QMessageBox::information(this, "contextmenu", "context");

    QDialog::contextMenuEvent(pEvent);
}

void TestMouseDlg::on_pushButton_2_clicked()
{
    close();
}
