#include "host.h"

Host::Host() :
    ImageGridWidget::Item(QImage(), QString::null)
{
}

Host::Host(QString name, int imageIndex, QString macAddress, QImage image ) :
    ImageGridWidget::Item(image, name)
{
    m_imageIndex = imageIndex;
    m_macAddress = macAddress;
}

Host::Host(const Host& other)
    : ImageGridWidget::Item(other)
{
    m_imageIndex = other.m_imageIndex;
    m_macAddress = other.m_macAddress;
}

void Host::registerMeataType() {
    qRegisterMetaType<Host>("Host");
    qRegisterMetaTypeStreamOperators<Host>("Host");

    qRegisterMetaType< QList<Host> >("QList<Host>");
    qRegisterMetaTypeStreamOperators< QList<Host> >("QList<Host>");
}

bool Host::getMacAddress(char address[]) {
    QRegExp hexMac("^([a-fA-F0-9]?[a-fA-F0-9]):([a-fA-F0-9]?[a-fA-F0-9]):([a-fA-F0-9]?[a-fA-F0-9]):([a-fA-F0-9]?[a-fA-F0-9]):([a-fA-F0-9]?[a-fA-F0-9]):([a-fA-F0-9]?[a-fA-F0-9])$");

    if (!hexMac.indexIn(m_macAddress)) {
        bool ok;
        for ( int c=0; c<6; c++ ) {
            address[c] = hexMac.cap(c+1).toInt(&ok, 16);
            if (!ok) return false;
        }
        return true;
    }

    return false;
}

// serialization
QT_BEGIN_NAMESPACE
QDataStream &operator<<(QDataStream &out, const Host &bookmark) {
    out << bookmark.m_macAddress;
    out << bookmark.m_imageIndex;

    // ImageGridWidget::Item
    out << bookmark.m_name;

    return out;
}
QDataStream &operator>>(QDataStream &in, Host &bookmark) {
    in >> bookmark.m_macAddress;
    in >> bookmark.m_imageIndex;

    // ImageGridWidget::Item
    in >> bookmark.m_name;

    return in;
}
QT_END_NAMESPACE
// end: serialization
