/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 *
  */

#include "utils.h"

#ifdef Q_WS_MAEMO_5
#include <QDBusInterface>
#include <QDBusConnection>
#endif

#include "EditTemplates.h"
#include "eWallet.h"
#include <Qt>
#include <QtGui>
#include <QFile>
#include <QDesktopServices>
#include <QListView>

EditTemplates::EditTemplates(QWidget *parent) : QMainWindow(parent)
{
    setWindowTitle("Wallet");

    fieldsChanged = false;

//	isFirst = true;
//	currentGroup = NULL;
//	centralWidget = NULL;
//	isShowGroups = 0;

#ifdef Q_WS_MAEMO_5
//	this->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
//	connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged(int)));
	this->setAttribute(Qt::WA_Maemo5StackedWindow);
#else
	this->setMinimumSize(WINDOW_WIDTH, WINDOW_HEIGHT);
#endif

	showList ();
	showTargets(true);
}

void EditTemplates::showList () {
	setProperty("FingerScrollable", false);

//	centralWidget = new QWidget(this);

	setContextMenuPolicy(Qt::DefaultContextMenu);
//	vboxlayout = new QVBoxLayout;
//	vboxlayout->setSpacing(0);
//	vboxlayout->setMargin(0);
	// Custom list box
	//vboxlayout->addWidget(backButton);

	fnListWidget = new QListWidget(this);
	fnListWidget->setSortingEnabled(false);
	fnListWidget->setFocusPolicy(Qt::NoFocus);
//	vboxlayout->addWidget(fnListWidget);

	QObject::connect(fnListWidget, SIGNAL(itemClicked(QListWidgetItem *)), this, SLOT(selectItem(QListWidgetItem *)));
//	QObject::connect(fnListWidget, SIGNAL(itemDoubleClicked(QListWidgetItem *)), this, SLOT(selectDItem(QListWidgetItem *)));

//	centralWidget->setLayout(vboxlayout);

	//fnListWidget->setContextMenuPolicy(Qt::DefaultContextMenu);

	createMenu ();

	////qDebug () << "setCentralWidget(centralWidget);";
	setCentralWidget(fnListWidget); //centralWidget);

	////qDebug () << "setFocus()";
	//centralWidget->setFocus ();
	//fnListWidget->setFocus ();
}

EditTemplates::~EditTemplates ()
{
	
}


void EditTemplates::showTargets(bool reset)
{
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
	//qDebug () << "show Targets " << reset;

	int current = fnListWidget->currentRow();

//#ifdef Q_WS_MAEMO_5
//	show_banner (this, tr("Loading data, please wait"));
//#endif
    //QApplication::instance()->processEvents();
	// Clean previous items from the layout
	fnListWidget->clear();

	if (reset) {
            Target * target;
            foreach(target, list) {
                    delete target;
            }
            list.clear ();
            list = ::dbManager->getTemplates();
	}

	qDebug () << "LIST " << list.size();
	for (int i = 0; i < list.size (); i++) {
		Target * target = list.at(i);

		QListWidgetItem* listitem = new QListWidgetItem(target->getName ());
		//listitem->set(target->getSummary());
		fnListWidget->addItem(listitem);
	}

	if (current >= 0 && current <= list.size ())
		fnListWidget->setCurrentRow(current);
	else
		fnListWidget->setCurrentRow(0);

	update();

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void EditTemplates::contextMenuEvent (QContextMenuEvent * event) {
	if (fnListWidget->currentRow() >= 0) {
		//Target * target = list.at(fnListWidget->currentRow());

		QMenu menu(this);
		menu.addAction(tr("Rename"), this, SLOT(renameTemplate()));
		menu.addAction(tr("Edit"), this, SLOT(editTemplate()));
		Target * target = list.at(fnListWidget->currentRow());
		if (target->id < GENERIC_TYPES_NUMBER) {

		}
		else {
			menu.addAction(tr("Delete"), this, SLOT(deleteTemplate()));
		}
		menu.exec(event->globalPos());
	}
}


void EditTemplates::createMenu()
{
//	//qDebug () << "create Menu " << isAskPassword;
//#ifdef Q_WS_MAEMO_5
	menuBar()->clear();
	menuBar()->addAction(tr("New"), this, SLOT(newTemplate()));
	menuBar()->addAction(tr("Rename"), this, SLOT(renameTemplate()));
	menuBar()->addAction(tr("Edit"), this, SLOT(editTemplate()));
	menuBar()->addAction(tr("Delete"), this, SLOT(deleteTemplate()));
//#else
//	menuBar()->clear();
//	if (isAskPassword) {
//		menuBar()->addAction(tr("Exit"), QApplication::instance(), SLOT(quit()));
//		menuBar()->addAction(tr("About"), this, SLOT(about()));
////		if (!isChangingPassword) {
////			menuBar()->addAction(tr("Delete DB"), this, SLOT(deleteDB()));
////		}
//	}
//	else {
//		QMenu * m = menuBar()->addMenu(tr("Card"));
//		m->addAction(tr("New"), this, SLOT(newTarget()));
//		if (isShowGroups == 2)
//			m->addAction(tr("Edit"), this, SLOT(_editcTarget()));
//		m->addSeparator();
//		m->addAction(tr("Invert Sort"), this, SLOT(sort()));
//		m->addSeparator();
//		m->addAction(tr("Change Password"), this, SLOT(changePassword()));
//		m->addSeparator();
//		m->addAction(tr("Import"), this, SLOT(import()));
//		m->addAction(tr("Export"), this, SLOT(exportData()));
//		m->addAction(tr("Export Xml"), this, SLOT(exportXml()));
//		m->addSeparator();
//		m->addAction(tr("Merge DB"), this, SLOT(mergeDB()));
//		m->addSeparator();
//		m->addAction(tr("Options"), this, SLOT(options()));
//		m->addSeparator();
//		menuBar()->addAction(tr("Exit"), QApplication::instance(), SLOT(quit()));
//		menuBar()->addAction(tr("About"), this, SLOT(about()));
//		//menuBar()->addAction(tr("Change View"), this, SLOT(changeMode()));
//	}
//#endif
}

void EditTemplates::renameTemplate()
{
	if (fnListWidget->currentRow() >= 0) {
		if (fnListWidget->isItemHidden(fnListWidget->item(fnListWidget->currentRow()))) return;
		Target * target = list.at(fnListWidget->currentRow());

		RenameGroupDialog * dialog = new RenameGroupDialog (this);
		dialog->setName(target->name);
		if (dialog->exec() == QDialog::Accepted) {
			QString newName = dialog->getName();

			if (newName.length() > 0) {
				target->name = newName;

				::dbManager->updateTemplate(target);

				fnListWidget->item(fnListWidget->currentRow())->setText (newName);
			}
		}
		//qDebug () << "NEW GROUP NAME " << target << " TO " << newName;

		delete dialog;
	}
}

void EditTemplates::newTemplate()
{
	RenameGroupDialog * dialog = new RenameGroupDialog (this);
	dialog->setName("");
	if (dialog->exec() == QDialog::Accepted) {
		QString newName = dialog->getName();

		if (newName.length() > 0) {
			Target * target = new Target (newName);

			::dbManager->insertTemplate(target);

			list.append(target);

			QListWidgetItem* listitem = new QListWidgetItem(target->getName ());
			//listitem->set(target->getSummary());
			fnListWidget->addItem(listitem);

			fnListWidget->setCurrentItem(listitem);
		}
	}
	//qDebug () << "NEW GROUP NAME " << target << " TO " << newName;

	delete dialog;

}

void EditTemplates::editTemplate()
{
	if (fnListWidget->currentRow() >= 0) {
		if (fnListWidget->isItemHidden(fnListWidget->item(fnListWidget->currentRow()))) return;
		Target * target = list.at(fnListWidget->currentRow());

		if (createFieldDlg.isNull()) {

			::dbManager->getTemplateFields(target);

			createFieldDlg = new CreateFieldDialog(target, this, this);
			createFieldDlg->setMinimumSize(size().width(),size().height()-100);
			if (createFieldDlg->exec()  == QDialog::Accepted) {
				::dbManager->updateTemplateFields(target);
			}
			delete createFieldDlg;
			createFieldDlg = 0;
		}

	}
}

void EditTemplates::deleteTemplate()
{
	if (fnListWidget->currentRow() >= 0) {
		if (fnListWidget->isItemHidden(fnListWidget->item(fnListWidget->currentRow()))) return;
		Target * target = list.at(fnListWidget->currentRow());

		if (target->id < GENERIC_TYPES_NUMBER) return;

		if (messageBox.isNull()) {
			messageBox = new QMessageBox(this);
			int b = messageBox->information(this, "Wallet", tr("Are you sure you want to remove it?"), QMessageBox::Yes, QMessageBox::No);
			if (b != QMessageBox::Yes) {
				delete messageBox;
				messageBox = 0;

				return;
			}
		}
		delete messageBox;
		messageBox = 0;

		if (::dbManager->deleteTemplate(target)) {
			int i = list.indexOf(target);
			//qDebug () << "DELETE ON " << i;
			//qDebug () << "trying to remove " << i;
			list.removeAt(i);

			//qDebug () << "trying to takeItem " << i;
			fnListWidget->takeItem(i); //oveItem (row);
		}
	}
}

void EditTemplates::selectItem(QListWidgetItem *) {
	renameTemplate();
}

//void EditTemplates::selectDItem(QListWidgetItem *) {
//	editTemplate();
//}
