/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#ifndef QLABELW_H
#define QLABELW_H

#include <QtGui>
#include <QDebug>
#include "DatabaseManager.h"
#include "CreateFieldDialog.h"

class QLabelW: public QLabel {
	Q_OBJECT
public:
	QLabelW(const QString &text, bool isLabel, bool isImage, bool isEdit, QWidget *parent=0, Qt::WindowFlags f=0);
	QLabelW(QWidget *parent=0, Qt::WindowFlags f=0);
	~QLabelW();

	inline bool isModified () {
		return this->modified;
	}

public slots:
	void readImage (TargetField * field);
	void labelMenu(const QPoint & _p);
	void m_copy ();
	void m_goto ();
	void m_sms ();
	void m_call ();

	void m_editImage ();
	void m_rotateImage ();
	void m_deleteImage ();
	void m_exportImage ();

	QImage * getPicture ();
	void setPicture (TargetField * field);

protected:
	bool isLabel;
    void mousePressEvent(QMouseEvent *);

    QImage * image;
    bool isImage;
    bool isEdit;
    bool modified;
	QSettings settings;

};

#endif // QLABELW_H
