/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>

 */

#include <openssl/aes.h>
#include <openssl/evp.h>
#include <openssl/sha.h>

#include "utils.h"
#include "Constants.h"
#include "DatabaseManager.h"
#include "eWallet.h"
#include <QStringList>
#include <QDir>
#include <QVariant>
#include <QBuffer>
#include <QFile>
#include <QDesktopServices>
#include <QDebug>



#define nBASE64

// ---------------------------------------------------------------------------
// Renter
// ---------------------------------------------------------------------------
Target::Target(QString n)
{
	name = n;
	groupName = "";
	type = "";
	id = 0;
	pictureSmall = NULL;
	picture = NULL;
	pictureBack = NULL;
	listLoaded = false;
}
Target::Target()
{
	name = "";
	groupName = "";
	type = "";
	id = 0;
	pictureSmall = NULL;
	picture = NULL;
	pictureBack = NULL;
	listLoaded = false;
}
Target::~Target()
{
	freeFieldList ();
	freeResources();
	if(pictureSmall) delete pictureSmall;
}

void Target::freeResources()
{
	//qDebug () << " free resources for " << this->id;
	if(picture) delete picture;
	if(pictureBack) delete pictureBack;
	picture = NULL;
	pictureBack = NULL;
}

//bool operator<(const Entry &entry, const QString &family)
//{
//    return entry.familyName < family;
//}
//
//bool operator<(const QString &family, const Entry &entry)


void Target::freeFieldList()
{
	//qDebug () << " free list for " << this->id;
	TargetField * field;
	foreach(field,this->fields) {
		delete field;
	}
	fields.clear ();
	listLoaded = false;
	fieldsContent.clear();
}

bool Target::existField (QString name) {
	TargetField * field;
	foreach(field,this->fields) {
		if (field->name == name) return true;
	}
	return false;
}

int Target::getFieldByName (QString name) {
	for (int i = 0; i < this->fields.size(); i++) {
		TargetField * field = this->fields.at(i);
		if (field->name == name) return i;
	}
	return -1;
}

QString Target::getName () {
	return name;
//	QString tmp = "<qt>%1<br>%2 %3</qt>";
//	tmp = tmp.arg(this->name).arg(this->creationdate).arg(this->modificationdate);
////	//return this->type;
//	return tmp;
}

QString Target::getSummary () {
//	QString tmp;
//	tmp << this->type << " " << this->creationdate << " " << this->modificationdate;

	return this->type;
//	return tmp;
}
QImage * Target::getPictureSmall () {
	////qDebug () << "getPictureSmall " << this->id << " " << pictureSmall;
	if(!pictureSmall) {
		QImage * orig = getPicture();

		if (orig) {
			pictureSmall = new QImage (orig->scaled (SMALL_WIDTH, SMALL_HEIGH));
		}
		else
			pictureSmall = NULL;

	}
	return pictureSmall;
}
QImage * Target::getPicture () {
	return getPicture (::dbManager);
}
QImage * Target::getPictureBack () {
	return getPictureBack (::dbManager);
}
QImage * Target::getPicture (DatabaseManager * mgr) {
	if(!picture) {
		picture = mgr->getPicture (this);
	}
	return picture;
}
QImage * Target::getPictureBack (DatabaseManager * mgr) {
	if(!pictureBack) {
		pictureBack = mgr->getPictureBack (this);
	}
	return pictureBack;
}
/*void Target::setPictureSmall (QImage * a) {
	if(pictureSmall) delete pictureSmall;
	pictureSmall = a;
}*/
void Target::setPicture (QImage * a) {
	if(picture) delete picture;
	picture = a;
	if(pictureSmall) delete pictureSmall;
	pictureSmall = NULL;
}
void Target::setPictureBack (QImage * a) {
	if(pictureBack) delete pictureBack;
	pictureBack = a;
}

TargetField::~TargetField()
{
}
// ---------------------------------------------------------------------------
// DatabaseManager
// ---------------------------------------------------------------------------
DatabaseManager::DatabaseManager(QObject *parent): QObject(parent)
{
	opendb = false;
	initdb = false;
}

DatabaseManager::~DatabaseManager()
{
	qDebug () << "CLOSE DB " << connectionName;
	if (connectionName.length() > 0)
		db.removeDatabase(connectionName);
//	else
//		db.removeDatabase();

	qDebug () << "CLOSED DB " << connectionName;

	if (db.isOpen()) {
		qDebug () << "CLOSing DB " << connectionName;
		db.close();
	}

	qDebug () << "~DatabaseManager " << connectionName;
}

bool DatabaseManager::close()
{
	if (db.isOpen()) {
		qDebug () << "CLOSing DB " << connectionName;
		db.close();
	}

	opendb = false;
	return true;
}


bool DatabaseManager::isInit()
{
	//qDebug () << "is init?";
	return db.tables().count() >= 3;
}

void DatabaseManager::reset () {
	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		ret |= query.exec("drop table id");
		ret |= query.exec("drop table targets");
		ret |= query.exec("drop table fields");
		ret |= query.exec("drop table softwareVersion");
		ret |= query.exec("drop table fieldsDef");
		ret |= query.exec("drop table targetsDef");
	}

}

bool DatabaseManager::initDB()
{
	//qDebug () << "INIT DB " << connectionName;
	bool ret = true;

	// Create tables
	if (createIdTable()) {
		createTargetTable();
		createTargetFieldTable();
		createTableVersion ();
		createFieldDefinitionTable();
		createTemplateDefinitionTable();

		emit createDatabase();

		ret = addVersion (SOFT_VERSION);
	}
	currentVersion = getVersion ();

	// Check that tables exists
	if (db.tables().count() != 6)
		ret = false;

	return ret;
}

bool DatabaseManager::migrateVersion (int fromV, int toV, const QString & pas) {
	bool ret = true;

	qDebug () << "MIGRATING DB VERSION FROM " << fromV << " TO " << toV;

	if (fromV == 0 && toV == 1) {
		if (backupDB ("BACK")) {
			QSqlQuery query(db);
			ret = query.exec("alter table targets ADD COLUMN groupName varchar(100)");
		}
		else
			ret = false;
	}

	if (fromV == 1 && toV == 2) {
		if (backupDB ("BACK")) {
			if (createPassword(pas, 2)) {
				if (!addVersion(2)) {
					ret = false;
				}
			}
			else
				ret = false;
		}
		else
			ret = false;
	}

	if (fromV == 2 && toV == 3) {
		if (backupDB ("BACK")) {
			QSqlQuery query(db);
			qDebug () << "query 0 " << ret;
			ret &= query.exec("alter table targets ADD COLUMN creationdate varchar(24)");
			qDebug () << "query 1 " << ret << " " << query.lastError();
			ret &= query.exec("alter table targets ADD COLUMN modificationdate varchar(24)");
			qDebug () << "query 2 " << ret << " " << query.lastError();

			ret &= query.exec("update targets set creationdate = CURRENT_TIMESTAMP, modificationdate = CURRENT_TIMESTAMP");
			qDebug () << "query 3 " << ret << " " << query.lastError();

			if (ret && !addVersion(3)) {
				ret = false;
			}
		}
		else
			ret = false;
	}

	if (fromV == 3 && toV == 4) {
		if (backupDB ("BACK")) {
			QSqlQuery query(db);
			qDebug () << "adding fieldsContent " << db.lastError() << " " << ret;
			ret = query.exec("ALTER TABLE targets ADD COLUMN fieldsContent BLOB");
			qDebug () << "adding field definition " << db.lastError() << " " << ret;
			ret &= createFieldDefinitionTable();
			qDebug () << "adding template definition " << db.lastError() << " " << ret;
			ret &= createTemplateDefinitionTable();
			qDebug () << "migrating " << db.lastError() << " " << ret;
			ret &= migrateTo4 ();

			if (ret && !addVersion(4)) {
				ret = false;
			}
		}
		else
			ret = false;
	}

	emit migrateDatabase(fromV, toV);

	qDebug () << "MIGRATED DB VERSION FROM " << fromV << " TO " << toV << " WITH RESULT " << ret;

	return ret;
}

bool DatabaseManager::deleteDB(const QString & prefix)
{
	//qDebug () << "REMOVE DB " << connectionName;
	db.close();

	QString path(QDir::home().path());
	//path.append(QDir::separator()).append(FOLDER);
	path.append(QDir::separator()).append(QDir::separator()).append(prefix).append("qtwallet.db.sqlite");
	path = QDir::toNativeSeparators(path);

	return QFile::remove(path);
}
bool DatabaseManager::backupDB(const QString & prefix) {
	QString path(QDir::home().path());
	//path.append(QDir::separator()).append(FOLDER);
	path.append(QDir::separator()).append("qtwallet.db.sqlite");
	path = QDir::toNativeSeparators(path);

	QString pathBack(QDir::home().path());
	//pathBack.append(QDir::separator()).append(FOLDER);
	pathBack.append(QDir::separator()).append(prefix).append("qtwallet.db.sqlite");
	pathBack = QDir::toNativeSeparators(pathBack);

	bool dup = true;

	QFile fileBack (pathBack);
	if (fileBack.exists())
		dup = fileBack.remove();

	if (dup) {
		QFile file (path);
		dup = file.copy(pathBack);
	}

	qDebug () << "duplicate " << prefix << " DB " << dup;

	return dup;
}
bool DatabaseManager::restoreDB(const QString & prefix) {
	QString path(QDir::home().path());
	//path.append(QDir::separator()).append(FOLDER);
	path.append(QDir::separator()).append("qtwallet.db.sqlite");
	path = QDir::toNativeSeparators(path);

	QString pathBack(QDir::home().path());
	//pathBack.append(QDir::separator()).append(FOLDER);
	pathBack.append(QDir::separator()).append(prefix).append("qtwallet.db.sqlite");
	pathBack = QDir::toNativeSeparators(pathBack);

	bool dup = true;

	QFile file (path);
	if (file.exists())
		dup = file.remove();

	if (dup) {
		QFile fileBack (pathBack);
		dup = fileBack.copy(path);
	}

	//qDebug () << "restore " << prefix << " DB " << dup;

	return dup;
}
//bool DatabaseManager::openDB()
//{
//	return _openDB ("qtwallet.db.sqlite");
//}

bool DatabaseManager::_mergeDB (DatabaseManager * mergeDB) {
    QList<Target*>  listMerge = mergeDB->getTargets(NULL);
    QList<Target*>  list = getTargets(NULL);

    int maxOrig = 0;
    for (int i = 0; i < list.size (); i++) {
        Target * target = list[i];
        if (target->id > maxOrig)
            maxOrig = target->id;
    }

    qDebug () << "max orig is " << maxOrig;

    int maxMerg = 0;
    for (int j = 0; j < listMerge.size (); j++) {
        Target * targetMerge = listMerge[j];
        if (targetMerge->id > maxMerg)
            maxMerg = targetMerge->id;
    }

    qDebug () << "max merg is " << maxMerg;

    // TODO check remaining elements on listMerge
    bool res;

    for (int i = 0; i < list.size (); i++) {
        Target * target = list[i];

        qDebug () << "Checking[" << i << "] " << target->id;
        int j = 0;
        for (; j < listMerge.size (); j++) {
            Target * targetMerge = listMerge[j];
            qDebug () << "Looking for[" << j << "] " << targetMerge->id;
            if (targetMerge->id == target->id) {

                qDebug () << "Checking changes with[" << j << "]";

                if (targetMerge->creationdate != target->creationdate) {
                    qDebug () << "Attention different creation time[" << j << "]";

                    int idTargetMerge = targetMerge->id;
                    int idTarget= target->id;

                    if (maxOrig >= maxMerg) {
                        mergeDB->getFields(targetMerge);
                        targetMerge->getPicture(mergeDB);
                        targetMerge->getPictureBack(mergeDB);
                        res = this->insertTarget(targetMerge);
                        this->updateFields(targetMerge);

                        qDebug () << "New target on this [" << targetMerge->id << "]";

                        res = mergeDB->copyTarget(targetMerge);
                        //mergeDB->updateFields(targetMerge);

                        qDebug () << "New target on merged [" << targetMerge->id << "]";

                        this->getFields(target);
                        target->getPicture(this);
                        target->getPictureBack(this);
                        res = mergeDB->insertTarget(target);
                        mergeDB->updateFields(target);

                        qDebug () << "New target on merged [" << target->id << "]";

                        res = this->copyTarget(target);
                        //this->updateFields(target);

                        qDebug () << "New target on this [" << target->id << "]";
                    }
                    else {
                        this->getFields(target);
                        target->getPicture(this);
                        target->getPictureBack(this);
                        res = mergeDB->insertTarget(target);
                        mergeDB->updateFields(target);

                        qDebug () << "New target on merged [" << target->id << "]";

                        res = this->copyTarget(target);
                        //this->updateFields(target);

                        qDebug () << "New target on this [" << target->id << "]";

                        mergeDB->getFields(targetMerge);
                        targetMerge->getPicture(mergeDB);
                        targetMerge->getPictureBack(mergeDB);
                        res = this->insertTarget(targetMerge);
                        this->updateFields(targetMerge);

                        qDebug () << "New target on this [" << targetMerge->id << "]";

                        res = mergeDB->copyTarget(targetMerge);
                        //mergeDB->updateFields(targetMerge);

                        qDebug () << "New target on merged [" << targetMerge->id << "]";
                    }
                    mergeDB->_deleteTarget (idTargetMerge);
                    this->_deleteTarget (idTarget);

                    target->freeFieldList();
                    target->freeResources();

                    targetMerge->freeFieldList();
                    targetMerge->freeResources();

                    break;
                }

                if (targetMerge->modificationdate < target->modificationdate) {
                    qDebug () << "MOVE << [" << j << "]";

                    targetMerge->name = target->name;
                    targetMerge->groupName = target->groupName;
                    targetMerge->setPicture(target->getPicture(this));
                    targetMerge->setPictureBack(target->getPictureBack(this));
                    //??targetMerge->creationdate = target->creationdate;
                    targetMerge->modificationdate = target->modificationdate;

                    // TODO merge fields?????
                    // Load fields from this into targetMerge
                    this->getFields(targetMerge);

                    mergeDB->updateTarget(targetMerge);
                    mergeDB->updateTargetPicture(targetMerge);
                    mergeDB->updateTargetPictureBack(targetMerge);
                    mergeDB->updateFields(targetMerge);

                }
                else
                if (targetMerge->modificationdate > target->modificationdate) {
                    qDebug () << "MOVE >> [" << j << "]";

                    // TODO is required to duplicate images and strings
                    target->name = targetMerge->name;
                    target->groupName = targetMerge->groupName;
                    target->setPicture(targetMerge->getPicture(mergeDB));
                    target->setPictureBack(targetMerge->getPictureBack(mergeDB));
                    //??target->creationdate = targetMerge->creationdate;
                    target->modificationdate = targetMerge->modificationdate;

                    // TODO merge fields?????
                    // Load fields from mergeDB into target
                    mergeDB->getFields(target);

                    this->updateTarget(target);
                    this->updateTargetPicture(target);
                    this->updateTargetPictureBack(target);
                    this->updateFields(target);
                }
                else {
                    qDebug () << "SAME TIME[" << j << "]";
                }

                target->freeFieldList();
                target->freeResources();

                targetMerge->freeFieldList();
                targetMerge->freeResources();
                break;
            }
        }
        if (j > listMerge.size ()) {
            // NOT FOUND

            this->getFields(target);
            target->getPicture(this);
            target->getPictureBack(this);
            res = mergeDB->copyTarget(target);
            //mergeDB->updateFields(target);

            qDebug () << "New target on merged [" << target->id << "]";

            target->freeFieldList();
            target->freeResources();
        }
        else {
            Target * targetMerge = listMerge[j];
            listMerge.removeAt(j);
            delete targetMerge;

            qDebug () << "remaining " << listMerge.size () << " elements on merge list";
        }
    }

    int j = 0;
    for (; j < listMerge.size (); j++) {
        Target * targetMerge = listMerge[j];

        mergeDB->getFields(targetMerge);
        targetMerge->getPicture(mergeDB);
        targetMerge->getPictureBack(mergeDB);
        res = this->copyTarget(targetMerge);
        //this->updateFields(targetMerge);

        qDebug () << "New target on this [" << targetMerge->id << "]";

        targetMerge->freeFieldList();
        targetMerge->freeResources();
    }

    Target * target;
    foreach(target, list) {
            delete target;
    }
    foreach(target, listMerge) {
            delete target;
    }
    // TODO should I delete objects on list???
    listMerge.clear();
    list.clear();

	// TODO copy templates

    return true;
}


bool DatabaseManager::migrationFrom (DatabaseManager * mgr) {
	bool res;

    QList<Target *> list = mgr->getFullTargets();
	for (int i = 0; i < list.size (); i++) {
		Target * target = list[i];

		target->getPicture(mgr);
		target->getPictureBack(mgr);
		res = copyTarget(target);

		//qDebug () << "MIGRATING 1 " << target->name << res << " " << target->id;
		if (!res) return false;

//		if (target->getPicture(mgr) != NULL) {
//			res = updateTargetPicture (target);
//			//qDebug () << "MIGRATING 2 " << target->name << res;
//			if (!res) return false;
//		}
//
//		if (target->getPictureBack(mgr) != NULL) {
//			res = updateTargetPictureBack (target);
//			//qDebug () << "MIGRATING 3 " << target->name << res;
//			if (!res) return false;
//		}

		//res = updateFields (target);
		//qDebug () << "MIGRATING 4 " << target->name << res;
		if (!res) return false;

		target->freeFieldList();
		target->freeResources();


	}

	QList<Target *> typesTmp = mgr->getTemplates();

	for (int i = 0; i < typesTmp.size(); i++) {
		Target * t = typesTmp.at(i);
		mgr->getTemplateFields(t);
		qDebug () << "copying type " << t->name;

		res = insertTemplate(t);
		res &= updateTemplateFields(t);
		if (!res) return false;

		delete t;
	}

	typesTmp.clear();

	return res;
}

bool DatabaseManager::_openFileDB(const QString & name, const QString & cName) {
        qDebug () << "OPEN DB " << name << "(" << cName << ")";

        connectionName = cName;

        // Find QSLite driver
        if (connectionName.length() > 0)
                db = QSqlDatabase::addDatabase("QSQLITE", connectionName);
        else
                db = QSqlDatabase::addDatabase("QSQLITE");

        db.setDatabaseName(name);

        if (db.open()) {
                return true;
        }
        return false;
}

bool DatabaseManager::_openDB(const QString & name, const QString & cName) {
        qDebug () << "OPEN DB " << name << "(" << cName << ")";

	connectionName = cName;

	// Find QSLite driver
	if (connectionName.length() > 0)
		db = QSqlDatabase::addDatabase("QSQLITE", connectionName);
	else
		db = QSqlDatabase::addDatabase("QSQLITE");
	// http://doc.trolltech.com/4.5/sql-driver.html#qsqlite
	QString path(QDir::home().path());
	//path.append(QDir::separator()).append(FOLDER);
	path.append(QDir::separator()).append(name);
	path = QDir::toNativeSeparators(path);

	db.setDatabaseName(path);

	if (db.open()) {
		return true;
	}
	return false;
}

QSqlError DatabaseManager::lastError()
{
	return db.lastError();
}

int DatabaseManager::getVersion() {
	if (db.isOpen()) {
		QSqlQuery query (db);
		bool ret = query.exec("select max(versionNumber) from softwareVersion");
		if (ret) {
			if (query.next()) {
				return query.value(0).toInt();
			}
		}
	}
	return -1;
}
bool DatabaseManager::addVersion(int v) {
	qDebug () << "add new version " << v;

	QSqlQuery query (db);
	bool ret = query.prepare("insert into softwareVersion values (:ver)");
	if (ret) {
		query.bindValue(":ver", v);
		ret = query.exec();
	}
	return ret;
}

int DatabaseManager::nextId()
{
	int ret = -1;
	if (db.isOpen()) {
		QSqlQuery query("select id from id", db);
		if (query.next()) {
			// Get last used id
			ret = query.value(0).toInt();
			// Increase that
			ret++;
			// Store new value
			query.exec(QString("update id set id=%1 where id=%2").arg(ret).arg(ret - 1));
		} else {
			// Set first id to zero
			if (!query.exec("insert into id values(1, NULL)"))
				return -1;
			else
				ret = 1;
		}
	}

	return ret;
}

QString DatabaseManager::mergeDB (const QString & dbToMerge, const QString & passwordToMerge) {
    bool ret = false;

    QString result = "";

    ret = backupDB("BACK"); // TODO remove

    if (ret) {
        DatabaseManager * mergeDB = new DatabaseManager();
        ret = mergeDB->backupDB("BACKMERGE"); // TODO remove

        ret = mergeDB->_openFileDB(dbToMerge, "MERGE");
        if (ret) {
            int currentVersionToMerge =  mergeDB->getVersion ();
            if (currentVersionToMerge != SOFT_VERSION) {
                qDebug () << "INVALID VERSION " << currentVersionToMerge;
            }
            else {
                if (hasSecretPhrase()) {
                    if (mergeDB->checkPassword(passwordToMerge, SOFT_VERSION)) {
                        ret = _mergeDB (mergeDB);
                    }
                    else {
                        qDebug () << "INVALID PASSWORD";
                    }
                }
                else {
                    qDebug () << "NOT INIT DATABASE";
                }
            }

        }

        delete mergeDB;
    }

    return "";
}

QString DatabaseManager::changePassword (const QString & newPassword) {
	bool ret = false;

	QString result = "";

	ret = backupDB("BACK");

	if (ret) {
		DatabaseManager * oldDB = new DatabaseManager();
		ret = oldDB->_openDB("NEWqtwallet.db.sqlite", "NEW");
		if (ret) {
			oldDB->reset ();
			ret = oldDB->initDB();
			if (ret){
				ret = oldDB->createPassword(newPassword, oldDB->currentVersion);
				if (ret) {
					if (oldDB->migrationFrom(this)) {
						//qDebug () << "succesfull migrated ";
						close ();
						oldDB->close();

						ret = oldDB->restoreDB ("NEW");
						if (ret) {
							//qDebug () << "succesfull changed ";

						}
						else {
							result = "DB cannot be restored";
						}

					}
					else
						result = "NEWqtwallet.db.sqlite cannot be migrated";
				}
				else
					result = "NEWqtwallet.db.sqlite cannot be init";
			}
			else
				result = "NEWqtwallet.db.sqlite cannot be reset";

			oldDB->deleteDB("NEW");
		}
		else
			result = "NEWqtwallet.db.sqlite cannot be opened";
		delete oldDB;
	}

	return result;
}


void DatabaseManager::lock () {
	initdb = false;
}

bool DatabaseManager::hasPassword() {
	if (!opendb)
		opendb = _openDB("qtwallet.db.sqlite");

	return opendb && isInit () && hasSecretPhrase();
}

bool DatabaseManager::openDB(const QString & pas) {
	initdb = false;

	qDebug() << "open db with pas " << SOFT_VERSION;

	if (!opendb)
		opendb = _openDB("qtwallet.db.sqlite");

	if (!opendb) return false;

	//qDebug() << "init db with pas";

	if (db.tables().count() == 0) {
		if (initDB())
			initdb = createPassword(pas, SOFT_VERSION);
		currentVersion = SOFT_VERSION;
	}
	else {
		bool res = false;
		bool initWas = false;
		// Check that tables exists
		if (db.tables().count() == 3) {
#ifdef Q_WS_MAEMO_5
			show_banner(NULL, tr("Migrating database from version %1, please wait").arg(0));
#endif
			res = migrateVersion (0, 1, pas);
			if (res)
				res = createTableVersion ();
			if (res)
				res = addVersion (1);
			currentVersion = 1;
		}

		qDebug() << "init db with pas taules "<< db.tables().count();

//		if (db.tables().count() != 4) {
//			initdb = false;
//			currentVersion = SOFT_VERSION;
//		}
//		else {
			currentVersion = getVersion ();

			if (currentVersion >= 3) {
				if (hasSecretPhrase()) {
					initdb = checkPassword(pas, currentVersion);
				}
				else {
					initdb = createPassword(pas, currentVersion);
				}

				initWas = true;

				if (!initdb) {
					return false;
				}
			}


			if (currentVersion < SOFT_VERSION) {
				do {
#ifdef Q_WS_MAEMO_5
			show_banner(NULL, tr("Migrating database from version %1, please wait").arg(currentVersion));
#endif
					res = migrateVersion (currentVersion, currentVersion + 1, pas);
					if (res)
						currentVersion =  getVersion ();

					if ((!initWas) && currentVersion >= 3) {
						if (hasSecretPhrase()) {
							initdb = checkPassword(pas, currentVersion);
						}
						else {
							initdb = createPassword(pas, currentVersion);
						}

						initWas = true;

						if (!initdb) {
							return false;
						}
					}

				}
				while (res && currentVersion < SOFT_VERSION);
			}
			else
				res = true;

			if (currentVersion != SOFT_VERSION || !res) {
				// TODO show an error!!!
#ifdef Q_WS_MAEMO_5
		show_information_note (NULL, tr("Migration not possible, stop at version %1").arg(currentVersion));
#endif
				qDebug () << "MIGRATION NOT POSSIBLE " << currentVersion << " to " << SOFT_VERSION;
				return false;
			}

			if ((!initWas) && currentVersion < 3) {
				if (hasSecretPhrase()) {
					initdb = checkPassword(pas, currentVersion);
				}
				else {
					initdb = createPassword(pas, currentVersion);
				}
			}
//		}
	}

	//qDebug() << "init db with pas " << initdb << " " << currentVersion;

	return initdb;
}

bool DatabaseManager::isReady () {
	return opendb && initdb;
}

bool DatabaseManager::createIdTable()
{
	// Create table
	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		ret = query.exec("create table id (id integer primary key, phrase varchar(20))");
	}
	return ret;
}

bool DatabaseManager::createTableVersion()
{
	// Create table
	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		ret = query.exec("create table softwareVersion (versionNumber integer)");
	}
	return ret;
}

bool DatabaseManager::createTargetTable()
{
	// Create table
	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		ret = query.exec("create table targets "
		                 "(id integer primary key, " // this is autoincrement field http://www.sqlite.org/autoinc.html
		                 "name varchar(30), "
		                 "picture BLOB, "
		                 "pictureBack BLOB, "
						 "fieldsContent BLOB, "
		                 "type varchar(5), "
		                 "groupName varchar(100), "
		                 "creationdate varchar(24), "
		                 "modificationdate varchar(24))");

	}
	return ret;
}

bool DatabaseManager::createTargetFieldTable()
{
	// Create table
	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		ret = query.exec("create table fields "
		                 "(id integer primary key, " // this is autoincrement field http://www.sqlite.org/autoinc.html
		                 "targetId integer, "
		                 "orderN integer, "
		                 "encrypted integer, "
		                 "name varchar(30), "
		                 "value varchar(30), "
		                 "type integer)");

	}
	return ret;
}

bool DatabaseManager::createTemplateDefinitionTable()
{
	// Create table
	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		ret = query.exec("create table targetsDef "
		                 "(id integer primary key, " // this is autoincrement field http://www.sqlite.org/autoinc.html
		                 "name varchar(30), "
//		                 "picture BLOB, "
//		                 "pictureBack BLOB, "
//		                 "type varchar(5), "
//		                 "groupName varchar(100), "
		                 "creationdate varchar(24), "
		                 "modificationdate varchar(24))");
	}
	return ret;
}

bool DatabaseManager::createFieldDefinitionTable()
{
	// Create table
	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		ret = query.exec("create table fieldsDef "
		                 "(id integer primary key, " // this is autoincrement field http://www.sqlite.org/autoinc.html
		                 "targetId integer, "
		                 "orderN integer, "
		                 "encrypted integer, "
		                 "name varchar(30), "
		                 "type integer)");

		ret &= query.exec("create index fieldsDef_idx on fieldsDef (targetId)");
		//qDebug () << " 1 " << ret << " " << db.lastError();
		ret &= query.exec("create index fields_idx on fields (targetId)");
		//qDebug () << " 2 " << ret << " " << db.lastError();

	}
	return ret;
}

//void DatabaseManager::getDefinitions(QList<Target*> * types, QList<QList<TargetField*>*> * fieldsByType) {
//	QSqlQuery query (db);
//	bool ret;
//
//	qDebug () << "getDefinitions";
//
//	ret = query.prepare("select t.id, t.name, f.id, f.orderN, f.encrypted, f.name, f.type from targetsDef t, fieldsDef f where t.id = f.targetId order by t.name, f.orderN");
//	ret &= query.exec ();
//
//	int previous = -1;
//	while (query.next()) {
//		int i = query.value(0).toInt();
//		if (i != previous) {
//			Target * t = new Target (query.value(1).toString());
//			t->id = i;
//			types->append(t);
//			fieldsByType->append (new QList<TargetField*>);
//			previous = i;
//
//			qDebug () << "getDefinitions " << t->name;
//		}
//
//		fieldsByType->at(types->length() - 1)->append(new TargetField(query.value(5).toString(),query.value(6).toInt(), query.value(4).toBool(), query.value(3).toInt(), query.value(2).toString()));
//	}
//
//}

bool DatabaseManager::insertTemplate(Target* target)
{
	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		if (target->id <= 0) {
			ret = query.prepare("INSERT INTO targetsDef (name, creationdate, modificationdate) VALUES (:name, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)");

			if (ret) {
				query.bindValue(":name", target->name);
				ret = query.exec();
			}
			if (ret) {
				target->id = query.lastInsertId().toInt();
			}
		}
		else {
			ret = query.prepare("INSERT INTO targetsDef (id, name, creationdate, modificationdate) VALUES (:id, :name, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)");

			if (ret) {
				query.bindValue(":id", target->id);
				query.bindValue(":name", target->name);
				ret = query.exec();
			}
		}
	}
	return ret;
}

bool DatabaseManager::updateTemplateFields(Target* target)
{
	bool ret = false;
	if (db.isOpen()) {

		QSqlQuery query (db);
		//qDebug () << "delete";
		ret = query.prepare("delete from fieldsDef where targetId=:code");
		query.bindValue(":code", target->id);
		ret = query.exec();
		//qDebug () << "deleted";

		if (ret) {
			for (int i = 0; i < target->fields.count(); i++) {
				TargetField * field = target->fields[i];

				//qDebug () << "insert";
				field->targetId = target->id;
				//field->id = 0; //i + 1;
				ret &= insertTemplateField (field);
				//qDebug () << "inserted";
			}
		}
	}

	return ret;
}

bool DatabaseManager::insertTemplateField(TargetField* field)
{
	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		if (field->id <= 0) {
			ret = query.prepare("INSERT INTO fieldsDef (targetId, name, type, orderN, encrypted) "
								"VALUES (:targetId, :name, :type, :order, :encrypted)");
			if (ret) {
				query.bindValue(":targetId", field->targetId);
				query.bindValue(":name", field->name);
				query.bindValue(":type", field->type);
				query.bindValue(":order", field->order);
				query.bindValue(":encrypted", field->encrypted ? 1 : 0);
				ret = query.exec();
			}

			if (ret) {
				field->id = query.lastInsertId().toInt();
			}
		}
		else {
			ret = query.prepare("INSERT INTO fieldsDef (id, targetId, name, type, orderN, encrypted) "
								"VALUES (:id, :targetId, :name, :type, :order, :encrypted)");
			if (ret) {
				query.bindValue(":id", field->id);
				query.bindValue(":targetId", field->targetId);
				query.bindValue(":name", field->name);
				query.bindValue(":type", field->type);
				query.bindValue(":order", field->order);
				query.bindValue(":encrypted", field->encrypted ? 1 : 0);
				ret = query.exec();
			}

		}
	}
	return ret;
}

bool DatabaseManager::copyTemplateFields(Target* target)
{
	bool ret = true;
	for (int i = 0; i < target->fields.count(); i++) {
		TargetField * field = target->fields[i];
		ret &= copyTemplateField (field);
	}

	return ret;
}

bool DatabaseManager::copyTemplateField(TargetField* field)
{
	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		ret = query.prepare("INSERT INTO fieldsDef (id, targetId, name, type, orderN, encrypted) "
		                    "VALUES (:id, :targetId, :name, :type, :order, :encrypted)");
		if (ret) {
			query.bindValue(":id", field->id);
			query.bindValue(":targetId", field->targetId);
			query.bindValue(":name", field->name);
			query.bindValue(":type", field->type);
			query.bindValue(":order", field->order);
			query.bindValue(":encrypted", field->encrypted ? 1 : 0);
			ret = query.exec();
		}

	}
	return ret;
}

bool DatabaseManager::copyTemplate(Target* target)
{
	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		ret = query.prepare("INSERT INTO targetsDef (id, name, creationdate, modificationdate) VALUES (:id, :name, :creationdate, :modificationdate)");
		QByteArray t1;

		if (ret) {
			query.bindValue(":id", target->id);
			query.bindValue(":name", target->name);
			query.bindValue(":creationdate", target->creationdate);
			query.bindValue(":modificationdate", target->modificationdate);
			ret = query.exec();
		}
	}
	return ret;
}

QList<Target*> DatabaseManager::getTemplates()
{
	QList<Target*> result;

	QSqlQuery query (db);
	bool ret;

	ret = query.prepare("select id, name, creationdate, modificationdate from targetsDef order by lower(name)");

	//qDebug () << " 1 " << ret;
	ret &= query.exec ();
	//qDebug () << " 2 " << ret;

	while (query.next()) {
		Target * item = new Target();
		item->id = query.value(0).toInt();
		item->name = query.value(1).toString();
		item->creationdate = query.value(2).toString();
		item->modificationdate = query.value(3).toString();
		result.append(item);
	}

	return result;
}

void DatabaseManager::getTemplateFields(Target * target)
{
	if (target->listLoaded) return;

	//qDebug () << " loading fields for template " << target->id << " " << target->name;
	bool ret = false;
	QSqlQuery query (db);
	ret = query.prepare("select id, name, type, targetId, orderN, encrypted from fieldsDef where targetId=:targetId order by orderN");
	query.bindValue(":targetId", target->id);
	ret &= query.exec ();
	while (query.next()) {
		TargetField* item = new TargetField();
		item->id = query.value(0).toInt();
		item->name = query.value(1).toString();
		item->type= query.value(2).toInt();
		item->targetId = query.value(3).toInt ();
		item->order = query.value(4).toInt ();
		item->encrypted = query.value(5).toInt () != 0;
		target->fields.append(item);
	}

	target->listLoaded = true;
	//qDebug () << " loaded fields (" << target->fields.size() << ") for template " << target->id << " " << target->name;
}

bool DatabaseManager::deleteTemplate(Target * target)
{
    return _deleteTemplate (target->id);
}

bool DatabaseManager::_deleteTemplate(int idTarget)
{
    bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);

		ret = query.prepare("delete from fieldsDef where targetId=:code");
        query.bindValue(":code", idTarget);
		ret = query.exec();

		if (ret) {
			ret = query.prepare("delete from targetsDef where id=:code");
			if (ret) {
                query.bindValue(":code", idTarget);
				ret = query.exec();
			}
		}
	}

	return ret;
}

bool DatabaseManager::updateTemplate(Target* target)
{
	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		ret = query.prepare("UPDATE targetsDef set name=:name, modificationdate=CURRENT_TIMESTAMP where id=:code");
		QByteArray t1;
		if (ret) {
			query.bindValue(":name", target->name);
			query.bindValue(":code", target->id);
			ret = query.exec();
		}
	}
	return ret;
}


bool DatabaseManager::insertTarget(Target* target)
{
		//qDebug() << "step 0" ;
	bool ret = false;
	if (db.isOpen()) {
		//target->id = nextId(); // We demostrates autoincrement in this case

		// http://www.sqlite.org/autoinc.html
		// NULL = is the keyword for the autoincrement to generate next value
		QSqlQuery query (db);
		ret = query.prepare("INSERT INTO targets (name, type, picture, pictureBack, groupName, creationdate, modificationdate) VALUES (:name, :type, :picture, :pictureBack, :groupName, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)");
		QByteArray t1;

		//qDebug() << "step 1" ;
		if (ret) {
		//qDebug() << "step 2" ;
			encrypt(target->name, t1);
		//qDebug() << "step 3" ;
			query.bindValue(":name", t1);
			query.bindValue(":type", target->type);
			query.bindValue(":groupName", target->groupName);
					//qDebug() << "step 4" ;

			QByteArray im1;
			QBuffer buffer1(&im1);
			QByteArray im_r1;
			QByteArray im2;
			QBuffer buffer2(&im2);
			QByteArray im_r2;
		//qDebug() << "step 5" ;

			if (target->picture != NULL) {
				//eWallet::preProcessImage (*target->picture);

				buffer1.open(QIODevice::WriteOnly);
				target->picture->save(&buffer1, "PNG"); // writes image into ba in PNG format

				encrypt(im1, im_r1);
				query.bindValue(":picture", im_r1);
			} else
				query.bindValue(":picture", QVariant (QVariant::ByteArray));
		//qDebug() << "step 6" ;

			if (target->pictureBack != NULL) {
				//eWallet::preProcessImage (*target->pictureBack);

				buffer2.open(QIODevice::WriteOnly);
				target->pictureBack->save(&buffer2, "PNG"); // writes image into ba in PNG format

				QByteArray im_r2;
				encrypt(im2, im_r2);
				query.bindValue(":pictureBack", im_r2);
			} else
				query.bindValue(":pictureBack", QVariant (QVariant::ByteArray));
						//qDebug() << "step 7" ;

			ret = query.exec();
		}
		// Get database given autoincrement value
		if (ret) {
			// http://www.sqlite.org/c3ref/last_insert_rowid.html
			target->id = query.lastInsertId().toInt();
			//qDebug () << "INSERT " << target->id;

		}
	}
	return ret;
}

bool DatabaseManager::copyTarget(Target* target)
{
		//qDebug() << "step 0" ;

	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		ret = query.prepare("INSERT INTO targets (id, name, type, picture, pictureBack, groupName, creationdate, modificationdate, fieldsContent) VALUES (:id, :name, :type, :picture, :pictureBack, :groupName, :creationdate, :modificationdate, :fieldsContent)");
		QByteArray t1;
		QByteArray t2;

		if (ret) {
			encrypt(target->name, t1);
			encrypt(target->fieldsContent, t2);
			query.bindValue(":id", target->id);
			query.bindValue(":name", t1);
			query.bindValue(":type", target->type);
			query.bindValue(":groupName", target->groupName);
			query.bindValue(":creationdate", target->creationdate);
			query.bindValue(":modificationdate", target->modificationdate);
			query.bindValue(":fieldsContent", t2);

			QByteArray im1;
			QBuffer buffer1(&im1);
			QByteArray im_r1;
			QByteArray im2;
			QBuffer buffer2(&im2);
			QByteArray im_r2;

			if (target->picture != NULL) {
				buffer1.open(QIODevice::WriteOnly);
				target->picture->save(&buffer1, "PNG"); // writes image into ba in PNG format

				encrypt(im1, im_r1);
				query.bindValue(":picture", im_r1);
			} else
				query.bindValue(":picture", QVariant (QVariant::ByteArray));

			if (target->pictureBack != NULL) {
				buffer2.open(QIODevice::WriteOnly);
				target->pictureBack->save(&buffer2, "PNG"); // writes image into ba in PNG format

				QByteArray im_r2;
				encrypt(im2, im_r2);
				query.bindValue(":pictureBack", im_r2);
			} else
				query.bindValue(":pictureBack", QVariant (QVariant::ByteArray));
						//qDebug() << "step 7" ;

			ret = query.exec();
		}
	}
	return ret;
}

QList<Target*> DatabaseManager::getTargets(const QString * filter)
{
	if (filter != NULL)
		qDebug () << "getting targets with filter " << filter;
	else
		qDebug () << "getting targets";

	QList<Target*> result;

	QSqlQuery query (db);
	bool ret;
	if (filter != NULL) {// && filter.length() > 0) {
		ret = query.prepare("select id, name, type, groupName, creationdate, modificationdate from targets where coalesce(groupName,'') = :groupName");
		query.bindValue(":groupName", *filter);
	}
	else {
		ret = query.prepare("select id, name, type, groupName, creationdate, modificationdate from targets");
	}

	ret &= query.exec ();

	while (query.next()) {
		Target * target = new Target();
		target->id = query.value(0).toInt();
		qDebug () << "found target " << target->id;
		target->type = query.value(2).toString();
		//qDebug () << "found target type" << query.value(2);
		if (query.value(3).isNull())
			target->groupName = "";
		else
			target->groupName = query.value(3).toString();
		//qDebug () << "found target group" << query.value(3);
		decrypt(query.value(1).toByteArray(), target->name);
		//qDebug () << "found target name " << target->name;
		target->pictureSmall = NULL;
		target->picture = NULL;
		target->pictureBack = NULL;
		target->creationdate = query.value(4).toString();
		target->modificationdate = query.value(5).toString();
		result.append(target);

//		 QApplication::instance()->processEvents();
	}

	return result;
}

QList<Target*> DatabaseManager::getFullTargets()
{
	qDebug () << "getting full targets";

	QList<Target*> result;

	QSqlQuery query (db);
	bool ret;
	ret = query.prepare("select id, name, type, groupName, creationdate, modificationdate, fieldsContent from targets");
	ret &= query.exec ();

	while (query.next()) {
		Target * target = new Target();
		target->id = query.value(0).toInt();
		qDebug () << "found target " << target->id;
		target->type = query.value(2).toString();
		//qDebug () << "found target " << query.value(2);
		if (query.value(3).isNull ())
			target->groupName = "";
		else
			target->groupName = query.value(3).toString();
		//qDebug () << "found target " << query.value(3);
		decrypt(query.value(1).toByteArray(), target->name);
		//qDebug () << "found target " << target->name;
		target->pictureSmall = NULL;
		target->picture = NULL;
		target->pictureBack = NULL;
		target->creationdate = query.value(4).toString();
		target->modificationdate = query.value(5).toString();
		decrypt(query.value(6).toByteArray(), target->fieldsContent);
		result.append(target);

//		 QApplication::instance()->processEvents();
	}

	return result;
}

QList<QString> DatabaseManager::getGroups()
{
	QList<QString> result;

	//QSqlQuery query("select distinct coalesce(groupName,'') from targets where groupName != '' and groupName is Not Null order by groupName", db);
	QSqlQuery query("select distinct coalesce(groupName,'') from targets order by coalesce(groupName,'')", db);
	while (query.next()) {
		QString name = query.value(0).toString();

		//qDebug () << "ADDING GROUP " << name;

		result.append(name);
	}

	return result;
}

bool DatabaseManager::deleteTarget(Target * target)
{
    return _deleteTarget (target->id);
}

bool DatabaseManager::_deleteTarget(int idTarget)
{
	qDebug () << "going to delete " << idTarget;

    bool ret = true;
	if (db.isOpen()) {
		QSqlQuery query (db);

		if (currentVersion <= 3) {
			ret = query.prepare("delete from fields where targetId=:code");
			query.bindValue(":code", idTarget);
			ret = query.exec();
		}
		if (ret) {
			ret = query.prepare("delete from targets where id=:code");
			if (ret) {
				qDebug () << "DELETE " << idTarget;
                query.bindValue(":code", idTarget);
				ret = query.exec();
			}
		}
	}

	return ret;
}

bool DatabaseManager::updateFields(Target* target)
{
	qDebug () << "updating fields " << target->name << " " << target->fields.size();
	bool ret = false;
	if (db.isOpen()) {
		if (currentVersion <= 3) {
			QSqlQuery query (db);
			ret = query.prepare("delete from fields where targetId=:code");
			query.bindValue(":code", target->id);
			ret &= query.exec();

			if (ret)
				for (int i = 0; i < target->fields.count(); i++) {
					TargetField * field = target->fields[i];

					field->targetId = target->id;
					field->id = 0;
					ret &= insertTargetField (field);
				}
		}
		else {
			target->fieldsContent.clear();
			QXmlStreamWriter stream(&target->fieldsContent);

			stream.setAutoFormatting(false);
			stream.writeStartDocument();
			stream.writeStartElement("ff");
			for (int j = 0; j < target->fields.size (); j++) {
				TargetField * field = target->fields.at(j);
				stream.writeStartElement("f");
				//stream.writeAttribute("i", QString("%1").arg(field->id));
				stream.writeAttribute("t", QString::number(field->type));
				stream.writeAttribute("o", QString::number(field->order));
				stream.writeAttribute("n", field->name);
				stream.writeCharacters(field->value);
				stream.writeEndElement();
			}
			stream.writeEndElement();
			stream.writeEndDocument();

			qDebug () << "encrypting fields " << target->name << " " << target->fields.size();
			QByteArray res;
			encrypt(target->fieldsContent, res);

			qDebug () << "storing fields " << target->name << " " << target->fields.size();
			QSqlQuery query (db);
			ret = query.prepare("UPDATE targets SET fieldsContent = :content WHERE id = :targetId");
			query.bindValue(":content", res);
			query.bindValue(":targetId", target->id);
			ret &= query.exec();
			qDebug () << "stored fields " << target->name << " " << ret;
		}
	}
	return ret;
}

//bool DatabaseManager::copyFields(Target* target)
//{
//	bool ret = true;
//
//	for (int i = 0; i < target->fields.count(); i++) {
//		TargetField * field = target->fields[i];
//		ret &= copyTargetField (field);
//	}
//
//	return ret;
//}

bool DatabaseManager::updateTarget(Target* target)
{
	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		ret = query.prepare("UPDATE targets set name=:name, type=:type, groupName=:groupName, modificationdate=CURRENT_TIMESTAMP where id=:code");
		QByteArray t1;
		if (ret) {
			encrypt(target->name, t1);
			query.bindValue(":name", t1);
			query.bindValue(":type", target->type);
			query.bindValue(":groupName", target->groupName);
			query.bindValue(":code", target->id);
			ret = query.exec();

			//qDebug () << "updated " << target->id;

		}
	}
	return ret;
}

bool DatabaseManager::updateTargetPicture(Target* target)
{
	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		ret = query.prepare("UPDATE targets set picture=:picture, modificationdate=CURRENT_TIMESTAMP where id=:code");
		if (ret) {
			//qDebug () << "updating image " << target->id << " " << target->picture;

			QByteArray im1;
			QBuffer buffer1(&im1);
			QByteArray im_r1;

			if (target->picture != NULL) {
				buffer1.open(QIODevice::WriteOnly);
				target->picture->save(&buffer1, "PNG"); // writes image into ba in PNG format

				encrypt(im1, im_r1);
				query.bindValue(":picture", im_r1);
			}
			else {
				//qDebug () << "delete image ";

				query.bindValue(":picture", QVariant (QVariant::ByteArray));
			}

			query.bindValue(":code", target->id);
			ret = query.exec();

			//qDebug () << "update picturde " << target->id;

		}
	}
	return ret;
}

bool DatabaseManager::updateTargetPictureBack(Target* target)
{
	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		ret = query.prepare("UPDATE targets set pictureBack=:pictureBack, modificationdate=CURRENT_TIMESTAMP where id=:code");
		if (ret) {
			//qDebug () << "UPDATE " << target->id << " " << target->name << " " << target->type;
			QByteArray im2;
			QBuffer buffer2(&im2);
			QByteArray im_r2;

			if (target->pictureBack != NULL) {
				buffer2.open(QIODevice::WriteOnly);
				target->pictureBack->save(&buffer2, "PNG"); // writes image into ba in PNG format

				QByteArray im_r2;
				encrypt(im2, im_r2);
				query.bindValue(":pictureBack", im_r2);
			}
			else {
				query.bindValue(":pictureBack", QVariant (QVariant::ByteArray));
			}

			query.bindValue(":code", target->id);
			ret = query.exec();
			
			//qDebug () << "update picture back" << target->id;

		}
	}
	return ret;
}

//bool DatabaseManager::updateTargetField(TargetField* field)
//{
//	bool ret = false;
//	if (db.isOpen()) {
//		QSqlQuery query (db);
//		ret = query.prepare("UPDATE fields set name=:name, value=:value, type=:type, orderN=:order, "
//		                     "encrypted=:encrypted where targetId=:targetId and id=:id");
//		if (ret) {
//			query.bindValue(":targetId", field->targetId);
//			query.bindValue(":id", field->id);
//
//			if (field->encrypted) {
//				QByteArray a, b;
//				encrypt(field->name, a);
//				encrypt(field->value, b);
//				query.bindValue(":name", a);
//				query.bindValue(":value", b);
//			}
//			else {
//				query.bindValue(":name", field->name);
//				query.bindValue(":value", field->value);
//			}
//			query.bindValue(":type", field->type);
//			query.bindValue(":order", field->order);
//			query.bindValue(":encrypted", field->encrypted ? 1 : 0);
//			ret = query.exec();
//		}
//	}
//	return ret;
//}

bool DatabaseManager::insertTargetField(TargetField* field)
{
	bool ret = false;
	if (db.isOpen()) {
		//field->id = nextId(); // We demostrates autoincrement in this case

		// http://www.sqlite.org/autoinc.html
		// NULL = is the keyword for the autoincrement to generate next value

		QSqlQuery query (db);
		ret = query.prepare("INSERT INTO fields (targetId, name, value, type, orderN, encrypted) "
		                    "VALUES (:targetId, :name, :value, :type, :order, :encrypted)");
		if (ret) {
			query.bindValue(":targetId", field->targetId);

			if (field->encrypted) {
				QByteArray a, b;
				encrypt(field->name, a);
				encrypt(field->value, b);
				query.bindValue(":name", a);
				query.bindValue(":value", b);
			}
			else {
				query.bindValue(":name", field->name);
				query.bindValue(":value", field->value);
			}
			query.bindValue(":type", field->type);
			query.bindValue(":order", field->order);
			query.bindValue(":encrypted", field->encrypted ? 1 : 0);
			ret = query.exec();
		}

		// Get database given autoincrement value
		if (ret) {
			// http://www.sqlite.org/c3ref/last_insert_rowid.html
			field->id = query.lastInsertId().toInt();
		}
	}
	return ret;
}

//bool DatabaseManager::copyTargetField(TargetField* field)
//{
//	bool ret = false;
//	if (db.isOpen()) {
//		QSqlQuery query (db);
//		ret = query.prepare("INSERT INTO fields (id, targetId, name, value, type, orderN, encrypted) "
//							"VALUES (:id, :targetId, :name, :value, :type, :order, :encrypted)");
//		if (ret) {
//			query.bindValue(":id", field->id);
//			query.bindValue(":targetId", field->targetId);
//
//			if (field->encrypted) {
//				QByteArray a, b;
//				encrypt(field->name, a);
//				encrypt(field->value, b);
//				query.bindValue(":name", a);
//				query.bindValue(":value", b);
//			}
//			else {
//				query.bindValue(":name", field->name);
//				query.bindValue(":value", field->value);
//			}
//			query.bindValue(":type", field->type);
//			query.bindValue(":order", field->order);
//			query.bindValue(":encrypted", field->encrypted ? 1 : 0);
//			ret = query.exec();
//		}
//
//	}
//	return ret;
//}

void DatabaseManager::getFields(Target * target)
{
	qDebug () << "get fields " << target->name << " " << currentVersion;

	if (target->listLoaded) return;

	bool ret = false;
	
	if (currentVersion <= 3) {
		QSqlQuery query (db);
		ret = query.prepare("select id, name, value, type, targetId, orderN, encrypted from fields where targetId=:targetId order by orderN");
		query.bindValue(":targetId", target->id);
		ret = query.exec ();
		while (query.next()) {
			TargetField* item = new TargetField();
			item->id = query.value(0).toInt();
			item->type= query.value(3).toInt();
			item->targetId = query.value(4).toInt ();
			item->order = query.value(5).toInt ();
			item->encrypted = query.value(6).toInt () != 0;
			if (item->encrypted) {
				decrypt(query.value(1).toByteArray(), item->name);
				decrypt(query.value(2).toByteArray(), item->value);
			}
			else {
				item->name = query.value(1).toString();
				item->value= query.value(2).toString();
			}
			target->fields.append(item);
		}
	}
	else {
		bool ret = false;
		QSqlQuery query (db);

		ret = query.prepare("select fieldsContent from targets where id=:targetId");
		query.bindValue(":targetId", target->id);
		ret &= query.exec ();
		ret &= query.next();

		decrypt(query.value(0).toByteArray(), target->fieldsContent);

		QXmlStreamReader xml (target->fieldsContent);
		if (!xml.atEnd()) {
			xml.readNext();
			if (xml.isStartDocument()) {
				//qDebug () << "START " << xml.name().toString();
				xml.readNext();
				if (xml.isStartElement()) {
					QString sec(xml.name().toString());
					if (sec == "ff") {
						//qDebug () << "START ff " << xml.name().toString();
						xml.readNext();
						while (xml.isStartElement()) {
							//xml.readNext();
							QString sec(xml.name().toString());
							if (sec == "f") {
								TargetField * f = new TargetField ();

								QXmlStreamAttributes attrs = xml.attributes();
								//qDebug() << "id " << attrs.value("i").toString() ;

								//qDebug() << "name " << attrs.value("n").toString() ;
								f->name = attrs.value("n").toString();
								//qDebug() << "type " << attrs.value("t").toString() ;
								f->type = attrs.value("t").toString().toInt();
								//qDebug() << "order " << attrs.value("o").toString() ;
								f->order = attrs.value("o").toString().toInt();

								xml.readNext();
								if (xml.isCharacters()) {
									//qDebug() << "text " << xml.text().toString() ;
									f->value = xml.text().toString();
									xml.readNext();
								}
								else
									f->value = "";

								if (!xml.isEndElement()) {
									//qDebug () << " not fixed!";
								}
								else {
									xml.readNext();
								}

								target->fields.append(f);
							}
							else {
								//qDebug () << "  not f";
							}
						}
					}
					else {
						//qDebug () << "  not ff";
					}
				}
			}
		}
	}
	target->listLoaded = true;
}

QImage * DatabaseManager::getPicture (Target * target) {
	QImage * result = NULL;
	QSqlQuery query (db);
	bool ret = query.prepare("select picture from targets where id=:targetId");
	query.bindValue(":targetId", target->id);
	ret = query.exec ();
	while (query.next()) {
		if (query.value(0).isNull()) {
			result = NULL;
		}
		else {
			result = new QImage ();
			QByteArray im_s;
			decrypt(query.value(0).toByteArray(), im_s);
			if (!result->loadFromData (im_s)) {
				//qDebug () << "Error loading image " << target->id;
			} else {
				//qDebug () << "loaded image " << target->id;
			}
		}
		break;
	}

	return result;
}
QImage * DatabaseManager::getPictureBack (Target * target) {
	QImage * result = NULL;
	QSqlQuery query (db);
	bool ret = query.prepare("select pictureBack from targets where id=:targetId");
	query.bindValue(":targetId", target->id);
	ret = query.exec ();
	while (query.next()) {
		if (query.value(0).isNull()) {
			result = NULL;
		}
		else {
			result = new QImage ();
			QByteArray im_s;
			decrypt(query.value(0).toByteArray(), im_s);
			if (!result->loadFromData (im_s)) {
				//qDebug () << "Error loading back image " << target->id;
			}
			else {
				////qDebug () << "loaded back image " << target->id;
			}
		}
		break;
	}

	return result;
}

bool DatabaseManager::renameGroup (const QString & from, const QString & to) {
	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		ret = query.prepare("UPDATE targets set groupName = :newGroupName, modificationdate=CURRENT_TIMESTAMP WHERE coalesce(groupName,'') = :oldGroupName");
		if (ret) {
			query.bindValue(":newGroupName", to);
			query.bindValue(":oldGroupName", from);
			ret = query.exec ();
		};
	}
	return ret;
}

bool DatabaseManager::deleteGroup (const QString & from) {
	bool ret = false;
	if (db.isOpen()) {
		QSqlQuery query (db);
		ret = query.prepare("UPDATE targets set groupName = '', modificationdate=CURRENT_TIMESTAMP WHERE coalesce(groupName,'') = :oldGroupName");
		if (ret) {
			query.bindValue(":oldGroupName", from);
			ret = query.exec ();
		};
	}
	return ret;
}




//
//char *pass = "password";
//char *salt = "12340000";
//int ic = 1;
//unsigned char buf[1024];
//
//ic = 1;
//PKCS5_PBKDF2_HMAC_SHA1(pass, strlen(pass), (unsigned char*)salt, strlen(salt), ic, 32+16, buf);
//printf("PKCS5_PBKDF2_HMAC_SHA1(\"%s\", \"%s\", %d)=\n", pass, salt, ic);
//print_hex(buf, 32+16);
//
//ic = 1;
//EVP_BytesToKey(EVP_aes_256_cbc(), EVP_sha1(), (unsigned char*)salt, (unsigned char*)pass, strlen(pass), ic, buf, buf+32);
//printf("EVP_BytesToKey(\"%s\", \"%s\", %d)=\n", pass, salt, ic);
//print_hex(buf, 32+16);
bool DatabaseManager::validatePassword (const QString _a) {
	qDebug () << "checkPassword " << currentVersion << "(" << connectionName << ")"; // << _a;

	QByteArray a;
	if (currentVersion < 2)
		encrypt(QString(PASS1), a);
	else {
		QString pp(_a);
		pp.append (PASS2);
		encryptSHA1(pp.mid(0, SHA1_LEN), a);
	}

	QByteArray b = selectSecretPhrase ();

	//qDebug()<< "checkPassword [[[[[" << b << "]]]]]";

	return a == b;
}

bool DatabaseManager::checkPassword (QString _a, int version)
{
	qDebug () << "checkPassword " << version << "(" << connectionName << ")"; // << _a;

	QByteArray t = _a.toLocal8Bit();

	keyLen = 32*8;
	for (int i = 0; i < 32; i++) {
		key [i] = i;

		if (i < t.size ()) {
			key[i] = (unsigned char)t[i];
		}
	}
	/*unsigned char key16[] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};
	unsigned char key24[] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23};
	unsigned char key32[] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31};*/

//	int AES_set_encrypt_key(const unsigned char *userKey, const int bits,
//		AES_KEY *key);

	AES_set_encrypt_key(key, keyLen, &aeskeyE);
	AES_set_decrypt_key(key, keyLen, &aeskeyD);

	QByteArray a;
	if (version < 2)
		encrypt(QString(PASS1), a);
	else {
		QString pp(_a);
		pp.append (PASS2);
		encryptSHA1(pp.mid(0, SHA1_LEN), a);
	}

	QByteArray b = selectSecretPhrase ();

	//qDebug()<< "checkPassword [[[[[" << b << "]]]]]";

	return a == b;
}

bool DatabaseManager::createPassword (QString _a, int version)
{
	//qDebug () << "createPassword " << version << "(" << connectionName << ")";

	QByteArray t = _a.toLocal8Bit();

//	if (version >= 4) {
//		char * pass = t.constData();
//		unsigned char buf[1024];
//		PKCS5_PBKDF2_HMAC_SHA1(pass, strlen(pass), (unsigned char*)PASS3, strlen(PASS3), 4000, 32+16, buf);
//
//		t =
////		printf("PKCS5_PBKDF2_HMAC_SHA1(\"%s\", \"%s\", %d)=\n", pass, salt, ic);
////		print_hex(buf, 32+16);
//
//	}

	keyLen = 32*8;
	for (int i = 0; i < 32; i++) {
		key [i] = i;

		if (i < t.size ()) {
			key[i] = (unsigned char)t[i];
		}
	}
	/*unsigned char key16[] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};
	unsigned char key24[] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23};
	unsigned char key32[] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31};*/
	AES_set_encrypt_key(key, keyLen, &aeskeyE);
	AES_set_decrypt_key(key, keyLen, &aeskeyD);

	QByteArray a;
	if (version < 2)
		encrypt(QString(PASS1), a);
	else {
		QString pp(_a);
		pp.append (PASS2);
		encryptSHA1(pp.mid(0, SHA1_LEN), a); // encrypt
	}

	////qDebug () << "create secret " << a;

	return updateSecretPhrase (a);
}

bool DatabaseManager::updateSecretPhrase(QByteArray a) {
	////qDebug () << "update secret " << a;

	bool ret = false;
	if (nextId () > 0) {
		QSqlQuery query (db);
		ret = query.prepare("update id set phrase = :phrase");
		if (ret) {
			query.bindValue(":phrase", a);
			ret = query.exec();
			////qDebug () << "update secret " << ret;
			return ret;
		}
	}
	return ret;
}

bool DatabaseManager::hasSecretPhrase()
{
	//qDebug () << "has secret?";

	QSqlQuery query("select phrase from id", db);
	if (query.next()) {
		return !query.value(0).isNull();
	}
	//query.clear();
	return false;
}

QByteArray DatabaseManager::selectSecretPhrase()
{
	//qDebug () << "get secret?";

	QByteArray ret;
	QSqlQuery query("select phrase from id", db);
	if (query.next()) {
		return query.value(0).toByteArray();
	}

	return ret;
}

void DatabaseManager::encryptSHA1 (const QString & a, QByteArray& b) {
	QByteArray t = a.toLocal8Bit();
	int length = t.size();

	SHA512_CTX context;
	unsigned char md[SHA512_DIGEST_LENGTH];

	SHA512_Init(&context);
	SHA512_Update(&context, (unsigned char*)t.constData(), length);
	SHA512_Final(md, &context);

#ifdef BASE64
	b = QByteArray((char*)md, SHA512_DIGEST_LENGTH).toBase64();
#else
	b = QByteArray((char*)md, SHA512_DIGEST_LENGTH);
#endif
}


void DatabaseManager::encrypt (const QString a, QByteArray& b)
{
	unsigned char ivE[] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};

	QByteArray t = a.toUtf8();
	int size = t.size();
	int c = size / 16 + 1;
	short p = 16 - size % 16;

	unsigned char pout [c * 16];
	unsigned char pin [c * 16];
	memset (pin, p, c * 16);
	memset(pout, 0, c * 16);
	memcpy(pin, (unsigned char *)t.constData(), size);

	AES_cbc_encrypt(pin, pout, c*16, &aeskeyE, ivE, AES_ENCRYPT);

#ifdef BASE64
	b = QByteArray((char*)pout, c * 16).toBase64();
#else
	b = QByteArray((char*)pout, c * 16);
#endif
}

#ifdef BASE64
void DatabaseManager::decrypt (const QByteArray& aa, QString& b)
{
	QByteArray a = QByteArray::fromBase64(aa);
#else
void DatabaseManager::decrypt (const QByteArray& a, QString& b)
{
#endif
	unsigned char ivD[] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};

	int size = a.size ();
	int c = size / 16;
	unsigned char pout [size];
	unsigned char pin [size];
	memset(pout, 0, size);
	memcpy(pin, (unsigned char *)a.constData(), size);

	AES_cbc_encrypt(pin, pout, c*16, &aeskeyD, ivD, AES_DECRYPT);
	int ss = size-(short)(pout[size-1]);
	pout [ss] = 0;

	b = QString::fromUtf8((char*)pout, ss);
}

void DatabaseManager::encrypt (const QByteArray& t, QByteArray& b)
{
	unsigned char ivE[] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};

	int size = t.size();
	int c = size / 16 + 1;
	short p = 16 - size % 16;

	unsigned char pout [c * 16];
	unsigned char pin [c * 16];
	memset (pin, p, c * 16);
	memset(pout, 0, c * 16);
	memcpy(pin, (unsigned char *)t.constData(), size);

	AES_cbc_encrypt(pin, pout, c*16, &aeskeyE, ivE, AES_ENCRYPT);

#ifdef BASE64
	b = QByteArray((char*)pout, c * 16).toBase64();
#else
	b = QByteArray((char*)pout, c * 16);
#endif
}

#ifdef BASE64
void DatabaseManager::decrypt (const QByteArray& aa, QByteArray& b)
{
	QByteArray a = QByteArray::fromBase64(aa);
#else
void DatabaseManager::decrypt (const QByteArray& a, QByteArray& b)
{
#endif
	unsigned char ivD[] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};
	int size = a.size ();
	int c = size / 16;
	unsigned char pout [size];
	unsigned char pin [size];
	memset(pout, 0, size);
	memcpy(pin, (unsigned char *)a.constData(), size);

	AES_cbc_encrypt(pin, pout, c*16, &aeskeyD, ivD, AES_DECRYPT);
	int l = size-(short)(pout[size-1]); //pout [l] = 0;

	b = QByteArray ((char*)pout, l);
}

bool DatabaseManager::migrateTo4 () {
	QTime t; t.start ();

	bool ret = true;

	qDebug () << "starting to migrate to 4 ... from " << currentVersion << " " << db.lastError();

    QList<Target *> list = getTargets(NULL);
	for (int i = 0; i < list.size (); i++) {
		Target * target = list[i];

		getFields(target);

		qDebug () << "migrating " << target->name;

		target->fieldsContent.clear();
	    QXmlStreamWriter stream(&target->fieldsContent);

	    stream.setAutoFormatting(false);
	    stream.writeStartDocument();
	    stream.writeStartElement("ff");
		for (int j = 0; j < target->fields.size (); j++) {
			TargetField * field = target->fields.at(j);
		    stream.writeStartElement("f");
//		    stream.writeAttribute("i", QString("%1").arg(field->id));
		    stream.writeAttribute("t", QString::number(field->type));
		    stream.writeAttribute("o", QString::number(field->order));
		    stream.writeAttribute("n", field->name);
		    stream.writeCharacters(field->value);
			stream.writeEndElement();
		}
	    stream.writeEndElement();
	    stream.writeEndDocument();

		QByteArray res;
		encrypt(target->fieldsContent, res);

		qDebug () << "storing " << target->name;
		QSqlQuery query (db);
		ret &= query.prepare("UPDATE targets SET fieldsContent = :content WHERE id = :targetId");
		query.bindValue(":content", res);
		query.bindValue(":targetId", target->id);
		ret &= query.exec();

		qDebug () << "deleting " << target->name << " " << ret;
		delete target;
	}

	list.clear();

	qDebug () << "Delete fields " << ret;

	QSqlQuery query2 (db);
	ret &= query2.prepare("DELETE FROM fields");
	qDebug () << "Delete fields " << ret;
	ret &= query2.exec();

	qDebug () << "Delete fields " << ret;
	qDebug () << "END migration to 4 " << t.elapsed();

	return ret;
}
