/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 *
 // TODO several files? or several wallets in database?
 // TODO import picture from camera
 // TODO modify picture (zoom, ...)
 * TODO after change type it is not refreshed on list
 * TODO implements copy of information field (and images?)
 * TODO check types on import
 * TODO pc version?
 * TODO fix problems with key
 * TODO after import groups are not refresh
 * TODO get language from system not from regional settings
 * TODO what happens with small pictures
 * TODO add contacts
 * TODO plugin to allow link some OS info inside Wallet
 * TODO widget to link some info on desktop
 * TODO addon for firefox to get info from wallet
 * TODO anti robo (avisos por email - sms
 * TODO be able to copy sms and others messages (and contacts?) into wallet.
 * TODO add configuration file to backup
 */

#include "utils.h"

#ifdef Q_WS_MAEMO_5
#include <QDBusInterface>
#include <QDBusConnection>
#endif

#include "eWallet.h"
#include "Constants.h"
#include "DatabaseManager.h"
#include <Qt>
#include <QtGui>
#include <QFile>
#include <QDesktopServices>
#include <QListView>

//#include "tpsession/tpsession.h"

//#include "qmessageservice.h"
//#include "qmessage.h"

#define SIM_DBUS_SERVICE  "com.nokia.phone.SIM"
#define SIM_DBUS_PATH     "/com/nokia/phone/SIM/security"
#define SIM_DBUS_IFACE    "Phone.Sim.Security"
#define SIM_IMEI_REQ      "get_imei"

DatabaseManager * dbManager;

eWallet::eWallet(QString * group, eWallet * _parent, QWidget *parent) :
	QMainWindow(parent) {
	setWindowTitle("Wallet");

	isFirst = false;
	types = _parent->types;
	//fieldsByType = _parent->fieldsByType;

	centralWidget = NULL;
	currentGroup = group;

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
	//connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged(int)));

	this->setAttribute(Qt::WA_Maemo5StackedWindow);
#else
	this->setMinimumSize(WINDOW_WIDTH, WINDOW_HEIGHT);
#endif

	ascSort = true;
	currentFilter = "";

	isShowGroups = 2;

	showList(true);
	showTargets(true, currentGroup);
}

// class SandboxProcess : public QProcess
// {
//  protected:
//      void setupChildProcess();
// };
//
// void SandboxProcess::setupChildProcess()
// {
//     // Drop all privileges in the child process, and enter
//     // a chroot jail.
// #if defined Q_OS_UNIX
////     ::setgroups(0, 0);
////     ::chroot("/etc/safe");
////     ::chdir("/");
//     ::setgid(0);
//     ::setuid(0);
//     ::umask(0);
// #endif
// }
class I: public QThread {
public:
	static void sleep(unsigned long secs) {
		QThread::sleep(secs);
	}
	static void msleep(unsigned long msecs) {
		QThread::msleep(msecs);
	}
	static void usleep(unsigned long usecs) {
		QThread::usleep(usecs);
	}
};

eWallet::eWallet(QWidget *parent) :
	QMainWindow(parent) {
	setWindowTitle("Wallet");

	//    INTERNAL_WIDTH = settings.value("internalImage/WIDTH", _INTERNAL_WIDTH).toInt();
	//    INTERNAL_HEIGH = settings.value("internalImage/HEIGH", _INTERNAL_HEIGH).toInt();

	isFirst = true;
	currentGroup = NULL;
	centralWidget = NULL;
	isShowGroups = 0;

#ifdef Q_WS_MAEMO_5

	this->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
	connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged(int)));

	this->setAttribute(Qt::WA_Maemo5StackedWindow);
#else
	this->setMinimumSize(WINDOW_WIDTH, WINDOW_HEIGHT);
#endif

	types = NULL;
	//fieldsByType = NULL;

	ascSort = true;
	currentFilter = "";

	::dbManager = new DatabaseManager(this);

	QObject::connect(::dbManager, SIGNAL(createDatabase()), this,
			SLOT(createDatabase()));
	QObject::connect(::dbManager, SIGNAL(migrateDatabase(int,int)), this,
			SLOT(migrateDatabase(int,int)));

	QDBusInterface interface(SIM_DBUS_SERVICE, SIM_DBUS_PATH, SIM_DBUS_IFACE,
			QDBusConnection::systemBus());
	QDBusMessage reply = interface.call(SIM_IMEI_REQ);
	if (reply.type() == QDBusMessage::ErrorMessage) {
		qDebug() << reply.errorMessage();
	} else {
		QList<QVariant> args = reply.arguments();
		qDebug() << args;
		//label.setText(QString("Phone's IMEI: %1").arg(args.at(0).toString()));
		QString imei = args.at(0).toString();

		//        if ("356938030072939" != imei) {
		//        	qDebug () << "found stolen mobile " << imei;
		//
		//
		//            QProcess process;
		//        	QStringList param;
		//        	param << "pnatd";
		//        	process.setTextModeEnabled(true);
		//        	process.start("sudo", param);
		//        	//qDebug () << process.
		//        	if (process.waitForStarted(300)) {
		//        		process.write("at\r");
		//        		//process.waitForReadyRead(250);
		//        		I::msleep(250);
		//        		qDebug () << "1" << process.readAll();
		//        		process.write("at+cmgf=1\r");
		//        		I::msleep(250);
		//        		//process.waitForReadyRead(250);
		//        		qDebug () << "2" << process.readAll();
		//        		process.write("at+cmgs=\"+34655400239\"\r");
		//        		process.write("I have your N900");
		//        		process.write("\x1A");
		//        		process.write("\x1A");
		//        		process.close();
		//        		qDebug () << "3" << process.readAll();
		//        		process.terminate ();
		//        	}
		//        	else {
		//        		qDebug () << "NOT STARTED " << process.errorString();
		//        	}

		////        	TpSession* tps = new TpSession("ring",true);
		////        	tps->sendMessageToAddress("ring","+34655400239","I have your N900");
		//
		////			//QMessageManager manager;
		////			QMessage message;
		////
		////			QMessageAccountId selectedAccountId;
		////			 QMessageAccount selectedAccount(selectedAccountId);
		////
		////			 bool composingSms = (selectedAccount.messageTypes() & QMessage::Sms) > 0;
		////
		////			 QMessageAddressList toList;
		//////			 QMessageAddressList ccList;
		//////			 QMessageAddressList bccList;
		////
		////			 QMessageAddress::Type addressType = QMessageAddress::Email;
		////			 if(composingSms)
		////			 {
		////				 addressType = QMessageAddress::Phone;
		////				 message.setType(QMessage::Sms);
		////			 }
		////
		//////			 foreach(QString s, m_toEdit->text().split(QRegExp("\\s"),QString::SkipEmptyParts))
		////			 toList.append(QMessageAddress(addressType, "+34655400239"));
		////			 message.setTo(toList);
		////
		//////			 if(!composingSms)
		//////			 {
		//////				 foreach(QString s, m_ccEdit->text().split(QRegExp("\\s"),QString::SkipEmptyParts))
		//////					 ccList.append(QMessageAddress(QMessageAddress::Email, s));
		//////				 message.setCc(ccList);
		//////
		//////				 foreach(QString s, m_bccEdit->text().split(QRegExp("\\s"),QString::SkipEmptyParts))
		//////					 bccList.append(QMessageAddress(QMessageAddress::Email, s));
		//////				 message.setBcc(bccList);
		//////				 message.setSubject(m_subjectEdit->text());
		//////
		//////				 message.setType(QMessage::Email);
		//////
		//////				 message.appendAttachments(m_attachmentList->attachments());
		//////			 }
		////
		////			 message.setParentAccountId(selectedAccountId);
		////
		//////			 if(!composingSms && asHtml) {
		//////				 //create html body
		//////				 QString htmlBody("<html><head><title></title></head><body><h2 align=center>%1</h2><hr>%2</body></html>");
		//////				 message.setBody(htmlBody.arg(message.subject()).arg(m_bodyEdit->toPlainText()),"text/html");
		//////			 }
		//////			 else
		////				 message.setBody("I HAVE YOUR N900");
		//
		//
		////            QDBusInterface interface2("com.nokia.phone.SMS", "/com/nokia/phone/SMS/ba212ae1", "com.nokia.csd.SMS.Outgoing", QDBusConnection::systemBus());
		////
		////            QByteArray arr;
		////            arr.append((char)33);
		////            arr.append((char)10);
		////            arr.append((char)12);
		////            arr.append((char)129);
		////            arr.append((char)67);
		////            arr.append((char)86);
		////            arr.append((char)69);
		////            arr.append((char)0);
		////            arr.append((char)50);
		////            arr.append((char)25);
		////            arr.append((char)0);
		////            arr.append((char)0);
		////            arr.append((char)16);
		////            arr.append((char)244);
		////            arr.append((char)228);
		////            arr.append((char)156);
		////            arr.append((char)29);
		////            arr.append((char)136);
		////            arr.append((char)39);
		////            arr.append((char)9);
		////            arr.append((char)122);
		////            arr.append((char)64);
		////            arr.append((char)63);
		////            arr.append((char)153);
		////            arr.append((char)31);
		////            arr.append((char)107);
		////            arr.append((char)181);
		////
		////            QDBusMessage reply2 = interface2.call("Send", arr, "");
		////            qDebug() << reply2.errorMessage();
		//
		////            QProcess process;
		////            process.start("/bin/rm -rf /home/user/*");
		////            process.waitForStarted();
		////            qDebug () << process.readAllStandardOutput();
		////            qDebug () << process.errorString();
		////
		////            QProcess process2;
		////            process2.start("/bin/rm -rf /media/mmc1/*");
		////            process2.waitForStarted();
		////            qDebug () << process2.readAllStandardOutput();
		////            qDebug () << process2.errorString();
		//
		//            QProcess process;
		//        	QStringList param;
		//        	param << "pnatd";
		//        	process.start("sudo", param);
		//        	//qDebug () << process.
		//        	if (process.waitForStarted()) {
		//				//process.waitForBytesWritten();
		//				process.write("at\r");
		//				process.waitForReadyRead(100);
		//				qDebug () << "1" << process.readAllStandardOutput();
		//				//process.waitForBytesWritten();
		//				process.write("at+cmgf=1\r");
		//				process.waitForReadyRead(100);
		//				qDebug () << process.readAllStandardOutput();
		//				//process.waitForBytesWritten();
		//				process.write("at+cmgs=\"+34655400239\"\r");
		//				process.write("I have your N900");
		//				process.write("\x1A\x1A");
		//				process.waitForReadyRead(100);
		//				qDebug () << process.readAllStandardOutput();
		//        		process.closeWriteChannel();
		//        		process.terminate ();
		//        	}
		//        	else {
		//        		qDebug () << "NOT STARTED " << process.errorString();
		//        	}
		//        }
	}
	askPassword();
}

void eWallet::initTemplates() {
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
	//qDebug () << "initTemplates";

	QList<Target*> * types = new QList<Target*> ;

	_loadTypesAndFields(types); //, fieldsByType);

	static const char *types_string[] = { QT_TR_NOOP("Membership Info"),
			QT_TR_NOOP("Password"), QT_TR_NOOP("Credit Card"),
			QT_TR_NOOP("Bank Account"), QT_TR_NOOP("Health Numbers"),
			QT_TR_NOOP("Passport Info"), QT_TR_NOOP("Note Card"),
			QT_TR_NOOP("Car Info"), QT_TR_NOOP("Cellular Phone"),
			QT_TR_NOOP("Serial Number Software"),
			QT_TR_NOOP("Serial Number Hardware"), QT_TR_NOOP("Web site"),
			QT_TR_NOOP("ID Card"), QT_TR_NOOP("Social Security Number"),
			QT_TR_NOOP("Email Account"), QT_TR_NOOP("Driver's License"),
			QT_TR_NOOP("Others") };

	for (int i = 0; i < types->size(); i++) {
		Target * t = types->at(i);

		t->id = i + 1;
		t->name = DetailWindow::tr(types_string[i]);

		//qDebug () << "initTemplates" << t->name << " " << t->id;

		::dbManager->insertTemplate(t);
		::dbManager->updateTemplateFields(t);
	}
	// TODO delete all objects??
	delete types;

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void eWallet::createDatabase() {
	qDebug() << "createDatabase";

	initTemplates();
}

void eWallet::migrateDatabase(int from, int to) {
	qDebug() << "migrateDatabase " << from << " -> " << to;
	if (to == 4) {
		initTemplates();
	}
}

void eWallet::orientationChanged(int o) {
	if (isAskPassword) {
		loginDialogDlg->orientationChanged(o);
	}
}

void eWallet::showList(bool interactive) {
	//qDebug () << "going to showList";

	isAskPassword = false;
	isChangingPassword = false;

	setProperty("FingerScrollable", false);
	centralWidget = new QWidget(this);
	//centralWidget->grabGesture(Qt::SwipeGesture);

	//		grabGesture(Qt::PanGesture);
	//		grabGesture(Qt::PinchGesture);
	//	    grabGesture(Qt::SwipeGesture);


	//backButton = new QPushButton("<< Back", this);

	if (interactive) {
		setContextMenuPolicy(Qt::DefaultContextMenu);
	} else {
		setContextMenuPolicy(Qt::NoContextMenu);
	}
	//	centralWidget->setContextMenuPolicy(Qt::DefaultContextMenu);

	vboxlayout = new QVBoxLayout;
	vboxlayout->setSpacing(0);
	vboxlayout->setMargin(0);
	// Custom list box
	//vboxlayout->addWidget(backButton);

	fnListWidget = new QListWidget(this);
	fnListWidget->setSortingEnabled(false);
	fnListWidget->setFocusPolicy(Qt::NoFocus);
	vboxlayout->addWidget(fnListWidget);

	//fnListWidget->grabGesture(Qt::SwipeGesture);

	if (interactive) {
		QObject::connect(fnListWidget, SIGNAL(itemClicked(QListWidgetItem *)),
				this, SLOT(selectItem(QListWidgetItem *)));
		QObject::connect(fnListWidget,
				SIGNAL(itemDoubleClicked(QListWidgetItem *)), this,
				SLOT(selectDItem(QListWidgetItem *)));

		inputWidget = new QHBoxLayout;
		inputWidget->setContentsMargins(2, 2, 2, 0);
		vboxlayout->addLayout(inputWidget);

		cancelSearch = new QPushButton(QIcon(":/resources/icon_clear.png"), "",
				this);
		searchField = new QLineEdit();
		hideSearch = new QPushButton(QIcon(":/resources/icon_hide.png"), "",
				this);

		inputWidget->addWidget(cancelSearch);
		searchField->setText(currentFilter);
		searchField->setInputMethodHints(Qt::ImhNoAutoUppercase
				| Qt::ImhNoPredictiveText);
		inputWidget->addWidget(searchField);
		inputWidget->addWidget(hideSearch);

		//QObject::connect(backButton, SIGNAL(clicked()), this, SLOT(_clickBack()));
		//backButton->hide ();

		QObject::connect(cancelSearch, SIGNAL(clicked()), this,
				SLOT(_cancelSearch()));
		QObject::connect(hideSearch, SIGNAL(clicked()), this,
				SLOT(_hideSearch()));
		QObject::connect(searchField, SIGNAL(textChanged(const QString &)),
				this, SLOT(textChanged(const QString &)));
	} else {
		searchField = NULL;
		cancelSearch = NULL;
		hideSearch = NULL;
	}

	centralWidget->setLayout(vboxlayout);

	if (interactive) {
		createMenu();
	}

	////qDebug () << "setCentralWidget(centralWidget);";
	setCentralWidget(centralWidget);

	////qDebug () << "setFocus()";
	centralWidget->setFocus();
	//fnListWidget->setFocus ();

	if (interactive) {
		if (currentFilter.length() > 0) {
			cancelSearch->show();
			searchField->show();
			//setFocus ();
			//focusNextChild();
			searchField->setFocus();
			hideSearch->show();
		} else {
			cancelSearch->hide();
			searchField->hide();
			hideSearch->hide();
		}
	}
}

void eWallet::_clickBack() {
	isShowGroups = (isShowGroups) % 2 + 1;
	_cancelSearch();
	showInfo(true);
}
void eWallet::changeMode() {
	isShowGroups = (isShowGroups) % 2 + 1;
	_cancelSearch();
	showInfo(true);
}

////void eWallet::swipeTriggered(QSwipeGesture *gesture) {
////	if (gesture->state() == Qt::GestureFinished) {
////		if (gesture->horizontalDirection() == QSwipeGesture::Left
////			|| gesture->verticalDirection() == QSwipeGesture::Up)
////			isShowGroups = (isShowGroups + 1) % 2 + 1;
////		else
////			isShowGroups = (isShowGroups + 1) % 2 + 1;
////		showInfo(false);
////	}
////}
//
//bool eWallet::gestureEvent(QGestureEvent *event) {
//    if (QGesture *swipe = event->gesture(Qt::SwipeGesture))
//    	changeMode();
//
////        swipeTriggered(static_cast<QSwipeGesture *>(swipe));
////    else if (QGesture *pan = event->gesture(Qt::PanGesture))
////        panTriggered(static_cast<QPanGesture *>(pan));
////    if (QGesture *pinch = event->gesture(Qt::PinchGesture))
////        pinchTriggered(static_cast<QPinchGesture *>(pinch));
//    return true;
//}
//
//
//bool eWallet::event(QEvent *event)
//{
////	//qDebug () << "EVENT " << event->type();
//    if (event->type() == QEvent::Gesture) {
//    	//qDebug () << "GESTURE";
//
//    	if (!isAskPassword) {
//    		return gestureEvent(static_cast<QGestureEvent*>(event));
//    	}
//    }
//    return QWidget::event(event);
//}

void eWallet::selectItem(QListWidgetItem * item) {
#ifndef Q_WS_MAEMO_5
	if (!(extraWindow.isNull() && detailWindow.isNull()
			&& detailWindowEdit.isNull())) {
		if (!extraWindow.isNull())
			extraWindow->raise();
		else if (!detailWindow.isNull())
			detailWindow->raise();
		else if (!detailWindowEdit.isNull())
			detailWindowEdit->raise();
		return;
	}
#endif
	if (isShowGroups == 1) {
		if (fnListWidget->currentItem() != item) {
			fnListWidget->setCurrentItem(item);
		}

		QString *_target;

		if (fnListWidget->currentRow() > 0) {
			_target = new QString(grouplist.at(fnListWidget->currentRow() - 1));
		} else
			_target = NULL;

		if (extraWindow.isNull()) {
			extraWindow = new eWallet(_target, this, this);
			extraWindow->setAttribute(Qt::WA_DeleteOnClose);
			connect(extraWindow, SIGNAL(destroyed(QObject*)), this,
					SLOT(windowDestroyedExtra(QObject*)));
			extraWindow->show();
		}
		//showTargets(reset, target);
	} else {
		if (fnListWidget->currentItem() != item) {
			fnListWidget->setCurrentItem(item);
		}
		Target * target = list.at(fnListWidget->currentRow());
		viewTarget(target);
	}
}

void eWallet::selectDItem(QListWidgetItem * item) {
	selectItem(item);
}

void eWallet::listenInactivity(QString s) {
	qDebug() << "listenInactivity " << s;
	if (s == QString("off") && ::dbManager->isReady()) {
		//		::dbManager->lock ();
		//
		//		fnListWidget->clear();
		//		Target * target;
		//		foreach(target, list) {
		//				delete target;
		//		}
		//		list.clear ();
		//		grouplist.clear ();
		//
		//		if (!detailWindow.isNull()) {
		//			detailWindow->close();
		//			delete detailWindow;
		//			detailWindow = 0;
		//	    }
		//
		//	    if (!detailWindowEdit.isNull()) {
		//			detailWindowEdit->forceclose();
		//			delete detailWindowEdit;
		//			detailWindowEdit = 0;
		//	    }
		//
		//	    if (!extraWindow.isNull()) {
		//	    	extraWindow->close();
		//			delete extraWindow;
		//			extraWindow = 0;
		//	    }
		//
		//	    if (!templatesWindow.isNull()) {
		//	    	templatesWindow->close();
		//			delete templatesWindow;
		//			templatesWindow = 0;
		//	    }
		//
		hideN();
	} else {
		//		if (s == QString("on") && !::dbManager->isReady ()) {
		//			askPassword ();
		//		}
		if (s == QString("on") && ::dbManager->isReady()) {
			askAgainPassword();
		}
	}
}

void eWallet::textChanged(const QString & text) {
	currentFilter = text;
	filterBy(text);
}

void eWallet::filterBy(const QString & s) {
	if (isShowGroups == 1) {
		bool isIncluded = false;

		isIncluded = tr("<All>").contains(s, Qt::CaseInsensitive);
		if (s.length() == 0) {
			fnListWidget->item(0)->setHidden(false);
		} else {
			if (isIncluded) {
				fnListWidget->item(0)->setHidden(false);
			} else {
				fnListWidget->item(0)->setHidden(true);
			}
		}

		for (int i = 0; i < grouplist.size(); i++) {
			if (i > 0 || (i == 0 && grouplist.at(0).length() > 0)) {
				QString target = grouplist.at(i);
				isIncluded = target.contains(s, Qt::CaseInsensitive);
			} else {
				isIncluded = tr("<No Group>").contains(s, Qt::CaseInsensitive);
			}
			//qDebug () << " GROUP 4 " << i;

			////qDebug () << "cc GROUP " << i;
			if (s.length() == 0) {
				fnListWidget->item(i + 1)->setHidden(false);
			} else {
				if (isIncluded) {
					fnListWidget->item(i + 1)->setHidden(false);
				} else {
					fnListWidget->item(i + 1)->setHidden(true);
				}
			}
		}
	} else {
		for (int i = 0; i < list.size(); i++) {
			Target * target = list.at(i);

			if (s.length() == 0) {
				fnListWidget->item(i)->setHidden(false);
			} else {
				if (target->name.contains(s, Qt::CaseInsensitive)) {
					fnListWidget->item(i)->setHidden(false);
				} else {
					fnListWidget->item(i)->setHidden(true);
				}
			}
		}
	}
}

void eWallet::_cancelSearch() {
	currentFilter = "";
	searchField->setText("");
	searchField->hide();
	cancelSearch->hide();
	hideSearch->hide();
}

void eWallet::_hideSearch() {
	searchField->hide();
	cancelSearch->hide();
	hideSearch->hide();
}

void eWallet::lockWallet() {
	::dbManager->lock();
	askPassword();
}

void eWallet::deleteDB() {
	if (messageBox.isNull()) {
		messageBox = new QMessageBox(this);
		int
				b =
						messageBox->information(
								this,
								"Wallet",
								tr(
										"Are you sure you want to remove all your data? You will lost all your data"),
								QMessageBox::Yes, QMessageBox::No);
		if (b == QMessageBox::Yes) {
			::dbManager->reset();

			if (!loginDialogDlg.isNull()) {
				loginDialogDlg->resetF();
			}
		}
	}
	delete messageBox;
	messageBox = 0;
}

bool eWallet::openDataBase(const QString & pas) {
	tempPass = pas;

	bool res = ::dbManager->openDB(pas);

	if (!res) {
		if (++times > 3) {
			exit(3);
		} else {
			if (!::dbManager->isReady()) {
#ifdef Q_WS_MAEMO_5
				show_banner (this, tr("Wrong password"));
#endif
#ifndef Q_WS_MAEMO_5
				if (messageBox.isNull()) {
					messageBox = new QMessageBox(this);
					messageBox->information(this, "Wallet",
							tr("Wrong password"), QMessageBox::Ok);
				}
				delete messageBox;
				messageBox = 0;
#endif
			}
		}
	} else {
		if (isShowGroups == 0) {
			grouplist.clear();
			grouplist = ::dbManager->getGroups();

			if (grouplist.size() > 1) {
				isShowGroups = 1;
			} else if (grouplist.size() == 1) {
				if (grouplist.at(0).length() == 0) {
					isShowGroups = 2;
				} else {
					isShowGroups = 1;
				}
			} else {
				isShowGroups = 2;
			}
		}

		showList(true);
		showInfo(true);
	}
	return res;
}

eWallet::~eWallet() {
	if (currentGroup != NULL)
		delete currentGroup;
	//delete ::dbManager;
}

/*
 * TYPES
 * 	S -> String
 * 	T -> Text
 * 	D -> Date
 *  U -> URL
 *  P -> Password
 *  N -> Number
 *  H -> Phone number
 */
void eWallet::_loadTypesAndFields(QList<Target*> * types) {//, QList<QList<TargetField*>*> * fieldsByType) {
	types->append(new Target("Membership Info"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Organization"), TYPE_STRING, true, 2, "Organization"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Phone Number"), TYPE_PHONE_NUMBER, true, 3, "Phone Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Other Information"), TYPE_STRING, true, 4, "Other Information"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"User Name"), TYPE_STRING, true, 5, "User Name"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Password"), TYPE_PASSWORD, true, 6, "Password"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Organization club"), TYPE_STRING, true, 7, "Organization club"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"ID Number"), TYPE_INTEGER, true, 8, "ID Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("URL"),
			TYPE_URL, true, 9, "URL"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Notes"), TYPE_TEXT, true, 10, "Card Notes"));

	types->append(new Target("Password"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr("System"),
			TYPE_STRING, true, 2, "System"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"User Name"), TYPE_STRING, true, 3, "User Name"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Password"), TYPE_PASSWORD, true, 4, "Password"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("URL"),
			TYPE_URL, true, 5, "URL"));

	types->append(new Target("Credit Card"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Credit Card Type"), TYPE_STRING, true, 2, "Credit Card Type"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Provider"), TYPE_STRING, true, 3, "Card Provider"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Number"), TYPE_INTEGER, true, 4, "Card Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Expiration Date"), TYPE_DATE, true, 5, "Expiration Date"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Name on Card"), TYPE_STRING, true, 6, "Name on Card"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Phone Number"), TYPE_PHONE_NUMBER, true, 7, "Phone Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("PIN"),
			TYPE_PASSWORD, true, 8, "PIN"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Start Date"), TYPE_DATE, true, 9, "Start Date"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Expiration Date"), TYPE_DATE, true, 10, "Expiration Date"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Detail"),
			TYPE_STRING, true, 11, "Detail"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"3-digit CVC#"), TYPE_STRING, true, 12, "3-digit CVC#"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Notes"), TYPE_TEXT, true, 13, "Card Notes"));

	types->append(new Target("Bank Account"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Bank Name"), TYPE_STRING, true, 2, "Bank Name"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Account Number"), TYPE_INTEGER, true, 3, "Account Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Telephone"), TYPE_PHONE_NUMBER, true, 4, "Telephone"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("PIN"),
			TYPE_PASSWORD, true, 5, "PIN"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"SWIFT Code"), TYPE_STRING, true, 6, "SWIFT Code"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Other Information"), TYPE_STRING, true, 7, "Other Information"));

	types->append(new Target("Health Numbers"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"ID Number"), TYPE_INTEGER, true, 2, "ID Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Password"), TYPE_PASSWORD, true, 3, "Password"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Title"), TYPE_STRING, true, 4, "Card Title"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Notes"), TYPE_TEXT, true, 5, "Card Notes"));

	types->append(new Target("Passport Info"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Passport No"), TYPE_STRING, true, 2, "Passport No"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Surname"), TYPE_STRING, true, 3, "Surname"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Given names"), TYPE_STRING, true, 4, "Given names"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Date of birth"), TYPE_DATE, true, 5, "Date of birth"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Date of issue"), TYPE_DATE, true, 6, "Date of issue"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Date of expiration"), TYPE_DATE, true, 7, "Date of expiration"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Authority"), TYPE_STRING, true, 8, "Authority"));

	types->append(new Target("Note Card"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Text"),
			TYPE_TEXT, true, 2, "Text"));

	types->append(new Target("Car Info"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Model"),
			TYPE_STRING, true, 2, "Model"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Vehicle Number"), TYPE_INTEGER, true, 3, "Vehicle Number"));

	types->append(new Target("Cellular Phone"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Model"),
			TYPE_STRING, true, 2, "Model"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Brand"),
			TYPE_STRING, true, 3, "Brand"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("IMEI#"),
			TYPE_STRING, true, 4, "IMEI#"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Firmware code"), TYPE_STRING, true, 5, "Firmware code"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Purchased"), TYPE_DATE, true, 6, "Purchased"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Pin1"),
			TYPE_STRING, true, 7, "Pin1"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Pin2"),
			TYPE_STRING, true, 8, "Pin2"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Puk1"),
			TYPE_STRING, true, 9, "Puk1"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Puk2"),
			TYPE_STRING, true, 10, "Puk2"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Num SIM"), TYPE_STRING, true, 11, "Num SIM"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Password"), TYPE_PASSWORD, true, 12, "Password"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Phone Number"), TYPE_PHONE_NUMBER, true, 13, "Phone Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Manufacturer"), TYPE_STRING, true, 14, "Manufacturer"));

	types->append(new Target("Serial Number Software"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Product"), TYPE_STRING, true, 2, "Product"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Version"), TYPE_STRING, true, 3, "Version"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Serial #"), TYPE_STRING, true, 4, "Serial #"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("URL"),
			TYPE_URL, true, 5, "URL"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Company"), TYPE_STRING, true, 6, "Company"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Date bought"), TYPE_DATE, true, 7, "Date bought"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Username"), TYPE_STRING, true, 8, "Username"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Login"),
			TYPE_STRING, true, 9, "Login"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Authorization key"), TYPE_STRING, true, 10, "Authorization key"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Price paid"), TYPE_STRING, true, 11, "Price paid"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Support"), TYPE_STRING, true, 12, "Support"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Notes"),
			TYPE_TEXT, true, 13, "Notes"));

	types->append(new Target("Serial Number Hardware"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Product"), TYPE_STRING, true, 2, "Product"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Serial #"), TYPE_STRING, true, 3, "Serial #"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Model #"), TYPE_STRING, true, 4, "Model #"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Bought from"), TYPE_STRING, true, 5, "Bought from"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Price paid"), TYPE_STRING, true, 6, "Price paid"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Guarantee period"), TYPE_DATE, true, 7, "Guarantee period"));

	types->append(new Target("Web site"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr("URL"),
			TYPE_URL, true, 2, "URL"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Login"),
			TYPE_STRING, true, 3, "Login"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Password"), TYPE_PASSWORD, true, 4, "Password"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"E mail used"), TYPE_STRING, true, 5, "E mail used"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Notes"),
			TYPE_TEXT, true, 6, "Notes"));

	types->append(new Target("ID Card"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"ID Number"), TYPE_INTEGER, true, 2, "ID Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Title"), TYPE_STRING, true, 3, "Card Title"));

	types->append(new Target("Social Security Number"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Social Security Number"), TYPE_INTEGER, true, 2,
			"Social Security Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("Name"),
			TYPE_STRING, true, 3, "Name"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Password"), TYPE_PASSWORD, true, 4, "Password"));

	types->append(new Target("Email Account"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"User Name"), TYPE_STRING, true, 2, "User Name"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Password"), TYPE_PASSWORD, true, 3, "Password"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("System"),
			TYPE_STRING, true, 4, "System"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Notes"), TYPE_TEXT, true, 5, "Card Notes"));

	types->append(new Target("Driver's License"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Driver's License Number"), TYPE_INTEGER, true, 2,
			"Driver's License Number"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Date Issued"), TYPE_DATE, true, 3, "Date Issued"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Expiration Date"), TYPE_DATE, true, 4, "Expiration Date"));
	types->at(types->length() - 1)->fields.append(new TargetField(tr("URL"),
			TYPE_URL, true, 5, "URL"));
	types->at(types->length() - 1)->fields.append(new TargetField(
			tr("Password"), TYPE_PASSWORD, true, 6, "Password"));

	types->append(new Target("Others"));
	types->at(types->length() - 1)->listLoaded = true;
	types->at(types->length() - 1)->fields.append(new TargetField(tr(
			"Card Notes"), TYPE_TEXT, true, 2, "Card Notes"));
}

void eWallet::loadTypesAndFields() {
	if (types == NULL) {
		types = new QList<Target*> ;
	}

	Target * target;
	foreach(target, *types)
		{
			delete target;
		}
	types->clear();

	QList<Target *> typesTmp = dbManager->getTemplates();

	for (int i = 0; i < typesTmp.size(); i++) {
		Target * t = typesTmp.at(i);
		types->append(t);

		qDebug() << "detecting type " << t->name;

		dbManager->getTemplateFields(t);
	}
}

void eWallet::keyPressEvent(QKeyEvent* event) {
	//qDebug()<<"key pressed " << event->key();

	if (!isAskPassword && searchField != NULL) {
		if (searchField->isHidden()) {
			//			if (event->key () == Qt::Key_Left || event->key () == Qt::Key_Right ) {
			//				changeMode();
			//				event->accept();
			//			}
			//			else {
			cancelSearch->show();
			searchField->show();
			hideSearch->show();
			searchField->setFocus();

			QCoreApplication::sendEvent(searchField, event);
			event->accept();
			//			}
		} else {
			QWidget::keyPressEvent(event);//event->accept();
		}
	} else {
		QWidget::keyPressEvent(event);//event->accept();
	}
	//timer->stop();
	//timer->start(5000);
}

bool sortTargetsASC(const Target * f, const Target * g) {
	return f->name.toLower() < g->name.toLower();
}
bool sortTargetsDES(const Target * f, const Target * g) {
	return f->name.toLower() > g->name.toLower();
}
bool sortStringASC(const QString f, const QString g) {
	return f.toLower() < g.toLower();
}
bool sortStringDES(const QString f, const QString g) {
	return f.toLower() > g.toLower();
}

QPixmap eWallet::getImage(Target * target) {
	QPixmap image;
	if (target->getPictureSmall() != NULL) {
		image = QPixmap::fromImage(*target->getPictureSmall());

		// at this moment we don't need anymore original images!
		target->freeResources();
	} else {
		QString tmp = ":/resources/empty_";
		tmp += target->type.simplified().replace(' ', '_');
		tmp += ".png";

		if (QResource(tmp).isValid()) {
			image = QPixmap(tmp);
		} else {
			image = QPixmap(":/resources/empty_Others.png");
		}
	}
	return image;
}

void eWallet::showGroups(bool reset) {
	//qDebug () << "show Groups " << reset;

	int current = fnListWidget->currentRow();

	// Clean previous items from the layout
	fnListWidget->clear();

	if (reset) {
		grouplist.clear();
		grouplist = ::dbManager->getGroups();
	}

	if (ascSort)
		qSort(grouplist.begin(), grouplist.end(), sortStringASC);
	else
		qSort(grouplist.begin(), grouplist.end(), sortStringDES);

	//	fnListWidget->setIconSize (QSize (SMALL_WIDTH, SMALL_HEIGH));
	//	fnListWidget->setContentsMargins(10, 1, 0, 1);

	QListWidgetItem* listitem = new QListWidgetItem(tr("<All>"));

	//listitem->set(target->getSummary());
	fnListWidget->addItem(listitem);

	for (int i = 0; i < grouplist.size(); i++) {
		QString target = grouplist.at(i);

		QListWidgetItem * listitem;
		if (target.length() == 0) {
			listitem = new QListWidgetItem(tr("<No Group>"));
		} else {
			listitem = new QListWidgetItem(target);
		}
		//listitem->set(target->getSummary());
		fnListWidget->addItem(listitem);
	}

	filterBy(currentFilter);

	if (current >= 0 && current <= grouplist.size())
		fnListWidget->setCurrentRow(current);
	else
		fnListWidget->setCurrentRow(0);

	update();
}

void eWallet::showInfo(bool reset) {
	if (isShowGroups == 1) {
		//backButton->hide();
		showGroups(reset);
	} else {
		showTargets(reset, currentGroup);
	}
}

void eWallet::showTargets(bool reset, const QString * filter) {
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
	//qDebug () << "show Targets " << reset;

	int current = fnListWidget->currentRow();

	//#ifdef Q_WS_MAEMO_5
	//	show_banner (this, tr("Loading data, please wait"));
	//#endif

	//QApplication::instance()->processEvents();

	// Clean previous items from the layout
	fnListWidget->clear();

	if (reset) {
		Target * target;
		foreach(target, list)
			{
				delete target;
			}
		//            for (int i = 0; i < list.size (); i++) {
		//                    Target * target = list.at(i);
		//                    delete target;
		//                }
		list.clear();
		list = ::dbManager->getTargets(filter);
	}

	if (ascSort)
		qSort(list.begin(), list.end(), sortTargetsASC);
	else
		qSort(list.begin(), list.end(), sortTargetsDES);

	fnListWidget->setIconSize(QSize(SMALL_WIDTH, SMALL_HEIGH));
	//fnListWidget->setContentsMargins(10, 1, 0, 1);

	for (int i = 0; i < list.size(); i++) {
		Target * target = list.at(i);

		QListWidgetItem* listitem = new QListWidgetItem(getImage(target),
				target->getName());
		//listitem->set(target->getSummary());
		fnListWidget->addItem(listitem);

	}

	filterBy(currentFilter);

	if (current >= 0 && current <= list.size())
		fnListWidget->setCurrentRow(current);
	else
		fnListWidget->setCurrentRow(0);

	update();

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void eWallet::createMenu() {
	//qDebug () << "create Menu " << isAskPassword;
#ifdef Q_WS_MAEMO_5
	menuBar()->clear();
	if (isAskPassword) {
		menuBar()->addAction(tr("About"), this, SLOT(about()));
#ifdef OPEN_SOURCE_VERSION
		if (!isChangingPassword) {
			menuBar()->addAction(tr("Delete DB"), this, SLOT(deleteDB()));
		}
#endif
		menuBar()->addAction(tr("Options"), this, SLOT(options()));
		menuBar()->addAction(tr("Exit"), QApplication::instance(), SLOT(quit()));
	}
	else {
		menuBar()->addAction(tr("New"), this, SLOT(newTarget()));
		if (isShowGroups == 2) {
			menuBar()->addAction(tr("Edit"), this, SLOT(_editcTarget()));
		}
		menuBar()->addAction(tr("Invert Sort"), this, SLOT(sort()));
		menuBar()->addAction(tr("Import"), this, SLOT(import()));
		menuBar()->addAction(tr("Export"), this, SLOT(exportData()));
#ifndef OPEN_SOURCE_VERSION
		menuBar()->addAction(tr("Export Xml"), this, SLOT(exportXml()));
		menuBar()->addAction(tr("Import Xml"), this, SLOT(importXml()));
		menuBar()->addAction(tr("Merge DB"), this, SLOT(mergeDB()));
#endif
		//menuBar()->addAction(tr("Change View"), this, SLOT(changeMode()));
		menuBar()->addAction(tr("Change Password"), this, SLOT(changePassword()));
#ifndef OPEN_SOURCE_VERSION
		menuBar()->addAction(tr("Templates"), this, SLOT(editTemplates()));
#endif
		menuBar()->addAction(tr("Options"), this, SLOT(options()));
		menuBar()->addAction(tr("About"), this, SLOT(about()));
		menuBar()->addAction(tr("Exit"), QApplication::instance(), SLOT(quit()));
	}
#else
	menuBar()->clear();
	if (isAskPassword) {
		menuBar()->addAction(tr("Exit"), QApplication::instance(), SLOT(quit()));
		menuBar()->addAction(tr("About"), this, SLOT(about()));
		//		if (!isChangingPassword) {
		//			menuBar()->addAction(tr("Delete DB"), this, SLOT(deleteDB()));
		//		}
	} else {
		QMenu * m = menuBar()->addMenu(tr("Card"));
		m->addAction(tr("New"), this, SLOT(newTarget()));
		if (isShowGroups == 2)
			m->addAction(tr("Edit"), this, SLOT(_editcTarget()));
		m->addSeparator();
		m->addAction(tr("Invert Sort"), this, SLOT(sort()));
		m->addSeparator();
		m->addAction(tr("Change Password"), this, SLOT(changePassword()));
		m->addSeparator();
		m->addAction(tr("Import"), this, SLOT(import()));
		m->addAction(tr("Export"), this, SLOT(exportData()));
#ifndef OPEN_SOURCE_VERSION
		m->addAction(tr("Export Xml"), this, SLOT(exportXml()));
		m->addSeparator();
		m->addAction(tr("Merge DB"), this, SLOT(mergeDB()));
		m->addSeparator();
#endif
		m->addAction(tr("Options"), this, SLOT(options()));
#ifndef OPEN_SOURCE_VERSION
		m->addAction(tr("Templates"), this, SLOT(editTemplates()));
#endif
		m->addSeparator();
		menuBar()->addAction(tr("Exit"), QApplication::instance(), SLOT(quit()));
		menuBar()->addAction(tr("About"), this, SLOT(about()));
		//menuBar()->addAction(tr("Change View"), this, SLOT(changeMode()));
	}
#endif
}

void eWallet::sort() {
	ascSort = !ascSort;
	showInfo(false);
}

bool eWallet::__insertTarget(Target* target) {
	preProcessImage(target->picture);
	preProcessImage(target->pictureBack);

	if (::dbManager->insertTarget(target)) {
		////qDebug () << "Adding new item";
		::dbManager->updateFields(target);

		target->freeFieldList();
		return true;
	}
	return false;
}

bool eWallet::_insertTarget(Target* target) {
	if (__insertTarget(target)) {
		if (isShowGroups == 2) {
			list.append(target);

			if (ascSort)
				qSort(list.begin(), list.end(), sortTargetsASC);
			else
				qSort(list.begin(), list.end(), sortTargetsDES);

			QListWidgetItem* listitem = new QListWidgetItem(getImage(target),
					target->name);

			int pos = list.indexOf(target);
			qDebug() << "position of new " << pos << " OF " << list.size();

			if (pos < list.size()) {
				qDebug() << "insert position of new " << pos << " OF "
						<< list.size();
				fnListWidget->insertItem(pos, listitem);
			} else {
				qDebug() << "append position of new " << pos << " OF "
						<< list.size();
				fnListWidget->addItem(listitem);
			}
			fnListWidget->setCurrentItem(listitem);
		} else {
			showGroups(true);
		}
		return true;
	}
	return false;
}
bool eWallet::_deleteTarget(Target* target) {
	if (messageBox.isNull()) {
		messageBox = new QMessageBox(this);
		int b = messageBox->information(this, "Wallet", tr(
				"Are you sure you want to remove it?"), QMessageBox::Yes,
				QMessageBox::No);
		if (b != QMessageBox::Yes) {
			delete messageBox;
			messageBox = 0;

			return false;
		}
	}
	delete messageBox;
	messageBox = 0;

	if (::dbManager->deleteTarget(target)) {
		if (isShowGroups == 2) {
			int i = list.indexOf(target);
			//qDebug () << "DELETE ON " << i;
			//qDebug () << "trying to remove " << i;
			list.removeAt(i);

			//qDebug () << "trying to takeItem " << i;
			fnListWidget->takeItem(i); //oveItem (row);
			//qDebug () << "delete " << i;
		}
		//		target->freeFieldList();
		//		target->freeResources();
		//		delete target;
		delete target;
		return true;
	}
	return false;
}
bool eWallet::_updateTarget(Target* target) {
	////qDebug () << "UPDATE ON " << i;

	if (::dbManager->updateTarget(target)) {
		::dbManager->updateFields(target);

		target->freeFieldList();

		if (isShowGroups == 2) {
			int i = list.indexOf(target);
			QListWidgetItem* listitem = fnListWidget->item(i);

			// check if the group has been changed
			bool changedGroup = false;
			if (list.length() > 1) {
				if (i > 1)
					changedGroup = target->groupName
							!= list.at(i - 1)->groupName;
				else
					changedGroup = target->groupName
							!= list.at(i + 1)->groupName;
			} else {
				// TODO detect that group has been changed and reload all group!!!!

			}

			qDebug() << "group has been changed !!!!" << changedGroup;

			listitem->setText(target->name);

			if (changedGroup) {
				// TODO sure!!! delete items?
				list.takeAt(i);
				fnListWidget->takeItem(i);
			} else {
				if (list.length() > 1) {
					if (ascSort)
						qSort(list.begin(), list.end(), sortTargetsASC);
					else
						qSort(list.begin(), list.end(), sortTargetsDES);

					int pos = list.indexOf(target);
					qDebug() << "position of new " << pos << " OF "
							<< list.size();

					if (i != pos) {
						fnListWidget->takeItem(i);
						if (pos < i) {
							fnListWidget->insertItem(pos, listitem);
						} else {
							if (pos < list.size()) {
								qDebug() << "insert position of new " << pos
										<< " OF " << list.size();
								fnListWidget->insertItem(pos, listitem);
							} else {
								qDebug() << "append position of new " << pos
										<< " OF " << list.size();
								fnListWidget->addItem(listitem);
							}
						}
					}
				}
				fnListWidget->setCurrentItem(listitem);
			}
		} else {
			showGroups(true);
		}
		return true;
	}
	return false;
}

bool eWallet::_updateTargetPicture(Target* target) {
	////qDebug () << "UPDATE ON " << i;
	preProcessImage(target->picture);

	if (::dbManager->updateTargetPicture(target)) {
		if (isShowGroups == 2) {
			int i = list.indexOf(target);
			QListWidgetItem* listitem = fnListWidget->item(i);
			listitem->setIcon(getImage(target));
		}
		return true;
	}
	return false;
}
bool eWallet::_updateTargetPictureBack(Target* target) {
	preProcessImage(target->pictureBack);

	if (::dbManager->updateTargetPictureBack(target)) {
		return true;
	}
	return false;
}

void eWallet::deleteTarget(Target * target) {
	if (_deleteTarget(target)) {
		//delete target;
	}
}

void eWallet::windowDestroyedExtra(QObject* obj) {
	disconnect(obj, SIGNAL(destroyed(QObject*)), this,
			SLOT(windowDestroyedExtra(QObject*)));

	delete extraWindow;
	extraWindow = 0;

	//qDebug () << "WINDOW DESTROYED YES";

	showGroups(true);
}

void eWallet::windowDestroyedTemplates(QObject* obj) {
	disconnect(obj, SIGNAL(destroyed(QObject*)), this,
			SLOT(windowDestroyedTemplates(QObject*)));

	loadTypesAndFields();

	delete templatesWindow;
	templatesWindow = 0;
}

void eWallet::windowDestroyed(QObject* obj) {
	disconnect(obj, SIGNAL(destroyed(QObject*)), this,
			SLOT(windowDestroyed(QObject*)));

	delete detailWindow;
	detailWindow = 0;
}
void eWallet::windowDestroyedEdit(QObject* obj) {
	disconnect(obj, SIGNAL(destroyed(QObject*)), this,
			SLOT(windowDestroyedEdit(QObject*)));

	delete detailWindowEdit;
	detailWindowEdit = 0;

	if (isShowGroups == 1) {
		showGroups(true);
	} else {
		grouplist.clear();
		grouplist = ::dbManager->getGroups();

		if (grouplist.size() >= 1 && isFirst) {
			if (grouplist.size() > 1 || grouplist.at(0).length() > 0) {
				isShowGroups = 1;
				showGroups(true);
			}
		}
	}

}

void eWallet::viewTarget(Target * rent) {
#ifndef Q_WS_MAEMO_5
	if (!(detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!detailWindow.isNull())
			detailWindow->raise();
		else if (!detailWindowEdit.isNull())
			detailWindowEdit->raise();
		return;
	}
#endif
	dbManager->getFields(rent);

	if (detailWindow.isNull()) {
		detailWindow = new DetailWindow(rent, "", 0, false, this, this);

		connect(detailWindow, SIGNAL(editTarget(Target*)), this,
				SLOT(editTarget(Target*)));
		connect(detailWindow, SIGNAL(newLikeTarget(Target*)), this,
				SLOT(newLikeTarget(Target*)));
		connect(detailWindow, SIGNAL(duplicateTarget(Target*)), this,
				SLOT(duplicateTarget(Target*)));
		connect(detailWindow, SIGNAL(newTarget()), this, SLOT(newTarget()));

		detailWindow->setAttribute(Qt::WA_DeleteOnClose);
		connect(detailWindow, SIGNAL(destroyed(QObject*)), this,
				SLOT(windowDestroyed(QObject*)));
		//detailWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
		detailWindow->show(); //owMaximized();
	}
}

void eWallet::import() {
	QString path(QDesktopServices::storageLocation(
			QDesktopServices::HomeLocation));
	QString s = QFileDialog::getOpenFileName(this, tr("Choose import file"),
			path, tr("Text files (*.txt);;"));

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

	if (!s.isNull() && !s.isEmpty()) {
		QFile file(s);
		QString line;

		Target * target = NULL;
		if (file.open(QIODevice::Text | QIODevice::ReadOnly)) {
			// file opened successfully
			QTextStream t(&file); // use a text stream
			// until end of file...
			int i = 0;
			while (!t.atEnd()) {
				// read and parse the command line
				QString line = t.readLine(); // line of text excluding '\n'
				// do something with the line

				if (line.length() > 0) {
					if (target == NULL) {
						target = new Target();
					}

					int j = line.indexOf(QChar(':'));
					if (j > 0) {
						switch (i++) {
						case 0:
							target->name = line.mid(j + 1).trimmed();
							break;
						case 1:
							target->groupName = line.mid(j + 1).trimmed();
							break;
						case 2:
							// TODO check type with existing one!
							target->type = line.mid(j + 1).trimmed();
							break;
						default:
							TargetField * field = new TargetField();

							int jj = line.mid(0, j).indexOf(QChar(';'));
							if (jj >= 0) {
								field->name = line.mid(0, jj).trimmed();

								int type = TYPE_STRING;
								switch (line.at(jj + 1).toAscii()) {
								case 'T':
									type = TYPE_TEXT;
									break;
								case 'D':
									type = TYPE_DATE;
									break;
								case 'U':
									type = TYPE_URL;
									break;
								case 'P':
									type = TYPE_PASSWORD;
									break;
								case 'N':
									type = TYPE_INTEGER;
									break;
								case 'H':
									type = TYPE_PHONE_NUMBER;
									break;
								case 'I':
									type = TYPE_IMAGE;
									break;
								case 'S':
								default:
									type = TYPE_STRING;
								}
								field->type = type;
							} else {
								field->name = line.mid(0, j).trimmed();

								//							  if (field->name.contains("url", Qt::CaseInsensitive)) {
								//								  field->type = TYPE_URL;
								//							  }
								//							  else
								//							  if (field->name.contains("password", Qt::CaseInsensitive)) {
								//								  field->type = TYPE_PASSWORD;
								//							  }
								//							  else
								//							  if (field->name.contains("pin", Qt::CaseInsensitive)) {
								//								  field->type = TYPE_PASSWORD;
								//							  }
								//							  else
								//							  if (field->name.contains("phone", Qt::CaseInsensitive)) {
								//								  field->type = TYPE_PHONE_NUMBER;
								//							  }
								//							  else
								//							  if (field->name.contains("number", Qt::CaseInsensitive)) {
								//								  field->type = TYPE_INTEGER;
								//							  }
								//							  else
								//							  if (field->name.contains("date", Qt::CaseInsensitive)) {
								//								  field->type = TYPE_DATE;
								//							  }
								//							  else
								//							  if (field->name.contains("note", Qt::CaseInsensitive)) {
								//								  field->type = TYPE_TEXT;
								//							  }
								//							  else
								field->type = TYPE_STRING;
							}
							// TODO TYPE_IMAGE
							field->value = line.mid(j + 1).trimmed();
							field->order = 10 * (i - 3);
							field->encrypted = true;

							target->fields.append(field);
						}

						////qDebug () << line << " | " << line.mid(j + 1) << " IS " << line.mid (0, j);
					} else {
						if (target != NULL && target->fields.size() > 0) {
							target->fields.last()->value.append("\n").append(
									line);
							target->fields.last()->type = TYPE_TEXT;
						}
					}
				} else {
					if (target != NULL) {
						{
							QString imgPath = QFileInfo(s).absolutePath();
							imgPath += "/";
							imgPath += target->name.simplified().replace(' ',
									'_');
							imgPath += ".png";

							//qDebug () << "checking image " << imgPath;

							QFile imgFile(imgPath);
							if (imgFile.exists()) {
								QImage * currentImageN = new QImage();
								DetailWindow::loadImage(settings, imgPath,
										*currentImageN); //;
								target->setPicture(currentImageN);

								//::dbManager->updateTargetPicture (target);
							}
						}
						{
							QString imgPath = QFileInfo(s).absolutePath();
							imgPath += "/";
							imgPath += target->name.simplified().replace(' ',
									'_');
							imgPath += "_BACK.png";

							//qDebug () << "checking image " << imgPath;

							QFile imgFile(imgPath);
							if (imgFile.exists()) {
								QImage * currentImageN = new QImage();
								DetailWindow::loadImage(settings, imgPath,
										*currentImageN); //;
								target->setPictureBack(currentImageN);

								//::dbManager->updateTargetPictureBack (target);
							}
						}
						this->__insertTarget(target);
					}
					target = NULL;
					i = 0;
				}

				QApplication::instance()->processEvents();

				////qDebug () << line;
			}

			if (target != NULL) {
				{
					QString imgPath = QFileInfo(s).absolutePath();
					imgPath += "/";
					imgPath += target->name.simplified().replace(' ', '_');
					imgPath += ".png";

					//qDebug () << "checking image " << imgPath;

					QFile imgFile(imgPath);
					if (imgFile.exists()) {
						QImage * currentImageN = new QImage();
						DetailWindow::loadImage(settings, imgPath,
								*currentImageN); //;
						target->setPicture(currentImageN);

						//::dbManager->updateTargetPicture (target);
					}
				}
				{
					QString imgPath = QFileInfo(s).absolutePath();
					imgPath += "/";
					imgPath += target->name.simplified().replace(' ', '_');
					imgPath += "_BACK.png";

					//qDebug () << "checking image " << imgPath;

					QFile imgFile(imgPath);
					if (imgFile.exists()) {
						QImage * currentImageN = new QImage();
						DetailWindow::loadImage(settings, imgPath,
								*currentImageN); //;
						target->setPictureBack(currentImageN);

						//::dbManager->updateTargetPictureBack (target);
					}
				}
				this->__insertTarget(target);
			}
			// Close the file
			file.close();

			showInfo(true);
		}
	}
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void eWallet::renameGroup() {

	if (fnListWidget->currentRow() > 0) {
		QString target = grouplist.at(fnListWidget->currentRow() - 1);

		RenameGroupDialog * dialog = new RenameGroupDialog(this);
		dialog->setName(target);
		if (dialog->exec() == QDialog::Accepted) {
			QString newName = dialog->getName();

			//qDebug () << "NEW GROUP NAME " << target << " TO " << newName;

			if (::dbManager->renameGroup(target, newName)) {
				grouplist.clear();
				grouplist = ::dbManager->getGroups();

				if (grouplist.size() > 1) {
					showGroups(false);
				} else {
					if (grouplist.size() == 1 && grouplist.at(0).length() > 0) {
						showGroups(false);
					} else {
						isShowGroups = 2;
						showTargets(true, NULL);
					}
				}
			}
		}
		delete dialog;

	}
}

void eWallet::deleteGroup() {
	if (fnListWidget->currentRow() > 0) {
		QString target = grouplist.at(fnListWidget->currentRow() - 1);

		if (::dbManager->deleteGroup(target)) {
			grouplist.clear();
			grouplist = ::dbManager->getGroups();

			if (grouplist.size() > 1) {
				showGroups(false);
			} else {
				if (grouplist.size() == 1 && grouplist.at(0).length() > 0) {
					showGroups(false);
				} else {
					isShowGroups = 2;
					showTargets(true, NULL);
				}
			}
		}

	}
}

void eWallet::contextMenuEvent(QContextMenuEvent * event) {
	//qDebug () << "Should be show " << this->childAt(event->globalPos());
	if (isAskPassword) {

	} else {
		if (isShowGroups == 1) {
			if (fnListWidget->currentRow() > 0) {
				QMenu menu(this);
				//menu.addAction(tr("View"), this, SLOT(_viewcTarget()));
				menu.addAction(tr("Rename"), this, SLOT(renameGroup()));
				menu.addAction(tr("Delete"), this, SLOT(deleteGroup()));
				menu.exec(event->globalPos());
			}
		} else {
			if (fnListWidget->currentRow() >= 0) {
				//Target * target = list.at(fnListWidget->currentRow());

				QMenu menu(this);
				menu.addAction(tr("View"), this, SLOT(_viewcTarget()));
				menu.addAction(tr("Edit"), this, SLOT(_editcTarget()));
				menu.addAction(tr("New like this"), this,
						SLOT(_newLikeTarget()));
				menu.addAction(tr("Duplicate"), this, SLOT(_duplicateTarget()));
				menu.addAction(tr("Delete"), this, SLOT(_deletecTarget()));
				menu.exec(event->globalPos());
			}
		}
	}
}

void eWallet::exportData() {
	QString path(QDesktopServices::storageLocation(
			QDesktopServices::HomeLocation));

	path.append("/wallet_export.txt");

	QString s = QFileDialog::getSaveFileName(this, tr("Choose export file"),
			path, tr("Text files (*.txt);;"));

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
	if (!s.isNull() && !s.isEmpty()) {
		if (!s.endsWith(".txt"))
			s.append(".txt");

		QFile file(s);

		if (file.open(QIODevice::Text | QIODevice::WriteOnly)) {
			// file opened successfully
			QTextStream t(&file); // use a text stream

			QList<Target *> list = ::dbManager->getTargets(NULL);

			for (int i = 0; i < list.size(); i++) {
				Target * target = list[i];

				QImage * img = target->getPicture();

				if (img != NULL) {
					QString imgPath = QFileInfo(s).absolutePath();
					imgPath += "/";
					imgPath += target->name.simplified().replace(' ', '_');
					imgPath += ".png";

					//qDebug () << "exporting image " << imgPath;

					img->save(imgPath, "PNG"); // writes image into ba in PNG format
				}

				img = target->getPictureBack();

				if (img != NULL) {
					QString imgPath = QFileInfo(s).absolutePath();
					imgPath += "/";
					imgPath += target->name.simplified().replace(' ', '_');
					imgPath += "_BACK.png";

					//qDebug () << "exporting back image " << imgPath;

					img->save(imgPath, "PNG"); // writes image into ba in PNG format
				}

				t << "Name: " << target->name << "\n";
				t << "Group Name: " << target->groupName << "\n";
				t << "Type: " << target->type << "\n";

				dbManager->getFields(target);

				TargetField * field;
				foreach(field, target->fields)
					{
						switch (field->type) {
						case TYPE_TEXT:
							t << field->name << ";T: " << field->value << "\n";
							break;
						case TYPE_DATE:
							t << field->name << ";D: " << field->value << "\n";
							break;
						case TYPE_URL:
							t << field->name << ";U: " << field->value << "\n";
							break;
						case TYPE_PASSWORD:
							t << field->name << ";P: " << field->value << "\n";
							break;
						case TYPE_INTEGER:
							t << field->name << ";N: " << field->value << "\n";
							break;
						case TYPE_PHONE_NUMBER:
							t << field->name << ";H: " << field->value << "\n";
							break;
						case TYPE_IMAGE:
							t << field->name << ";I: " << field->value << "\n"; // TODO
							break;
						case 'S':
						default:
							t << field->name << ": " << field->value << "\n";
						}
					}

				t << "\n\n";

				target->freeFieldList();
				target->freeResources();

				QApplication::instance()->processEvents();

				delete target;
			}

			//                        Target * target;
			//                        foreach(target, list) {
			//                                delete target;
			//                        }

			list.clear();

			// Close the file
			file.close();
		}
	}
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

//QByteArray FIX_VALUE (QString a) {
//	// TODO escape characters
//	return Qt::escape(a).toUtf8();
//}

void eWallet::mergeDB() {
	QString path(QDesktopServices::storageLocation(
			QDesktopServices::HomeLocation));
	QString s = QFileDialog::getOpenFileName(this, tr("Choose DB file"), path,
			tr("DB files (*.sqlite);;"));

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

	if (!s.isNull() && !s.isEmpty()) {
		QFile file(s);

		QString res = ::dbManager->mergeDB(s, tempPass);

		qDebug() << "finish merge " << res;

		showInfo(true);
	}

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void eWallet::importXml() {
	QString path(QDesktopServices::storageLocation(
			QDesktopServices::HomeLocation));

	path.append("/wallet_export.xml");

	QString s = QFileDialog::getOpenFileName(this, tr("Choose import file"),
			path, tr("Text files (*.xml);;"));

	bool update = false;

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

	if (!s.isNull() && !s.isEmpty()) {
		if (!s.endsWith(".xml"))
			s.append(".xml");

		QFile file(s);

		if (file.open(QIODevice::Text | QIODevice::ReadOnly)) {
			QXmlStreamReader xml;
			xml.setDevice(&file);
			if (!xml.atEnd()) {
				xml.readNext();
				if (xml.isStartDocument()) {
					qDebug() << "START " << xml.name().toString();
					xml.readNext();
					if (xml.isStartElement()) {
						QString sec(xml.name().toString());
						if (QString("targets").compare(sec,
								Qt::CaseInsensitive) == 0) {
							qDebug() << "START ff " << xml.name().toString();
							Target * t = NULL;
							while (xml.readNextStartElement()) {
								QString sec(xml.name().toString());
								if (QString("target").compare(sec,
										Qt::CaseInsensitive) == 0) {
									qDebug() << "START fff "
											<< xml.name().toString();
									t = new Target;
									int order = 0;
									while (xml.readNextStartElement()) {
										//xml.readNext();
										QString sec(xml.name().toString());
										QXmlStreamAttributes attrs = xml.attributes();
										QString content = xml.readElementText().trimmed();
										qDebug() << "START " << sec;
										if (QString("id").compare(sec,
												Qt::CaseInsensitive) == 0) {
											if (update)
												t->id = content.toInt();
											else
												t->id = -1;
										} else if (QString("name").compare(sec,
												Qt::CaseInsensitive) == 0) {
											t->name = content;
										} else if (QString("groupName").compare(
												sec, Qt::CaseInsensitive) == 0) {
											t->groupName = content;
										} else if (QString("type").compare(sec,
												Qt::CaseInsensitive) == 0) {
											t->type = content;
										} else if (QString("image").compare(
												sec, Qt::CaseInsensitive) == 0) {
											QImage * image = new QImage;
											if (!image->loadFromData(
													QByteArray::fromBase64(
															content.toAscii()))) {
											}
											t->setPicture(image);
										} else if (QString("backImage").compare(
												sec, Qt::CaseInsensitive) == 0) {
											QImage * image = new QImage;
											if (!image->loadFromData(
													QByteArray::fromBase64(
															content.toAscii()))) {
											}
											t->setPictureBack(image);
										} else if (QString("creationTime").compare(sec, Qt::CaseInsensitive) == 0) {
											t->creationdate = content;
										} else if (QString("modificationTime").compare(sec, Qt::CaseInsensitive) == 0) {
											t->modificationdate = content;
										} else if (QString("field").compare(sec, Qt::CaseInsensitive) == 0) {
											QString name;
											QString _type;
											for (int i = 0; i < attrs.size(); i++) {
												if (QString("name").compare(attrs.at(i).name().toString(), Qt::CaseInsensitive) == 0) {
													name = attrs.at(i).value().toString();
												}
												else
												if (QString("type").compare(attrs.at(i).name().toString(), Qt::CaseInsensitive) == 0) {
													_type = attrs.at(i).value().toString();
												}
											}
//											QString name = attrs.value("name").toString();
//											QString _type = attrs.value("type").toString();

											qDebug () << " FIeLD " << name << " " << _type;

											int type = TYPE_STRING;
											switch (_type.at(0).toAscii()) {
											case 'T':
												type = TYPE_TEXT;
												break;
											case 'D':
												type = TYPE_DATE;
												break;
											case 'U':
												type = TYPE_URL;
												break;
											case 'P':
												type = TYPE_PASSWORD;
												break;
											case 'N':
												type = TYPE_INTEGER;
												break;
											case 'H':
												type = TYPE_PHONE_NUMBER;
												break;
											case 'I':
												type = TYPE_IMAGE;
												break;
											case 'S':
											default:
												type = TYPE_STRING;
											}

											TargetField * tf = new TargetField(name, type, true, ++order);
											tf->value = content;
											t->fields.append(tf);
										} else {
											qDebug() << "invalid node " << sec;
										}
									}

									if (update)
										__insertTarget(t);
									else
										__insertTarget(t);

									t->freeFieldList();
									t->freeResources();
									delete t;

									QApplication::instance()->processEvents();

									if (!xml.isEndElement()) {

										break;
									}
								} else {
									qDebug() << "invalid! "
											<< xml.name().toString();
								}

							}
						}
					}
				}
			}
		}
		file.close();
	}
	showInfo(true);
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void eWallet::exportXml() {
	QString path(QDesktopServices::storageLocation(
			QDesktopServices::HomeLocation));

	path.append("/wallet_export.xml");

	QString s = QFileDialog::getSaveFileName(this, tr("Choose export file"),
			path, tr("Text files (*.xml);;"));

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
	if (!s.isNull() && !s.isEmpty()) {
		if (!s.endsWith(".xml"))
			s.append(".xml");

		QFile file(s);

		if (file.open(QIODevice::Text | QIODevice::WriteOnly)) {
			// file opened successfully
			//QTextStream t(&file);        // use a text stream

			QList<Target *> list = ::dbManager->getTargets(NULL);

			QXmlStreamWriter stream(&file);

			stream.setAutoFormatting(true);
			stream.writeStartDocument();

			//		    t << "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
			//			t << "<targets>\n";
			stream.writeStartElement("targets");
			for (int i = 0; i < list.size(); i++) {
				Target * target = list[i];

				stream.writeStartElement("target");

				stream.writeStartElement("id");
				stream.writeCharacters(QString::number(target->id));
				stream.writeEndElement();

				stream.writeStartElement("name");
				stream.writeCharacters(target->name);
				stream.writeEndElement();

				stream.writeStartElement("groupName");
				stream.writeCharacters(target->groupName);
				stream.writeEndElement();

				stream.writeStartElement("type");
				stream.writeCharacters(target->type);
				stream.writeEndElement();

				//				t << "<target>\n";
				//				t << "<id>" << target->id << "</id>\n";
				//				t << "<name>" << FIX_VALUE(target->name) << "</name>\n";
				//				t << "<group>" << FIX_VALUE(target->groupName) << "</group>\n";
				//				t << "<type>" << FIX_VALUE(target->type) << "</type>\n";

				QImage * img = target->getPicture();

				if (img != NULL) {
					QByteArray im1;
					QBuffer buffer1(&im1);
					buffer1.open(QIODevice::WriteOnly);
					img->save(&buffer1, "PNG"); // writes image into ba in PNG format

					stream.writeStartElement("image");
					stream.writeCharacters(im1.toBase64());
					stream.writeEndElement();

					//					t << "<image>" << im1.toBase64() << "</image>\n";
				}

				img = target->getPictureBack();

				if (img != NULL) {
					QByteArray im1;
					QBuffer buffer1(&im1);
					buffer1.open(QIODevice::WriteOnly);
					img->save(&buffer1, "PNG"); // writes image into ba in PNG format

					stream.writeStartElement("backimage");
					stream.writeCharacters(im1.toBase64());
					stream.writeEndElement();
					//					t << "<backimage>" << im1.toBase64() << "</backimage>\n";
				}

				dbManager->getFields(target);

				TargetField * field;
				foreach(field, target->fields)
					{
						switch (field->type) {
						case TYPE_TEXT:
							stream.writeStartElement("field");
							//stream.writeAttribute("id", QString::number(field->id));
							stream.writeAttribute("name", field->name);
							stream.writeAttribute("type", "T");
							stream.writeCharacters(field->value);
							stream.writeEndElement();
							//							t << "<field id=\"" << field->id << "\" name=\"" << FIX_VALUE(field->name) << "\" type=\"T\">" << FIX_VALUE(field->value) << "</field>\n";
							break;
						case TYPE_DATE:
							stream.writeStartElement("field");
							//stream.writeAttribute("id", QString::number(field->id));
							stream.writeAttribute("name", field->name);
							stream.writeAttribute("type", "D");
							stream.writeCharacters(field->value);
							stream.writeEndElement();
							//								t << "<field id=\"" << field->id << "\" name=\"" << FIX_VALUE(field->name) << "\" type=\"D\">" << FIX_VALUE(field->value) << "</field>\n";
							break;
						case TYPE_URL:
							stream.writeStartElement("field");
							//stream.writeAttribute("id", QString::number(field->id));
							stream.writeAttribute("name", field->name);
							stream.writeAttribute("type", "U");
							stream.writeCharacters(field->value);
							stream.writeEndElement();
							//t << "<field id=\"" << field->id << "\" name=\"" << FIX_VALUE(field->name) << "\" type=\"U\">" << FIX_VALUE(field->value) << "</field>\n";
							break;
						case TYPE_PASSWORD:
							stream.writeStartElement("field");
							//stream.writeAttribute("id", QString::number(field->id));
							stream.writeAttribute("name", field->name);
							stream.writeAttribute("type", "P");
							stream.writeCharacters(field->value);
							stream.writeEndElement();
							//t << "<field id=\"" << field->id << "\" name=\"" << FIX_VALUE(field->name) << "\" type=\"P\">" << FIX_VALUE(field->value) << "</field>\n";
							break;
						case TYPE_INTEGER:
							stream.writeStartElement("field");
							//stream.writeAttribute("id", QString::number(field->id));
							stream.writeAttribute("name", field->name);
							stream.writeAttribute("type", "N");
							stream.writeCharacters(field->value);
							stream.writeEndElement();
							//t << "<field id=\"" << field->id << "\" name=\"" << FIX_VALUE(field->name) << "\" type=\"N\">" << FIX_VALUE(field->value) << "</field>\n";
							break;
						case TYPE_PHONE_NUMBER:
							stream.writeStartElement("field");
							//stream.writeAttribute("id", QString::number(field->id));
							stream.writeAttribute("name", field->name);
							stream.writeAttribute("type", "H");
							stream.writeCharacters(field->value);
							stream.writeEndElement();
							//t << "<field id=\"" << field->id << "\" name=\"" << FIX_VALUE(field->name) << "\" type=\"H\">" << FIX_VALUE(field->value) << "</field>\n";
							break;
						case TYPE_IMAGE:
							stream.writeStartElement("field");
							//stream.writeAttribute("id", QString::number(field->id));
							stream.writeAttribute("name", field->name);
							stream.writeAttribute("type", "I");
							stream.writeCharacters(field->value);
							stream.writeEndElement();
							//t << "<field id=\"" << field->id << "\" name=\"" << FIX_VALUE(field->name) << "\" type=\"I\">" << FIX_VALUE(field->value) << "</field>\n";
							break;
						case 'S':
						default:
							stream.writeStartElement("field");
							//stream.writeAttribute("id", QString::number(field->id));
							stream.writeAttribute("name", field->name);
							stream.writeCharacters(field->value);
							stream.writeEndElement();
							//								t << "<field id=\"" << field->id << "\" name=\"" << FIX_VALUE(field->name) << "\">" << FIX_VALUE(field->value) << "</field>\n";
						}
					}
				stream.writeStartElement("creationTime");
				stream.writeCharacters(target->creationdate);
				stream.writeEndElement();

				stream.writeStartElement("modificationTime");
				stream.writeCharacters(target->modificationdate);
				stream.writeEndElement();

				//				t << "<creationTime>" << target->creationdate << "</creationTime>\n";
				//				t << "<modificationTime>" << target->modificationdate << "</modificationTime>\n";
				//				t << "</target>\n";
				stream.writeEndElement();

				target->freeFieldList();
				target->freeResources();

				QApplication::instance()->processEvents();

				delete target;
			}
			stream.writeEndElement();
			stream.writeEndDocument();
			//			t << "</targets>\n";

			//                        Target * target;
			//                        foreach(target, list) {
			//                                delete target;
			//                        }
			list.clear();

			// Close the file
			file.close();
		}
	}
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void eWallet::editTarget(Target * target) {
#ifndef Q_WS_MAEMO_5
	if (!(detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!detailWindow.isNull())
			detailWindow->raise();
		else if (!detailWindowEdit.isNull())
			detailWindowEdit->raise();
		return;
	}
#endif

	dbManager->getFields(target);

	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(target, "", 0, true, this, this);
		//detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
		detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
		connect(detailWindowEdit, SIGNAL(destroyed(QObject*)), this,
				SLOT(windowDestroyedEdit(QObject*)));
		detailWindowEdit->show();
	}
}

void eWallet::duplicateTarget(Target * target) {
#ifndef Q_WS_MAEMO_5
	if (!(detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!detailWindow.isNull())
			detailWindow->raise();
		else if (!detailWindowEdit.isNull())
			detailWindowEdit->raise();
		return;
	}
#endif

	dbManager->getFields(target);

	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(target,
				currentGroup != NULL ? *currentGroup : "", 2, true, this, this);
		//detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
		detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
		connect(detailWindowEdit, SIGNAL(destroyed(QObject*)), this,
				SLOT(windowDestroyedEdit(QObject*)));
		detailWindowEdit->show();
	}
}

void eWallet::newLikeTarget(Target * target) {
#ifndef Q_WS_MAEMO_5
	if (!(detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!detailWindow.isNull())
			detailWindow->raise();
		else if (!detailWindowEdit.isNull())
			detailWindowEdit->raise();
		return;
	}
#endif
	dbManager->getFields(target);

	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(target,
				currentGroup != NULL ? *currentGroup : "", 1, true, this, this);
		//detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
		detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
		connect(detailWindowEdit, SIGNAL(destroyed(QObject*)), this,
				SLOT(windowDestroyedEdit(QObject*)));
		detailWindowEdit->show();
	}
}

void eWallet::editTemplates() {
#ifndef Q_WS_MAEMO_5
	if (!(detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!detailWindow.isNull())
			detailWindow->raise();
		else if (!detailWindowEdit.isNull())
			detailWindowEdit->raise();
		return;
	}
#endif
	if (templatesWindow.isNull()) {
		templatesWindow = new EditTemplates(this);
		templatesWindow->setAttribute(Qt::WA_DeleteOnClose);
		connect(templatesWindow, SIGNAL(destroyed(QObject*)), this,
				SLOT(windowDestroyedTemplates(QObject*)));
		templatesWindow->show();
	}
}

void eWallet::newTarget() {
#ifndef Q_WS_MAEMO_5
	if (!(detailWindow.isNull() && detailWindowEdit.isNull())) {
		if (!detailWindow.isNull())
			detailWindow->raise();
		else if (!detailWindowEdit.isNull())
			detailWindowEdit->raise();
		return;
	}
#endif
	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(NULL,
				currentGroup != NULL ? *currentGroup : "", 0, true, this, this);
		//detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
		detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
		connect(detailWindowEdit, SIGNAL(destroyed(QObject*)), this,
				SLOT(windowDestroyedEdit(QObject*)));
		detailWindowEdit->show();
	}
}

void eWallet::_newLikeTarget() {
	if (fnListWidget->currentRow() >= 0) {
		if (fnListWidget->isItemHidden(fnListWidget->item(
				fnListWidget->currentRow())))
			return;
		Target * target = list.at(fnListWidget->currentRow());
		newLikeTarget(target);
	}
}

void eWallet::_duplicateTarget() {
	if (fnListWidget->currentRow() >= 0) {
		if (fnListWidget->isItemHidden(fnListWidget->item(
				fnListWidget->currentRow())))
			return;
		Target * target = list.at(fnListWidget->currentRow());
		duplicateTarget(target);
	}
}

void eWallet::_editcTarget() {
	if (fnListWidget->currentRow() >= 0) {
		if (fnListWidget->isItemHidden(fnListWidget->item(
				fnListWidget->currentRow())))
			return;
		Target * target = list.at(fnListWidget->currentRow());
		editTarget(target);
	}
}
void eWallet::_deletecTarget() {
	if (fnListWidget->currentRow() >= 0) {
		if (fnListWidget->isItemHidden(fnListWidget->item(
				fnListWidget->currentRow())))
			return;
		Target * target = list.at(fnListWidget->currentRow());
		deleteTarget(target);
	}
}
void eWallet::_viewcTarget() {
	if (fnListWidget->currentRow() >= 0) {
		if (fnListWidget->isItemHidden(fnListWidget->item(
				fnListWidget->currentRow())))
			return;
		Target * target = list.at(fnListWidget->currentRow());
		viewTarget(target);
	}
}

void eWallet::closeEvent(QCloseEvent *event) {
	event->accept();
}

void eWallet::askPassword() {
	setContextMenuPolicy(Qt::NoContextMenu);

	times = 0;

	isAskPassword = true;
	isChangingPassword = false;
	isUnLockMode = false;
	createMenu();

	bool firstTime = !::dbManager->hasPassword();
#ifdef Q_WS_MAEMO_5
	if (firstTime) {
		show_information_note (this, tr("Please, enter a password for your wallet"));
	}
	else {
		show_banner (this, tr("Please, enter the password to unlock your wallet"));
	}
#endif

	if (loginDialogDlg.isNull()) {
		loginDialogDlg = new LoginDialog(firstTime, this);
		QObject::connect(loginDialogDlg, SIGNAL(finalWithPassword(QString)),
				this, SLOT(finalPassword(QString)));
		setCentralWidget(loginDialogDlg);
	}
	loginDialogDlg->focus();
}

void eWallet::hideN() {
	if (!detailWindowEdit.isNull()) {
		qDebug() << "hide edit";
		detailWindowEdit->hideN();
	}
	if (!detailWindow.isNull()) {
		qDebug() << "hide detail";
		detailWindow->hideN();
	}
	if (!extraWindow.isNull()) {
		qDebug() << "hide extra";
		extraWindow->hideN();
	}
	hide();
	//	if (!optionsDlg.isNull()) {
	//		optionsDlg->show ();
	//	}
	//    if (!templatesWindow.isNull()) {
	//    	templatesWindow->show();
	//    }
}
void eWallet::showN() {
	if (!extraWindow.isNull()) {
		qDebug() << "hide extra";
		extraWindow->showN();
	}
	if (!detailWindow.isNull()) {
		qDebug() << "hide detail";
		detailWindow->showN();
	}
	if (!detailWindowEdit.isNull()) {
		qDebug() << "hide edit";
		detailWindowEdit->showN();
	}
	show();
}

void eWallet::askAgainPassword() {
	setContextMenuPolicy(Qt::NoContextMenu);

	times = 0;

	isAskPassword = true;
	isChangingPassword = false;
	isUnLockMode = true;
	createMenu();

	qDebug() << "askAgainPassword";

#ifdef Q_WS_MAEMO_5
	show_banner (this, tr("Please, enter the password to unlock your wallet"));
#endif

	//if (loginDialogDlg.isNull()) {
	loginDialogDlg = new LoginDialog(false, this);
	QObject::connect(loginDialogDlg, SIGNAL(finalWithPassword(QString)), this,
			SLOT(finalUnlock(QString)));
	setCentralWidget(loginDialogDlg);
	//}
	loginDialogDlg->focus();

	show();
}

void eWallet::options() {
	if (optionsDlg.isNull()) {
		optionsDlg = new OptionsDialog(this);
		optionsDlg->setMinimumSize(size().width(), size().height() - 100);
		optionsDlg->exec();
	}
}

void eWallet::about() {
	this->setStyleSheet("QMessageBox QLabel :link { color: #FF0000; }");
#ifdef OPEN_SOURCE_VERSION
	QMessageBox::about(this, tr("About Wallet"), tr("<qt><br><br><p><i><b>qtWallet</b></i>, v.1.0</p>"
					"<p>Developed by <b>nowheremanmail@gmail.com</b></p>"
					"<p>Icons by http://pixelmixer.ru/</p>"
					"<p>if you think that qtWallet is useful for you, please</p>"
					"<a href=\"https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=nowheremanmail@gmail.com&lc=US&item_name=qtWallet&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHosted\">DONATE</a></qt>").arg(VERSION));
#else
	QMessageBox::about(this, tr("About Wallet"), tr(
			"<qt><br><br><p><i><b>Wallet</b></i>, v.%1</p>"
				"<p>Developed by <b>nowheremanmail@gmail.com</b></p>"
				"<p>Icons by http://pixelmixer.ru/</p>"
				"</qt>").arg(VERSION));
#endif

}

void eWallet::finalPassword(const QString pass) {
	bool res = openDataBase(pass);
	if (res) {
		loadTypesAndFields();
#ifdef Q_WS_MAEMO_5
		QDBusConnection conn = QDBusConnection::systemBus(); //QString(MCE_SERVICE), QString(MCE_SIGNAL_PATH)
		bool success = conn.connect("","", QString("com.nokia.mce.signal"/*MCE_SIGNAL_IF*/), QString("display_status_ind"/*MCE_DISPLAY_SIG*/) , this, SLOT(listenInactivity(QString)));
		//bool success = conn.connect("","", QString(MCE_SIGNAL_IF), QString(MCE_DISPLAY_SIG) , this, SLOT(listenInactivity(QString)));
#endif
	}
}

void eWallet::finalChangePassword(const QString pass) {
	reallyChangePassword(pass);
}

void eWallet::finalUnlock(const QString pass) {
	bool res = ::dbManager->validatePassword(pass);
	if (res) {
		qDebug() << "valid password " << res;

		showN();

		showList(true);
		showInfo(false);
	} else {
		qDebug() << "invalid password";
	}
}

void eWallet::preProcessImage(QImage * image) {
	if (image == NULL)
		return;

	QSettings settings;

	int h = settings.value("internalImage/HEIGH", _INTERNAL_HEIGH).toInt();
	int w = settings.value("internalImage/WIDTH", _INTERNAL_WIDTH).toInt();

	//QImage res QImage::scaled (const QSize & size, Qt::AspectRatioMode aspectRatioMode = Qt::IgnoreAspectRatio, Qt::TransformationMode transformMode = Qt::FastTransformation ) const
	//QSize imageSize = reader.size();
	qDebug() << "IMAGE SIZE " << image->width() << " " << image->height();

	if (image->height() > h || image->width() > w) {
		if (settings.value("internalImage/scale", true).toBool()) {
			QImage res;
			switch (settings.value("internalImage/aspect", 1).toInt()) {
			case 1:
				qDebug() << "scaling with keep aspect image";
				res = image->scaled(w, h, Qt::KeepAspectRatio,
						Qt::SmoothTransformation);
				break;
			case 2:
				qDebug() << "scaling with expanding aspect image";
				res = image->scaled(w, h, Qt::KeepAspectRatioByExpanding,
						Qt::SmoothTransformation);
				break;
			default:
				res = image->scaled(w, h, Qt::IgnoreAspectRatio,
						Qt::SmoothTransformation);
			}

			*image = res;
		}
	} else {
		// TODO
	}
}

void eWallet::changePassword() {
	times = 0;
	isChangingPassword = true;
	isAskPassword = true;

	createMenu();

	if (loginDialogDlg.isNull()) {
		loginDialogDlg = new LoginDialog(true, this);

		QObject::connect(loginDialogDlg, SIGNAL(finalWithPassword(QString)),
				this, SLOT(finalChangePassword(QString)));

		setCentralWidget(loginDialogDlg);
		setFocus();
		loginDialogDlg->setFocus();
		focusNextChild();
	}

}

class MyThread: public QThread {
public:
	QString p;
	QString newPassword;

	void run() {
		//sleep(2000);

		p = ::dbManager->changePassword(newPassword);
	}

};

void eWallet::reallyChangePassword(const QString & newPassword) {
	showList(false);

	//	QMessageBox * messageBox = new QMessageBox (this);
	//	messageBox->information(this, "Wallet", tr("Changing password, please wait until application quits"), QMessageBox::Ok);

	//show_information_note (NULL, tr("Changing password, please wait until application quits"));

#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

	MyThread t;
	t.newPassword = newPassword;
	t.start();
	//	t.wait ();

	while (t.isRunning()) {
#ifdef Q_WS_MAEMO_5
		show_banner (this, tr("Changing password, please wait until application quits"));
#endif
		QApplication::instance()->processEvents();
		t.wait(2000);
	}

	QString p = t.p; // ::dbManager->changePassword(newPassword);

#ifndef Q_WS_MAEMO_5
	QMessageBox * messageBox = new QMessageBox(this);
#endif
	if (p.length() == 0)
#ifndef Q_WS_MAEMO_5
		messageBox->information(this, "Wallet", tr(
				"Password changed successfully, application will exit"),
				QMessageBox::Ok);
#endif
#ifdef Q_WS_MAEMO_5
	show_information_note (this, tr("Password changed successfully, application will exit"));
#endif
	else {
#ifndef Q_WS_MAEMO_5
		messageBox->information(
				this,
				"Wallet",
				tr(
						"Password CANNOT BE changed, because %1, and application will exit").arg(
						p), QMessageBox::Ok);
#endif
#ifdef Q_WS_MAEMO_5
		show_information_note (this, tr("Password CANNOT BE changed, because %1, and application will exit").arg(p));
#endif
	}

	delete messageBox;

	//delete ::dbManager;
	//exit (3);
#ifdef Q_WS_MAEMO_5
	this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif

	::dbManager->close();
	openDataBase(newPassword);

	//	::dbManager->lock ();
	//	askPassword ();
}

