/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#include "eWallet.h"
#include "DatabaseManager.h"
#include <Qt>
#include <QFile>
#ifdef Q_WS_MAEMO_5
//#include <QtMaemo5/QMaemo5KineticScroller>
#endif

DatabaseManager * dbManager;

eWallet::eWallet(QWidget *parent) :
		QMainWindow(parent)
{
	::dbManager = new DatabaseManager(this);

	askPassword ();
	
	setProperty("FingerScrollable", false);
	//setContextMenuPolicy(Qt::NoContextMenu);

	loadTypesAndFields ();

	//                         // Central widget and Layout
	centralWidget = new QWidget(this);

	setContextMenuPolicy(Qt::DefaultContextMenu);
	centralWidget->setContextMenuPolicy(Qt::DefaultContextMenu);

	vboxlayout = new QVBoxLayout;
	vboxlayout->setSpacing(0);
	vboxlayout->setMargin(0);
	// Custom list box
	fnListWidget = new QFNListWidget(this);
	vboxlayout->addWidget(fnListWidget);

	showTargets ();

	centralWidget->setLayout(vboxlayout);
	setCentralWidget(centralWidget);

	createMenu ();

	centralWidget->setFocus ();
	

	timer = new QTimer(this);
	//TODO connect(timer, SIGNAL(timeout()), this, SLOT(lockWallet()));
    //TODO timer->start(5000);
}

void eWallet::lockWallet () {
	::dbManager->lock ();
	askPassword ();
}

bool eWallet::openDataBase (QString pas)
{
	return ::dbManager->openDB(pas);
}

eWallet::~eWallet ()
{
	delete ::dbManager;
}

void eWallet::loadTypesAndFields () {
	  QFile file(":/resources/types.txt");
	  QString line;

	  if ( file.open(QIODevice::Text | QIODevice::ReadOnly) ) {
	    // file opened successfully
	    QTextStream t(&file);        // use a text stream
	    // until end of file...
	    int i = 0;
	    while ( !t.atEnd() ) {
	      // read and parse the command line
	      QString line = t.readLine();         // line of text excluding '\n'
	      // do something with the line

	      if (line.length() > 0) {
	    	  if ((i++) == 0) {
	    		  this->types.append(line);
	    		  this->fieldsByType.append (new QList<TargetField>);
				  qDebug () << " new type "<< line << " " << this->types.length();
	    	  }
	    	  else {
	    		  // TODO implements types
	    		  this->fieldsByType [this->types.length() - 1]->append(TargetField (line, TYPE_STRING, true, i));
				  qDebug () << " new field "<< line << " " << this->types.length();
	    	  }
	      }
	      else {
	    	  i = 0;
	      }

	    }

	    // Close the file
	    file.close();
	  }
}

//
//	this->types.append("Credit Card");
//	this->types.append("Membership Info");
//	this->types.append("Password");
//	this->types.append("Bank Account");
//	this->types.append("Cellular Phone");
//	this->types.append("Web Site");
//	this->types.append("Health Numbers");
//	this->types.append("Passport Info");
//	this->types.append("Note Card");
//	this->types.append("Car Info");
//	this->types.append("ID Card");
//	this->types.append("Social Security Number");
//	this->types.append("Driver's License");
//	this->types.append("Email Account");
//	this->types.append("Others");
//
//	fieldsByType [0].append(TargetField ("Expired Date", TYPE_DATE, true, 1));
//	fieldsByType [0].append(TargetField ("Bank", TYPE_STRING, true, 2));
//	fieldsByType [0].append(TargetField ("PIN", TYPE_INTEGER, true, 3));
//	fieldsByType [0].append(TargetField ("Extra 1", TYPE_STRING, true, 40));
//	fieldsByType [0].append(TargetField ("Extra 2", TYPE_STRING, true, 50));
//	fieldsByType [0].append(TargetField ("Extra 3", TYPE_STRING, true, 60));
//	fieldsByType [0].append(TargetField ("Extra 4", TYPE_STRING, true, 70));
//	fieldsByType [0].append(TargetField ("Extra 5", TYPE_STRING, true, 80));
//
//	fieldsByType [1].append(TargetField ("Issued Date", TYPE_DATE, true, 1));
//	fieldsByType [1].append(TargetField ("Titular", TYPE_STRING, true, 2));
//	fieldsByType [1].append(TargetField ("PIN", TYPE_INTEGER, true, 3));
//	fieldsByType [1].append(TargetField ("Extra 1", TYPE_STRING, true, 40));
//	fieldsByType [1].append(TargetField ("Extra 2", TYPE_STRING, true, 50));
//	fieldsByType [1].append(TargetField ("Extra 3", TYPE_STRING, true, 60));
//	fieldsByType [1].append(TargetField ("Extra 4", TYPE_STRING, true, 70));
//	fieldsByType [1].append(TargetField ("Extra 5", TYPE_STRING, true, 80));
//
//	fieldsByType [2].append(TargetField ("Extra 1", TYPE_STRING, true, 40));
//	fieldsByType [2].append(TargetField ("Extra 2", TYPE_STRING, true, 50));
//	fieldsByType [2].append(TargetField ("Extra 3", TYPE_STRING, true, 60));
//	fieldsByType [2].append(TargetField ("Extra 4", TYPE_STRING, true, 70));
//	fieldsByType [2].append(TargetField ("Extra 5", TYPE_STRING, true, 80));



void eWallet::timerEvent(QTimerEvent* event)
{
}
void eWallet::keyPressEvent(QKeyEvent* event) {
	//qDebug()<<"key pressed " << event->key();


	
/*		if (event->key() == Qt::Key_Backspace || event->key() == Qt::Key_Delete) {
			if (current.size () > 0) {
				current = current.left (current.size ()-1);
				label->setText (QString ("************************").right(current.size()));						
			}
			event->accept();
		}
		else {
			if (event->key() == Qt::Key_Return || event->key() == Qt::Key_Enter) {
				event->accept();
				acceptS();
			}
			else {*/
				QWidget::keyPressEvent(event);
/*			}
		}
	}*/
}


void eWallet::showTargets()
{
	// Clean previous items from the layout
	fnListWidget->clear();

	//QPixmap available(":/resources/icon_available.png");
	//QPixmap notavailable(":/resources/icon_notavailable.png");

	list.clear ();
	list = ::dbManager->getTargets ("");

	for (int i = 0; i < list.size (); i++) {
		QFNListItem* listitem = new QFNListItem(list.at(i), this);
		fnListWidget->addItem(listitem, Qt::AlignTop | Qt::AlignLeft);
		
		QObject::connect(listitem, SIGNAL(viewTarget(Target*)),
                      this, SLOT(viewTarget(Target*)));
		QObject::connect(listitem, SIGNAL(editTarget(Target*)),
                      this, SLOT(editTarget(Target*)));
		QObject::connect(listitem, SIGNAL(deleteTarget(Target*)),
                      this, SLOT(deleteTarget(Target*)));
	}
	//fnListWidget->setFocusedItem(0);
	update();
}

void eWallet::createMenu()
{
	menuBar()->addAction("New", this, SLOT(newTarget()));
	menuBar()->addAction("Import", this, SLOT(import()));
	menuBar()->addAction("Exit", QApplication::instance(), SLOT(quit()));

}
/*
void eWallet::newTarget()
{
	row = -1;
	if (createTargetDlg.isNull()) {
		createTargetDlg = new CreateTargetDialog(NULL, this);
#if defined(Q_OS_WIN32)
		createTargetDlg->setFixedSize(640,480);
#elif defined(Q_WS_HILDON)
		createTargetDlg->setMinimumSize(size().width(),size().height()-100);
#else
		createTargetDlg->showMaximized();
#endif
		createTargetDlg->exec();
		delete createTargetDlg;
		createTargetDlg = 0;
	}
}
*/
bool eWallet::_insertTarget(Target* target)
{
	if (::dbManager->insertTarget(target)) {
		//qDebug () << "Adding new item";
		::dbManager->updateFields (target);
		
		QFNListItem* listitem = new QFNListItem(target, this);
		//qDebug () << "Adding new item 2";
		fnListWidget->addItem(listitem, Qt::AlignTop | Qt::AlignLeft);
		
		QObject::connect(listitem, SIGNAL(viewTarget(Target*)),
                      this, SLOT(viewTarget(Target*)));
		QObject::connect(listitem, SIGNAL(editTarget(Target*)),
                      this, SLOT(editTarget(Target*)));
		QObject::connect(listitem, SIGNAL(deleteTarget(Target*)),
                      this, SLOT(deleteTarget(Target*)));
					  
		update ();
//qDebug () << "Adding new item 4";
		return true;
	}
	return false;
}
bool eWallet::_deleteTarget(Target* target)
{
	if (::dbManager->deleteTarget(target)) {
		QFNListItem* listitem = fnListWidget->itemAt (row);

		//disconnect(obj, SIGNAL(destroyed(QObject*)),               this, SLOT(windowDestroyed(QObject*)));
		QObject::disconnect(listitem, SIGNAL(viewTarget(Target*)),
                      this, SLOT(viewTarget(Target*)));
		QObject::disconnect(listitem, SIGNAL(editTarget(Target*)),
                      this, SLOT(editTarget(Target*)));
		QObject::disconnect(listitem, SIGNAL(deleteTarget(Target*)),
                      this, SLOT(deleteTarget(Target*)));

		fnListWidget->removeItem (row);

		update ();
		return true;
	}
	return false;
}
bool eWallet::_updateTarget(Target* target)
{
	if (::dbManager->updateTarget(target)) {
		::dbManager->updateFields (target);
		
		if (row >= 0) {
			fnListWidget->itemAt (row)->setText (target->name);
		}			
		return true;
	}
	return false;
}

bool eWallet::_updateTargetPicture(Target* target)
{
	if (::dbManager->updateTargetPicture(target)) {
		if (row >= 0) {
			fnListWidget->itemAt (row)->setImage (target->picture, target->type);
		}
		return true;
	}
	return false;
}
bool eWallet::_updateTargetPictureBack(Target* target)
{
	if (::dbManager->updateTargetPictureBack(target)) {
		return true;
	}
	return false;
}

void eWallet::deleteTarget(Target * target) {

	qDebug()<<"delete ";

	row = fnListWidget->findRow(target);
	
	_deleteTarget (target);

	delete target;
}

void eWallet::windowDestroyed(QObject* obj)
{
    disconnect(obj, SIGNAL(destroyed(QObject*)),
               this, SLOT(windowDestroyed(QObject*)));

    if (obj == detailWindow.data()) {
		delete detailWindow;
		detailWindow = 0;
    }
    else
    if (obj == detailWindowEdit.data()) {
		delete detailWindowEdit;
		detailWindowEdit = 0;
    }
}

void eWallet::viewTarget(Target * rent) {
	qDebug()<<"view ";

	row = fnListWidget->findRow(rent);

	dbManager->getFields(rent);

	if (detailWindow.isNull()) {
		detailWindow = new DetailWindow(rent, false, this, this);

		connect(detailWindow, SIGNAL(editTarget(Target*)),
                      this, SLOT(editTarget(Target*)));
		connect(detailWindow, SIGNAL(newTarget()),
                      this, SLOT(newTarget()));
#ifdef Q_WS_MAEMO_5
		detailWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
        detailWindow->setAttribute(Qt::WA_DeleteOnClose);
        connect(detailWindow, SIGNAL(destroyed(QObject*)),
                this, SLOT(windowDestroyed(QObject*)));
	    detailWindow->show(); //owMaximized();
	}
}

void eWallet::editTarget(Target * rent) {
	qDebug()<<"edit ";

	row = fnListWidget->findRow(rent);

	dbManager->getFields(rent);

	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(rent, true, this, this);
#ifdef Q_WS_MAEMO_5
		detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
		detailWindowEdit->showMaximized();
        detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
        connect(detailWindowEdit, SIGNAL(destroyed(QObject*)),
                this, SLOT(windowDestroyed(QObject*)));
        detailWindowEdit->show();
		//detailWindow->exec();
	}
}

void eWallet::import() {
	QString path(QDesktopServices::storageLocation(QDesktopServices::PicturesLocation));
	QString s = QFileDialog::getOpenFileName(
	                this,
	                "Choose import file",
	                path,
	                "Text (*.txt)");
	if (!s.isNull () && !s.isEmpty ()) {

		  QFile file(s);
		  QString line;

		  Target * target = NULL;
		  if ( file.open(QIODevice::Text | QIODevice::ReadOnly) ) {
		    // file opened successfully
		    QTextStream t(&file);        // use a text stream
		    // until end of file...
		    int i = 0;
		    while ( !t.atEnd() ) {
		      // read and parse the command line
		      QString line = t.readLine();         // line of text excluding '\n'
		      // do something with the line

		      if (line.length() > 0) {
		    	  if (target == NULL) {
		    		  target = new Target ();
		    	  }

		    	  int j = line.indexOf(QChar(':'));
		    	  if (j > 0) {
					  switch (i++) {
					  case 0:
						  target->name = line.mid(j + 1).trimmed();
						  break;
					  case 1:
						  // TODO check type with existing one!
						  target->type = line.mid(j + 1).trimmed();
						  break;
					  default:
						  TargetField * field = new TargetField ();
						  field->name = line.mid (0, j).trimmed();
						  field->value = line.mid(j + 1).trimmed();
						  field->encrypted = true;
						  field->type = TYPE_STRING;
						  target->fields.append(field);
					  }

					  qDebug () << line << " | " << line.mid(j + 1) << " IS " << line.mid (0, j);
		    	  }
		    	  else {
		    		  if (target != NULL && target->fields.size() > 0) {
		    			  target->fields.last()->value.append("\n").append (line);
		    			  target->fields.last()->type = TYPE_TEXT;
		    		  }
		    	  }
		      }
		      else {
		    	  if (target != NULL) {
		    		  this->_insertTarget(target);
		    	  }
		    	  target = NULL;
		    	  i = 0;
		      }

		      qDebug () << line;
		    }

			 if (target != NULL) {
				  this->_insertTarget(target);
			 }
		    // Close the file
		    file.close();
		  }

	}
}

void eWallet::newTarget() {
	qDebug()<<"new ";

	row = -1;

	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(NULL, true, this, this);
#ifdef Q_WS_MAEMO_5
		detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
		detailWindowEdit->showMaximized();
        detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
        connect(detailWindowEdit, SIGNAL(destroyed(QObject*)),
                this, SLOT(windowDestroyed(QObject*)));
        detailWindowEdit->show();
		//detailWindow->exec();
	}
}
/*
void eWallet::contextMenuEvent (QContextMenuEvent * event) {
	//qDebug () << "Should be show " << this->childAt(event->globalPos());

	row = this->fnListWidget->findOn (event->globalPos());

	if (row >= 0) {
		QMenu menu(this);
		menu.addAction("View", this, SLOT(_viewcTarget()));
		menu.addAction("Edit", this, SLOT(_editcTarget()));
		menu.addAction("Delete", this, SLOT(_deletecTarget()));
		menu.exec(event->globalPos());
	}
}
*/
/*
void eWallet::editTarget(Target * rent)
{
	row = fnListWidget->findRow(rent);

	qDebug()<<"Edit ";

	if (createTargetDlg.isNull()) {
			createTargetDlg = new CreateTargetDialog(rent, this);
#if defined(Q_OS_WIN32)
			createTargetDlg->setFixedSize(640,480);
#elif defined(Q_WS_HILDON)
			createTargetDlg->setMinimumSize(size().width(),size().height()-100);
#else
			createTargetDlg->showMaximized();
#endif
			createTargetDlg->exec();
			delete createTargetDlg;
			createTargetDlg = 0;
		
	}
}
*/
void eWallet::_editcTarget() {
	editTarget(this->fnListWidget->itemAt(row)->getSource());
}
void eWallet::_deletecTarget() {
	deleteTarget(this->fnListWidget->itemAt(row)->getSource());
}
void eWallet::_viewcTarget() {
	viewTarget(this->fnListWidget->itemAt(row)->getSource());
}

//eWallet closeEvent function:
void eWallet::closeEvent(QCloseEvent *event){
	qDebug () << "close Event";
        //saveSettings();
        event->accept();
}

void eWallet::askPassword () {
	int times = 0;
	
	do {
		if (loginDialogDlg.isNull()) {
			loginDialogDlg = new LoginDialog(this);
	#if defined(Q_OS_WIN32)
			loginDialogDlg->setFixedSize(640,480);
	#elif defined(Q_WS_HILDON)
			loginDialogDlg->setMinimumSize(size().width(),size().height()-100);
	#else
			loginDialogDlg->showMaximized();
	#endif
			loginDialogDlg->exec();
			delete loginDialogDlg;
			loginDialogDlg = 0;
		}
		
		//qDebug () << "TIME " << times;
			
		if (++times > 3) {
			exit(3);
		}
		else {
			if (!::dbManager->isReady ()) {
				if (messageBox.isNull()) {
					messageBox = new QMessageBox(this);
					messageBox->information(this, "Wallet", "Wrong password", QMessageBox::Ok);
				}
				delete messageBox;
				messageBox = 0;
			}
		}
	}
	while(!::dbManager->isReady ());
}
