/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#ifndef QFNLISTITEM_H
#define QFNLISTITEM_H

#include <QWidget>
#include <QFrame>
#include <QLabel>
#include <QPixmap>
#include <QGridLayout>
#include <QHBoxLayout>
#include <QMetaType>
#include "DatabaseManager.h"

class QFNListItem: public QFrame
{
	Q_OBJECT

public:
	QFNListItem(Target * t, QWidget* parent = 0);
	~QFNListItem();

	void setText(QString text);
	QString getText();
	void setImage(QImage* image, QString type);

	Target * getSource ();

public slots:
	void _editTarget();
	void _viewTarget();
	void _deleteTarget();

signals:
	void newTarget();
	void editTarget(Target * source);
	void viewTarget(Target * source);
	void deleteTarget(Target * source);

private:
	//void enterEvent ( QEvent * event );
	//void leaveEvent ( QEvent * event );
	
	void mouseReleaseEvent(QMouseEvent*);
	void contextMenuEvent (QContextMenuEvent *);

	QLabel*         imageLabel;
	QLabel*         label;
	QHBoxLayout*    layout;
	Target * source;
	//void paintEvent(QPaintEvent* event);
};


// This macro makes the type QFNListItem known to QMetaType
Q_DECLARE_METATYPE(QFNListItem*)

#endif // QFNLISTITEM_H
