/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#include "eWallet.h"
#include "LoginDialog.h"
#include "Constants.h"

LoginDialog::LoginDialog(eWallet *paTarget) :
		QDialog((QWidget*)paTarget)
{
	setContextMenuPolicy(Qt::NoContextMenu);

	QHBoxLayout * layout = new QHBoxLayout(this);
	QGridLayout * componentLayout = new QGridLayout ();
	this->parent = paTarget;

	layout->setMargin(0);
	layout->setSpacing(0);
#ifdef Q_WS_HILDON
	layout->setSpacing(10);
	layout->setMargin(10);
#endif

	QPushButton * imageButton [12];

	QSignalMapper * signalMapper = new QSignalMapper(this);

	label = new QLabel("", this);
	label->setContextMenuPolicy(Qt::NoContextMenu);
	label->setAlignment(Qt::AlignCenter);

	
	for (int i = 0; i < 12; i++) {
		QString text ('0' + i + 1);

		if (i == 9) {
			text = "Accept";
			imageButton[i] = new QPushButton(QIcon(":/resources/icon_accept.png"), text, this);
			imageButton[i] ->setFixedHeight(60);
			imageButton[i] ->setContextMenuPolicy(Qt::NoContextMenu);
			imageButton[i] ->setFocusPolicy(Qt::NoFocus);
			imageButton[i] ->setIconSize(QSize(40, 40));
			componentLayout->addWidget(imageButton[i], i / 3, i % 3, 1, 1);

			//signalMapper->setMapping(imageButton[i], text);

			QObject::connect(imageButton[i], SIGNAL(clicked()), this, SLOT(acceptS()));
		} else {
			if (i == 10) {
				text = "0";
				imageButton[i] = new QPushButton(QIcon(":/resources/number.png"), text, this);
				imageButton[i] ->setFixedHeight(60);
				imageButton[i] ->setContextMenuPolicy(Qt::NoContextMenu);
				imageButton[i] ->setFocusPolicy(Qt::NoFocus);
				imageButton[i] ->setIconSize(QSize(40, 40));
				componentLayout->addWidget(imageButton[i], i / 3, i % 3, 1, 1);

				signalMapper->setMapping(imageButton[i], text);

				QObject::connect(imageButton[i], SIGNAL(clicked()), signalMapper, SLOT(map()));
			} else
				if (i == 11) {
					text = "Clear";
					imageButton[i] = new QPushButton(QIcon(":/resources/icon_clear.png"), text, this);
					imageButton[i] ->setFixedHeight(60);
					imageButton[i] ->setContextMenuPolicy(Qt::NoContextMenu);
					imageButton[i] ->setFocusPolicy(Qt::NoFocus);
					imageButton[i] ->setIconSize(QSize(40, 40));
					componentLayout->addWidget(imageButton[i], i / 3, i % 3, 1, 1);

					//signalMapper->setMapping(imageButton[i], text);

					QObject::connect(imageButton[i], SIGNAL(clicked()), this, SLOT(clearS()));
				} else {
					imageButton[i] = new QPushButton(QIcon(":/resources/number.png"), text, this);
					imageButton[i] ->setFixedHeight(60);
					imageButton[i] ->setContextMenuPolicy(Qt::NoContextMenu);
					imageButton[i] ->setFocusPolicy(Qt::NoFocus);
					imageButton[i] ->setIconSize(QSize(40, 40));
					componentLayout->addWidget(imageButton[i], i / 3, i % 3, 1, 1);

					signalMapper->setMapping(imageButton[i], text);

					QObject::connect(imageButton[i], SIGNAL(clicked()), signalMapper, SLOT(map()));
				}
		}
	}

	connect(signalMapper, SIGNAL(mapped(const QString &)),
	        this, SLOT(select(const QString &)));

	componentLayout->addWidget(label, 4, 0, 1, 3);

	QDialogButtonBox* dlgBtnBox = new QDialogButtonBox(this);
	dlgBtnBox->setOrientation(Qt::Vertical);

	QPushButton * deleteButton = new QPushButton(QIcon(":/resources/exit.png"), "Exit", this);
	deleteButton->setFixedHeight(70);
	deleteButton->setContextMenuPolicy(Qt::NoContextMenu);
	deleteButton->setFocusPolicy(Qt::NoFocus);
	deleteButton->setIconSize(QSize(48, 48));
	QObject::connect(deleteButton, SIGNAL(clicked()), QApplication::instance(), SLOT(quit()));
	dlgBtnBox->addButton(deleteButton, QDialogButtonBox::ActionRole);

	layout->addLayout(componentLayout);
	layout->setAlignment(componentLayout, Qt::AlignVCenter);

	layout->addWidget(dlgBtnBox);
	layout->setAlignment(dlgBtnBox, Qt::AlignBottom);


	setLayout(layout);
}

LoginDialog::~LoginDialog()
{
}

void LoginDialog::clearS()
{
	label->setText ("");
	current = "";
}

void LoginDialog::acceptS() {
	if (parent->openDataBase (current)) {
		close();
	}
	else {
		label->setText ("");
		current = "";
	}
}

void LoginDialog::select(const QString& a) {
	if (current.size() < KEY_SIZE) {
		current += a;
		label->setText (QString ("************************").right(current.size()));		
	}
}

void LoginDialog::keyPressEvent(QKeyEvent* event) {
	//qDebug()<<"key pressed " << event->key();
	
	if (event->key() >= Qt::Key_0 && event->key() <= Qt::Key_9) {
		if (current.size() < KEY_SIZE) {
			current += (char)(event->key());
			label->setText (QString ("************************").right(current.size()));		
		}
		event->accept();
	}
	else {
		if (event->key() == Qt::Key_Backspace || event->key() == Qt::Key_Delete) {
			if (current.size () > 0) {
				current = current.left (current.size ()-1);
				label->setText (QString ("************************").right(current.size()));						
			}
			event->accept();
		}
		else {
			if (event->key() == Qt::Key_Return || event->key() == Qt::Key_Enter) {
				event->accept();
				acceptS();
			}
			else {
				QWidget::keyPressEvent(event);
			}
		}
	}
}
/*
void LoginDialog::focusOutEvent ( QFocusEvent * event ) {
	
	qDebug () << "LOST FOCUS";
}
*/