/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#include "QFNListItem.h"
#include "QFNListWidget.h"
#include "Constants.h"


#include <QGridLayout>
#include <QHBoxLayout>
#include <QPainter>
#include <QKeyEvent>
#include <QDebug>

void QFNListItem::_editTarget() {
	emit editTarget (this->source);
}
void QFNListItem::_deleteTarget() {
	emit deleteTarget (this->source);
}
void QFNListItem::_viewTarget() {
	emit viewTarget (this->source);
}
Target * QFNListItem::getSource() {
	return (this->source);
}

void QFNListItem::contextMenuEvent (QContextMenuEvent * event) {
	qDebug () << "Should be show";

	QMenu menu(this);
	menu.addAction("View", this, SLOT(_viewTarget()));
	menu.addAction("Edit", this, SLOT(_editTarget()));
	menu.addAction("Delete", this, SLOT(_deleteTarget()));
	menu.exec(event->globalPos());
}

QFNListItem::QFNListItem(Target * target, QWidget* parent) :
		QFrame(parent)
{
	imageLabel = 0;

	source = target;

	setProperty("FingerScrollable", false);

	this->setFrameShape(QFrame::NoFrame);

	//setContextMenuPolicy(Qt::NoContextMenu);
	//setFocusPolicy(Qt::StrongFocus);

//	QAction * edit = new QAction ("Edit", this);
//	addAction (edit);
//
//    connect(edit, SIGNAL(triggered()), this, SLOT(_editTarget()));


	//QPalette p(Qt::white);
	//setPalette(p);
	setContextMenuPolicy(Qt::DefaultContextMenu);

	label = new QLabel(this);
	//label->setPalette(p);

	//label->setContextMenuPolicy(Qt::NoContextMenu);
	label->setBackgroundRole(QPalette::NoRole);
	label->setText(target->name);

	//label->setContextMenuPolicy(Qt::DefaultContextMenu);

	imageLabel = new QLabel(this);
	//imageLabel->setContextMenuPolicy(Qt::NoContextMenu);
	imageLabel->setBackgroundRole(QPalette::NoRole);
	imageLabel->setScaledContents(true);
	imageLabel->setFixedSize(SMALL_WIDTH, SMALL_HEIGH);
	if (target->getPictureSmall() != NULL) {
		imageLabel->setPixmap(QPixmap::fromImage (*target->getPictureSmall()));

		// at this moment we don't need anymore original images!
		target->freeResources();
	} else {
		QPixmap available(":/resources/empty_card.png");
		imageLabel->setPixmap(available);
	}

	//imageLabel->setContextMenuPolicy(Qt::DefaultContextMenu);

	layout = new QHBoxLayout;

	layout->setSpacing(10);
	layout->setMargin(10);

	layout->addWidget(imageLabel);
	layout->addWidget(label);

	setLayout(layout);

}

QFNListItem::~QFNListItem()
{
}

void QFNListItem::setText(QString text)
{
	label->setText(text);
	update();
}

QString QFNListItem::getText()
{
	return label->text();
}

/*int QFNListItem::itemHeight()
{
	return height;
}*/

void QFNListItem::setImage(QImage* image)
{
	if (image != NULL) {
		imageLabel->clear();
		imageLabel->setFixedSize(SMALL_WIDTH, SMALL_HEIGH);
		imageLabel->setPixmap(QPixmap::fromImage (*image));
	}
	else {
		QPixmap available(":/resources/empty_card.png");
		imageLabel->clear();
		imageLabel->setFixedSize(SMALL_WIDTH, SMALL_HEIGH);
		imageLabel->setPixmap(available);
	}
	update();
}
/*
void QFNListItem::mousePressEvent(QMouseEvent *event)
{
	qDebug() << "QFNLIST ITEM mouse press event " << event->button();

	QFrame::mousePressEvent(event);
}
*/
void QFNListItem::mouseReleaseEvent(QMouseEvent *event)
{
	qDebug() << "QFNLIstITEM mouse release event " << event->button();
	QFrame::mouseReleaseEvent(event);
	//update();

	// We do not want to handle this event here, it will be sended to parent
	//event->ignore();
	_viewTarget();
}

/*//////////////////////////////////////
void QFNListItem::focusInEvent(QFocusEvent* event)
{
	qDebug() << "focusInEvent mouse event ";
	QFrame::focusInEvent(event);
	if (event->gotFocus()) {
		setFocus ();
	qDebug() << "focusInEvent mouse event GETT";
		//startAnim();
#ifdef Q_WS_HILDON // N900 Maemo device
		//emit customFocus(this);
#endif
	}
}

void QFNListItem::mouseMoveEvent(QMouseEvent *event)
{
	qDebug() << "mouse event " << event->button();

	QFrame::mouseMoveEvent(event);
	// We do not want to handle this event here, it will be sended to parent
	event->ignore();
}



void QFNListItem::keyPressEvent(QKeyEvent* event)
{
	QFrame::keyPressEvent(event);
}

void QFNListItem::focusInEvent(QFocusEvent* event)
{
	QFrame::focusInEvent(event);
	if (event->gotFocus()) {
		startAnim();
#ifdef Q_WS_HILDON // N900 Maemo device
		emit customFocus(this);
#endif
	}
}

void QFNListItem::startAnim()
{
	anim = 0;
	if (animTimer == 0)
		animTimer = this->startTimer(20);
}

void QFNListItem::timerEvent(QTimerEvent *event)
{
	if (animTimer != event->timerId())
		return;

	if (anim < -5) {
		this->killTimer(animTimer);
		animTimer = 0;
	} else {
		anim--;
	}
	update();
}

void QFNListItem::paintEvent(QPaintEvent* event)
{
	QFrame::paintEvent(event);

	QPainter painter(this);
	if (hasFocus()) {
		QRect r = rect();
		int ad = anim - 5;
		r.adjust(ad, ad, ad, ad);
		r.setTopLeft(QPoint(anim * -1, anim * -1));

#if defined (Q_OS_SYMBIAN)
		QBrush b(Qt::white, Qt::SolidPattern);
#else
		QBrush b(Qt::blue,Qt::SolidPattern);
#endif

		painter.setBrush(b);
		painter.setPen(Qt::black);
		QPen pen = painter.pen();
		if (animTimer != 0) {
			pen.setWidth(3);
			painter.setPen(pen);
			painter.setOpacity(0.4);
		} else {
			pen.setWidth(1);
			painter.setPen(pen);
			painter.setOpacity(0.2);
		}

		painter.drawRoundedRect(r, 5, 5);
	}
}
*/
