/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#ifndef EWALLET_H
#define EWALLET_H

#include <QtGui>
#include <QDebug>

#include "DatabaseManager.h"
#include "DetailedWindow.h"
#include "LoginDialog.h"

extern DatabaseManager * dbManager;

class eWallet: public QMainWindow
{
	Q_OBJECT

public:
	eWallet (QWidget *parent = 0);
	~eWallet ();

	bool openDataBase (QString pas);
	bool _deleteTarget(Target* target);
	bool _updateTarget(Target* target);
	bool _updateTargetPicture(Target* target);
	bool _updateTargetPictureBack(Target* target);
	bool _insertTarget(Target* target);
	bool __insertTarget(Target* target);
	
	QList<QString> types;
	QList<QList<TargetField>*> fieldsByType;

public slots:
	void newTarget();
	void editTarget(Target * t);
	void deleteTarget(Target * t);
	void viewTarget(Target * t);
	Q_SCRIPTABLE void listenInactivity(QString s);

	void selectItem(QListWidgetItem *);
	void selectDItem(QListWidgetItem *);

	void deleteDB ();
	void changeMode ();

private:
	bool event (QEvent *event);
	void swipeTriggered (QSwipeGesture *gesture);
	bool gestureEvent (QGestureEvent *event);

	void showList ();
	void keyPressEvent(QKeyEvent*);
	void createMenu();
	void showGroups(bool reset);
	void showInfo(bool reset);
	void showTargets(bool reset, const QString & filter);
	void loadTypesAndFields ();
	void filterBy (const QString & s);
	QPixmap getImage (Target * f);
	bool isAskPassword;

private slots:
	void orientationChanged(int);
    void windowDestroyed(QObject* obj = 0);
    void sort ();
    void _newLikeTarget ();
	void _editcTarget();
	void _deletecTarget();
	void _viewcTarget();
	void lockWallet ();
	void _cancelSearch ();
	void _hideSearch ();
	void about ();
	void import();
	void exportData();
	void textChanged (const QString &);
	void contextMenuEvent (QContextMenuEvent * event);
	
private:
	void askPassword ();
	void closeEvent(QCloseEvent *event);
	
	QVBoxLayout * vboxlayout;
	int times;
	QListWidget* fnListWidget;
	QList<Target *> list;
	QList<QString> grouplist;

	QHBoxLayout * inputWidget;
	QPushButton * cancelSearch;
	QPushButton * hideSearch;
	QLineEdit * searchField;

	QPointer<LoginDialog> loginDialogDlg;
	QPointer<DetailWindow> detailWindow;
	QPointer<DetailWindow> detailWindowEdit;
	QWidget* centralWidget;
	QPointer <QMessageBox> messageBox;
	bool opendb;
	bool initdb;
	bool ascSort;
	int isShowGroups;
	QString currentFilter;

};


#endif // EWALLET_H
