/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */

#include "eWallet.h"
#include "Constants.h"
#include "DetailedWindow.h"
#include <Qt>
#include <QDesktopServices>
//#include <QtXml>
//#include <QXmlSimpleReader>

class QLabelW: public QLabel {

public:
	QLabelW(const QString &text, bool isLabel, QWidget *parent=0, Qt::WindowFlags f=0) : QLabel (text, parent, f) {
		this->isLabel = isLabel;
	}
	QLabelW(QWidget *parent=0, Qt::WindowFlags f=0): QLabel (parent, f) {
	}
	~QLabelW() {
	}
protected:
	bool isLabel;
    void mousePressEvent(QMouseEvent *ev) {
    	//qDebug () << "click on field " << this->userData(0);
    	TargetField * f = ((ButtonInfo *)this->userData(0))->field;
    	if (f->type == TYPE_URL && !isLabel) {
    		QDesktopServices::openUrl(QUrl::fromUserInput(f->value));
    	}
    	else {
			//if (f != NULL)
			//qDebug () << "pressed " << f->value;
			QClipboard *cb = QApplication::clipboard();
			cb->setText(f->value);
    	}
    }
};

DetailWindow::DetailWindow(Target * _target, bool istemplate, bool edit, eWallet *paTarget, QWidget *parent) :
		QMainWindow(parent)
{
	this->setAttribute(Qt::WA_Maemo5StackedWindow);
	if (!edit)
		connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged(int)));

	isNew = istemplate || _target == NULL;

	this->target = _target;
	this->parent = paTarget;
	this->edit = edit;

	if (istemplate) {
		this->target = new Target ();
		this->target->type = _target->type;
		this->target->groupName = _target->groupName;

		for (int i = 0; i < _target->fields.size(); i++) {
			TargetField * tmp = _target->fields.at(i);

			//if (!target->existField (tmp.name)) {
				TargetField * f=  new TargetField (tmp->name, tmp->type, tmp->encrypted, tmp->order);

				this->target->fields.append(f);
			//}
		}

		_target->freeFieldList();
	}
	else
	if (isNew) {
		this->target = new Target ();
		this->target->type = this->parent->types[0];
		changeFields (0);
	}

	qDebug () << " going to " << edit << " " << (isNew ? "NEW" : this->target->name);

	orgType = this->target->type;

	deleteFace = false;
	deleteBack = false;

	currentImageN = NULL;
	currentImageBackN = NULL;

	if (_target && !istemplate) {
		currentImage = this->target->getPicture();
		currentImageBack = this->target->getPictureBack();
	}
	else {
		currentImage = NULL;
		currentImageBack = NULL;
	}


	if (edit) {
		menuBar()->addAction("Save", this, SLOT(saveTarget()));
		if (!isNew)
			menuBar()->addAction("Delete", this, SLOT(_deleteTarget()));
		menuBar()->addAction("Change Face Pict.", this, SLOT(cardFace()));
		menuBar()->addAction("Mirror Face Pict.", this, SLOT(mirrorFace()));
		menuBar()->addAction("Change Back Pict.", this, SLOT(cardBack()));
		menuBar()->addAction("Mirror Back Pict.", this, SLOT(mirrorBack()));
		menuBar()->addAction("Delete Face Pict.", this, SLOT(deleteCardFace()));
		menuBar()->addAction("Delete Back Pict.", this, SLOT(deleteCardBack()));
		menuBar()->addAction("Modify fields", this, SLOT(modifyFields()));
		//TODO menuBar()->addAction("Delete field", this, SLOT(addNewField()));
		//TODO menuBar()->addAction("Modify field", this, SLOT(addNewField()));
	}
	else {
		menuBar()->addAction("New", this, SLOT(_newTarget()));
		menuBar()->addAction("Edit", this, SLOT(_editTarget()));
		menuBar()->addAction("Export Face Pict.", this, SLOT(exportCardFace()));
		menuBar()->addAction("Export Back Pict.", this, SLOT(exportCardBack()));
	}
	
	centralWidget = new QWidget(this);

	//setContextMenuPolicy(Qt::DefaultContextMenu);
	setContextMenuPolicy(Qt::CustomContextMenu);
	//centralWidget->setContextMenuPolicy(Qt::CustomContextMenu);

	vboxlayout = new QVBoxLayout ();
	vboxlayout->setSpacing(0);
	vboxlayout->setMargin(0);

	entryScrollArea = new QScrollArea;
	//entryScrollArea->setProperty("FingerScrollable", false);
	entryScrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	entryScrollArea->setWidgetResizable(true);
	entryScrollArea->setWidget(centralWidget);
	entryScrollArea->setProperty("FingerScrollable", true);

	centralWidget->setLayout(vboxlayout);
	setCentralWidget(entryScrollArea);

	// Create layout for the ui controls
	componentLayout = new QGridLayout ();
	// Name label
	if (edit) {
		QLabel * nameLabel = new QLabel("Name", this);
		componentLayout->addWidget(nameLabel, 1, 1, 1, 2);

	    nameLineEdit = new QLineEdit(this);
		componentLayout->addWidget(nameLineEdit, 1, 3, 1, 4);

			nameLineEdit->setText (this->target->name);

		nameLabel = new QLabel("Group Name", this);
		componentLayout->addWidget(nameLabel, 2, 1, 1, 2);

	    groupLineEdit = new QLineEdit(this);
		componentLayout->addWidget(groupLineEdit, 2, 3, 1, 4);

			groupLineEdit->setText (this->target->groupName);
	}
	else {
		this->setWindowTitle (_target->name);
	}

	if (edit) {
		// type label
		QLabel * typeLabel = new QLabel("Type", this);

		componentLayout->addWidget(typeLabel, 3, 1, 1, 2);

		typeLineEdit = new QComboBox(this);

		bool selected = false;
		for(int i = 0; i < this->parent->types.size(); i++) {
			typeLineEdit->addItem (this->parent->types[i], this->parent->types[i]);

				if (this->target->type == this->parent->types[i]) {
					typeLineEdit->setCurrentIndex(i);
					selected = true;
				}
		}
		if (!selected) {
			typeLineEdit->setCurrentIndex(this->parent->types.size() - 1);
		}

	    connect(typeLineEdit, SIGNAL(activated(int)), this, SLOT(emitCommitData(int)));

		componentLayout->addWidget(typeLineEdit, 3, 3, 1, 4);
	}
	else {

	}

	vboxlayout->addLayout(componentLayout);

	componentLayout = new QGridLayout ();

	QObject::connect(this, SIGNAL(customContextMenuRequested(const QPoint&)), this, SLOT(cardMenu(const QPoint&)));

	if (edit || this->target->getPicture() != NULL) {
		imageLabel = new QLabel(this);

		imageLabel->setBackgroundRole(QPalette::NoRole);
		imageLabel->setContentsMargins(5, 2, 0, 2);
		if (edit) {
			imageLabel->setMaximumSize(BIG_WIDTH, BIG_HEIGH);
			imageLabel->setMinimumSize(BIG_WIDTH, BIG_HEIGH);
			imageLabel->setScaledContents(true);
		}
		else {
			imageLabel->setMaximumSize(MAX_WIDTH, MAX_HEIGH);
			imageLabel->setMinimumSize(MAX_WIDTH, MAX_HEIGH);
			imageLabel->setScaledContents(true);
		}
		if (currentImage == NULL) {
			QPixmap available(":/resources/empty_card.png");
			imageLabel->setPixmap(available);
		}
		else {
			imageLabel->setPixmap(QPixmap::fromImage (*currentImage));
		}
		
		//imageLabel->setContextMenuPolicy(Qt::CustomContextMenu);
		//QObject::connect(imageLabel, SIGNAL(customContextMenuRequested(const QPoint&)), this, SLOT(cardFaceMenu(const QPoint&)));

		if (edit) {
			componentLayout->addWidget(imageLabel, 3, 1, 2, 3);
		}
		else
			vboxlayout->addWidget(imageLabel); //, 0, 0, 1, 1);
	}
	else {
		imageLabel = NULL;
	}

	if (edit || this->target->getPictureBack() != NULL) {
		imageBackLabel = new QLabel(this);

		imageBackLabel->setBackgroundRole(QPalette::NoRole);
		//imageBackLabel->setFocusPolicy(Qt::StrongFocus);
		imageBackLabel->setContentsMargins(5, 2, 0, 2);
		if (edit) {
			imageBackLabel->setMaximumSize(BIG_WIDTH, BIG_HEIGH);
			imageBackLabel->setMinimumSize(BIG_WIDTH, BIG_HEIGH);
			imageBackLabel->setScaledContents(true);
		}
		else {
			//imageBackLabel->setMaximumSize(MAX_WIDTH, MAX_HEIGH);
			imageBackLabel->setMaximumSize(MAX_WIDTH, MAX_HEIGH);
			imageBackLabel->setMinimumSize(MAX_WIDTH, MAX_HEIGH);
			imageBackLabel->setScaledContents(true);
		}
		if (currentImageBack == NULL) {
			QPixmap availableBack(":/resources/empty_card_back.png");
			imageBackLabel->setPixmap(availableBack);
		}
		else {
			imageBackLabel->setPixmap(QPixmap::fromImage (*currentImageBack));
		}

		//imageBackLabel->setContextMenuPolicy(Qt::CustomContextMenu);
		//QObject::connect(imageBackLabel, SIGNAL(customContextMenuRequested(const QPoint&)), this, SLOT(cardBackMenu(const QPoint&)));

		if (edit) {
			componentLayout->addWidget(imageBackLabel, 3, 4, 2, 3);
		}
		else
			vboxlayout->addWidget(imageBackLabel); //, 1, 0, 1, 1);
	}
	else {
		imageBackLabel = NULL;
	}

	if (edit) {
		vboxlayout->addLayout(componentLayout);
		componentLayout = new QGridLayout ();
	}

	componentLayout->setColumnMinimumWidth(1, 100);

	showFields ();

	vboxlayout->addLayout(componentLayout);

	orientationChanged(0);
}

void DetailWindow::modifyFields() {
	if (createFieldDlg.isNull()) {
		createFieldDlg = new CreateFieldDialog(this->target, this);
		createFieldDlg->setMinimumSize(size().width(),size().height()-100);
		createFieldDlg->exec();

		//qDebug () << "NOW ";

		showFields ();

		delete createFieldDlg;
		createFieldDlg = 0;
	}

}

void DetailWindow::addField (TargetField * field) {
	target->fields.append(field);

	_addField (field);
}

void DetailWindow::_addField (TargetField * field) {
	int s = 1;
	if (field->type == TYPE_TEXT) {
		s = 10;
	}

	//qDebug () << "trying to show " << field->name << " v=" << field->value << " t=" << field->type;

	QLineEdit * nameLabel = new QLineEdit(this);
	//nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
	componentLayout->addWidget(nameLabel, pos + 1, 1, 1, 2);
	nameLabel->setText (field->name);
	this->labels.append (nameLabel);

	//ButtonInfo * info = new ButtonInfo (field);
	//nameLabel->setUserData(0, info);

	if (field->type == TYPE_TEXT) {
		QTextEdit * nameLineEdit = new QTextEdit(this);
		//nameLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
		componentLayout->addWidget(nameLineEdit, pos + 1, 3, s, 4);
		nameLineEdit->setText (field->value);
		this->values.append (nameLineEdit);
		//nameLineEdit->setUserData(0,info);
	}
/*	else
	if (field->type == TYPE_PHONE_NUMBER) {
		// TODO
		QLineEdit * nameLineEdit = new QLineEdit(this);
		//nameLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
		componentLayout->addWidget(nameLineEdit, pos + 1, 3, s, 4);
		nameLineEdit->setText (field->value);
		this->values.append (nameLineEdit);

	}*/
	else {
		QLineEdit * nameLineEdit = new QLineEdit(this);
		//nameLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
		componentLayout->addWidget(nameLineEdit, pos + 1, 3, s, 4);
		nameLineEdit->setText (field->value);
		this->values.append (nameLineEdit);

		//nameLineEdit->setUserData(0,info);
	}

}

void DetailWindow::showFields () {

	if (edit) {
		for (int i = 0; i < this->labels.size(); i++) {
			componentLayout->removeWidget(this->labels[i]);
			delete this->labels[i];
		}

		for (int i = 0; i < this->values.size(); i++) {
			componentLayout->removeWidget(this->values[i]);
			delete this->values[i];
		}

		this->values.clear();
		this->labels.clear();
	}

	QSignalMapper * signalMapper = NULL;
	if (!edit) {
		signalMapper = new QSignalMapper(this);
		QObject::connect(signalMapper, SIGNAL(mapped(QWidget *)), this, SLOT(clickPass(QWidget *)));
	}

	pos = 0;
	if (target) {
		TargetField * field;
		foreach(field, target->fields) {
			int s = 1;
			if (field->type == TYPE_TEXT) {
				s = 10;
			}
			if (edit) {
				_addField (field);
			}
			else {
				if (field->value.length() > 0) {
					QLabel * nameLabel = new QLabelW(field->name, true, this);
					nameLabel->setFont (QFont("arial", 11, 1, true));
					nameLabel->setAlignment(Qt::AlignRight | Qt::AlignVCenter);
					nameLabel->setContentsMargins(0, 0, 10, 0);

					nameLabel->setUserData(0, new ButtonInfo (field));

					componentLayout->addWidget(nameLabel, pos + 1, 1, 1, 2);

					if (field->type == TYPE_PASSWORD) {// || field->name.contains("password", Qt::CaseInsensitive)) {
						QPushButton * nameLineEdit = new QPushButton("Click to see", this);
						//nameLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
						componentLayout->addWidget(nameLineEdit, pos + 1, 3, s, 2);

						nameLineEdit->setUserData(0, new ButtonInfo (field)); //ObjectName(field->value);
						signalMapper->setMapping(nameLineEdit, nameLineEdit);

						QObject::connect(nameLineEdit, SIGNAL(clicked()), signalMapper, SLOT(map()));
					}
					else {
						QLabel * nameLineEdit = new QLabelW(field->value, false, this);
						nameLineEdit->setUserData(0, new ButtonInfo (field));
						componentLayout->addWidget(nameLineEdit, pos + 1, 3, s, 4);
//						if (field->type == TYPE_URL) {
//							nameLineEdit->setFoStyle(QStyle::)
//						}
					}
				}
			}
			pos += s;
		}

	}

	//qDebug () << " shown " << pos << " rows";
	if (pos < 20) {
		componentLayout->addItem(new QSpacerItem(1,20 - pos), pos + 1, 1, 20-pos, 6);
		//qDebug () << " add " << (20 - pos) << " rows";
	}
}

void DetailWindow::clickPass (QWidget * _wid) {
	QPushButton * b = (QPushButton *)_wid;

	//qDebug () << "click on field " << b->userData(0);

	TargetField * f = ((ButtonInfo *)b->userData(0))->field;

	if (b->text() == f->value) {
		b->setText("Click to see");
	}
	else {
		b->setText(f->value);
	}
}

void DetailWindow::changeFields (int a) {

	qDebug () << "selected type " << a;

	for (int i = target->fields.size(); i > 0; i--) {
		TargetField * field = target->fields [i - 1];

		if (field->value.length() == 0) {
			qDebug () << "remove" << field->name;
			target->fields.removeAt(i - 1);
			delete field;
		}
		else
			qDebug () << "keep" << field->name;
	}

	for (int i = 0; i < parent->fieldsByType [a]->size(); i++) {
		TargetField tmp = parent->fieldsByType [a]->at(i);

		if (!target->existField (tmp.name)) {
			TargetField * f;

			f = new TargetField (tmp.name, tmp.type, tmp.encrypted, tmp.order);

			target->fields.append(f);
		}

	}
}

void DetailWindow::emitCommitData (int a) {
	changeFields (a);
	showFields();
}

DetailWindow::~DetailWindow () {
	//target->freeResources();
	//if (currentImageBackN) delete currentImageBackN;
	//if (currentImageN) delete currentImageN;
}

void DetailWindow::saveTarget () {
	if (nameLineEdit->text().length() < 1) {
		if (messageBox.isNull()) {
			messageBox = new QMessageBox(this);
			messageBox->information(this, "Wallet", "Card description is missing", QMessageBox::Ok);
		}
		delete messageBox;
		messageBox = 0;
		return;
	}

	 if (typeLineEdit->currentIndex() < 0) {
		if (messageBox.isNull()) {
			messageBox = new QMessageBox(this);
			messageBox->information(this, "Wallet", "Type card is missing", QMessageBox::Ok);
		}
		delete messageBox;
		messageBox = 0;
		return;
	}
	
	if (target == NULL) {
		this->target = new Target ();
	}


	this->target->name = nameLineEdit->text();
	this->target->groupName = groupLineEdit->text();
	this->target->type = typeLineEdit->itemData(typeLineEdit->currentIndex()).toString();
	
	//qDebug () << "getting fields ";

	for (int i = 0; i < target->fields.count(); i++) {
		TargetField * field = target->fields[i];
		qDebug () << "getting field " << i;
		
		field->name = labels[i]->text();
		if (field->type == TYPE_TEXT) {
			//qDebug () << "getting TEX field " << i;
			field->value = ((QTextEdit*)values[i])->toPlainText();
		}
		else {
			//qDebug () << "getting LIN field " << i;
			field->value = ((QLineEdit*)values[i])->text();
		}
	}
	qDebug () << "updating target";
	if (isNew) {
		parent->_insertTarget(this->target);
	}
	else {
		parent->_updateTarget(this->target);
	}
	qDebug () << "updating target face";

	if (deleteFace) {
		qDebug () << "DELETE FACE";
		target->setPicture (NULL);
		parent->_updateTargetPicture(target);
	}
	else
	if (currentImageN) {
		target->setPicture (currentImageN);
		currentImageN = NULL;
		parent->_updateTargetPicture(target);
	}
	else {
		if (orgType != target->type && target->getPicture() == NULL) {
			parent->_updateTargetPicture(target);
		}
	}

	qDebug () << "updating target back";

	if (deleteBack) {
		qDebug () << "DELETE BACK";
		target->setPictureBack (NULL);
		parent->_updateTargetPictureBack(target);
	}
	else
	if (currentImageBackN) {
		target->setPictureBack (currentImageBackN);
		currentImageBackN = NULL;
		parent->_updateTargetPictureBack(target);
	}

	qDebug () << "end updating ";

	target->freeResources();
	if (currentImageBackN) delete currentImageBackN;
	if (currentImageN) delete currentImageN;

	qDebug () << "clse ";
	close();
}

void DetailWindow::_deleteTarget () {
	if (target) {
		parent->deleteTarget(target);
	}

	close();
}

void DetailWindow::_editTarget () {
	emit editTarget(target);

	close ();
}

void DetailWindow::_newTarget () {

	emit newTarget();

	close ();
}

void DetailWindow::loadImage (QString q, QImage& res) {
	QImageReader reader;
	reader.setFileName(q);
	//Set/scale image size into screen
	QSize imageSize = reader.size();
	QSize ss (INTERNAL_WIDTH, INTERNAL_HEIGH);
	imageSize.scale(ss, Qt::KeepAspectRatio);
	reader.setScaledSize(ss);
	// Read image
	res = reader.read();
	//qDebug () << "read " << q << " as (" << imageSize << ") with result " << reader.errorString ();
}

void DetailWindow::cardMenu(const QPoint & _p) {
	QPoint p = _p;//this->mapFromGlobal(_p);

	QScrollBar* bar = entryScrollArea->verticalScrollBar();

	if (bar)
		p.setY(p.y() + bar->value());

	entryScrollArea->ensureVisible(p.x(), p.y());

	if (this->imageLabel != NULL && this->imageLabel->geometry().contains(p)) {
		QMenu menu(this);
		if (edit) {
			menu.addAction("Edit", this, SLOT(cardFace()));
			menu.addAction("Mirror", this, SLOT(mirrorFace()));
			menu.addAction("Delete", this, SLOT(deleteCardFace()));
		}
		else {
			menu.addAction("Export Face", this, SLOT(exportCardFace()));
		}
		menu.exec(_p);
	}
	else
	if (this->imageBackLabel != NULL && this->imageBackLabel->geometry().contains(p)) {
		QMenu menu(this);
		if (edit) {
			menu.addAction("Edit", this, SLOT(cardBack()));
			menu.addAction("Mirror", this, SLOT(mirrorBack()));
			menu.addAction("Delete", this, SLOT(deleteCardBack()));
		}
		else {
			menu.addAction("Export Back", this, SLOT(exportCardBack()));
		}
		menu.exec(_p);
	}
}
void DetailWindow::deleteCardFace()
{
	QPixmap available(":/resources/empty_card.png");
	imageLabel->setPixmap(available);

	deleteFace = true;
}
void DetailWindow::exportCardFace()
{
	if (target->picture != NULL) {
		QString path(QDesktopServices::storageLocation(QDesktopServices::PicturesLocation));
		QString s = QFileDialog::getSaveFileName(
	                this,
	                "Choose card face image file",
	                path,
	                "Images (*.png)");
		if (!s.isNull () && !s.isEmpty ()) {
			s.append(".png");
			target->picture->save(s, "PNG"); // writes image into ba in PNG format
		}
	}
}
void DetailWindow::cardFace()
{
	QString path(QDesktopServices::storageLocation(QDesktopServices::PicturesLocation));
	QString s = QFileDialog::getOpenFileName(
	                this,
	                "Choose card face image",
	                path,
	                "Images (*.png *.jpg *.gif *.jpeg)");

	if (!s.isNull () && !s.isEmpty ()) {
		//qDebug () << "loading " << s;
		if (currentImageN) delete currentImageN;

		currentImageN = new QImage ();
		loadImage(s, *currentImageN); //;
		//qDebug () << "loaded " << s;
		imageLabel->setPixmap(QPixmap::fromImage (*currentImageN));
		//qDebug () << "asigned " << s;
		//update();
		deleteFace = false;
	}
}

void DetailWindow::mirrorFace () {
	if (currentImageN) {
		QImage * tmp = currentImageN;
		currentImageN = new QImage (tmp->mirrored (true, true));
		imageLabel->setPixmap(QPixmap::fromImage (*currentImageN));
		delete tmp;
		deleteFace = false;
	}
	else
	if (currentImage) {
		currentImageN = new QImage (currentImage->mirrored (true, true));
		imageLabel->setPixmap(QPixmap::fromImage (*currentImageN));
		deleteFace = false;
	}
}

void DetailWindow::mirrorBack () {
	if (currentImageBackN) {
		QImage * tmp = currentImageBackN;
		currentImageBackN = new QImage (tmp->mirrored (true, true));
		imageBackLabel->setPixmap(QPixmap::fromImage (*currentImageBackN));
		delete tmp;
		deleteBack = false;
	}
	else
	if (currentImageBack) {
		currentImageBackN = new QImage (currentImageBack->mirrored (true, true));
		imageBackLabel->setPixmap(QPixmap::fromImage (*currentImageBackN));
		deleteBack = false;
	}
}
//void DetailWindow::contextMenuEvent (QContextMenuEvent * event) {
//	qDebug () << "NOW";
//}
//void DetailWindow::cardBackMenu(const QPoint & pos) {
//
//	//qDebug () << "MENU";
//
//	QMenu menu(this);
//	if (edit) {
//		menu.addAction("Edit", this, SLOT(cardBack()));
//		menu.addAction("Mirror", this, SLOT(mirrorBack()));
//		menu.addAction("Delete", this, SLOT(deleteCardBack()));
//	}
//	else {
//		menu.addAction("Export", this, SLOT(exportCardBack()));
//	}
//	menu.exec(pos);
//}
//void DetailWindow::cardFaceMenu(const QPoint & pos) {
//
//	//qDebug () << "MENU";
//
//	QMenu menu(this);
//	if (edit) {
//		menu.addAction("Edit", this, SLOT(cardFace()));
//		menu.addAction("Mirror", this, SLOT(mirrorFace()));
//		menu.addAction("Delete", this, SLOT(deleteCardFace()));
//	}
//	else {
//		menu.addAction("Export", this, SLOT(exportCardFace()));
//	}
//	menu.exec(pos);
//}

void DetailWindow::orientationChanged(int o) {
	//qDebug () << "CHAGNED";

	if (!edit) {
		QRect screenGeometry = QApplication::desktop()->screenGeometry();
		if (screenGeometry.width() > screenGeometry.height()) {
			if (imageLabel != NULL) {
				imageLabel->setMaximumSize(MAX_WIDTH, MAX_HEIGH);
				imageLabel->setMinimumSize(MAX_WIDTH, MAX_HEIGH);
			}
			if (imageBackLabel != NULL) {
				imageBackLabel->setMaximumSize(MAX_WIDTH, MAX_HEIGH);
				imageBackLabel->setMinimumSize(MAX_WIDTH, MAX_HEIGH);
			}
		}
		else {
			if (imageLabel != NULL) {
				imageLabel->setMaximumSize(MAX_WIDTH_L, MAX_HEIGH_L);
				imageLabel->setMinimumSize(MAX_WIDTH_L, MAX_HEIGH_L);
			}
			if (imageBackLabel != NULL) {
				imageBackLabel->setMaximumSize(MAX_WIDTH_L, MAX_HEIGH_L);
				imageBackLabel->setMinimumSize(MAX_WIDTH_L, MAX_HEIGH_L);
			}
		}
	}
}

void DetailWindow::deleteCardBack()
{
	QPixmap available(":/resources/empty_card_back.png");
	imageBackLabel->setPixmap(available);

	deleteBack = true;
}
void DetailWindow::exportCardBack()
{
	if (target->pictureBack != NULL) {
		QString path(QDesktopServices::storageLocation(QDesktopServices::PicturesLocation));
		QString s = QFileDialog::getSaveFileName(
	                this,
	                "Choose card back image file",
	                path,
	                "Images (*.png)");
		if (!s.isNull () && !s.isEmpty ()) {
			s.append(".png");
			target->pictureBack->save(s, "PNG"); // writes image into ba in PNG format
		}
	}
}
void DetailWindow::cardBack()
{
	QString path(QDesktopServices::storageLocation(QDesktopServices::PicturesLocation));
	QString s = QFileDialog::getOpenFileName(
	                this,
	                "Choose card back image",
	                path,
	                "Images (*.png *.jpg *.gif *.jpeg)");
	if (!s.isNull () && !s.isEmpty ()) {
		//qDebug () << "loading " << s;
		if (currentImageBackN) delete currentImageBackN;
		
		currentImageBackN = new QImage ();
		loadImage(s, *currentImageBackN); //;
		
		imageBackLabel->setPixmap(QPixmap::fromImage (*currentImageBackN));
		//update ();
		deleteBack = false;
	}
}

CreateFieldDialog::CreateFieldDialog(Target * target, DetailWindow *paTarget) :
		QDialog((QWidget*)paTarget)
{
	pos = 0;
	this->target = target;
	this->parent = paTarget;

	setContextMenuPolicy(Qt::NoContextMenu);

	// Create dialog main layout

	QHBoxLayout * layout = new QHBoxLayout(this);

	layout->setMargin(0);
	layout->setSpacing(0);

	layout->setSpacing(10);
	layout->setMargin(10);

	QDialogButtonBox* dlgBtnBox = new QDialogButtonBox(this);
	dlgBtnBox->setOrientation(Qt::Vertical);

	previousButton = new QPushButton(QIcon(":/resources/icon_previous.png"), "", this);
	//previousButton->setFixedHeight(70);
	previousButton->setContextMenuPolicy(Qt::NoContextMenu);
	previousButton->setFocusPolicy(Qt::NoFocus);
	previousButton->setIconSize(QSize(48, 48));
	QObject::connect(previousButton, SIGNAL(clicked()), this, SLOT(previous()));
	dlgBtnBox->addButton(previousButton, QDialogButtonBox::ActionRole);

	nextButton = new QPushButton(QIcon(":/resources/icon_next.png"), "", this);
	//nextButton->setFixedHeight(70);
	nextButton->setContextMenuPolicy(Qt::NoContextMenu);
	nextButton->setFocusPolicy(Qt::NoFocus);
	nextButton->setIconSize(QSize(48, 48));
	QObject::connect(nextButton, SIGNAL(clicked()), this, SLOT(next()));
	dlgBtnBox->addButton(nextButton, QDialogButtonBox::ActionRole);

	deleteButton = new QPushButton(QIcon(":/resources/icon_delete.png"), "", this);
	//deleteButton->setFixedHeight(70);
	deleteButton->setContextMenuPolicy(Qt::NoContextMenu);
	deleteButton->setFocusPolicy(Qt::NoFocus);
	deleteButton->setIconSize(QSize(48, 48));
	QObject::connect(deleteButton, SIGNAL(clicked()), this, SLOT(deleteCurrent()));
	dlgBtnBox->addButton(deleteButton, QDialogButtonBox::ActionRole);

	QPushButton * newButton = new QPushButton(QIcon(":/resources/icon_add_new.png"), "", this);
	//newButton->setFixedHeight(70);
	newButton->setContextMenuPolicy(Qt::NoContextMenu);
	newButton->setFocusPolicy(Qt::NoFocus);
	newButton->setIconSize(QSize(48, 48));
	QObject::connect(newButton, SIGNAL(clicked()), this, SLOT(addNew()));
	dlgBtnBox->addButton(newButton, QDialogButtonBox::ActionRole);

	QPushButton * closeButton = new QPushButton("Save && Close", this);
	//closeButton->setFixedHeight(70);
	closeButton->setContextMenuPolicy(Qt::NoContextMenu);
	closeButton->setFocusPolicy(Qt::NoFocus);
	closeButton->setIconSize(QSize(48, 48));
	QObject::connect(closeButton, SIGNAL(clicked()), this, SLOT(save()));
	dlgBtnBox->addButton(closeButton, QDialogButtonBox::ActionRole);

	QGridLayout * componentLayout = new QGridLayout ();
	componentLayout->setContentsMargins(15, 0, 15, 0);
	componentLayout->setSpacing(5);

	// Name label
	QLabel * nameLabel = new QLabel("Name", this);
	nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
	//nameLabel->setAlignment(Qt::AlignTop);
	componentLayout->addWidget(nameLabel, 1, 1, 1, 2);

// Name line edit
	nameLineEdit = new QLineEdit(this);
	nameLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
	//nameLineEdit->setAlignment(Qt::AlignTop);

	componentLayout->addWidget(nameLineEdit, 1, 3, 1, 4);

	// type label
	QLabel * typeLabel = new QLabel("Type", this);
	typeLabel->setContextMenuPolicy(Qt::NoContextMenu);
	//typeLabel->setAlignment(Qt::AlignTop);
	componentLayout->addWidget(typeLabel, 2, 1, 1, 2);

	// type line edit
	typeLineEdit = new QComboBox(this);
	typeLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
	//typeLineEdit->setAlignment(Qt::AlignTop);

	typeLineEdit->addItem ("String", QVariant(TYPE_STRING));
	typeLineEdit->addItem ("Text", QVariant(TYPE_TEXT));
	typeLineEdit->addItem ("Date", QVariant(TYPE_DATE));
	typeLineEdit->addItem ("Number", QVariant(TYPE_INTEGER));
	typeLineEdit->addItem ("Phone Number", QVariant(TYPE_PHONE_NUMBER));
	typeLineEdit->addItem ("Password", QVariant(TYPE_PASSWORD));
	typeLineEdit->addItem ("URL", QVariant(TYPE_URL));

	componentLayout->addWidget(typeLineEdit, 2, 3, 1, 4);

	// Name label
	QLabel * orderLabel = new QLabel("Order", this);
	orderLabel->setContextMenuPolicy(Qt::NoContextMenu);
	//nameLabel->setAlignment(Qt::AlignTop);
	componentLayout->addWidget(orderLabel, 3, 1, 1, 2);

// Name line edit
	orderEdit = new QLineEdit(this);
	orderEdit->setContextMenuPolicy(Qt::NoContextMenu);
	orderEdit->setValidator(new QIntValidator (1, 100, this));

	componentLayout->addWidget(orderEdit, 3, 3, 1, 4);

	layout->addLayout(componentLayout);
	layout->setAlignment(componentLayout, Qt::AlignVCenter);

	layout->addWidget(dlgBtnBox);
	layout->setAlignment(dlgBtnBox, Qt::AlignBottom);

	setLayout(layout);

	showField ();
}

void CreateFieldDialog::update () {
	if (pos < target->fields.length()) {
		int type = typeLineEdit->itemData(typeLineEdit->currentIndex()).toInt();
		int order = QVariant (orderEdit->text()).toInt();
		target->fields[pos]->name = nameLineEdit->text();
		target->fields[pos]->type = type;
		target->fields[pos]->order = order;
	}
}

void CreateFieldDialog::previous () {
	if (pos > 0) {
		update ();
		pos--;
		showField ();
	}
}
void CreateFieldDialog::addNew () {
	update ();
	pos = target->fields.length();
	target->fields.append(new TargetField ("", TYPE_STRING, true, 100));
	showField ();
}
void CreateFieldDialog::next () {
	if ((pos + 1) < target->fields.length()) {
		update ();
		pos++;
		showField ();
	}
}
void CreateFieldDialog::deleteCurrent () {
	if (pos >= 0 && pos < target->fields.length()) {
		update ();
		target->fields.removeAt(pos);
		if (pos >= target->fields.length()) {
			pos--;
			if (pos < 0) pos = 0;
		}
		showField ();
	}
}
void CreateFieldDialog::showField () {
	if (pos == 0) {
		previousButton->setDisabled(true);
	}
	else {
		previousButton->setDisabled(false);
	}
	if ((pos + 1) >= target->fields.length()) {
		nextButton->setDisabled(true);
	}
	else {
		nextButton->setDisabled(false);
	}
	if (pos >= 0 && pos < target->fields.length()) {
		deleteButton->setDisabled(false);
	}
	else {
		deleteButton->setDisabled(true);
	}
	if (pos < target->fields.length()) {
		nameLineEdit->setText(target->fields[pos]->name);
		int i = typeLineEdit->findData(QVariant (target->fields[pos]->type));
		typeLineEdit->setCurrentIndex(i);
		orderEdit->setText(QString::number(target->fields[pos]->order));
	}
}
void CreateFieldDialog::save () {
	update ();
	close();
}
CreateFieldDialog::~CreateFieldDialog() {

}
