/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 *
// TODO several files? or several wallets in database?
// TODO export to a file with pictures!!!??
// TODO import picture from camera
// TODO modify picture (zoom, ...)
// TODO support for portrain
// TODO final images
 * TODO strong encryption with characters
 * TODO check that export images get the right size
 * TODO image size when no credit card (axa)
 * TODO free list resources
 * TODO after change type it is not refreshed on list
 * TODO implements copy of information field (and images?)
 * TODO allow to change password
 * TODO use hilton notifications and banner???
 * TODO check types on import
 * TODO sort after insert new card
 * TODO add warn message when import and export!
 */

#include "eWallet.h"
#include "Constants.h"
#include "DatabaseManager.h"
#include <Qt>
#include <QtGui>
#include <QFile>
#include <QDBusInterface>
#include <QDBusConnection>
#include <QDesktopServices>
#include <QListView>

//#ifdef Q_WS_MAEMO_5
//#include <mce/mode-names.h>
//#include <mce/dbus-names.h>
//#endif

DatabaseManager * dbManager;

eWallet::eWallet(QWidget *parent) : QMainWindow(parent)
{
	this->setAttribute(Qt::WA_Maemo5StackedWindow);

	ascSort = true;
	currentFilter = "";

	//this->setAttribute(Qt::WA_Maemo5AutoOrientation, true);

	loadTypesAndFields ();

	::dbManager = new DatabaseManager(this);

	askPassword ();

	QDBusConnection conn = QDBusConnection::systemBus(); //QString(MCE_SERVICE), QString(MCE_SIGNAL_PATH)
	bool success = conn.connect("","", QString("com.nokia.mce.signal"/*MCE_SIGNAL_IF*/), QString("display_status_ind"/*MCE_DISPLAY_SIG*/) , this, SLOT(listenInactivity(QString)));
	//bool success = conn.connect("","", QString(MCE_SIGNAL_IF), QString(MCE_DISPLAY_SIG) , this, SLOT(listenInactivity(QString)));
}

void eWallet::showList () {
	setProperty("FingerScrollable", false);
	//setContextMenuPolicy(Qt::NoContextMenu);
	//                         // Central widget and Layout
	centralWidget = new QWidget(this);

//	setContextMenuPolicy(Qt::DefaultContextMenu);
//	centralWidget->setContextMenuPolicy(Qt::DefaultContextMenu);

	vboxlayout = new QVBoxLayout;
	vboxlayout->setSpacing(0);
	vboxlayout->setMargin(0);
	// Custom list box

	fnListWidget = new QListWidget(this);
	vboxlayout->addWidget(fnListWidget);

	QObject::connect(fnListWidget, SIGNAL(itemClicked(QListWidgetItem *)), this, SLOT(selectItem(QListWidgetItem *)));
	QObject::connect(fnListWidget, SIGNAL(itemDoubleClicked(QListWidgetItem *)), this, SLOT(selectDItem(QListWidgetItem *)));

	inputWidget = new QHBoxLayout;
	inputWidget->setContentsMargins(2, 2, 2, 0);
	vboxlayout->addLayout(inputWidget);

	cancelSearch = new QPushButton(QIcon(":/resources/icon_clear.png"), "", this);
	searchField = new QLineEdit ();
	hideSearch = new QPushButton(QIcon(":/resources/icon_hide.png"), "", this);

	inputWidget->addWidget(cancelSearch);
	inputWidget->addWidget(searchField);
	inputWidget->addWidget(hideSearch);

	QObject::connect(cancelSearch, SIGNAL(clicked()), this, SLOT(_cancelSearch()));
	QObject::connect(hideSearch, SIGNAL(clicked()), this, SLOT(_hideSearch()));
	QObject::connect(searchField, SIGNAL(textChanged(const QString &)), this, SLOT(textChanged(const QString &)));

	cancelSearch->hide ();
	searchField->hide ();
	hideSearch->hide ();

	showTargets (true);

	centralWidget->setLayout(vboxlayout);
	setCentralWidget(centralWidget);

	createMenu ();

	centralWidget->setFocus ();
}

void eWallet::selectItem(QListWidgetItem * item) {
	if (fnListWidget->currentItem() != item) {
		fnListWidget->setCurrentItem(item);
	}
	Target * target = list.at(fnListWidget->currentRow());
	viewTarget(target);
}

void eWallet::selectDItem(QListWidgetItem * item) {
	if (fnListWidget->currentItem() != item) {
		fnListWidget->setCurrentItem(item);
	}
	Target * target = list.at(fnListWidget->currentRow());
	editTarget(target);
}

void eWallet::listenInactivity(QString s) {
	//qDebug () << "HELLO " << s;
	if (s == QString("off") && ::dbManager->isReady ()) {
		::dbManager->lock ();

		// TODO sure????
		fnListWidget->clear();
		list.clear ();

		if (!detailWindow.isNull()) {
			detailWindow->close();
			delete detailWindow;
			detailWindow = 0;
	    }

	    if (!detailWindowEdit.isNull()) {
			detailWindowEdit->close();
			delete detailWindowEdit;
			detailWindowEdit = 0;
	    }

	}
	else {
		if (s == QString("on") && !::dbManager->isReady ()) {
			askPassword ();
//			if (::dbManager->isReady ()) {
//				showList ();
//			}
		}
	}
}

void eWallet::textChanged (const QString & text) {
	currentFilter = text;
	filterBy (text);
}

void eWallet::filterBy (const QString & s) {
	for (int i = 0; i < list.size (); i++) {
		Target * target = list.at(i);

		if (s.length() == 0) {
			fnListWidget->item(i)->setHidden(false);
		}
		else {
			if (target->name.contains(s, Qt::CaseInsensitive)) {
				fnListWidget->item(i)->setHidden(false);
			}
			else {
				fnListWidget->item(i)->setHidden(true);
			}
		}
	}
}

void eWallet::_cancelSearch () {
	searchField->setText("");
	searchField->hide();
	cancelSearch->hide();
	hideSearch->hide ();
}

void eWallet::_hideSearch () {
	searchField->hide();
	cancelSearch->hide();
	hideSearch->hide ();
}

void eWallet::lockWallet () {
	::dbManager->lock ();
	askPassword ();
}

void eWallet::deleteDB () {
	if (messageBox.isNull()) {
		messageBox = new QMessageBox(this);
		int b = messageBox->information(this, "Wallet", "Are you sure you want to remove all your data? You will lost all your data", QMessageBox::Yes, QMessageBox::No);
		if (b == QMessageBox::Yes) {
			::dbManager->reset ();

			if (!loginDialogDlg.isNull()) {
				loginDialogDlg->resetF ();
			}
		}
	}
	delete messageBox;
	messageBox = 0;
}

bool eWallet::openDataBase (QString pas)
{
	bool res = ::dbManager->openDB(pas);

	if (!res) {
		if (++times > 3) {
			exit(3);
		}
		else {
			if (!::dbManager->isReady ()) {
				if (messageBox.isNull()) {
					messageBox = new QMessageBox(this);
					messageBox->information(this, "Wallet", "Wrong password", QMessageBox::Ok);
				}
				delete messageBox;
				messageBox = 0;
			}
		}
	}
	else {
		showList ();
	}
	return res;
}

eWallet::~eWallet ()
{
	delete ::dbManager;
}
/*
 * TYPES
 * 	S -> String
 * 	T -> Text
 * 	D -> Date
 *  U -> URL
 *  P -> Password
 *  N -> Number
 *  H -> Phone number
 */
void eWallet::loadTypesAndFields () {
	  QFile file(":/resources/types.txt");
	  QString line;

	  if ( file.open(QIODevice::Text | QIODevice::ReadOnly) ) {
	    // file opened successfully
	    QTextStream t(&file);        // use a text stream
	    // until end of file...
	    int i = 0;
	    while ( !t.atEnd() ) {
	      // read and parse the command line
	      QString line = t.readLine();         // line of text excluding '\n'
	      // do something with the line

	      if (line.length() > 0) {
	    	  if ((i++) == 0) {
	    		  int p = line.indexOf(';');
	    		  if (p >= 0) {
	    			  // TODO
	    			  QChar imageType = line.at(p + 1);
					  this->types.append(line.mid(0, p).trimmed());
	    		  }
	    		  else {
					  this->types.append(line);
	    		  }
	    		  this->fieldsByType.append (new QList<TargetField>);
				  //qDebug () << " new type "<< line << " " << this->types.length();
	    	  }
	    	  else {
	    		  int p = line.indexOf(';');
	    		  if (p >= 0) {
	    			  int type = TYPE_STRING;
	    			  switch (line.at(p + 1).toAscii()) {
						  case 'T':
							  type = TYPE_TEXT;
							  break;
						  case 'D':
							  type = TYPE_DATE;
							  break;
						  case 'U':
							  type = TYPE_URL;
							  break;
						  case 'P':
							  type = TYPE_PASSWORD;
							  break;
						  case 'N':
							  type = TYPE_INTEGER;
							  break;
						  case 'H':
							  type = TYPE_PHONE_NUMBER;
							  break;
						  case 'S':
						  default:
			    			  type = TYPE_STRING;
						}
	    			  this->fieldsByType [this->types.length() - 1]->append(TargetField (line.mid(0, p).trimmed(), type, true, i));
	    		  }
	    		  else {
	    			  this->fieldsByType [this->types.length() - 1]->append(TargetField (line, TYPE_STRING, true, i));
	    		  }
				  //qDebug () << " new field "<< line << " " << this->types.length();
	    	  }
	      }
	      else {
	    	  i = 0;
	      }

	    }

	    // Close the file
	    file.close();
	  }
}

void eWallet::keyPressEvent(QKeyEvent* event) {
	//qDebug()<<"key pressed " << event->key();
	
	if (searchField != NULL && searchField->isHidden()) {
		cancelSearch->show ();
		searchField->show ();
		hideSearch->show ();
		searchField->setFocus();

		QCoreApplication::sendEvent (searchField, event);

		event->accept();
	}
	else {
		event->accept();
	}
	//timer->stop();
	//timer->start(5000);
}

bool sortTargetsASC (const Target * f, const Target * g) {
	return f->name.toLower() < g->name.toLower();
}
bool sortTargetsDES (const Target * f, const Target * g) {
	return f->name.toLower() > g->name.toLower();
}

QPixmap eWallet::getImage (Target * target) {
	QPixmap image;
	if (target->getPictureSmall() != NULL) {
		image = QPixmap::fromImage (*target->getPictureSmall());

		// at this moment we don't need anymore original images!
		target->freeResources();
	} else {
		QString tmp = ":/resources/empty_";
		tmp += target->type.simplified().replace(' ', '_');
		tmp += ".png";

		if (QResource (tmp).isValid()) {
			image = QPixmap (tmp);
		}
		else {
			image = QPixmap (":/resources/empty_Others.png");
		}
	}
	return image;
}
void eWallet::showTargets(bool reset)
{
	// Clean previous items from the layout
	fnListWidget->clear();

	//QPixmap available(":/resources/icon_available.png");
	//QPixmap notavailable(":/resources/icon_notavailable.png");
	if (reset) {
		list.clear ();
		list = ::dbManager->getTargets ("");
	}

	if (ascSort)
		qSort (list.begin(),list.end(),sortTargetsASC);
	else
		qSort (list.begin(),list.end(),sortTargetsDES);

	fnListWidget->setIconSize (QSize (SMALL_WIDTH, SMALL_HEIGH));
	//fnListWidget->setContentsMargins(10, 1, 0, 1);

	for (int i = 0; i < list.size (); i++) {
		Target * target = list.at(i);

		QListWidgetItem* listitem = new QListWidgetItem(getImage(target), target->name, fnListWidget);
		//listitem->set(target->getSummary());
		fnListWidget->addItem(listitem);
		
//		QObject::connect(listitem, SIGNAL(viewTarget(Target*)),
//                      this, SLOT(viewTarget(Target*)));
//		QObject::connect(listitem, SIGNAL(editTarget(Target*)),
//                      this, SLOT(editTarget(Target*)));
//		QObject::connect(listitem, SIGNAL(deleteTarget(Target*)),
//                      this, SLOT(deleteTarget(Target*)));
	}

	filterBy(currentFilter);

	fnListWidget->setCurrentRow(0);

	//update();
}

void eWallet::createMenu()
{
	menuBar()->addAction("New", this, SLOT(newTarget()));
	menuBar()->addAction("Edit", this, SLOT(_editcTarget()));
	menuBar()->addAction("Invert Sort", this, SLOT(sort()));
	menuBar()->addAction("Import", this, SLOT(import()));
	menuBar()->addAction("Export", this, SLOT(exportData()));
	menuBar()->addAction("About", this, SLOT(about()));
	menuBar()->addAction("Exit", QApplication::instance(), SLOT(quit()));

}

void eWallet::sort()
{
	ascSort = !ascSort;
	showTargets(false);
}

bool eWallet::__insertTarget(Target* target)
{
	if (::dbManager->insertTarget(target)) {
		//qDebug () << "Adding new item";
		::dbManager->updateFields (target);
		
		target->freeFieldList();
		return true;
	}
	return false;
}

bool eWallet::_insertTarget(Target* target)
{
	if (__insertTarget(target)) {

		list.append(target);

//		if (ascSort)
//			qSort (list.begin(),list.end(),sortTargetsASC);
//		else
//			qSort (list.begin(),list.end(),sortTargetsDES);

		QListWidgetItem* listitem = new QListWidgetItem(getImage(target), target->name, fnListWidget);

		int pos = list.indexOf(target);
		qDebug () << "position of new " << pos << " OF " << list.size ();

		if (pos < list.size()) {
			//qDebug () << "insert position of new " << pos << " OF " << list.size ();
			fnListWidget->insertItem(pos, listitem);
		}
		else {
			//qDebug () << "append position of new " << pos << " OF " << list.size ();
			fnListWidget->addItem(listitem);
		}
		fnListWidget->setCurrentItem(listitem);
		return true;
	}
	return false;
}
bool eWallet::_deleteTarget(Target* target)
{
	int i = list.indexOf(target);
	//qDebug () << "DELETE ON " << i;
	if (::dbManager->deleteTarget(target)) {
		list.removeAt(i);

		fnListWidget->takeItem(i); //oveItem (row);
//		target->freeFieldList();
//		target->freeResources();
//		delete target;
		delete target;
		return true;
	}
	return false;
}
bool eWallet::_updateTarget(Target* target)
{
	int i = list.indexOf(target);
	//qDebug () << "UPDATE ON " << i;

	if (::dbManager->updateTarget(target)) {
		::dbManager->updateFields (target);
		
		target->freeFieldList();

		QListWidgetItem* listitem = fnListWidget->item (i);
		listitem->setText(target->name);
		//((QFNListItem*)fnListWidget->currentItem())->setText (target->name);
		return true;
	}
	return false;
}

bool eWallet::_updateTargetPicture(Target* target)
{
	int i = list.indexOf(target);
	//qDebug () << "UPDATE ON " << i;
	if (::dbManager->updateTargetPicture(target)) {
		QListWidgetItem* listitem = fnListWidget->item (i);
		listitem->setIcon(getImage(target));
		return true;
	}
	return false;
}
bool eWallet::_updateTargetPictureBack(Target* target)
{
	if (::dbManager->updateTargetPictureBack(target)) {
		return true;
	}
	return false;
}

void eWallet::deleteTarget(Target * target) {

	//qDebug()<<"delete ";

	//row = fnListWidget->findRow(target);
	
	_deleteTarget (target);

	delete target;
}

void eWallet::windowDestroyed(QObject* obj)
{
    disconnect(obj, SIGNAL(destroyed(QObject*)),
               this, SLOT(windowDestroyed(QObject*)));

//    if (currentTarget != NULL) {
//    	currentTarget->freeFieldList();
//    }

    if (obj == detailWindow.data()) {
		delete detailWindow;
		detailWindow = 0;
    }
    else
    if (obj == detailWindowEdit.data()) {
		delete detailWindowEdit;
		detailWindowEdit = 0;
    }
}

void eWallet::viewTarget(Target * rent) {
	//qDebug()<<"view ";

	//row = fnListWidget->findRow(rent);

	//currentTarget = rent;

	dbManager->getFields(rent);

	if (detailWindow.isNull()) {
		detailWindow = new DetailWindow(rent, false, this, this);

		connect(detailWindow, SIGNAL(editTarget(Target*)),
                      this, SLOT(editTarget(Target*)));
		connect(detailWindow, SIGNAL(newTarget()),
                      this, SLOT(newTarget()));
//#ifdef Q_WS_MAEMO_5
//#endif
        detailWindow->setAttribute(Qt::WA_DeleteOnClose);
        connect(detailWindow, SIGNAL(destroyed(QObject*)),
                this, SLOT(windowDestroyed(QObject*)));
		detailWindow->setAttribute(Qt::WA_Maemo5StackedWindow);
	    detailWindow->show(); //owMaximized();
	}
}

void eWallet::editTarget(Target * rent) {
	//qDebug()<<"edit ";

	//row = fnListWidget->findRow(rent);

	dbManager->getFields(rent);

	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(rent, true, this, this);
//#ifdef Q_WS_MAEMO_5
		detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
//#endif
		//detailWindowEdit->showMaximized();
        detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
        connect(detailWindowEdit, SIGNAL(destroyed(QObject*)),
                this, SLOT(windowDestroyed(QObject*)));
        detailWindowEdit->show();
		//detailWindow->exec();
	}
}

void eWallet::import() {
	QString path(QDesktopServices::storageLocation(QDesktopServices::HomeLocation));
	QString s = QFileDialog::getOpenFileName(
	                this,
	                "Choose import file",
	                path,
	                "Text (*.txt)");
	if (!s.isNull () && !s.isEmpty ()) {

		  QFile file(s);
		  QString line;

		  Target * target = NULL;
		  if ( file.open(QIODevice::Text | QIODevice::ReadOnly) ) {
		    // file opened successfully
		    QTextStream t(&file);        // use a text stream
		    // until end of file...
		    int i = 0;
		    while ( !t.atEnd() ) {
		      // read and parse the command line
		      QString line = t.readLine();         // line of text excluding '\n'
		      // do something with the line

		      if (line.length() > 0) {
		    	  if (target == NULL) {
		    		  target = new Target ();
		    	  }

		    	  int j = line.indexOf(QChar(':'));
		    	  if (j > 0) {
					  switch (i++) {
					  case 0:
						  target->name = line.mid(j + 1).trimmed();
						  break;
					  case 1:
						  // TODO check type with existing one!
						  target->type = line.mid(j + 1).trimmed();
						  break;
					  default:
						  TargetField * field = new TargetField ();
						  field->name = line.mid (0, j).trimmed();
						  field->value = line.mid(j + 1).trimmed();
						  field->order = 10 * (i - 2);
						  field->encrypted = true;
						  if (field->name.contains("url", Qt::CaseInsensitive)) {
							  field->type = TYPE_URL;
						  }
						  else
						  if (field->name.contains("password", Qt::CaseInsensitive)) {
							  field->type = TYPE_PASSWORD;
						  }
						  else
						  if (field->name.contains("pin", Qt::CaseInsensitive)) {
							  field->type = TYPE_PASSWORD;
						  }
						  else
						  if (field->name.contains("phone", Qt::CaseInsensitive)) {
							  field->type = TYPE_PHONE_NUMBER;
						  }
						  else
						  if (field->name.contains("number", Qt::CaseInsensitive)) {
							  field->type = TYPE_INTEGER;
						  }
						  else
						  if (field->name.contains("date", Qt::CaseInsensitive)) {
							  field->type = TYPE_DATE;
						  }
						  else
						  if (field->name.contains("note", Qt::CaseInsensitive)) {
							  field->type = TYPE_TEXT;
						  }
						  else
							  field->type = TYPE_STRING;
						  target->fields.append(field);
					  }

					  //qDebug () << line << " | " << line.mid(j + 1) << " IS " << line.mid (0, j);
		    	  }
		    	  else {
		    		  if (target != NULL && target->fields.size() > 0) {
		    			  target->fields.last()->value.append("\n").append (line);
		    			  target->fields.last()->type = TYPE_TEXT;
		    		  }
		    	  }
		      }
		      else {
		    	  if (target != NULL) {
		    		  this->_insertTarget(target);
		    	  }
		    	  target = NULL;
		    	  i = 0;
		      }

		      //qDebug () << line;
		    }

			 if (target != NULL) {
				  this->_insertTarget(target);
			 }
		    // Close the file
		    file.close();

		    showTargets (true);
		  }
	}
}

void eWallet::newTarget() {
	//qDebug()<<"new ";

	if (detailWindowEdit.isNull()) {
		detailWindowEdit = new DetailWindow(NULL, true, this, this);
//#ifdef Q_WS_MAEMO_5
		detailWindowEdit->setAttribute(Qt::WA_Maemo5StackedWindow);
//#endif
		//detailWindowEdit->showMaximized();
        detailWindowEdit->setAttribute(Qt::WA_DeleteOnClose);
        connect(detailWindowEdit, SIGNAL(destroyed(QObject*)),
                this, SLOT(windowDestroyed(QObject*)));
        detailWindowEdit->show();
		//detailWindow->exec();
	}
}
/*
void eWallet::contextMenuEvent (QContextMenuEvent * event) {
	//qDebug () << "Should be show " << this->childAt(event->globalPos());

	row = this->fnListWidget->findOn (event->globalPos());

	if (row >= 0) {
		QMenu menu(this);
		menu.addAction("View", this, SLOT(_viewcTarget()));
		menu.addAction("Edit", this, SLOT(_editcTarget()));
		menu.addAction("Delete", this, SLOT(_deletecTarget()));
		menu.exec(event->globalPos());
	}
}
*/

void eWallet::exportData() {
	QString path(QDesktopServices::storageLocation(QDesktopServices::HomeLocation));
	QString s = QFileDialog::getSaveFileName(
	                this,
	                "Choose export file",
	                path,
	                "Text (*.txt)");
	if (!s.isNull () && !s.isEmpty ()) {
		  QFile file(s);

		  if ( file.open(QIODevice::Text | QIODevice::WriteOnly) ) {
		    // file opened successfully
		    QTextStream t(&file);        // use a text stream

			for (int i = 0; i < list.size (); i++) {
				Target * target = list[i];

				t << "Name: " << target->name << "\n";
				t << "Type: " << target->type << "\n";

				dbManager->getFields(target);

				TargetField * field;
				foreach(field, target->fields) {
					t << field->name << ": " << field->value << "\n";
				}

				t << "\n\n";

				target->freeFieldList();

			}

		    // Close the file
		    file.close();
		  }
	}
}

void eWallet::_editcTarget() {
	if (fnListWidget->currentRow() >= 0) {
		Target * target = list.at(fnListWidget->currentRow());
		editTarget(target);
	}
	//editTarget(((QFNListItem*)fnListWidget->currentItem())->getSource());
}
void eWallet::_deletecTarget() {
	//deleteTarget(((QFNListItem*)fnListWidget->currentItem())->getSource());
}
void eWallet::_viewcTarget() {
	if (fnListWidget->currentRow() >= 0) {
		Target * target = list.at(fnListWidget->currentRow());
		viewTarget(target);
	}
	//viewTarget(((QFNListItem*)fnListWidget->currentItem())->getSource());
}

//eWallet closeEvent function:
void eWallet::closeEvent(QCloseEvent *event){
	//qDebug () << "close Event";
        //saveSettings();
        event->accept();
}

void eWallet::askPassword () {
	times = 0;
	
	menuBar()->clear();

	if (loginDialogDlg.isNull()) {
		loginDialogDlg = new LoginDialog(!::dbManager->hasPassword (), this);

		// TODO should I remove all included widgets??
		setCentralWidget(loginDialogDlg);
		loginDialogDlg->setFocus ();

		centralWidget = NULL;
		vboxlayout = NULL;
		fnListWidget = NULL;
		inputWidget = NULL;
		cancelSearch = NULL;
		searchField = NULL;
		hideSearch = NULL;
	}
}

void eWallet::about() {
	QMessageBox::about(this, "About qtWallet", TEXT_ABOUT);
}
