/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */


#include "QFNListWidget.h"
#include <QDebug>
#include <QScrollBar>
#include <QTimerEvent>
#include <QGridLayout>
#include <QHBoxLayout>
#include <QPainter>
#include <QKeyEvent>
#include "eWallet.h"

QFNListWidget::QFNListWidget(QWidget* parent) :
		QWidget(parent)
{
	//setContextMenuPolicy(Qt::NoContextMenu);
	//setContextMenuPolicy(Qt::DefaultContextMenu);

	QVBoxLayout * layout = new QVBoxLayout(this);
	layout->setSpacing(0);
	layout->setMargin(0);

	//customFocusItem = 0;
	qRegisterMetaType<QFNListItem*> ("QFNListItem");


	setContextMenuPolicy(Qt::DefaultContextMenu);
/*
#if defined (Q_OS_SYMBIAN)
	QPalette* p = new QPalette(Qt::transparent);
#else
	QPalette* p = new QPalette(Qt::white);
#endif
	setPalette(*p);*/

	// QFrame
	entryFrame = new QFrame(this);
	//entryFrame->setContextMenuPolicy(Qt::NoContextMenu);
	frameLayout = new QVBoxLayout;
	frameLayout->setSizeConstraint(QLayout::SetFixedSize);
	frameLayout->setSpacing(1);
	frameLayout->setMargin(1);
	frameLayout->setContentsMargins(5, 0, 0, 0);
	//frameLayout->setFocusPolicy(Qt::StrongFocus);
	//entryFrame->setPalette(*p);
	entryFrame->setLayout(frameLayout);

	// Set QFrame into QScrollArea
	entryScrollArea = new QScrollArea;
	//entryScrollArea->setProperty("FingerScrollable", false);
	entryScrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	entryFrame->setProperty("FingerScrollable", false);
	//entryScrollArea->setPalette(*p);
	//entryScrollArea->setFocusPolicy(Qt::NoFocus);
	entryScrollArea->setFocusPolicy(Qt::StrongFocus);
	//entryScrollArea->setContextMenuPolicy(Qt::NoContextMenu);
	entryScrollArea->setWidgetResizable(true);
	entryScrollArea->setWidget(entryFrame);

	entryScrollArea->setProperty("FingerScrollable", true);

	// Set QScrollArea into layout
	layout->addWidget(entryScrollArea);

	setLayout(layout);
}

QFNListWidget::~QFNListWidget()
{
	itemList.clear();
}

QFNListItem* QFNListWidget::itemAt(int index)
{
	QFNListItem* ret = 0;
	ret = itemList[index];
	return ret;
}

int QFNListWidget::findRow(Target * t)
{
	int ret = 0;
	bool found = false;

	//qDebug() << "activeRow";
	if (itemList.count() == 0) {
		//qDebug() << "no elements";

		return -1;
	}
	
	QFNListItem* label;
	foreach(label,itemList) {
		// Try to find "normal" focus
		//qDebug() << "check " << ret;
		if (label->getSource ()== t) {
			//qDebug() << "check found " << ret;
			found = true;
			break;
		}/*
		// If not found, then
		// try to find item that we know to have previous focus
		else if (label == customFocusItem) {
			found = true;
			break;
		}*/
		ret++;
	}

	// Return -1 if we really do not know focus
	if (!found) {
		ret = -1;
	}

	return ret;
}

void QFNListWidget::setFocusedItem(int index)
{
	if (index < itemList.count()) {
		QFNListItem* item = itemList[index];
		item->setFocus();
		update();
	}
}
/*
void QFNListWidget::resizeEvent(QResizeEvent * event)
{
	QWidget::resizeEvent(event);
	//timerid = this->startTimer(50);
	updatePos();
}

void QFNListWidget::timerEvent(QTimerEvent *event)
{
	if (event->timerId() == timerid) {
		this->killTimer(timerid);
		updatePos();
	}
}
*/
//void QFNListWidget::updatePos()
//{
//	QFNListItem* item;
//
//	int w = width() - 20;
//	QScrollBar* bar = entryScrollArea->verticalScrollBar();
//	if (bar)
//		w = w - bar->sizeHint().width();
//
//	/*foreach(item,itemList) {
//		item->setFixedSize(w, item->itemHeight());
//	}*/
//}

void QFNListWidget::clear()
{
	QFNListItem* item;
	foreach(item,itemList) {
		frameLayout->removeWidget(item);
		delete item;
		item = 0;
	}

	itemList.clear();
	frameLayout->invalidate();
	frameLayout->update();
}

void QFNListWidget::addItem(QFNListItem* item, Qt::Alignment alignment)
{
	itemList.append(item);
	frameLayout->addWidget(item, alignment);

	//item->setFocus();

	//QObject::connect(item, SIGNAL(customFocus(QFNListItem*)),
	//                 this, SLOT(customFocus(QFNListItem*)));

	//updatePos();
}
/*
void QFNListWidget::customFocus(QFNListItem* focusItem)
{
	customFocusItem = focusItem;
}

QFNListItem* QFNListWidget::customFocusedItem()
{
	return customFocusItem;
}
*/
void QFNListWidget::removeItem(int index)
{
	QFNListItem* item = itemList[index];
	frameLayout->removeWidget(item);
	itemList.removeAt(index);
	delete item;
	item = 0;
	frameLayout->update();
}

int QFNListWidget::findOn(const QPoint & _p)
{
	QPoint p = this->mapFromGlobal(_p);

	QScrollBar* bar = entryScrollArea->verticalScrollBar();
	if (bar)
		p.setY(p.y() + bar->value());

	entryScrollArea->ensureVisible(p.x(), p.y());

	QFNListItem* item;
	int pos = 0;
	foreach(item,itemList) {
		if (item->geometry().contains(p)) {
			return pos;
		}
		pos++;
	}
	return -1;

}

